/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_fimage_h__

#include "item_common.h"
#include "item_method.h"
#include "pixbuf.h"

struct item_fimage
{
  gdouble                               m_pos_x;
  gdouble                               m_pos_y;
  gdouble                               m_len_x;
  gdouble                               m_len_y;
  struct item_border_attr               m_border;
  gchar                                 m_tag[1+FIELD_NAME_MAX_LEN];
  void*                                 m_value;
  gsize                                 m_value_size;
};

extern void
item_fimage_assign(
  struct item_fimage*const              o_fimage,
  struct item_method*const              o_method);

extern void
item_fimage_get_bbox(
  struct geom_rect*const                o_bbox,
  void const*const                      i_object);

extern void
item_fimage_in_event(
  enum event_type*const                 o_type,
  struct item_fimage const*const        i_fimage,
  struct item_in_event const*const      i_ctx);

extern void
item_fimage_destroy(
  struct item_fimage*const              io_fimage);

extern void
item_fimage_discharge(
  struct item_fimage*const              io_fimage);

extern void
item_fimage_draw(
  struct item_fimage*const              io_fimage,
  struct item_draw_context const*const  i_ctx);

extern void
item_fimage_move(
  struct item_fimage*const              io_fimage,
  struct geom_point const*const         i_event);

extern void
item_fimage_normalize(
  struct item_fimage*const              io_fimage,
  double const                          i_bound_width,
  double const                          i_bound_height);

extern int
item_fimage_property(
  struct item_fimage*const              io_fimage);

extern int
item_fimage_read(
  GError**                              o_error,
  struct item_fimage*const              io_fimage,
  struct xml *const               i_element);

extern void
item_fimage_resize(
  struct item_fimage*const              io_fimage,
  struct item_resize_event const*const  i_ctx);

extern int
item_fimage_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fimage const*const        io_fimage);

#define __item_fimage_h__
#endif
