/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_common_base_h__

#include "global_common.h"
#include "geom.h"
#include "icu.h"

#define FIELD_NAME_MAX_LEN              63
#define FIELD_FORMAT_MAX_LEN            63
#define SPECIAL_FIELD_VALUE_MAX_LEN     123

struct item;

enum element_tag_type
{
  element_tag_attribute,
  element_tag_autowrap,
  element_tag_bits_per_sample,
  element_tag_border,
  element_tag_center_x,
  element_tag_center_y,
  element_tag_channels,
  element_tag_circle,
  element_tag_color,
  element_tag_colorspace,
  element_tag_columns,
  element_tag_cover_footer,
  element_tag_cover_header,
  element_tag_data,
  element_tag_data_type,
  element_tag_date,
  element_tag_date_style,
  element_tag_dbname,
  element_tag_doubleline,
  element_tag_driver,
  element_tag_ellipse,
  element_tag_encode,
  element_tag_fbarcode,
  element_tag_filename,
  element_tag_fill,
  element_tag_fimage,
  element_tag_fnumber,
  element_tag_font,
  element_tag_format,
  element_tag_frame,
  element_tag_fsum,
  element_tag_ftext,
  element_tag_group,
  element_tag_group_footer,
  element_tag_group_header,
  element_tag_has_alpha,
  element_tag_height,
  element_tag_horizontal_pitch,
  element_tag_host,
  element_tag_hostaddr,
  element_tag_image,
  element_tag_iwrite,
  element_tag_label,
  element_tag_label_height,
  element_tag_label_width,
  element_tag_left_margin,
  element_tag_len,
  element_tag_length,
  element_tag_len_x,
  element_tag_len_y,
  element_tag_line,
  element_tag_locale,
  element_tag_margin_bottom,
  element_tag_margin_left,
  element_tag_margin_right,
  element_tag_margin_top,
  element_tag_name,
  element_tag_orientation,
  element_tag_overlay,
  element_tag_page,
  element_tag_page_height,
  element_tag_page_number,
  element_tag_page_width,
  element_tag_pattern,
  element_tag_port,
  element_tag_pos_x,
  element_tag_pos_x1,
  element_tag_pos_x2,
  element_tag_pos_y,
  element_tag_pos_y1,
  element_tag_pos_y2,
  element_tag_print_header,
  element_tag_prompt_password,
  element_tag_rect_v0,
  element_tag_rect_v1,
  element_tag_rect_v2,
  element_tag_rect_v3,
  element_tag_rect_v4,
  element_tag_rect_v5,
  element_tag_rect_v6,
  element_tag_rect_v7,
  element_tag_report_detail,
  element_tag_report_footer,
  element_tag_report_header,
  element_tag_rotate,
  element_tag_rows,
  element_tag_rowstride,
  element_tag_scale,
  element_tag_size,
  element_tag_special,
  element_tag_style,
  element_tag_tag,
  element_tag_text,
  element_tag_textual,
  element_tag_thickness,
  element_tag_time_style,
  element_tag_timezone,
  element_tag_top_margin,
  element_tag_type,
  element_tag_username,
  element_tag_value,
  element_tag_vertical_pitch,
  element_tag_width,
  element_tag_wrapmode
};

enum number_type
{
  number_float= 0,
  number_integer,
  number_monetary
};

enum event_type
{
  event_none=                           GDK_ARROW,
  event_move=                           GDK_FLEUR,
  event_resize_east=                    GDK_RIGHT_SIDE,
  event_resize_north=                   GDK_TOP_SIDE,
  event_resize_north_east=              GDK_TOP_RIGHT_CORNER,
  event_resize_north_west=              GDK_TOP_LEFT_CORNER,
  event_resize_north_south=             GDK_DOUBLE_ARROW,
  event_resize_south=                   GDK_BOTTOM_SIDE,
  event_resize_south_east=              GDK_BOTTOM_RIGHT_CORNER,
  event_resize_south_west=              GDK_BOTTOM_LEFT_CORNER,
  event_resize_west=                    GDK_LEFT_SIDE,
};

enum line_style_type
{
  line_style_solid=                     0,
  line_style_dash,
  line_style_dot,
  line_style_dash_dot,
  LINE_STYLE_SLOTS
};

struct item_border
{
  enum line_style_type                  m_style;
  gdouble                               m_thickness;
  GdkRGBA                               m_color;
};

struct item_border_attr
{
  gint                                  m_active;
  enum line_style_type                  m_style;
  gdouble                               m_thickness;
  GdkRGBA                               m_color;
};

enum item_draw_type
{
  item_draw_print= 0,
  item_draw_design
};

struct item_draw_options
{
  enum item_draw_type                   m_type;
  int                                   m_highlight;
};

struct item_draw_context
{
  struct item_draw_options              m_option;
  cairo_t*                              m_cr;
  int                                   m_selected;
};

struct item_resize_event
{
  enum event_type                       m_type;
  struct geom_point                     m_event;
};

struct item_in_event
{
  struct geom_point                     m_event;
  double                                m_scale;
  int                                   m_selected;
};

struct item_fill
{
  int                                   m_active;
  GdkRGBA                               m_color;
};

extern void
item_common_cairo_dash_set(
  cairo_t *const                        i_cr,
  enum line_style_type const            i_style);

extern enum date_style_type
item_common_get_datetime_style(
  char const*                           i_style);

extern char const*
item_common_get_datetime_style_text(
  enum date_style_type const            i_style);

extern enum line_style_type
item_common_get_line_style(
  char const*                           i_style);

extern char const*
item_common_get_line_style_text(
  enum line_style_type const            i_style);

extern enum number_type 
item_common_get_number(
  char const*                           i_type);

extern char const*
item_common_get_number_text(
  enum number_type const                i_type);

extern PangoWrapMode 
item_common_get_wrapmode(
  char const*                           i_mode);

extern char const*
item_common_get_wrapmode_text(
  PangoWrapMode const                   i_mode);

extern int
item_common_event_inside(
  struct item_in_event const*const      i_ctx,
  double const                          i_pos_x,
  double const                          i_pos_y,
  double const                          i_len_x,
  double const                          i_len_y);

extern void
item_common_lookup(
  int *const                            o_found,
  enum element_tag_type*const           o_type,
  char const*                           i_key);

extern int
item_common_read_border(
  GError**                              o_error,
  struct item_border*const              io_border,
  struct xml *const                     i_xml);

extern int
item_common_read_border_attr(
  GError**                              o_error,
  struct item_border_attr*const         io_border,
  struct xml *const                     i_xml);

extern int
item_common_read_fill(
  GError**                              o_error,
  struct item_fill*const                io_fill,
  struct xml *const                     i_xml);

extern int
item_common_write_border(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_border const*const        i_border);

extern int
item_common_write_border_attr(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_border_attr const*const   i_border);

extern int
item_common_write_fill(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fill const*const          i_fill);

#define __item_common_base_h__
#endif
