/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "export_config.h"

extern void
export_config_assign(
  struct exports_config*const           o_config)
{

  memset(o_config, 0, sizeof(*o_config));

  return;
}

extern void
export_config_discharge(
  struct exports_config*const           io_config)
{

  memset(io_config, 0, sizeof(*io_config));

  return;
}

extern int
export_config_read(
  GError**                              o_error,
  struct exports_config*const           io_config,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_found;
  GList*                                l_node;
  enum element_tag_type                 l_type;
  char const*                           l_value;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (struct xml*)(*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_print_header:
          l_value= xml_lookup_attribute_value(l_xml, "on");
          (*io_config).m_print_header= xml_convert_boolean(l_value);
          break;
        default:
          break;
      }
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern int
export_config_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct exports_config const*const     i_config)
{
  int                                   l_exit;

  l_exit= 0;

  fprintf(io_fp, "\t\t<config>\n");
  fprintf(io_fp, "\t\t\t<print_header on=\"%s\"/>\n", ((*i_config).m_print_header ? "true" : "false"));
  fprintf(io_fp, "\t\t</config>\n");

  return l_exit;
}
