/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
  CC0 1.0 Universal (CC0 1.0) Public Domain Dedication

  Deriviative works may remove this license dedication and incorporate 
  their own.
 
  GTK widget skeleton template
*/
#include "skel.h"
#include <gdk/gdk.h>

#include <string.h>

struct _SkelPrivate
{
  GdkWindow*				                    m_event_window;
};

G_DEFINE_TYPE_WITH_PRIVATE(Skel, skel, GTK_TYPE_WIDGET)

static void
skel_finalize(
  GObject*                              i_object)
{

  G_OBJECT_CLASS(skel_parent_class)->finalize(i_object);

  return;
}

static void
skel_realize(
  GtkWidget*                            i_widget)
{
  GtkAllocation                         l_alloc;
  GdkWindowAttr                         l_attr;
  gint                                  l_attr_mask;
  SkelPrivate*                          l_priv; 
  GdkWindow*                            l_win;

  l_priv= SKEL(i_widget)->m_priv;
  memset(&l_attr, 0, sizeof(l_attr));
  memset(&l_alloc, 0, sizeof(l_alloc));

  GTK_WIDGET_CLASS(skel_parent_class)->realize(i_widget);

  gtk_widget_get_allocation(i_widget, &l_alloc);

  l_attr.x= l_alloc.x;
  l_attr.y= l_alloc.y;
  l_attr.width= l_alloc.width;
  l_attr.height= l_alloc.height;
  l_attr.wclass= GDK_INPUT_ONLY;
  l_attr.window_type= GDK_WINDOW_CHILD;
  l_attr_mask= (GDK_WA_X | GDK_WA_Y);
  l_attr.event_mask= gtk_widget_get_events(i_widget);
  l_attr.event_mask|= GDK_POINTER_MOTION_MASK;

  l_win= gtk_widget_get_window(i_widget),
  (*l_priv).m_event_window= gdk_window_new(l_win, &l_attr, l_attr_mask);
  gtk_widget_register_window(i_widget, (*l_priv).m_event_window);

  return;
}

static void
skel_unrealize(
  GtkWidget*                            i_widget)
{
  SkelPrivate*                          l_priv; 

  do
  {

    l_priv= SKEL(i_widget)->m_priv;

    if (0 ==(*l_priv).m_event_window)
    {
      break;
    }

    gtk_widget_unregister_window(i_widget, (*l_priv).m_event_window);
    gdk_window_destroy((*l_priv).m_event_window);
    (*l_priv).m_event_window= 0;

  }while(0);

  GTK_WIDGET_CLASS(skel_parent_class)->unrealize(i_widget);

  return;
}

static void
skel_destroy(
  GtkWidget*                            i_widget)
{

  GTK_WIDGET_CLASS(skel_parent_class)->destroy(i_widget);

  return;
}

extern GtkWidget *
skel_new()
{
  GObject*                              l_object;

  l_object= g_object_new(TYPE_SKEL, 0);

  return GTK_WIDGET(l_object);
}

static gboolean
skel_draw(
  GtkWidget*                            i_widget,
  cairo_t*                              io_cr)
{
  SkelPrivate*                          l_priv; 

  l_priv= SKEL(i_widget)->m_priv;

  return 0;
}

static void
skel_map(
  GtkWidget*                            i_widget)
{
  SkelPrivate*                          l_priv; 

  l_priv= SKEL(i_widget)->m_priv;

  GTK_WIDGET_CLASS(skel_parent_class)->map(i_widget);

  gdk_window_show(l_priv->m_event_window);

  return;
}

static void
skel_unmap(
  GtkWidget*                            i_widget)
{
  SkelPrivate*                          l_priv; 

  l_priv= SKEL(i_widget)->m_priv;

  gdk_window_hide(l_priv->m_event_window);

  GTK_WIDGET_CLASS(skel_parent_class)->unmap(i_widget);

  return;
}

static void
skel_size_allocate(
  GtkWidget*                            i_widget,
  GtkAllocation*                        i_alloc)
{
  SkelPrivate*                          l_priv; 
  int                                   l_rc;

  l_priv= SKEL(i_widget)->m_priv;

  gtk_widget_set_allocation(i_widget, i_alloc);

  do
  {

    l_rc= gtk_widget_get_realized(i_widget);

    if (0 ==l_rc)
    {
      break;
    }

    gdk_window_move_resize (
      (*l_priv).m_event_window,
      (*i_alloc).x, 
      (*i_alloc).y,
      (*i_alloc).width, 
      (*i_alloc).height);

  }while(0);

  return;
}

static gboolean
skel_motion_notify(
  GtkWidget*                            i_widget,
  GdkEventMotion*                       i_event)
{

  return 1;
}

static void
skel_set_property(
  GObject*                              i_object,
  guint                                 i_prop_id,
  const GValue*                         i_value,
  GParamSpec*                           i_pspec)
{
  Skel*                                 l_skel;
  SkelPrivate*                          l_priv;

  l_skel= SKEL(i_object);
  l_priv= (*l_skel).m_priv;

  switch (i_prop_id)
  {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(i_object, i_prop_id, i_pspec);
      break;
  }

  return;
}

static void
skel_get_property(
  GObject*                              i_object,
  guint                                 i_prop_id,
  GValue*                               o_value,
  GParamSpec*                           i_pspec)
{
  Skel*                                 l_skel;
  SkelPrivate*                          l_priv;

  l_skel= SKEL(i_object);
  l_priv= (*l_skel).m_priv;

  switch (i_prop_id)
  {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(i_object, i_prop_id, i_pspec);
      break;
  }

  return;
}

static void
skel_install_class_property(
  GObjectClass*                        i_object_class)
{

  return;
}

static void
skel_get_preferred_width(
  GtkWidget*                            i_widget,
  gint*                                 o_minimum_size,
  gint*                                 o_natural_size)
{
  SkelPrivate*                          l_priv; 

  l_priv= SKEL(i_widget)->m_priv;

  (*o_minimum_size) = 72 * 0.25;
  (*o_natural_size) = (*o_minimum_size);

  return;
}

static void
skel_get_preferred_height(
  GtkWidget *                           i_widget,
  gint *                                o_minimum_size,
  gint *                                o_natural_size)
{
  SkelPrivate*                          l_priv; 

  l_priv= SKEL(i_widget)->m_priv;

  (*o_minimum_size) = 72 * 0.25;
  (*o_natural_size) = (*o_minimum_size);

  return;
}

static void
skel_class_init(
  SkelClass *                           i_klass)
{
  GObjectClass*                         l_object_class;
  GtkWidgetClass*                       l_widget_class;

  l_object_class= G_OBJECT_CLASS(i_klass);
  l_object_class->set_property= skel_set_property;
  l_object_class->get_property= skel_get_property;
  (*l_object_class).finalize= skel_finalize;

  skel_install_class_property(l_object_class);  

  l_widget_class= GTK_WIDGET_CLASS(i_klass);

  (*l_widget_class).size_allocate= skel_size_allocate;
  (*l_widget_class).map= skel_map;
  (*l_widget_class).unmap= skel_unmap;
  (*l_widget_class).destroy= skel_destroy;
  (*l_widget_class).realize= skel_realize;
  (*l_widget_class).unrealize= skel_unrealize;
  (*l_widget_class).get_preferred_width= skel_get_preferred_width;
  (*l_widget_class).get_preferred_height= skel_get_preferred_height;
  (*l_widget_class).motion_notify_event= skel_motion_notify;
  (*l_widget_class).draw= skel_draw;

  return;
}

static void
skel_init(
  Skel *                               io_skel)
{
  SkelPrivate*                         l_priv; 

  SKEL(io_skel)->m_priv= skel_get_instance_private(io_skel);
  l_priv= SKEL(io_skel)->m_priv;
  memset(l_priv, 0, sizeof(*l_priv));

  gtk_widget_set_can_focus(GTK_WIDGET(io_skel), TRUE);
  gtk_widget_set_has_window(GTK_WIDGET(io_skel), FALSE);

  return;
}
