/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "orcl.hpp"

extern void
iwsql_type_translate(
  enum iwsql_type *const                o_type,
  oracle::occi::Type const              i_type)
{

  (*o_type)= iwsql_type_unkown;

  switch(i_type)
  {
  case oracle::occi::OCCI_SQLT_CHR:
    (*o_type)= iwsql_type_bytea;
  break;
  case oracle::occi::OCCI_SQLT_NUM:
  break;
  case oracle::occi::OCCIINT:
    (*o_type)= iwsql_type_long;
  break;
  case oracle::occi::OCCIFLOAT:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCIBFLOAT:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCIBDOUBLE:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCIIBFLOAT:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCIIBDOUBLE:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCI_SQLT_STR:
    (*o_type)= iwsql_type_bytea;
  break;
  case oracle::occi::OCCI_SQLT_VNU:
  break;
  case oracle::occi::OCCI_SQLT_PDN:
  break;
  case oracle::occi::OCCI_SQLT_LNG:
    (*o_type)= iwsql_type_long;
  break;
  case oracle::occi::OCCI_SQLT_VCS:
  break;
  case oracle::occi::OCCI_SQLT_NON:
  break;
  case oracle::occi::OCCI_SQLT_RID:
  break;
  case oracle::occi::OCCI_SQLT_DAT:
  break;
  case oracle::occi::OCCI_SQLT_VBI:
  break;
  case oracle::occi::OCCI_SQLT_BIN:
  break;
  case oracle::occi::OCCI_SQLT_LBI:
  break;
  case oracle::occi::OCCIUNSIGNED_INT:
    (*o_type)= iwsql_type_long;
  break;
  case oracle::occi::OCCI_SQLT_SLS:
  break;
  case oracle::occi::OCCI_SQLT_LVC:
  break;
  case oracle::occi::OCCI_SQLT_LVB:
  break;
  case oracle::occi::OCCI_SQLT_AFC:
    (*o_type)= iwsql_type_vchar;
  break;
  case oracle::occi::OCCI_SQLT_AVC:
  break;
  case oracle::occi::OCCI_SQLT_CUR:
  break;
  case oracle::occi::OCCI_SQLT_RDD:
  break;
  case oracle::occi::OCCI_SQLT_LAB:
  break;
  case oracle::occi::OCCI_SQLT_OSL:
  break;
  case oracle::occi::OCCI_SQLT_NTY:
  break;
  case oracle::occi::OCCI_SQLT_REF:
  break;
  case oracle::occi::OCCI_SQLT_CLOB:
  break;
  case oracle::occi::OCCI_SQLT_BLOB:
    (*o_type)= iwsql_type_blob;
  break;
/*
  case oracle::occi::OCCI_SQLT_BFILEE:
  break;
*/
/*
  case oracle::occi::OCCI_SQLT_CFILEE:
  break;
*/
  case oracle::occi::OCCI_SQLT_RSET:
  break;
  case oracle::occi::OCCI_SQLT_NCO:
  break;
  case oracle::occi::OCCI_SQLT_VST:
  break;
  case oracle::occi::OCCI_SQLT_ODT:
  break;
  case oracle::occi::OCCI_SQLT_DATE:
  break;
  case oracle::occi::OCCI_SQLT_TIME:
  break;
  case oracle::occi::OCCI_SQLT_TIME_TZ:
  break;
  case oracle::occi::OCCI_SQLT_TIMESTAMP:
  break;
  case oracle::occi::OCCI_SQLT_TIMESTAMP_TZ:
  break;
  case oracle::occi::OCCI_SQLT_INTERVAL_YM:
  break;
  case oracle::occi::OCCI_SQLT_INTERVAL_DS:
  break;
  case oracle::occi::OCCI_SQLT_TIMESTAMP_LTZ:
  break;
/*
  case oracle::occi::OCCI_SQLT_FILE:
  break;
*/
  case oracle::occi::OCCI_SQLT_CFILE:
  break;
  case oracle::occi::OCCI_SQLT_BFILE:
  break;
  case oracle::occi::OCCICHAR:
    (*o_type)= iwsql_type_bytea;
  break;
  case oracle::occi::OCCIDOUBLE:
    (*o_type)= iwsql_type_double;
  break;
  case oracle::occi::OCCIBOOL:
    (*o_type)= iwsql_type_bool;
  break;
  case oracle::occi::OCCIANYDATA:
  break;
  case oracle::occi::OCCINUMBER:
  break;
  case oracle::occi::OCCIBLOB:
    (*o_type)= iwsql_type_blob;
  break;
  case oracle::occi::OCCIBFILE:
  break;
  case oracle::occi::OCCIBYTES:
  break;
  case oracle::occi::OCCICLOB:
  break;
  case oracle::occi::OCCIVECTOR:
  break;
  case oracle::occi::OCCIMETADATA:
  break;
  case oracle::occi::OCCIPOBJECT:
  break;
  case oracle::occi::OCCIREF:
  break;
  case oracle::occi::OCCIREFANY:
  break;
  case oracle::occi::OCCISTRING:
  break;
  case oracle::occi::OCCISTREAM:
  break;
  case oracle::occi::OCCIDATE:
  break;
  case oracle::occi::OCCIINTERVALDS:
  break;
  case oracle::occi::OCCIINTERVALYM:
  break;
  case oracle::occi::OCCITIMESTAMP:
  break;
  case oracle::occi::OCCIROWID:
  break;
  case oracle::occi::OCCICURSOR:
  break;
  default:
    break;
  }

  return;
}


