(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics written for Isabelle/Isar.

    Copyright (C) 2012-2013 Daniel de la Concepcion

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. *)

header{*\isaheader{Topology\_ZF\_6.thy}*}

theory Topology_ZF_6 imports Topology_ZF_4 Topology_ZF_2 Topology_ZF_1

begin

text{*
  This theory deals with the relations between continuous functions and convergence
  of filters. At the end of the file there some results about the building of functions
  in cartesian products.
  *}

section{*Image filter*}

text{*First of all, we will define the appropriate tools to work with functions
and filters together.*}

definition
  ImageFilter ("_[_].._" 98)
  where "\<FF> {is a filter on} X \<Longrightarrow> f:X\<rightarrow>Y \<Longrightarrow> f[\<FF>]..Y \<equiv> {A\<in>Pow(Y). \<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>A}"

text{*Note that in the previous definition, it is necessary to state
 $Y$ as the final set because $f$ is also a function to every superset of its range.
$X$ can be changed by @{text "domain(f)"} without any change in the definition.*}

lemma base_image_filter:
  assumes "\<FF> {is a filter on} X" "f:X\<rightarrow>Y"
  shows "{f``B .B\<in>\<FF>} {is a base filter}(f[\<FF>]..Y)" and "(f[\<FF>]..Y) {is a filter on} Y"
proof-
  {
    assume "0\<in>{f``B .B\<in>\<FF>}"
    then obtain B where "B\<in>\<FF>" and f_B:"f``B=0" by auto
    then have "B\<in>Pow(X)" using assms(1) IsFilter_def by auto
    then have "f``B={f`b. b\<in>B}" using image_fun assms(2) by auto
    with f_B have "{f`b. b\<in>B}=0" by auto
    then have "B=0" by auto
    with `B\<in>\<FF>` have "False" using IsFilter_def assms(1) by auto
  }
  then have "0\<notin>{f``B .B\<in>\<FF>}" by auto
  moreover
  from assms(1) obtain S where "S\<in>\<FF>" using IsFilter_def by auto
  then have "f``S\<in>{f``B .B\<in>\<FF>}" by auto
  then have nA:"{f``B .B\<in>\<FF>}\<noteq>0" by auto
  moreover
  {
    fix A B
    assume "A\<in>{f``B .B\<in>\<FF>}" and "B\<in>{f``B .B\<in>\<FF>}"
    then obtain AB BB where "A=f``AB" "B=f``BB" "AB\<in>\<FF>" "BB\<in>\<FF>" by auto
    then have "A\<inter>B=(f``AB)\<inter>(f``BB)" by auto
    then have "f``(AB\<inter>BB)\<subseteq>A\<inter>B" by auto
    moreover
    with `AB\<in>\<FF>``BB\<in>\<FF>` have "AB\<inter>BB\<in>\<FF>" using IsFilter_def assms(1) by auto
    ultimately have "\<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>A\<inter>B" by auto
  }
  then have "\<forall>A\<in>{f``B .B\<in>\<FF>}. \<forall>B\<in>{f``B .B\<in>\<FF>}. \<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>A\<inter>B" by auto
  ultimately have sbc:"{f``B .B\<in>\<FF>} {satisfies the filter base condition}" using SatisfiesFilterBase_def
    by auto
  moreover
  {
    fix t
    assume "t\<in>{f``B . B\<in>\<FF>}"
    then obtain B where "B\<in>\<FF>" and im_def:"f``B=t" by auto
    then have "B\<in>Pow(X)" using assms(1) unfolding IsFilter_def by auto
    with im_def have "t={f`x. x\<in>B}" using image_fun assms(2) by auto
    with `B\<in>Pow(X)` have "t\<subseteq>Y" using apply_funtype assms(2) by auto
    }
  then have nB:"{f``B . B\<in>\<FF>}\<subseteq>Pow(Y)" by auto
  ultimately
  have "(({f``B .B\<in>\<FF>} {is a base filter}{A \<in> Pow(Y) . \<exists>D\<in>{f``B .B\<in>\<FF>}. D \<subseteq> A}) \<and> (\<Union>{A \<in> Pow(Y) . \<exists>D\<in>{f``B .B\<in>\<FF>}. D \<subseteq> A}=Y))" using base_unique_filter_set2 
    by force
  then have "{f``B .B\<in>\<FF>} {is a base filter}{A \<in> Pow(Y) . \<exists>D\<in>{f``B .B\<in>\<FF>}. D \<subseteq> A}" by auto
  then show "{f``B .B\<in>\<FF>} {is a base filter}(f[\<FF>]..Y)" using ImageFilter_def assms by auto
  moreover
  note sbc
  moreover
  {from nA obtain D where "D\<in>{f``B .B\<in>\<FF>}" by blast
  moreover
  with nB have "D\<subseteq>Y" by auto
  ultimately have "Y\<in>{A\<in>Pow(Y). \<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>A}" by auto}
  then have "\<Union>{A\<in>Pow(Y). \<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>A}=Y" by auto
  with basic_filter calculation(1) show "(f[\<FF>]..Y) {is a filter on} Y" using calculation(2)
    using ImageFilter_def assms by auto
qed

section{*Continuous at a point vs. globally continuous*}

text{*If a function is continuous, then it is continuous at every point.*}

lemma cont_global_imp_continuous_x:
  fixes x
  assumes "IsContinuous(\<tau>\<^isub>1,\<tau>\<^isub>2,f)" "f\<in>(\<Union>\<tau>\<^isub>1)\<rightarrow>(\<Union>\<tau>\<^isub>2)" "x\<in>\<Union>\<tau>\<^isub>1"
  shows "\<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)"
proof-
  {
    fix U
    assume AS:"U\<in>\<tau>\<^isub>2""f`x\<in>U"
    then have "f-``(U)\<in>\<tau>\<^isub>1" using assms(1) IsContinuous_def by auto
    moreover
    have "f``(f-``(U))\<subseteq>U" using function_image_vimage fun_is_fun assms(2) by auto
    moreover
    from AS(2) have "x\<in>f-``U" using func1_1_L15 assms(2) assms(3) by auto
    ultimately have "\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U" by auto
  }
  then show "\<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)" by auto
qed

lemma ccontinuous_all_x_imp_cont_global:
  assumes "\<forall>x\<in>\<Union>\<tau>\<^isub>1. \<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)" "f\<in>(\<Union>\<tau>\<^isub>1)\<rightarrow>(\<Union>\<tau>\<^isub>2)" "\<tau>\<^isub>1 {is a topology}"
  shows "IsContinuous(\<tau>\<^isub>1,\<tau>\<^isub>2,f)"
proof-
  {
    fix U
    assume "U\<in>\<tau>\<^isub>2"
    {
      note `U\<in>\<tau>\<^isub>2`
      moreover
      fix x
      assume AS:"x\<in>f-``U"
      then have "f -`` U \<subseteq> \<Union>\<tau>\<^isub>1" using func1_1_L6A assms(2) by auto
      with AS have "x\<in>\<Union>\<tau>\<^isub>1" by auto
      then have "\<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)" using assms(1) by auto
      moreover
      from AS have "f`x\<in>U" using func1_1_L15 assms(2) by auto
      ultimately have "\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U" by auto
      then obtain V where "V\<in>\<tau>\<^isub>1" "x\<in>V" "f``V\<subseteq>U" by auto
      moreover
      then have "V\<subseteq>\<Union>\<tau>\<^isub>1" by auto
      moreover
      then have "V\<subseteq>f-``(f``V)" using func1_1_L9 assms(2) by auto
      ultimately have "V\<subseteq>f-``U" by blast
      with `V\<in>\<tau>\<^isub>1` `x\<in>V` have "\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> V\<subseteq>f-``U" by auto
      }
    then have "\<forall>x\<in>f-``U. \<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> V\<subseteq>f-``U" by auto
    then have "f-``(U)\<in>\<tau>\<^isub>1" using topology0.open_neigh_open topology0_def assms(3) by auto
  }
  then have "\<forall>U\<in>\<tau>\<^isub>2. f-``U\<in>\<tau>\<^isub>1" by auto
  then show ?thesis using IsContinuous_def by auto
qed

section{*Continuous functions and filters*}

text{*Now, let's get to the continuity-filter relation. If the function is continuous; then,
if the filter converges to a point, the image filter converges to the image point.*}

lemma (in two_top_spaces0) cont_imp_filter_conver_preserved:
  assumes "\<FF> {is a filter on} X\<^isub>1" "f {is continuous}" "\<FF> \<rightarrow>\<^isub>F x {in} \<tau>\<^isub>1"
  shows "(f[\<FF>]..X\<^isub>2) \<rightarrow>\<^isub>F (f`x) {in} \<tau>\<^isub>2"
proof-
  have x1:"x\<in>X\<^isub>1" using assms(3) topology0.FilterConverges_def topol_cntxs_valid(1) assms(1) X1_def by auto
  have "\<forall>o\<in>X\<^isub>1. f`o\<in>X\<^isub>2" using apply_funtype fmapAssum by blast
  with x1 have "f`x\<in>\<Union>\<tau>\<^isub>2" by auto
  moreover
  {
    fix U
    assume "U\<in>Pow(X\<^isub>2)" "(f`x)\<in>Interior(U,\<tau>\<^isub>2)"
    then have xim:"x\<in>f-``(Interior(U,\<tau>\<^isub>2))" and sub:"f-``(Interior(U,\<tau>\<^isub>2))\<in>Pow(X\<^isub>1)" using func1_1_L6A 
      fmapAssum func1_1_L15 fmapAssum x1 by auto
    note sub moreover
    have "Interior(U,\<tau>\<^isub>2)\<in>\<tau>\<^isub>2" using topology0.Top_2_L2 topol_cntxs_valid(2) by auto
    then have "f-``(Interior(U,\<tau>\<^isub>2))\<in>\<tau>\<^isub>1" using assms(2) unfolding isContinuous_def IsContinuous_def
      by auto
    with xim have "x\<in>Interior(f-``(Interior(U,\<tau>\<^isub>2)),\<tau>\<^isub>1)" using topology0.Top_2_L3
      topol_cntxs_valid(1) by auto
    moreover
      have "{U\<in>Pow(X\<^isub>1). x\<in>Interior(U,\<tau>\<^isub>1)}\<subseteq>\<FF>" using assms(3) topology0.FilterConverges_def topol_cntxs_valid(1) 
      assms(1) X1_def by auto
    ultimately have "f-``(Interior(U,\<tau>\<^isub>2))\<in>\<FF>" by auto
    moreover
    have "f``(f-``(Interior(U,\<tau>\<^isub>2)))\<subseteq>Interior(U,\<tau>\<^isub>2)" using function_image_vimage fun_is_fun fmapAssum
    by auto
    then have "f``(f-``(Interior(U,\<tau>\<^isub>2)))\<subseteq>U" using topology0.Top_2_L1 topol_cntxs_valid(2) by auto
    ultimately have "\<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>U" by auto
  }
  then have "\<forall>U\<in>Pow(\<Union>\<tau>\<^isub>2). (f`x)\<in>Interior(U,\<tau>\<^isub>2) \<longrightarrow> (\<exists>D\<in>{f``B .B\<in>\<FF>}. D\<subseteq>U)" by auto
  moreover
  have "{f``B .B\<in>\<FF>} {is a base filter}(f[\<FF>]..X\<^isub>2)" and "(f[\<FF>]..X\<^isub>2) {is a filter on} (\<Union>\<tau>\<^isub>2)"
    using base_image_filter assms(1) fmapAssum unfolding X1_def X2_def by auto
  from topology0.convergence_filter_base2 topol_cntxs_valid(2) this(2) this(1) calculation(2) calculation(1) show ?thesis .
qed

lemma (in two_top_spaces0) filter_conver_preserved_imp_cont:
  assumes "\<forall>x\<in>\<Union>\<tau>\<^isub>1. \<forall>\<FF>. ((\<FF> {is a filter on} X\<^isub>1) \<and> (\<FF> \<rightarrow>\<^isub>F x {in} \<tau>\<^isub>1)) \<longrightarrow> ((f[\<FF>]..X\<^isub>2) \<rightarrow>\<^isub>F (f`x) {in} \<tau>\<^isub>2)"
  shows "f{is continuous}"
proof-
  {
    fix x
    assume as2:"x\<in>\<Union>\<tau>\<^isub>1"
    with assms have reg:"\<forall>\<FF>. ((\<FF> {is a filter on} X\<^isub>1) \<and> (\<FF> \<rightarrow>\<^isub>F x {in} \<tau>\<^isub>1)) \<longrightarrow> ((f[\<FF>]..X\<^isub>2) \<rightarrow>\<^isub>F (f`x) {in} \<tau>\<^isub>2)" by auto
    let ?Neig="{U \<in> Pow(\<Union>\<tau>\<^isub>1) . x \<in> Interior(U, \<tau>\<^isub>1)}"
    from topology0.neigh_filter have NFil:"?Neig{is a filter on}X\<^isub>1" and NCon:"?Neig \<rightarrow>\<^isub>F x {in} \<tau>\<^isub>1"
      using topol_cntxs_valid(1) as2 by auto
    {
      fix U
      assume "U\<in>\<tau>\<^isub>2" "f`x\<in>U"
      then have "U\<in>Pow(\<Union>\<tau>\<^isub>2)" "f`x\<in>Interior(U,\<tau>\<^isub>2)" using topol_cntxs_valid(2) topology0.Top_2_L3 by auto
      moreover
      from NCon NFil reg have "(f[?Neig]..X\<^isub>2) \<rightarrow>\<^isub>F (f`x) {in} \<tau>\<^isub>2" by auto moreover
      have "(f[?Neig]..X\<^isub>2) {is a filter on} X\<^isub>2" using base_image_filter(2) NFil fmapAssum by auto
      ultimately have "U\<in>(f[?Neig]..X\<^isub>2)" using topology0.FilterConverges_def topol_cntxs_valid(2) unfolding X1_def X2_def by auto
      moreover
      have "{f``B .B\<in>?Neig} {is a base filter}(f[?Neig]..X\<^isub>2)" using base_image_filter(1)
        NFil fmapAssum unfolding X1_def X2_def by auto
      ultimately have "\<exists>V\<in>{f``B .B\<in>?Neig}. V\<subseteq>U" using basic_element_filter by blast
      then obtain B where "B\<in>?Neig" "f``B\<subseteq>U" by auto
      moreover
      have "Interior(B,\<tau>\<^isub>1)\<subseteq>B" using topology0.Top_2_L1 topol_cntxs_valid(1) by auto
      then have "f``Interior(B,\<tau>\<^isub>1)\<subseteq>f``B" by auto
      moreover
      have "Interior(B,\<tau>\<^isub>1)\<in>\<tau>\<^isub>1" using topology0.Top_2_L2 topol_cntxs_valid(1) by auto
      ultimately
      have "\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U" by force
    }
    then have "\<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)" by auto
  }
  then have "\<forall>x\<in>\<Union>\<tau>\<^isub>1. \<forall>U\<in>\<tau>\<^isub>2. f`x\<in>U \<longrightarrow> (\<exists>V\<in>\<tau>\<^isub>1. x\<in>V \<and> f``V\<subseteq>U)" by auto
  then show ?thesis using ccontinuous_all_x_imp_cont_global fmapAssum unfolding X1_def X2_def isContinuous_def using tau1_is_top by auto
qed

section{*Functions on cartesian products*}

text{*Given two functions, its product is a function.*}

lemma prod_fun:
  assumes "f:X\<^isub>1\<rightarrow>X\<^isub>2""g:X\<^isub>3\<rightarrow>X\<^isub>4"
  shows "{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>X\<^isub>3}:X\<^isub>1\<times>X\<^isub>3\<rightarrow>X\<^isub>2\<times>X\<^isub>4" 
proof-
 have "{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>X\<^isub>3}\<in>Pow((X\<^isub>1\<times>X\<^isub>3)\<times>(X\<^isub>2\<times>X\<^isub>4))" using apply_type assms(1) apply_type assms(2)
    by (safe,auto) moreover
  have "function({\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>X\<^isub>3})" unfolding function_def by auto
  moreover have "X\<^isub>1\<times>X\<^isub>3\<subseteq>domain({\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>X\<^isub>3})" unfolding domain_def
    by (safe,force)
  ultimately show fg_fun:"{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>X\<^isub>3}:X\<^isub>1\<times>X\<^isub>3\<rightarrow>X\<^isub>2\<times>X\<^isub>4" unfolding Pi_def by auto
qed

theorem prod_functions_surj:
  assumes "f\<in>surj(A,B)" "g\<in>surj(C,D)"
  shows "{\<langle>\<langle>a1,a2\<rangle>,\<langle>f`a1,g`a2\<rangle>\<rangle>.\<langle>a1,a2\<rangle>\<in>A\<times>C}\<in>surj(A\<times>C,B\<times>D)"
proof-  
  from assms have fun:"f:A\<rightarrow>B""g:C\<rightarrow>D" unfolding surj_def by auto
  then have pfun:"{\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> A \<times> C} \<in> A \<times> C \<rightarrow> B \<times> D" using prod_fun by auto
  {
    fix b assume "b\<in>B\<times>D"
    then obtain b1 b2 where "b=\<langle>b1,b2\<rangle>""b1\<in>B""b2\<in>D" by auto
    then obtain a1 a2 where "f`a1=b1""g`a2=b2""a1\<in>A""a2\<in>C" using assms unfolding surj_def
      by blast
    then have "\<langle>\<langle>a1,a2\<rangle>,\<langle>b1,b2\<rangle>\<rangle>\<in>{\<langle>\<langle>a1,a2\<rangle>,\<langle>f`a1,g`a2\<rangle>\<rangle>.\<langle>a1,a2\<rangle>\<in>A\<times>C}" by auto
    then have "{\<langle>\<langle>a1,a2\<rangle>,\<langle>f`a1,g`a2\<rangle>\<rangle>.\<langle>a1,a2\<rangle>\<in>A\<times>C}`\<langle>a1,a2\<rangle>=\<langle>b1,b2\<rangle>" using apply_equality
      pfun by auto
    then have "\<exists>aa\<in>A\<times>C. {\<langle>\<langle>a1,a2\<rangle>,\<langle>f`a1,g`a2\<rangle>\<rangle>.\<langle>a1,a2\<rangle>\<in>A\<times>C}`aa=b" using `b=\<langle>b1,b2\<rangle>``a1\<in>A``a2\<in>C` by auto
  }
  then have "\<forall>bb\<in>B\<times>D. \<exists>aa\<in>A\<times>C. {\<langle>\<langle>a1,a2\<rangle>,\<langle>f`a1,g`a2\<rangle>\<rangle>.\<langle>a1,a2\<rangle>\<in>A\<times>C}`aa=bb" by auto
  then show ?thesis using pfun unfolding surj_def by auto
qed

theorem(in two_top_spaces0) product_cont_functions:
  assumes "f:X\<^isub>1\<rightarrow>X\<^isub>2""g:\<Union>\<tau>\<^isub>3\<rightarrow>\<Union>\<tau>\<^isub>4""IsContinuous(\<tau>\<^isub>1,\<tau>\<^isub>2,f)""IsContinuous(\<tau>\<^isub>3,\<tau>\<^isub>4,g)""\<tau>\<^isub>4{is a topology}""\<tau>\<^isub>3{is a topology}"
  shows "IsContinuous(ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3),ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4),{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3})"
proof-
  have fg_fun:"{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}:X\<^isub>1\<times>\<Union>\<tau>\<^isub>3\<rightarrow>X\<^isub>2\<times>\<Union>\<tau>\<^isub>4" using assms(1,2) using prod_fun by auto
  have tops:"ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3){is a topology}""ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4){is a topology}" using Top_1_4_T1(1) tau1_is_top
    assms(6) Top_1_4_T1(1) tau2_is_top assms(5) by auto
  have bas:"ProductCollection(\<tau>\<^isub>2,\<tau>\<^isub>4){is a base for}ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4)" using Top_1_4_T1(2) tau2_is_top assms(5) by auto
  have "\<Union>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)=X\<^isub>1\<times>\<Union>\<tau>\<^isub>3""\<Union>ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4)=X\<^isub>2\<times>\<Union>\<tau>\<^isub>4" using Top_1_4_T1(3) tau1_is_top assms(6)
    Top_1_4_T1(3) tau2_is_top assms(5) by auto
  with fg_fun have fg_2:"{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}:\<Union>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)\<rightarrow>\<Union>ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4)" by auto
  {  
    fix R assume "R\<in>ProductCollection(\<tau>\<^isub>2,\<tau>\<^isub>4)"
    then obtain A B where R_def:"R=A\<times>B" and "A\<in>\<tau>\<^isub>2""B\<in>\<tau>\<^isub>4" unfolding ProductCollection_def by auto
    then have "{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``R={\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)" by auto
    {
      fix P assume PP:"P\<in>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)"
      then obtain s t where P_def:"P=\<langle>s,t\<rangle>" and "s\<in>X\<^isub>1""t\<in>\<Union>\<tau>\<^isub>3" using func1_1_L6A fg_fun by blast
      with PP obtain u v where "\<langle>\<langle>s,t\<rangle>,\<langle>u,v\<rangle>\<rangle>\<in>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}""\<langle>u,v\<rangle>\<in>(A\<times>B)" using vimage_iff by auto
      then have "\<langle>u,v\<rangle>=\<langle>f`s,g`t\<rangle>"and p:"u\<in>A""v\<in>B""s\<in>X\<^isub>1""t\<in>\<Union>\<tau>\<^isub>3" by auto
      then have "u=f`s""v=g`t" by auto
      with p have "s\<in>f-``A""t\<in>g-``B" using func1_1_L15 assms(1) func1_1_L15  assms(2)
        by auto
      then have pp:"\<langle>s,t\<rangle>\<in>(f-``A)\<times>(g-``B)" by auto
      from `A\<in>\<tau>\<^isub>2` assms(3) have "f-``A\<in>\<tau>\<^isub>1" unfolding IsContinuous_def by auto moreover
      from `B\<in>\<tau>\<^isub>4` assms(4) have "g-``B\<in>\<tau>\<^isub>3" unfolding IsContinuous_def by auto ultimately
      have "(f-``A)\<times>(g-``B)\<in>ProductCollection(\<tau>\<^isub>1,\<tau>\<^isub>3)" unfolding ProductCollection_def by auto moreover
      have "ProductCollection(\<tau>\<^isub>1,\<tau>\<^isub>3) {is a base for} ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)" using Top_1_4_T1(2) tau1_is_top assms(6) by auto
      ultimately have op:"(f-``A)\<times>(g-``B)\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)" using base_sets_open by auto
      {
        fix C D assume "\<langle>C,D\<rangle>\<in>(f-``A)\<times>(g-``B)"
        then have Su:"C\<in>(f-``A)""D\<in>(g-``B)" by auto
        then have "f`C\<in>A""g`D\<in>B" using func1_1_L15 assms(1) func1_1_L15 assms(2) by auto
        then have pro:"\<langle>f`C,g`D\<rangle>\<in>A\<times>B" by auto
        have "f-``A\<subseteq>X\<^isub>1""g-``B\<subseteq>\<Union>\<tau>\<^isub>3" using func1_1_L6A assms(1) func1_1_L6A assms(2) by auto
        with Su have "\<langle>C,D\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3" by auto
        with pro have "\<langle>C,D\<rangle>\<in>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)" using vimage_iff by auto
      }
      then have "(f-``A)\<times>(g-``B)\<subseteq>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)" by blast
      with pp op have "\<exists>U\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3). P\<in>U\<and>U\<subseteq>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)"
        using exI[where x="(f-``A)\<times>(g-``B)" and P="\<lambda>U. U\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)\<and>\<langle>s,t\<rangle>\<in>U\<and>U\<subseteq>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)"] 
        P_def by auto
      }
    then have "\<forall>P\<in>{\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> X\<^isub>1 \<times> \<Union>\<tau>\<^isub>3} -`` (A \<times> B). \<exists>U\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3). P\<in>U\<and>U\<subseteq>{\<langle>\<langle>x,y\<rangle>,\<langle>f`x,g`y\<rangle>\<rangle>. \<langle>x,y\<rangle>\<in>X\<^isub>1\<times>\<Union>\<tau>\<^isub>3}-``(A\<times>B)"
      by auto
    then have "{\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> X\<^isub>1 \<times> \<Union>\<tau>\<^isub>3} -`` (A \<times> B)\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)" using topology0.open_neigh_open
      unfolding topology0_def using tops(1) by auto
    then have "{\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> X\<^isub>1 \<times> \<Union>\<tau>\<^isub>3} -`` (R)\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)" using R_def by auto
  }
  then have "\<forall>R\<in>ProductCollection(\<tau>\<^isub>2,\<tau>\<^isub>4). {\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> X\<^isub>1 \<times> \<Union>\<tau>\<^isub>3} -`` (R)\<in>ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3)" by auto moreover
  have "two_top_spaces0(ProductTopology(\<tau>\<^isub>1,\<tau>\<^isub>3),ProductTopology(\<tau>\<^isub>2,\<tau>\<^isub>4),{\<langle>\<langle>x, y\<rangle>, f ` x, g ` y\<rangle> . \<langle>x,y\<rangle> \<in> X\<^isub>1 \<times> \<Union>\<tau>\<^isub>3})"
    unfolding two_top_spaces0_def using tops fg_2 by auto
  ultimately show ?thesis using two_top_spaces0.Top_ZF_2_1_L5 bas by auto
qed

end

