(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2011, 2012  Slawomir Kolodynski

    This program is free software Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES LOSS OF USE, DATA, OR PROFITS OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header{*\isaheader{Topology\_ZF\_3.thy}*}

theory Topology_ZF_3 imports Topology_ZF_2 FiniteSeq_ZF

begin

text{* @{text "Topology_ZF_1"} theory describes how we can define  a topology on a product
of two topological spaces. One way to generalize that is to construct topology for a cartesian
product of $n$ topological spaces. The cartesian product approach is somewhat inconvenient though.
Another way to approach product topology on $X^n$ is to model cartesian product as sets of 
sequences (of length $n$) of elements of $X$. This means that having a topology on $X$ we want
to define a toplogy on the space $n\rightarrow X$, where $n$ is a natural number (recall that 
$n = \{ 0,1,...,n-1\}$ in ZF). However, this in turn can be done more generally by defining a 
topology on any function space $I\rightarrow X$, where $I$ is any set of indices. This is what we 
do in this theory.*}

section{*The base of the product topology*}

text{*In this section we define the base of the product topology.*}

text{*Suppose $\mathcal{X} = I\rightarrow \bigcup T$ is a space of functions from some index set $I$
to the carrier of a topology $T$. Then take a finite) collection of open sets $W:N\rightarrow T$ 
indexed by $N\subseteq I$. We can define a subset of $\mathcal{X}$ that models the cartesian product of $W$
*}

definition
  "FinProd(\<X>,W) \<equiv> {x\<in>\<X>. \<forall> i\<in>domain(W). x`(i) \<in> W`(i)}"

text{*Now we define the base of the product topology as the collection of all finite products 
(in the sense defined above) of open sets. 
*}

definition
  "ProductTopBase(I,T) \<equiv>  \<Union>N\<in>FinPow(I).{FinProd(I\<rightarrow>\<Union>T,W). W\<in>N\<rightarrow>T}"

text{*Finally, we define the product topology on sequences. We use the ''Seq'' 
prefix although the definition is good for any index sets, not only natural numbers.*}

definition
  "SeqProductTopology(I,T) \<equiv> {\<Union>B. B \<in> Pow(ProductTopBase(I,T))}"

text{*Product topology base is closed with respect to intersections.*}

lemma prod_top_base_inter: 
  assumes A1: "T {is a topology}" and  
  A2: "U \<in> ProductTopBase(I,T)"  "V \<in> ProductTopBase(I,T)"
  shows "U\<inter>V \<in> ProductTopBase(I,T)"
proof -
  let ?\<X> = "I\<rightarrow>\<Union>T"  
  from A2 obtain N\<^isub>1  W\<^isub>1 N\<^isub>2 W\<^isub>2 where 
    I: "N\<^isub>1 \<in> FinPow(I)"  "W\<^isub>1\<in>N\<^isub>1\<rightarrow>T"  "U = FinProd(?\<X>,W\<^isub>1)" and
    II: "N\<^isub>2 \<in> FinPow(I)"  "W\<^isub>2\<in>N\<^isub>2\<rightarrow>T"  "V = FinProd(?\<X>,W\<^isub>2)"
    using ProductTopBase_def by auto
  let ?N\<^isub>3 = "N\<^isub>1 \<union> N\<^isub>2"
  let ?W\<^isub>3 = 
    "{\<langle>i,if i \<in> N\<^isub>1-N\<^isub>2 then W\<^isub>1`(i) 
        else if i \<in> N\<^isub>2-N\<^isub>1 then  W\<^isub>2`(i) 
        else (W\<^isub>1`(i)) \<inter> (W\<^isub>2`(i))\<rangle>. i \<in> ?N\<^isub>3}"
  from A1 I II have "\<forall>i \<in> N\<^isub>1 \<inter> N\<^isub>2.  (W\<^isub>1`(i) \<inter> W\<^isub>2`(i)) \<in> T"
      using apply_funtype IsATopology_def by auto
  moreover from I II have "\<forall>i\<in>N\<^isub>1-N\<^isub>2. W\<^isub>1`(i) \<in> T" and "\<forall>i\<in>N\<^isub>2-N\<^isub>1. W\<^isub>2`(i) \<in> T" 
      using apply_funtype by auto
  ultimately have  "?W\<^isub>3:?N\<^isub>3\<rightarrow>T" by (rule fun_union_overlap)
  with I II have "FinProd(?\<X>,?W\<^isub>3) \<in> ProductTopBase(I,T)" using union_finpow ProductTopBase_def
    by auto
  moreover have "U\<inter>V = FinProd(?\<X>,?W\<^isub>3)"
  proof
    { fix x assume "x\<in>U" and "x\<in>V"
      with `U = FinProd(?\<X>,W\<^isub>1)`  `W\<^isub>1\<in>N\<^isub>1\<rightarrow>T` and  `V = FinProd(?\<X>,W\<^isub>2)`  `W\<^isub>2\<in>N\<^isub>2\<rightarrow>T`
      have "x\<in>?\<X>" and "\<forall>i\<in>N\<^isub>1. x`(i) \<in> W\<^isub>1`(i)" and "\<forall>i\<in>N\<^isub>2. x`(i) \<in> W\<^isub>2`(i)"
        using func1_1_L1 FinProd_def by auto
      with `?W\<^isub>3:?N\<^isub>3\<rightarrow>T` `x\<in>?\<X>` have "x \<in> FinProd(?\<X>,?W\<^isub>3)"  
        using ZF_fun_from_tot_val func1_1_L1 FinProd_def by auto
    } thus "U\<inter>V \<subseteq> FinProd(?\<X>,?W\<^isub>3)" by auto
    { fix x assume "x \<in> FinProd(?\<X>,?W\<^isub>3)"
      with `?W\<^isub>3:?N\<^isub>3\<rightarrow>T` have "x:I\<rightarrow>\<Union>T" and III: "\<forall>i\<in>?N\<^isub>3. x`(i) \<in> ?W\<^isub>3`(i)"
        using FinProd_def func1_1_L1 by auto
     { fix i assume "i\<in>N\<^isub>1" 
       with `?W\<^isub>3:?N\<^isub>3\<rightarrow>T` have "?W\<^isub>3`(i) \<subseteq> W\<^isub>1`(i)" using ZF_fun_from_tot_val by auto
       with III `i\<in>N\<^isub>1` have "x`(i) \<in> W\<^isub>1`(i)" by auto
     } with `W\<^isub>1\<in>N\<^isub>1\<rightarrow>T` `x:I\<rightarrow>\<Union>T` `U = FinProd(?\<X>,W\<^isub>1)` 
      have "x \<in> U" using func1_1_L1 FinProd_def by auto
      moreover
      { fix i assume "i\<in>N\<^isub>2" 
        with `?W\<^isub>3:?N\<^isub>3\<rightarrow>T` have "?W\<^isub>3`(i) \<subseteq> W\<^isub>2`(i)" using ZF_fun_from_tot_val by auto
        with III `i\<in>N\<^isub>2` have "x`(i) \<in> W\<^isub>2`(i)" by auto
      } with `W\<^isub>2\<in>N\<^isub>2\<rightarrow>T` `x:I\<rightarrow>\<Union>T` `V = FinProd(?\<X>,W\<^isub>2)` have "x\<in>V" 
          using func1_1_L1 FinProd_def by auto 
      ultimately have "x \<in> U\<inter>V" by simp
    } thus "FinProd(?\<X>,?W\<^isub>3) \<subseteq> U\<inter>V" by auto
  qed
    ultimately show ?thesis by simp
qed 

text{*In the next theorem we show the collection of sets defined above as 
@{text "ProductTopBase(\<X>,T)"} satisfies the base condition. This is a condition, defined in 
@{text "Topology_ZF_1"} that allows to claim that this collection is a base for some topology.*}

theorem prod_top_base_is_base: assumes "T {is a topology}" 
  shows "ProductTopBase(I,T) {satisfies the base condition}"
  using assms prod_top_base_inter inter_closed_base by simp

text{*The (sequence) product topology is indeed a topology on the space of sequences.
In the proof we are using the fact that $(\emptyset\rightarrow X) = \{\emptyset\}$.*}

theorem seq_prod_top_is_top:  assumes "T {is a topology}"
  shows 
  "SeqProductTopology(I,T) {is a topology}" and 
  "ProductTopBase(I,T) {is a base for} SeqProductTopology(I,T)" and
  "\<Union>SeqProductTopology(I,T) = (I\<rightarrow>\<Union>T)"
proof -
  from assms show "SeqProductTopology(I,T) {is a topology}" and 
    I: "ProductTopBase(I,T) {is a base for} SeqProductTopology(I,T)"
      using prod_top_base_is_base SeqProductTopology_def Top_1_2_T1
        by auto
  from I have "\<Union>SeqProductTopology(I,T) = \<Union>ProductTopBase(I,T)"
    using Top_1_2_L5 by simp
  also have "\<Union>ProductTopBase(I,T) = (I\<rightarrow>\<Union>T)"
  proof
    show "\<Union>ProductTopBase(I,T) \<subseteq> (I\<rightarrow>\<Union>T)" using ProductTopBase_def FinProd_def
      by auto
    have "0 \<in> FinPow(I)" using empty_in_finpow by simp
    hence "{FinProd(I\<rightarrow>\<Union>T,W). W\<in>0\<rightarrow>T} \<subseteq> (\<Union>N\<in>FinPow(I).{FinProd(I\<rightarrow>\<Union>T,W). W\<in>N\<rightarrow>T})"
      by blast
    then show "(I\<rightarrow>\<Union>T) \<subseteq> \<Union>ProductTopBase(I,T)" using ProductTopBase_def FinProd_def
      by auto
  qed     
  finally show "\<Union>SeqProductTopology(I,T) = (I\<rightarrow>\<Union>T)" by simp
qed

section{*Finite product of topologies*}

text{*As a special case of the space of functions $I\rightarrow X$ we can consider space of lists
of elements of $X$, i.e. space $n\rightarrow X$, where $n$ is a natural number (recall that in ZF 
set theory $n=\{0,1,...,n-1\}$). Such spaces model finite cartesian products $X^n$ 
but are easier to deal with in formalized way (than the said products). 
This section discusses natural topology defined on $n\rightarrow X$ where $X$ is a topological space.
*}

text{*When the index set is finite, the definition of @{text "ProductTopBase(I,T)"} 
can be simplifed.*}

lemma fin_prod_def_nat: assumes A1: "n\<in>nat" and A2: "T {is a topology}"  
  shows "ProductTopBase(n,T) = {FinProd(n\<rightarrow>\<Union>T,W). W\<in>n\<rightarrow>T}"
proof
  from A1 have "n \<in> FinPow(n)" using nat_finpow_nat fin_finpow_self by auto
  then show "{FinProd(n\<rightarrow>\<Union>T,W). W\<in>n\<rightarrow>T} \<subseteq> ProductTopBase(n,T)" using ProductTopBase_def
    by auto
  { fix B assume "B \<in> ProductTopBase(n,T)"
    then obtain N W where  "N \<in> FinPow(n)" and "W \<in> N\<rightarrow>T" and "B = FinProd(n\<rightarrow>\<Union>T,W)"
      using ProductTopBase_def by auto
    let ?W\<^isub>n = "{\<langle>i,if i\<in>N then W`(i) else \<Union>T\<rangle>. i\<in>n}"
    from A2  `N \<in> FinPow(n)`  `W\<in>N\<rightarrow>T` have "\<forall>i\<in>n. (if i\<in>N then W`(i) else \<Union>T) \<in> T"
      using apply_funtype FinPow_def IsATopology_def by auto
    then have "?W\<^isub>n:n\<rightarrow>T" by (rule ZF_fun_from_total)
    moreover have "B = FinProd(n\<rightarrow>\<Union>T,?W\<^isub>n)"
    proof
      { fix x assume "x\<in>B"
        with `B = FinProd(n\<rightarrow>\<Union>T,W)` have "x \<in> n\<rightarrow>\<Union>T" using FinProd_def by simp
        moreover have "\<forall>i\<in>domain(?W\<^isub>n). x`(i) \<in> ?W\<^isub>n`(i)"
        proof
          fix i assume "i \<in> domain(?W\<^isub>n)"
          with `?W\<^isub>n:n\<rightarrow>T` have "i\<in>n" using func1_1_L1 by simp 
          with `x:n\<rightarrow>\<Union>T` have "x`(i) \<in> \<Union>T" using apply_funtype by blast
          with `x\<in>B` `B = FinProd(n\<rightarrow>\<Union>T,W)` `W \<in> N\<rightarrow>T` `?W\<^isub>n:n\<rightarrow>T` `i\<in>n`
          show "x`(i) \<in> ?W\<^isub>n`(i)" using func1_1_L1 FinProd_def ZF_fun_from_tot_val 
            by simp
        qed
        ultimately have "x \<in> FinProd(n\<rightarrow>\<Union>T,?W\<^isub>n)" using FinProd_def by simp
      } thus "B \<subseteq> FinProd(n\<rightarrow>\<Union>T,?W\<^isub>n)" by auto
      next
      { fix x assume "x \<in> FinProd(n\<rightarrow>\<Union>T,?W\<^isub>n)"    
        then have "x \<in> n\<rightarrow>\<Union>T" and "\<forall>i\<in>domain(?W\<^isub>n). x`(i) \<in> ?W\<^isub>n`(i)" 
          using  FinProd_def by auto
        with `?W\<^isub>n:n\<rightarrow>T` and `N \<in> FinPow(n)` have "\<forall>i\<in>N. x`(i) \<in> ?W\<^isub>n`(i)"
          using func1_1_L1 FinPow_def by auto
        moreover from `?W\<^isub>n:n\<rightarrow>T` and `N \<in> FinPow(n)` 
        have "\<forall>i\<in>N. ?W\<^isub>n`(i) = W`(i)"
          using ZF_fun_from_tot_val FinPow_def by auto
        ultimately have "\<forall>i\<in>N. x`(i) \<in> W`(i)" by simp
        with `W \<in> N\<rightarrow>T` `x \<in> n\<rightarrow>\<Union>T` `B = FinProd(n\<rightarrow>\<Union>T,W)` have "x\<in>B"
          using func1_1_L1 FinProd_def by simp
     } thus "FinProd(n\<rightarrow>\<Union>T,?W\<^isub>n) \<subseteq> B" by auto
  qed 
    ultimately have "B \<in> {FinProd(n\<rightarrow>\<Union>T,W). W\<in>n\<rightarrow>T}" by auto
  } thus "ProductTopBase(n,T) \<subseteq> {FinProd(n\<rightarrow>\<Union>T,W). W\<in>n\<rightarrow>T}" by auto
qed

text{*A technical lemma describing the carrier of a (cartesian) product topology of  
the (sequence) product topology of $n$ copies of topology $\tau$ and another 
copy of $\tau$.*}

lemma finite_prod_top: assumes "\<tau> {is a topology}" and  "T = SeqProductTopology(n,\<tau>)"
  shows "(\<Union>ProductTopology(T,\<tau>)) = (n\<rightarrow>\<Union>\<tau>)\<times>\<Union>\<tau>"
  using assms Top_1_4_T1 seq_prod_top_is_top by simp

text{*If $U$ is a set from the base of $X^n$ and $V$ is open in $X$, then $U\times V$
is in the base of $X^{n+1}$. The next lemma is an analogue of this fact for the 
function space approach. *}

lemma finite_prod_succ_base: assumes A1: "\<tau> {is a topology}" and A2: "n \<in> nat" and 
  A3: "U \<in> ProductTopBase(n,\<tau>)" and A4: "V\<in>\<tau>"
  shows "{x \<in> succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> U \<and> x`(n) \<in> V} \<in> ProductTopBase(succ(n),\<tau>)"
  proof -
    let ?B = "{x \<in> succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> U \<and> x`(n) \<in> V}"
    from A1 A2 have "ProductTopBase(n,\<tau>) = {FinProd(n\<rightarrow>\<Union>\<tau>,W). W\<in>n\<rightarrow>\<tau>}"
      using fin_prod_def_nat by simp
    with A3 obtain W\<^isub>U where "W\<^isub>U:n\<rightarrow>\<tau>" and "U =FinProd(n\<rightarrow>\<Union>\<tau>,W\<^isub>U)" by auto
    let ?W = "Append(W\<^isub>U,V)"
    from A4 and `W\<^isub>U:n\<rightarrow>\<tau>` have "?W:succ(n)\<rightarrow>\<tau>" using append_props by simp
    moreover have "?B = FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W)"
    proof
      { fix x assume "x\<in>?B"
        with `?W:succ(n)\<rightarrow>\<tau>` have "x \<in> succ(n)\<rightarrow>\<Union>\<tau>" and "domain(?W) = succ(n)" using func1_1_L1 
          by auto
        moreover from A2 A4 `x\<in>?B` `U =FinProd(n\<rightarrow>\<Union>\<tau>,W\<^isub>U)` `W\<^isub>U:n\<rightarrow>\<tau>` `x \<in> succ(n)\<rightarrow>\<Union>\<tau>` 
        have "\<forall>i\<in>succ(n). x`(i) \<in> ?W`(i)" using func1_1_L1 FinProd_def init_props append_props
          by simp 
        ultimately have "x \<in> FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W)" using FinProd_def by simp 
      } thus "?B \<subseteq> FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W)" by auto
      next
      { fix x assume "x \<in> FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W)"
        then have "x:succ(n)\<rightarrow>\<Union>\<tau>" and I: "\<forall>i \<in> domain(?W). x`(i) \<in> ?W`(i)"
          using FinProd_def by auto
        moreover have "Init(x) \<in> U"
        proof -
          from A2 and `x:succ(n)\<rightarrow>\<Union>\<tau>` have "Init(x):n\<rightarrow>\<Union>\<tau>" using init_props by simp 
          moreover have "\<forall>i\<in>domain(W\<^isub>U). Init(x)`(i) \<in> W\<^isub>U`(i)"
          proof -
            from A2 `x \<in> FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W)` `?W:succ(n)\<rightarrow>\<tau>` have "\<forall>i\<in>n. x`(i) \<in> ?W`(i)"
              using FinProd_def func1_1_L1 by simp 
            moreover from A2 `x: succ(n)\<rightarrow>\<Union>\<tau>` have "\<forall>i\<in>n. Init(x)`(i) = x`(i)"
              using init_props by simp
            moreover from A4 and `W\<^isub>U:n\<rightarrow>\<tau>` have "\<forall>i\<in>n. ?W`(i) =  W\<^isub>U`(i)"
              using append_props by simp
            ultimately have "\<forall>i\<in>n. Init(x)`(i) \<in> W\<^isub>U`(i)" by simp
            with `W\<^isub>U:n\<rightarrow>\<tau>` show ?thesis using func1_1_L1 by simp 
          qed
          ultimately have "Init(x) \<in> FinProd(n\<rightarrow>\<Union>\<tau>,W\<^isub>U)" using FinProd_def by simp
          with `U =FinProd(n\<rightarrow>\<Union>\<tau>,W\<^isub>U)` show ?thesis by simp 
        qed
        moreover have "x`(n) \<in> V"       
        proof -  
          from `?W:succ(n)\<rightarrow>\<tau>` I  have "x`(n) \<in> ?W`(n)" using func1_1_L1 by simp
          moreover from A4 `W\<^isub>U:n\<rightarrow>\<tau>` have "?W`(n) = V" using append_props by simp
          ultimately show ?thesis by simp 
        qed
        ultimately have "x\<in>?B" by simp  
      } thus "FinProd(succ(n)\<rightarrow>\<Union>\<tau>,?W) \<subseteq> ?B" by auto
    qed
    moreover from A1 A2 have "ProductTopBase(succ(n),\<tau>) = {FinProd(succ(n)\<rightarrow>\<Union>\<tau>,W). W\<in>succ(n)\<rightarrow>\<tau>}"
      using fin_prod_def_nat by simp
    ultimately show ?thesis by auto
 qed

text{* If $U$ is open in $X^n$ and $V$ is open in $X$, then $U\times V$ is open in $X^{n+1}$. 
The next lemma is an analogue of this fact for the function space approach.*}

lemma finite_prod_succ: assumes A1: "\<tau> {is a topology}" and A2: "n \<in> nat" and 
  A3: "U \<in> SeqProductTopology(n,\<tau>)" and A4: "V\<in>\<tau>"
  shows "{x \<in> succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> U \<and> x`(n) \<in> V} \<in> SeqProductTopology(succ(n),\<tau>)"
  proof -
     from A1 have "ProductTopBase(n,\<tau>) {is a base for} SeqProductTopology(n,\<tau>)" and 
      I: "ProductTopBase(succ(n),\<tau>) {is a base for} SeqProductTopology(succ(n),\<tau>)" and 
      II: "SeqProductTopology(succ(n),\<tau>) {is a topology}"
        using seq_prod_top_is_top by auto
    with A3 have "\<exists>\<B> \<in> Pow(ProductTopBase(n,\<tau>)). U = \<Union>\<B>" using Top_1_2_L1 by simp
    then obtain \<B> where "\<B> \<subseteq> ProductTopBase(n,\<tau>)" and "U = \<Union>\<B>" by auto
    then have 
    "{x:succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> U \<and> x`(n) \<in> V} = (\<Union>B\<in>\<B>.{x:succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> B \<and> x`(n) \<in> V})"
      by auto
    moreover from A1 A2 A4 `\<B> \<subseteq> ProductTopBase(n,\<tau>)` have
      "\<forall>B\<in>\<B>. ({x:succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> B \<and> x`(n) \<in> V} \<in> ProductTopBase(succ(n),\<tau>))"
      using finite_prod_succ_base by auto
    with I II have 
      "(\<Union>B\<in>\<B>.{x:succ(n)\<rightarrow>\<Union>\<tau>. Init(x) \<in> B \<and> x`(n) \<in> V}) \<in> SeqProductTopology(succ(n),\<tau>)"
      using base_sets_open union_indexed_open by auto
    ultimately show ?thesis by simp
  qed

(*    
text{*In the @{text "Topology_ZF_2"} theory we define product topology of two topological spaces.
The next lemma explains in what sense the topology on finite lists of lenght $n$ of 
elements of topological space $X$ can be thought as a model of the product topology on the cartesian 
product of $n$ copies of that space. Namely, we show that the space of lists of length $n+1$ 
of elements of $X$  is homeomorphic to the product topology (as defined in @{text "Topology_ZF_2"}) 
of two spaces: the space of lists of length $n$ and $X$. Recall that if $\mathcal{B}$ is a base 
(i.e. satisfies the base condition), the the collection ${\bigcup B| B \in Pow(\mathcal{B})\}$ 
is a topology (generated by $\mathcal{B}$).*}

lemma finite_top_prod_homeo: assumes A1: "\<tau> {is a topology}" and A2: "n \<in> nat" and 
  A3: "f = {\<langle>x,\<langle>Init(x),x`(n)\<rangle>\<rangle>. x \<in> succ(n)\<rightarrow>\<Union>\<tau>}" and
  A4: "T = SeqProductTopology(n,\<tau>)" and
  A5: "S = SeqProductTopology(succ(n),\<tau>)"
shows "IsAhomeomorphism(S,ProductTopology(T,\<tau>),f)"
proof -
  from assms have "f \<in> bij(\<Union>S,\<Union>ProductTopology(T,\<tau>))"
    using lists_cart_prod seq_prod_top_is_top Top_1_4_T1 by simp 
  moreover have "IsContinuous(S,ProductTopology(T,\<tau>),f)" sorry
  moreover have "IsContinuous(ProductTopology(T,\<tau>),S,converse(f))" sorry
  ultimately show ?thesis using IsAhomeomorphism_def by simp
qed
*)

end
