{- 
	This file is part of tiddlyisar - a tool for rendering IsarMathLib 
	theories in TiddlyWiki format.
    Copyright (C) 2008  Slawomir Kolodynski

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-}


module Main
   where

import IMLP_datatypes
import IMLParser
import ProcessThys
import Export2wiki
import Utils

-- | removes comments - the text between (* and *)
remComments :: String -> String
remComments = tail . (appBetween (\s -> "") "(*" "*)") . (' ':)
 
main = do
   rml   <- readFile "ROOT.ML"
   wikitempl <- readFile "formalmath_empty.html"
   names <- return $ map extractTheoryName (nonemptylines $ remComments rml)
   thstxt <- readFiles $ map ("../IsarMathLib/" ++) names
   thrsExported <- return $  exportTheories $ parseTheories $ zip names thstxt
   -- writeFiles thrsExported
   writeFile "formalmath.html" (fillWiki thrsExported wikitempl) 
   

-- | extract a name of the theory to load from a line in 
-- the ROOT.ML file
extractTheoryName :: String -> String
extractTheoryName = (++ ".thy") . takeWhile (/= '\"') . drop 9

