header{*\isaheader{Int\_ZF\_2.thy}*}

theory Int_ZF_2 imports func_ZF_1 Int_ZF_1 IntDiv_ZF_IML Group_ZF_3

begin

text{*In this theory file we consider the properties of integers that are 
  needed for the real numbers construction in @{text "Real_ZF"} series.*}

section{*Slopes*}

text{*In this section we study basic properties of slopes - the integer 
  almost homomorphisms. 
  The general definition of an almost homomorphism $f$ on a group $G$ 
  written in additive notation requires the set 
  $\{f(m+n) - f(m) - f(n): m,n\in G\}$ to be finite.
  In this section we establish a definition that is equivalent for integers: 
  that for all integer $m,n$ we have $|f(m+n) - f(m) - f(n)| \leq L$ for
  some $L$.  *}

text{*Comment*}

lemma (in int1) Int_ZF_2_4_L8:  assumes A1: "f \<in> \<S>\<^isub>+" and
  A2: "\<forall>m\<in>\<int>\<^sub>+. f\<inverse>(m)\<rs>\<one> \<in> \<int>\<^sub>+"
  shows "\<exists>M. \<forall>x\<in>\<int>\<^sub>+\<times>\<int>\<^sub>+. abs(\<epsilon>(f,x)) \<lsq> M"
proof -
  from A1 A2 have 
    "\<exists>U\<in>\<int>. \<forall>m\<in>\<int>\<^sub>+. \<forall>n\<in>\<int>\<^sub>+. f`(f\<inverse>(m\<ra>n)\<rs>f\<inverse>(m)\<rs>f\<inverse>(n)) \<lsq> U"
    "\<exists>N\<in>\<int>. \<forall>m\<in>\<int>\<^sub>+. \<forall>n\<in>\<int>\<^sub>+. N \<lsq> f`(f\<inverse>(m\<ra>n)\<rs>f\<inverse>(m)\<rs>f\<inverse>(n))"
    using  Int_ZF_2_4_L7 by auto;
  then obtain U N where I:
    "\<forall>m\<in>\<int>\<^sub>+. \<forall>n\<in>\<int>\<^sub>+. f`(f\<inverse>(m\<ra>n)\<rs>f\<inverse>(m)\<rs>f\<inverse>(n)) \<lsq> U" 
    "\<forall>m\<in>\<int>\<^sub>+. \<forall>n\<in>\<int>\<^sub>+. N \<lsq> f`(f\<inverse>(m\<ra>n)\<rs>f\<inverse>(m)\<rs>f\<inverse>(n))"
    by auto;
  have "\<int>\<^sub>+\<times>\<int>\<^sub>+ \<noteq> 0" using int_one_two_are_pos by auto;
  moreover from A1 have "f: \<int>\<rightarrow>\<int>"
    using AlmostHoms_def by simp;
  moreover from A1 have
    "\<forall>a\<in>\<int>.\<exists>b\<in>\<int>\<^sub>+.\<forall>x. b\<lsq>x \<longrightarrow> a \<lsq> f`(x)"
    using Int_ZF_2_3_L5 by simp;
  moreover from A1 have
    "\<forall>a\<in>\<int>.\<exists>b\<in>\<int>\<^sub>+.\<forall>y. b\<lsq>y \<longrightarrow> f`(\<rm>y) \<lsq> a"
    using Int_ZF_2_3_L5A by simp;
  moreover have 
    "\<forall>x\<in>\<int>\<^sub>+\<times>\<int>\<^sub>+. \<epsilon>(f,x) \<in> \<int> \<and> f`(\<epsilon>(f,x)) \<lsq> U \<and> N \<lsq> f`(\<epsilon>(f,x))"
  proof -
    { fix x assume A3: "x \<in> \<int>\<^sub>+\<times>\<int>\<^sub>+"
      let ?m = "fst(x)"
      let ?n = "snd(x)"
      from A3 have T: "?m \<in> \<int>\<^sub>+"  "?n \<in> \<int>\<^sub>+"  "?m\<ra>?n \<in> \<int>\<^sub>+"
	using pos_int_closed_add_unfolded by auto;
      with A1 have 
	"f\<inverse>(?m\<ra>?n) \<in> \<int>"  "f\<inverse>(?m) \<in> \<int>"  "f\<inverse>(?n) \<in> \<int>"
	using Int_ZF_2_4_L2 PositiveSet_def by auto;
      with I T have 
	"\<epsilon>(f,x) \<in> \<int> \<and> f`(\<epsilon>(f,x)) \<lsq> U \<and> N \<lsq> f`(\<epsilon>(f,x))"
	using Int_ZF_1_1_L5 by auto; 
    } thus ?thesis by simp;
    qed;
  ultimately show "\<exists>M.\<forall>x\<in>\<int>\<^sub>+\<times>\<int>\<^sub>+. abs(\<epsilon>(f,x)) \<lsq> M"
    by (rule Int_ZF_1_6_L4);
qed;

end
