(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005, 2006  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Topology\_ZF\_1.thy}*}

theory Topology_ZF_1 imports Topology_ZF Fol1 

begin

section{*Separation axioms.*}

text{*Topological spaces cas be classified according to certain properties
  called "separation axioms". This section defines what it means that a 
  topological space is $T_0$, $T_1$ or $T_2$.*}

text{*A topology on $X$ is $T_0$ if for every pair of distinct points of $X$
  there is an open set that contains only one of them.
  A topology is $T_1$ if for every such pair there exist an open set that 
  contains the first point but not the second.
  A topology is $T_2$ (Hausdorff) if for every pair of points there exist a 
  pair of disjoint open sets each containing one of the points.*}

constdefs
  
  isT0 ("_ {is T\<^isub>0}" [90] 91)
  "T {is T\<^isub>0} \<equiv> \<forall> x y. ((x \<in> \<Union>T \<and> y \<in> \<Union>T \<and>  x\<noteq>y) \<longrightarrow> 
  (\<exists>U\<in>T. (x\<in>U \<and> y\<notin>U) \<or> (y\<in>U \<and> x\<notin>U)))"

  isT1 ("_ {is T\<^isub>1}" [90] 91)
  "T {is T\<^isub>1} \<equiv> \<forall> x y. ((x \<in> \<Union>T \<and> y \<in> \<Union>T \<and>  x\<noteq>y) \<longrightarrow> 
  (\<exists>U\<in>T. (x\<in>U \<and> y\<notin>U)))"

  isT2 ("_ {is T\<^isub>2}" [90] 91)
  "T {is T\<^isub>2} \<equiv> \<forall> x y. ((x \<in> \<Union>T \<and> y \<in> \<Union>T \<and>  x\<noteq>y) \<longrightarrow>
  (\<exists>U\<in>T. \<exists>V\<in>T. x\<in>U \<and> y\<in>V \<and> U\<inter>V=0))";

text{*If a topology is $T_1$ then it is $T_0$. 
  We don't really assume here that $T$ is a topology on $X$. 
  Instead, we prove the relation between isT0 condition and isT1. *}

lemma T1_is_T0: assumes A1: "T {is T\<^isub>1}" shows "T {is T\<^isub>0}"
proof -
  from A1 have "\<forall> x y. x \<in> \<Union>T \<and> y \<in> \<Union>T \<and> x\<noteq>y \<longrightarrow> 
    (\<exists>U\<in>T. x\<in>U \<and> y\<notin>U)"
    using isT1_def by simp;
  then have "\<forall> x y. x \<in> \<Union>T \<and> y \<in> \<Union>T \<and> x\<noteq>y \<longrightarrow> 
    (\<exists>U\<in>T. x\<in>U \<and> y\<notin>U \<or> y\<in>U \<and> x\<notin>U)"
    by auto;
  then show "T {is T\<^isub>0}" using isT0_def by simp;
qed;

text{*If a topology is $T_2$ then it is $T_1$.*}

lemma T2_is_T1: assumes A1: "T {is T\<^isub>2}" shows "T {is T\<^isub>1}"
proof -
  { fix x y assume "x \<in> \<Union>T"  "y \<in> \<Union>T"  "x\<noteq>y"
    with A1 have "\<exists>U\<in>T. \<exists>V\<in>T. x\<in>U \<and> y\<in>V \<and> U\<inter>V=0"
      using isT2_def by auto;
    then have "\<exists>U\<in>T. x\<in>U \<and> y\<notin>U" by auto;
  } then have "\<forall> x y. x \<in> \<Union>T \<and> y \<in> \<Union>T \<and>  x\<noteq>y \<longrightarrow> 
      (\<exists>U\<in>T. x\<in>U \<and> y\<notin>U)" by simp;
  then show "T {is T\<^isub>1}" using isT1_def by simp;
qed;

text{*In a $T_0$ space two points that can not be separated 
  by an open set are equal. Proof by contradiction.*}

lemma Top_1_1_L1: assumes A1: "T {is T\<^isub>0}" and A2: "x \<in> \<Union>T"  "y \<in> \<Union>T"
  and A3: "\<forall>U\<in>T. (x\<in>U \<longleftrightarrow> y\<in>U)" 
  shows "x=y"
proof -
  { assume "x\<noteq>y"
    with A1 A2 have "\<exists>U\<in>T. x\<in>U \<and> y\<notin>U \<or> y\<in>U \<and> x\<notin>U"
      using isT0_def by simp;
    with A3 have False by auto;
  } then show "x=y" by auto;
qed;


section{*Bases and subbases.*}

text{*A base of topology is a collection of open sets such that every 
  open set is a union of the sets from the base. A subbase is a collection 
  of open sets such that finite intersection of those sets form a base.
  Below we formulate a condition that we will prove to be necessary and 
  sufficient for a collection $B$ of open sets to form a base. 
  It says that for any two sets $U,V$ from the collection $B$ we can
  find a point $x\in U\cap V$ with a neighboorhod from $B$ contained in $U\cap V$.
  *}

constdefs

  IsAbaseFor (infixl "{is a base for}" 65)
  "B {is a base for} T \<equiv> B\<subseteq>T \<and> T = {\<Union>A. A\<in>Pow(B)}"

  IsAsubBaseFor (infixl "{is a subbase for}" 65)
  "B {is a subbase for} T \<equiv> 
  B \<subseteq> T \<and> {\<Inter>A. A\<in>Fin(B)} {is a base for} T"

  SatisfiesBaseCondition ("_ {satisfies the base condition}" [50] 50)  
  "B {satisfies the base condition} \<equiv> 
  \<forall>U V. ((U\<in>B \<and> V\<in>B) \<longrightarrow> (\<forall>x \<in> U\<inter>V. \<exists>W\<in>B. x\<in>W \<and> W \<subseteq> U\<inter>V))"

text{*Each open set is a union of some sets from the base.*}

lemma Top_1_2_L1: assumes "B {is a base for} T"  and "U\<in>T" 
  shows "\<exists>A\<in>Pow(B). U = \<Union>A"
  using prems IsAbaseFor_def by simp;

text{*A necessary conditionfor a collection of sets to be a base for some 
  topology : every point in the intersection
  of two sets in the base has a neighboorhood from the base contained
  in the intersection.*}

lemma Top_1_2_L2: 
  assumes A1:"\<exists>T. T {is a topology} \<and> B {is a base for} T"
  and A2: "V\<in>B"  "W\<in>B"
  shows "\<forall> x \<in> V\<inter>W. \<exists>U\<in>B. x\<in>U \<and> U \<subseteq> V \<inter> W"
proof -
  from A1 obtain T where 
    D1: "T {is a topology}"   "B {is a base for} T"
    by auto;
  then have "B \<subseteq> T" using IsAbaseFor_def by auto;
  with A2 have "V\<in>T" and "W\<in>T" using IsAbaseFor_def by auto;
  with D1 have "\<exists>A\<in>Pow(B). V\<inter>W = \<Union>A" using IsATopology_def Top_1_2_L1
    by auto;
  then obtain A where "A \<subseteq> B" and "V \<inter> W = \<Union>A" by auto;
  then show "\<forall> x \<in> V\<inter>W. \<exists>U\<in>B. (x\<in>U \<and> U \<subseteq> V \<inter> W)" by auto;
qed;

text{*We will construct a topology as the collection of unions of (would-be)
  base. First we prove that if the collection of sets satisfies the 
  condition we want to show to be sufficient, the the intersection belongs
  to what we will define as topology (am I clear here?). Having this fact 
  ready simplifies the proof of the next lemma. There is not much topology
  here, just some set theory.*}

lemma Top_1_2_L3:
  assumes A1: "\<forall>x\<in> V\<inter>W . \<exists>U\<in>B. x\<in>U \<and> U \<subseteq> V\<inter>W"
  shows "V\<inter>W \<in> {\<Union>A. A\<in>Pow(B)}"
proof
  let ?A = "\<Union>x\<in>V\<inter>W. {U\<in>B. x\<in>U \<and> U \<subseteq> V\<inter>W}"
  show "?A\<in>Pow(B)" by auto;
  from A1 show "V\<inter>W = \<Union>?A" by blast;
qed;

text{*The next lemma is needed when proving that the would-be topology is
  closed with respect to taking intersections. We show here that intersection
  of two sets from this (would-be) topology can be written as union of sets 
  from the topology.*}

lemma Top_1_2_L4:
  assumes A1:  "U\<^isub>1 \<in> {\<Union>A. A\<in>Pow(B)}"   "U\<^isub>2 \<in> {\<Union>A. A\<in>Pow(B)}"
  and A2: "B {satisfies the base condition}"
  shows "\<exists>C. C \<subseteq> {\<Union>A. A\<in>Pow(B)} \<and> U\<^isub>1\<inter>U\<^isub>2 = \<Union>C"
proof -
  from A1 A2 obtain A\<^isub>1 A\<^isub>2 where 
    D1: "A\<^isub>1\<in> Pow(B)"  "U\<^isub>1 = \<Union>A\<^isub>1"  "A\<^isub>2 \<in> Pow(B)"  "U\<^isub>2 = \<Union>A\<^isub>2" 
    by auto;
  let ?C = "\<Union>U\<in>A\<^isub>1.{U\<inter>V. V\<in>A\<^isub>2}"
  from D1 have "(\<forall>U\<in>A\<^isub>1. U\<in>B) \<and> (\<forall>V\<in>A\<^isub>2. V\<in>B)" by auto;
  with A2 have "?C \<subseteq> {\<Union>A . A \<in> Pow(B)}"
    using Top_1_2_L3 SatisfiesBaseCondition_def by auto;
  moreover from D1 have "U\<^isub>1 \<inter> U\<^isub>2 = \<Union>?C" by auto;
  ultimately show ?thesis by auto;
qed;

text{*If $B$ satisfies the base condition, then the collection of unions
  of sets from $B$ is a topology and $B$ is a base for this topology.*}

theorem Top_1_2_T1:
  assumes A1: "B {satisfies the base condition}"
  and A2: "T = {\<Union>A. A\<in>Pow(B)}"
  shows "T {is a topology}" and "B {is a base for} T"
proof -
  show "T {is a topology}"
  proof -
    from A2 have "0\<in>T" by auto;
    moreover have I: "\<forall>C\<in>Pow(T). \<Union>C \<in> T"
    proof -
      { fix C assume A3: "C \<in> Pow(T)"
	let ?Q = "\<Union> {\<Union>{A\<in>Pow(B). U = \<Union>A}. U\<in>C}"
	from A2 A3 have "\<forall>U\<in>C. \<exists>A\<in>Pow(B). U = \<Union>A" by auto;
	then have "\<Union>?Q = \<Union>C" using  Finite1_L8 by simp;
	moreover from A2 have "\<Union>?Q \<in> T" by auto;
	ultimately have "\<Union>C \<in> T" by simp;
      } thus "\<forall>C\<in>Pow(T). \<Union>C \<in> T" by auto;
    qed;
    moreover have "\<forall>U\<in>T. \<forall> V\<in>T. U\<inter>V \<in> T"
    proof -
      { fix U V assume  "U \<in> T"  "V \<in> T"
	with A1 A2 have "\<exists>C.(C \<subseteq> T \<and> U\<inter>V = \<Union>C)"
	  using Top_1_2_L4 by simp;
	then obtain C where "C \<subseteq> T" and  "U\<inter>V = \<Union>C"
	  by auto;
	with I have "U\<inter>V \<in> T" by simp;
      } then show "\<forall>U\<in>T. \<forall> V\<in>T. U\<inter>V \<in> T" by simp;
    qed
    ultimately show "T {is a topology}" using IsATopology_def
      by simp;
  qed;
  from A2 have "B\<subseteq>T" by auto;
  with A2 show "B {is a base for} T" using IsAbaseFor_def 
    by simp;
qed;

text{*The carrier of the base and topology are the same.*}

lemma Top_1_2_L5: assumes "B {is a base for} T"
  shows "\<Union>T = \<Union>B"
  using prems IsAbaseFor_def by auto;

section{*Product topology*}

text{*In this section we consider a topology defined on a product of two sets.*}

text{*Given two topological spaces we can define a topology on the product of 
  the carriers such that the cartesian products of the sets of the topologies 
  are a base for the product topology. Recall that for two collections $S,T$ 
  of sets the product collection
  is defined (in @{text "ZF1.thy"}) as the collections of cartesian 
  products $A\times B$, where $A\in S, B\in T$.*}

constdefs

  "ProductTopology(T,S) \<equiv> {\<Union>W. W \<in> Pow(ProductCollection(T,S))}"


text{*The product collection satisfies the base condition.*}

lemma Top_1_4_L1: 
  assumes A1: "T {is a topology}"   "S {is a topology}"
  and A2: "A \<in> ProductCollection(T,S)"  "B \<in> ProductCollection(T,S)"
  shows "\<forall>x\<in>(A\<inter>B). \<exists>W\<in>ProductCollection(T,S). (x\<in>W \<and> W \<subseteq> A \<inter> B)"
proof
  fix x assume A3: "x \<in> A\<inter>B"
  from A2 obtain U\<^isub>1 V\<^isub>1 U\<^isub>2 V\<^isub>2 where 
    D1: "U\<^isub>1\<in>T"  "V\<^isub>1\<in>S"   "A=U\<^isub>1\<times>V\<^isub>1"  "U\<^isub>2\<in>T"  "V\<^isub>2\<in>S"   "B=U\<^isub>2\<times>V\<^isub>2"
    using ProductCollection_def by auto;
  let ?W = "(U\<^isub>1\<inter>U\<^isub>2) \<times> (V\<^isub>1\<inter>V\<^isub>2)";
  from A1 D1 have "U\<^isub>1\<inter>U\<^isub>2 \<in> T" and "V\<^isub>1\<inter>V\<^isub>2 \<in> S"
    using IsATopology_def by auto;
  then have "?W \<in> ProductCollection(T,S)" using ProductCollection_def 
    by auto;
  moreover from A3 D1 have "x\<in>?W" and "?W \<subseteq> A\<inter>B" by auto;
  ultimately have "\<exists>W. (W \<in> ProductCollection(T,S) \<and> x\<in>W \<and> W \<subseteq> A\<inter>B)"
    by auto;
  thus "\<exists>W\<in>ProductCollection(T,S). (x\<in>W \<and> W \<subseteq> A \<inter> B)" by auto;
qed;

text{*The product topology is indeed a topology on the product.*}

theorem Top_1_4_T1: assumes A1: "T {is a topology}"  "S {is a topology}"
  shows 
  "ProductTopology(T,S) {is a topology}"
  "ProductCollection(T,S) {is a base for} ProductTopology(T,S)"
  "\<Union> ProductTopology(T,S) = \<Union>T \<times> \<Union>S"
proof -
  from A1 show 
    "ProductTopology(T,S) {is a topology}"
    "ProductCollection(T,S) {is a base for} ProductTopology(T,S)"
    using Top_1_4_L1 ProductCollection_def 
      SatisfiesBaseCondition_def ProductTopology_def Top_1_2_T1 
    by auto;
  then show "\<Union> ProductTopology(T,S) = \<Union>T \<times> \<Union>S"
    using Top_1_2_L5 ZF1_1_L6 by simp;
qed;

end