{- This source file is part of mmisar - a tool for converting
Metamath proofs to Isabelle/Isar.
Copyright 2006 Slawomir Kolodynski

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-}

-- | this module defines a data type that is used as the internal
-- representation of Metamath ZF formulas.

module MMIDataTypes
   where


data LogExpr = InfixLLL LogExpr String LogExpr -- ^ infix (Logical, Logical) -> Logical
               | Negation LogExpr              -- ^ negation of a logical expression
               | InfixSSL SetExpr String SetExpr  -- ^ infix (Set, Set) -> Logical
               | Quant String SetExpr LogExpr -- ^ for ex. E. x phi -> Quant "E." (Svar "x") (Lvar "phi")
               | QuantRange String SetExpr SetExpr LogExpr -- ^ for ex. E! x e. A phi -> 
                                                        -- QuantRange "E!" (Svar "x") (Svar A) (Lvar "phi")
               | IsASet SetExpr         -- ^ a variable is a set, like NN e. V
               | Subst SetExpr SetExpr LogExpr -- ^ I am not sure what it is, but it looks like [ z / x ] (A e. NN -> ph )  
               | Lvar String            -- ^ logical variable
               deriving (Eq, Show) 

data SetExpr = InfixSSS SetExpr String SetExpr  -- ^ infix (Set, Set) -> Set
               | PrefixS String SetExpr          -- ^ negative of a number and intersection or union of a set
               | If LogExpr SetExpr SetExpr -- ^ if like in if ( A e. RR , A , 0 )     
               | SetCompr SetExpr LogExpr     -- ^ Set comprehension like { x | ph }
               | SetComprRange SetExpr SetExpr LogExpr -- ^ Set comprehension with range like  {x e. NN | ph }
               | Supremum SetExpr SetExpr SetExpr -- ^ Supremum B A R is a supremum of the set B when R strictly orders A
--               | Snum String          -- ^ number - a string of digits
               | Svar String          -- ^ set variable
               deriving (Eq, Show) 
