(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005, 2006  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Fol1.thy}*}

theory Fol1 imports Trancl 

begin

section{*Mission statement*}

text{*None yet. Maybe later.*}

section{*Release notes*}

text{* This release continues the process of importing Metamath's \cite{Metamath}
  set.mm database into IsarMathLib, adding about 340 facts and 200 translated proofs.*}

section{*Overview of the project*}

text{* 
  The  @{text "Fol1"}, @{text " ZF1"} and @{text "Nat_ZF"} theory files  contain some 
  background material that is needed for the remaining theories.

  @{text "Order_ZF"} reformulates some material from standard Isabelle's 
  @{text "Order"} theory in terms of non-strict (less-or-equal) order relations.
  @{text "Order_ZF_1"} on the other hand directly continues the @{text "Order"}
  theory file using strict order relations (less and not equal). This is useful
  for translating theorems from Metamath.
  
  The @{text "func1"} theory provides basic facts about functions.
  @{text "func_ZF"} continues this development with more advanced
  properties that relate to algebraic properties of binary operations, 
  like lifting a binary operation to a function space,
  associative, commutative and distributive operations and properties
  of functions related to order relations.

  @{text "Finite1"} theory file discusses the properties of the finite powerset
  defined in the standard Isabelle's @{text "Finite"} theory. 
  @{text "Finite_ZF"} continues this development with properties of finite sets 
  related to order relations.

  The @{text "EquivClass1"} theory file is a reformulation of standard
  Isabelle's @{text "EquivClass"} material in the spirit of ZF set theory.

  @{text "InductiveSeq_ZF"} provides the definition and properties of
  (what is known in basic calculus as) sequences defined by induction, 
  i. e. by a formula of the form $a_0 = x,\ a_{n+1} = f(a_n)$. 

  The @{text "Topology_ZF"} series covers basics of general topology: 
  interior, closure, boundary, compact sets, separation axioms and 
  continuous functions.
  
  @{text "Group_ZF"}, @{text "Group_ZF_1"}, and @{text "Group_ZF_2"}
  provide basic facts of the group theory. @{text "Group_ZF_3"} 
  considers the notion of almost homomorphisms that is nedeed for the 
  real numbers construction in @{text "Real_ZF"}. 
  
  @{text "Ring_ZF"} defines rings. @{text "Ring_ZF_1"} covers 
  the properties of  rings that are specific to the real numbers construction 
  in @{text "Real_ZF"}. 
  
  @{text "Int_ZF"} theory considers the integers as a monoid (multiplication) and 
  an abelian ordered group (addition). 
  In @{text "Int_ZF_1"} we show that integers form a commutative ring.
  @{text "Int_ZF_2"} contains some facts about slopes (almost homomorphisms 
  on integers) needed for real numbers construction, used in @{text "Real_ZF_1"}.

  @{text "Field_ZF"} and @{text "OrderedField_ZF"} contain basic facts
  about (you guessed it) fields and ordered fields. 
  
  The @{text "Real_ZF"} and @{text "Real_ZF_1"} theories 
  contain the construction of real numbers based on the paper \cite{Arthan2004}
  by R. D. Arthan (not Cauchy sequences, not Dedekind sections). The heavy lifting
  is done mostly in @{text "Group_ZF_3"}, @{text "Ring_ZF_1"} and @{text "Int_ZF_2"}.
  @{text "Real_ZF"} contains the part of the construction that can be done
  starting from generic abelian groups (rather than additive group of integers).
  This allows to show that real numbers form a ring. 
  @{text "Real_ZF_1"} continues the construction using properties specific
  to the integers and showing that real numbers constructed this way
  form a complete ordered field.

  In @{text "Complex_ZF"} we construct complex numbers starting from
  a complete ordered field (a model of real numbers). We also define 
  the notation for writing about complex numbers and prove that the 
  structure of complex numbers constructed there satisfies the axioms
  of complex numbers used in Metamath.

  The @{text "MMI_prelude"} defines the @{text "mmisar0"} context in which 
  most theorems translated from Metamath are proven. It also contains a 
  chapter explaining how the translation works.

  In the @{text "Metamath_interface"} theory we prove a theorem
  that the @{text "mmisar0"} context is valid (can be used) in the @{text "complex0"}
  context. All theories using the translated results will import the
  @{text "Metamath_interface"} theory. The @{text "Metamath_sampler"}
  theory provides some examples of using the translated theorems
  in the @{text "complex0"} context.

  The theories @{text "MMI_logic_and_sets"}, @{text "MMI_Complex.thy"}, 
  @{text "MMI_Complex_1"} and @{text "MMI_Complex_2"}
  contain the theorems imported from the
  Metamath's set.mm database. As the translated proofs are rather verbose
  these theories are not printed in this proof document.
  The full list of translated facts can be found in the 
  @{text "known_theorems.txt"} file included in the IsarMathLib distribution.
  The @{text "MMI_examples"} provides some theorems imported from Metamath
  that are printed in this proof document as examples of how translated
  proofs look like.
*}

section{*Notions and lemmas in FOL*}

text{*This section contains mostly shortcuts and workarounds 
  that allow to use more readable coding style.*}

(*temporarily removed bc. it takes too long to check
text{*The definition and lemma below implement a common idiom used in 
romantic mathematics when the author states some assumptions, says
"then the following are equivalent" and proceeds with the proof that shows 
implications between the statements. The usefulness of theorems stated this 
way is rather limited in Isar as the simp and auto methods may take a really 
long time to infer anything from equivalences if there is more than one. 
Still, we believe that being able to formulate a theorem like this 
is good for readibility.*}

constdefs
  All4areEquivalent :: "[o,o,o,o]\<Rightarrow>o"
  "All4areEquivalent(p,q,r,s) \<equiv> 
  (p\<longleftrightarrow>q) & (p\<longleftrightarrow>r) & (p\<longleftrightarrow>s) & (q\<longleftrightarrow>r) & (q\<longleftrightarrow>s) & (r\<longleftrightarrow>s)";

lemma Fol1_L1: assumes A1: "p\<longrightarrow>q" and A2: "q\<longrightarrow>r" 
  and A3: "r\<longrightarrow>s" and A4: "s\<longrightarrow>p" 
  shows "All4areEquivalent(p,q,r,s)"
proof-;  
  from A1 A2 A3 A4 have "p\<longleftrightarrow>q"by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "r\<longleftrightarrow>s" by auto;
  ultimately show ?thesis using All4areEquivalent_def by simp;
qed; 

text{*It happens quite often that we need to prove a statement of the form
$\forall x y. P(x,y) \rightarrow Q(x,y)$. The next lemma provides a shortcut 
for proving this type of statements. To apply this shortcut we can say 
"(rule double\_forall\_implies)" after the "proof" keyword and we are free to
show the statement by doing "fix x y assume P(x,y) show Q(x,y).*}

lemma double_forall_implies: 
  assumes A1:" \<And>x y. P(x,y) \<Longrightarrow> R(x,y)"
  shows "\<forall>x y. (P(x,y) \<longrightarrow> R(x,y))"
proof -;
  from A1 show ?thesis by simp;
qed;

*)

text{*The next lemma serves as a workaround to problems with applying 
  the definition of transitivity (of a relation) in our coding style 
  (any attempt to do
  something like @{text "using trans_def"} results up Isabelle in an 
  infinite loop). We reluctantly use @{text "(unfold trans_def)"} after the 
  @{text "proof"} keyword  to workaround this.*}

lemma Fol1_L2: assumes 
  A1: "\<forall> x y z. \<langle>x, y\<rangle> \<in> r \<and> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
  shows "trans(r)"
proof (unfold trans_def)
  from A1 show
    "\<forall> x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    using imp_conj by blast;
qed;

text{*Another workaround for the problem of Isabelle simplifier looping when 
  the transitivity definition is used. *}

lemma Fol1_L3: assumes A1: "trans(r)" and A2: "<a,b> \<in> r  \<and> <b,c> \<in> r"
  shows "<a,c> \<in> r"
proof -;
  from A1 have  "\<forall>x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    by (unfold trans_def);
  with A2 show ?thesis using imp_conj by fast;
qed;
  
text{*There is a problem with application of the definition of asymetry for
  relations. The next lemma is a workaround.*}

lemma Fol1_L4: 
  assumes A1: "antisym(r)" and A2: "<a,b> \<in> r"   "<b,a> \<in> r"  
  shows "a=b"
proof -;
  from A1 have "\<forall> x y. <x,y> \<in> r \<longrightarrow> <y,x> \<in> r \<longrightarrow> x=y"
    by (unfold antisym_def);
  with A2 show "a=b" using imp_conj by fast;
qed;

text{*The definition below implements a common idiom that states that 
  (perhaps under some assumptions) exactly one of give three statements 
  is true.*}

constdefs
  "Exactly_1_of_3_holds(p,q,r) \<equiv> 
  (p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)";

text{*The next lemma allows to prove statements of the form 
  @{text "Exactly_1_of_3_holds (p,q,r)"}.*}

lemma Fol1_L5:
  assumes "p\<or>q\<or>r"
  and "p \<longrightarrow> \<not>q \<and> \<not>r"
  and "q \<longrightarrow> \<not>p \<and> \<not>r"
  and "r \<longrightarrow> \<not>p \<and> \<not>q"
  shows "Exactly_1_of_3_holds (p,q,r)"
proof -;
  from prems have
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by blast;
  then show "Exactly_1_of_3_holds (p,q,r)"
    by (unfold Exactly_1_of_3_holds_def);
qed;

text{*If exactly one of $p,q,r$ holds and $p$ is not true, then
  $q$ or $r$.*}

lemma Fol1_L6: 
  assumes A1: "\<not>p" and A2: "Exactly_1_of_3_holds (p,q,r)" 
  shows "q\<or>r"
proof -
  from A2 have  
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by (unfold Exactly_1_of_3_holds_def);
  then have "p\<or>q\<or>r" by blast;
  with A1 show "q\<or>r" by simp;
qed;

text{*If exactly one of $p,q,r$ holds and $q$ is true, then 
  $r$ can not be true.*}

lemma Fol1_L7:
  assumes A1: "q" and A2: "Exactly_1_of_3_holds (p,q,r)"
  shows "\<not>r"
proof -
   from A2 have  
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by (unfold Exactly_1_of_3_holds_def)
  with A1 show "\<not>r" by blast;
qed;

text{* The next lemma demonstrates an elegant form of the 
  @{text "Exactly_1_of_3_holds (p,q,r)"} predicate. More on that
  at www.solcon.nl/mklooster/calc/calc-tri.html . *}

lemma Fol1_L8: 
  shows "Exactly_1_of_3_holds (p,q,r) \<longleftrightarrow> (p\<longleftrightarrow>q\<longleftrightarrow>r) \<and> \<not>(p\<and>q\<and>r)"
proof;
  assume "Exactly_1_of_3_holds (p,q,r)"
  then have 
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by (unfold Exactly_1_of_3_holds_def);
  thus "(p\<longleftrightarrow>q\<longleftrightarrow>r) \<and> \<not>(p\<and>q\<and>r)" by blast;
next assume "(p\<longleftrightarrow>q\<longleftrightarrow>r) \<and> \<not>(p\<and>q\<and>r)" 
  then have 
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by auto;
  thus "Exactly_1_of_3_holds (p,q,r)"
    using Exactly_1_of_3_holds_def by (unfold Exactly_1_of_3_holds_def);
qed;

text{*A property of the @{text "Exactly_1_of_3_holds"} predicate.*}

lemma Fol1_L8A: assumes A1: "Exactly_1_of_3_holds (p,q,r)"
  shows "p \<longleftrightarrow> \<not>(q \<or> r)"
proof -
  from A1 have "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by (unfold Exactly_1_of_3_holds_def)
  then show "p \<longleftrightarrow> \<not>(q \<or> r)" by blast;
qed;

text{*Exclusive or definition. There is one also defined in the standard 
  Isabelle, denoted @{text "xor"}, but it relates to boolean values, 
  which are sets. Here we define a logical functor.*}

constdefs
  Xor (infixl "Xor" 66)
  "p Xor q \<equiv> (p\<or>q) \<and> \<not>(p \<and> q)"

text{*The "exclusive or" is the same as negation of equivalence.*}

lemma Fol1_L9: shows "p Xor q \<longleftrightarrow> \<not>(p\<longleftrightarrow>q)"
  using Xor_def by auto;
(*
text{*This is an example how we can show a statement of the form 
  @{text "p Xor q"}.*}

lemma Fol1_L6: assumes "p\<or>q" and "\<not>p \<or> \<not>q"
  shows "p Xor q"
proof -
  from prems show "p Xor q" using Xor_def by simp;
qed;*)
text{*Equivalence relations are symmetric.*}

lemma equiv_is_sym: assumes A1:  "equiv(X,r)" and A2: "\<langle>x,y\<rangle> \<in> r"
  shows  "\<langle>y,x\<rangle> \<in> r"
proof -
  from A1 have "sym(r)" using equiv_def by simp;
  then have "\<forall>x y. \<langle>x,y\<rangle> \<in> r \<longrightarrow> \<langle>y,x\<rangle> \<in> r"
    by (unfold sym_def);
  with A2 show "\<langle>y,x\<rangle> \<in> r" by blast;
qed;

text{*This lemma is needed to be used as a rule in some very 
  complicated cases.*}

lemma five_more_conj: assumes "Axs"  "Ax1" "Ax2" "Ax3" "Ax4" "Ax5"
  shows "Ax1 \<and> Ax2 \<and> Ax3 \<and> Ax4 \<and> Ax5 \<and> Axs" using prems by simp;

(* In Isabelle/ZF conjunction associates to the right!.
lemma test: assumes A1: "P" "Q\<and>R"
  shows "P\<and>Q\<and>R"
proof - 
  from A1 show "P\<and>Q\<and>R" by (rule one_more_conj);
qed;

*)

  
    

end