
(* 
    This file is a part of MMIsar - a translation of Metamath's set.mm to Isabelle 2005 (ZF logic).

    Copyright (C) 2005, 2006  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{MMIsar.thy}*}

theory MMIsar imports MMI_prelude

begin 

text{*This theory contains theorems (with proofs) about complex numbers
  imported from the Metamath's set.mm database. 
  The original Metamath proofs were written by Norm Megill.*}

  lemma (in MMIsar0) MMI_recnt: 
   shows "A \<in> \<real> \<longrightarrow> A \<in> \<complex>"
proof -
   have S1: "\<real> \<subseteq> \<complex>" by (rule MMI_axresscn)
   from S1 show "A \<in> \<real> \<longrightarrow> A \<in> \<complex>" by (rule MMI_sseli)
qed

lemma (in MMIsar0) MMI_recn: assumes A1: "A \<in> \<real>"   
   shows "A \<in> \<complex>"
proof -
   have S1: "\<real> \<subseteq> \<complex>" by (rule MMI_axresscn)
   from A1 have S2: "A \<in> \<real>".
   from S1 S2 show "A \<in> \<complex>" by (rule MMI_sselii)
qed

lemma (in MMIsar0) MMI_recnd: assumes A1: "\<phi> \<longrightarrow> A \<in> \<real>"   
   shows "\<phi> \<longrightarrow> A \<in> \<complex>"
proof -
   from A1 have S1: "\<phi> \<longrightarrow> A \<in> \<real>".
   have S2: "A \<in> \<real> \<longrightarrow> A \<in> \<complex>" by (rule MMI_recnt)
   from S1 S2 show "\<phi> \<longrightarrow> A \<in> \<complex>" by (rule MMI_syl)
qed

lemma (in MMIsar0) MMI_elimne0: 
   shows "if ( A \<noteq> \<zero> , A , \<one> ) \<noteq> \<zero>";
proof -
   have S1: "A = if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
     ( A \<noteq> \<zero> \<longleftrightarrow> if ( A \<noteq> \<zero> , A , \<one> ) \<noteq> \<zero> )" by (rule MMI_neeq1)
   have S2: "\<one> = if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
     ( \<one> \<noteq> \<zero> \<longleftrightarrow> if ( A \<noteq> \<zero> , A , \<one> ) \<noteq> \<zero> )" by (rule MMI_neeq1)
   have S3: "\<one> \<noteq> \<zero>" by (rule MMI_ax1ne0)
   from S1 S2 S3 show "if ( A \<noteq> \<zero> , A , \<one> ) \<noteq> \<zero>" by (rule MMI_elimhyp)
qed

lemma (in MMIsar0) MMI_addex: 
   shows "\<caddset> isASet"
proof -
   have S1: "\<complex> isASet" by (rule MMI_axcnex)
   have S2: "\<complex> isASet" by (rule MMI_axcnex)
   from S1 S2 have S3: "( \<complex> \<times> \<complex> ) isASet" by (rule MMI_xpex)
   have S4: "\<caddset> : ( \<complex> \<times> \<complex> ) \<rightarrow> \<complex>" by (rule MMI_axaddopr)
   have S5: "( \<complex> \<times> \<complex> ) isASet \<longrightarrow> 
     ( \<caddset> : ( \<complex> \<times> \<complex> ) \<rightarrow> \<complex> \<longrightarrow> \<caddset> isASet )" by (rule MMI_fex)
   from S3 S4 S5 show "\<caddset> isASet" by (rule MMI_mp2)
qed;

lemma (in MMIsar0) MMI_mulex: 
   shows "\<cmulset> isASet"
proof -
   have S1: "\<complex> isASet" by (rule MMI_axcnex)
   have S2: "\<complex> isASet" by (rule MMI_axcnex)
   from S1 S2 have S3: "( \<complex> \<times> \<complex> ) isASet" by (rule MMI_xpex)
   have S4: "\<cmulset> : ( \<complex> \<times> \<complex> ) \<rightarrow> \<complex>" by (rule MMI_axmulopr)
   have S5: "( \<complex> \<times> \<complex> ) isASet \<longrightarrow> 
     ( \<cmulset> : ( \<complex> \<times> \<complex> ) \<rightarrow> \<complex> \<longrightarrow> \<cmulset> isASet )" by (rule MMI_fex)
   from S3 S4 S5 show "\<cmulset> isASet" by (rule MMI_mp2)
qed;

lemma (in MMIsar0) MMI_adddirt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
  ( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )"
proof -
   have S1: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( C \<cdot> ( A \<ca> B ) ) = ( ( C \<cdot> A ) \<ca> ( C \<cdot> B ) )" 
     by (rule MMI_axdistr)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( C \<cdot> ( A \<ca> B ) ) = ( ( C \<cdot> A ) \<ca> ( C \<cdot> B ) )" by (rule MMI_3coml)
   have S3: "( ( A \<ca> B ) \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( C \<cdot> ( A \<ca> B ) )" by (rule MMI_axmulcom)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S3 S4 have S5: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( C \<cdot> ( A \<ca> B ) )" by (rule MMI_sylan)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( C \<cdot> ( A \<ca> B ) )" by (rule MMI_3impa)
   have S7: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> C ) = ( C \<cdot> A )" 
     by (rule MMI_axmulcom)
   from S7 have S8: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> C ) = ( C \<cdot> A )" 
     by (rule MMI_3adant2)
   have S9: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) = ( C \<cdot> B )" 
     by (rule MMI_axmulcom)
   from S9 have S10: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) = ( C \<cdot> B )" 
     by (rule MMI_3adant1)
   from S8 S10 have S11: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) ) = ( ( C \<cdot> A ) \<ca> ( C \<cdot> B ) )" 
     by (rule MMI_opreq12d)
   from S2 S6 S11 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_3eqtr4d)
qed;

lemma (in MMIsar0) MMI_addcl: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<ca> B ) \<in> \<complex>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S1 S2 S3 show "( A \<ca> B ) \<in> \<complex>" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_mulcl: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<cdot> B ) \<in> \<complex>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cdot> B ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S1 S2 S3 show "( A \<cdot> B ) \<in> \<complex>" by (rule MMI_mp2an)
qed;

lemma (in MMIsar0) MMI_addcom: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<ca> B ) = ( B \<ca> A )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) = ( B \<ca> A )" 
     by (rule MMI_axaddcom)
   from S1 S2 S3 show "( A \<ca> B ) = ( B \<ca> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_mulcom: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<cdot> B ) = ( B \<cdot> A )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cdot> B ) = ( B \<cdot> A )" 
     by (rule MMI_axmulcom)
   from S1 S2 S3 show "( A \<cdot> B ) = ( B \<cdot> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_addass: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<ca> C ) = ( A \<ca> ( B \<ca> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
     ( A \<ca> ( B \<ca> C ) )" by (rule MMI_axaddass)
   from S1 S2 S3 S4 show "( ( A \<ca> B ) \<ca> C ) = 
     ( A \<ca> ( B \<ca> C ) )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_mulass: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<cdot> B ) \<cdot> C ) = ( A \<cdot> ( B \<cdot> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cdot> B ) \<cdot> C ) = 
     ( A \<cdot> ( B \<cdot> C ) )" by (rule MMI_axmulass)
   from S1 S2 S3 S4 show "( ( A \<cdot> B ) \<cdot> C ) = ( A \<cdot> ( B \<cdot> C ) )" 
     by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_adddi: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cdot> ( B \<ca> C ) ) = ( ( A \<cdot> B ) \<ca> ( A \<cdot> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> ( B \<ca> C ) ) = 
     ( ( A \<cdot> B ) \<ca> ( A \<cdot> C ) )" by (rule MMI_axdistr)
   from S1 S2 S3 S4 show "( A \<cdot> ( B \<ca> C ) ) = 
     ( ( A \<cdot> B ) \<ca> ( A \<cdot> C ) )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_adddir: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cdot> C ) = 
     ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" by (rule MMI_adddirt)
   from S1 S2 S3 S4 show "( ( A \<ca> B ) \<cdot> C ) = 
     ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_1cn: 
   shows "\<one> \<in> \<complex>"
proof -
   have S1: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from S1 show "\<one> \<in> \<complex>" by (rule MMI_recn)
qed

lemma (in MMIsar0) MMI_0cn: 
   shows "\<zero> \<in> \<complex>"
proof -
   have S1: "( ( \<i> \<cdot> \<i> ) \<ca> \<one> ) = \<zero>" by (rule MMI_axi2m1)
   have S2: "\<i> \<in> \<complex>" by (rule MMI_axicn)
   have S3: "\<i> \<in> \<complex>" by (rule MMI_axicn)
   from S2 S3 have S4: "( \<i> \<cdot> \<i> ) \<in> \<complex>" by (rule MMI_mulcl)
   have S5: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S4 S5 have S6: "( ( \<i> \<cdot> \<i> ) \<ca> \<one> ) \<in> \<complex>" by (rule MMI_addcl)
   from S1 S6 show "\<zero> \<in> \<complex>" by (rule MMI_eqeltrr)
qed

lemma (in MMIsar0) MMI_addid1: assumes A1: "A \<in> \<complex>"   
   shows "( A \<ca> \<zero> ) = A"
proof -
   from A1 have S1: "A \<in> \<complex>".
   have S2: "A \<in> \<complex> \<longrightarrow> ( A \<ca> \<zero> ) = A" by (rule MMI_ax0id)
   from S1 S2 show "( A \<ca> \<zero> ) = A" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_addid2: assumes A1: "A \<in> \<complex>"   
   shows "( \<zero> \<ca> A ) = A"
proof -
   have S1: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from A1 have S2: "A \<in> \<complex>".
   from S1 S2 have S3: "( \<zero> \<ca> A ) = ( A \<ca> \<zero> )" by (rule MMI_addcom)
   from A1 have S4: "A \<in> \<complex>".
   from S4 have S5: "( A \<ca> \<zero> ) = A" by (rule MMI_addid1)
   from S3 S5 show "( \<zero> \<ca> A ) = A" by (rule MMI_eqtr)
qed;

(*-----------------------------------------------------------------*)


lemma (in MMIsar0) MMI_mulid1: assumes A1: "A \<in> \<complex>"   
   shows "( A \<cdot> \<one> ) = A"
proof -
   from A1 have S1: "A \<in> \<complex>".
   have S2: "A \<in> \<complex> \<longrightarrow> ( A \<cdot> \<one> ) = A" by (rule MMI_ax1id)
   from S1 S2 show "( A \<cdot> \<one> ) = A" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_mulid2: assumes A1: "A \<in> \<complex>"   
   shows "( \<one> \<cdot> A ) = A"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from A1 have S2: "A \<in> \<complex>".
   from S1 S2 have S3: "( \<one> \<cdot> A ) = ( A \<cdot> \<one> )" by (rule MMI_mulcom)
   from A1 have S4: "A \<in> \<complex>".
   from S4 have S5: "( A \<cdot> \<one> ) = A" by (rule MMI_mulid1)
   from S3 S5 show "( \<one> \<cdot> A ) = A" by (rule MMI_eqtr)
qed

lemma (in MMIsar0) MMI_negex: assumes A1: "A \<in> \<complex>"   
   shows "\<exists> x \<in> \<complex> . ( A \<ca> x ) = \<zero>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   have S2: "A \<in> \<complex> \<longrightarrow> ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = \<zero> )" by (rule MMI_axnegex)
   from S1 S2 show "\<exists> x \<in> \<complex> . ( A \<ca> x ) = \<zero>" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_recex: assumes A1: "A \<in> \<complex>" and
    A2: "A \<noteq> \<zero>"   
   shows "\<exists> x \<in> \<complex> . ( A \<cdot> x ) = \<one>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "A \<noteq> \<zero>".
   have S3: "( A \<in> \<complex> \<and> A \<noteq> \<zero> ) \<longrightarrow> ( \<exists> x \<in> \<complex> . ( A \<cdot> x ) = \<one> )" 
     by (rule MMI_axrecex)
   from S1 S2 S3 show "\<exists> x \<in> \<complex> . ( A \<cdot> x ) = \<one>" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_readdcl: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "( A \<ca> B ) \<in> \<real>"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ca> B ) \<in> \<real>" by (rule MMI_axaddrcl);
   from S1 S2 S3 show "( A \<ca> B ) \<in> \<real>" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_remulcl: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "( A \<cdot> B ) \<in> \<real>"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<cdot> B ) \<in> \<real>" by (rule MMI_axmulrcl)
   from S1 S2 S3 show "( A \<cdot> B ) \<in> \<real>" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_addcan: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> B = C"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from S1 have S2: "\<exists> x \<in> \<complex> . ( A \<ca> x ) = \<zero>" by (rule MMI_negex)
   from A1 have S3: "A \<in> \<complex>".
   from A2 have S4: "B \<in> \<complex>".
   { fix x
     have S5: "( x \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( x \<ca> A ) \<ca> B ) = 
       ( x \<ca> ( A \<ca> B ) )" by (rule MMI_axaddass)
     from S4 S5 have S6: "( x \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( ( x \<ca> A ) \<ca> B ) = 
       ( x \<ca> ( A \<ca> B ) )" by (rule MMI_mp3an3)
     from A3 have S7: "C \<in> \<complex>".
     have S8: "( x \<in> \<complex> \<and> A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( x \<ca> A ) \<ca> C ) = 
       ( x \<ca> ( A \<ca> C ) )" by (rule MMI_axaddass)
     from S7 S8 have S9: "( x \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( ( x \<ca> A ) \<ca> C ) = 
       ( x \<ca> ( A \<ca> C ) )" by (rule MMI_mp3an3)
     from S6 S9 have S10: "( x \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> 
       ( ( ( x \<ca> A ) \<ca> B ) = ( ( x \<ca> A ) \<ca> C ) \<longleftrightarrow> 
       ( x \<ca> ( A \<ca> B ) ) = ( x \<ca> ( A \<ca> C ) ) )" 
       by (rule MMI_eqeq12d)
     from S3 S10 have S11: "x \<in> \<complex> \<longrightarrow> ( ( ( x \<ca> A ) \<ca> B ) = 
       ( ( x \<ca> A ) \<ca> C ) \<longleftrightarrow> ( x \<ca> ( A \<ca> B ) ) = 
       ( x \<ca> ( A \<ca> C ) ) )" by (rule MMI_mpan2)
     have S12: "( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> ( x \<ca> ( A \<ca> B ) ) = 
       ( x \<ca> ( A \<ca> C ) )" by (rule MMI_opreq2)
     from S11 S12 have S13: "x \<in> \<complex> \<longrightarrow> ( ( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> 
       ( ( x \<ca> A ) \<ca> B ) = ( ( x \<ca> A ) \<ca> C ) )" 
       by (rule MMI_syl5bir)
     from S13 have S14: "( x \<in> \<complex> \<and> ( A \<ca> x ) = \<zero> ) \<longrightarrow> ( ( A \<ca> B ) = 
       ( A \<ca> C ) \<longrightarrow> ( ( x \<ca> A ) \<ca> B ) = 
       ( ( x \<ca> A ) \<ca> C ) )" by (rule MMI_adantr)
     from A1 have S15: "A \<in> \<complex>".
     have S16: "( A \<in> \<complex> \<and> x \<in> \<complex> ) \<longrightarrow> ( A \<ca> x ) = ( x \<ca> A )" 
       by (rule MMI_axaddcom)
     from S15 S16 have S17: "x \<in> \<complex> \<longrightarrow> ( A \<ca> x ) = ( x \<ca> A )" 
       by (rule MMI_mpan)
     from S17 have S18: "x \<in> \<complex> \<longrightarrow> ( ( A \<ca> x ) = \<zero> \<longleftrightarrow> 
       ( x \<ca> A ) = \<zero> )" by (rule MMI_eqeq1d)
     have S19: "( x \<ca> A ) = \<zero> \<longrightarrow> ( ( x \<ca> A ) \<ca> B ) = 
       ( \<zero> \<ca> B )" by (rule MMI_opreq1)
     from A2 have S20: "B \<in> \<complex>".
     from S20 have S21: "( \<zero> \<ca> B ) = B" by (rule MMI_addid2)
     from S19 S21 have S22: "( x \<ca> A ) = \<zero> \<longrightarrow> 
       ( ( x \<ca> A ) \<ca> B ) = B" by (rule MMI_syl6eq)
     have S23: "( x \<ca> A ) = \<zero> \<longrightarrow> ( ( x \<ca> A ) \<ca> C ) = 
       ( \<zero> \<ca> C )" by (rule MMI_opreq1)
     from A3 have S24: "C \<in> \<complex>".
     from S24 have S25: "( \<zero> \<ca> C ) = C" by (rule MMI_addid2)
     from S23 S25 have S26: "( x \<ca> A ) = \<zero> \<longrightarrow> 
       ( ( x \<ca> A ) \<ca> C ) = C" by (rule MMI_syl6eq)
     from S22 S26 have S27: "( x \<ca> A ) = \<zero> \<longrightarrow> 
       ( ( ( x \<ca> A ) \<ca> B ) = ( ( x \<ca> A ) \<ca> C ) \<longleftrightarrow> B = C )" 
       by (rule MMI_eqeq12d)
     from S18 S27 have S28: "x \<in> \<complex> \<longrightarrow> ( ( A \<ca> x ) = \<zero> \<longrightarrow> 
       ( ( ( x \<ca> A ) \<ca> B ) = ( ( x \<ca> A ) \<ca> C ) \<longleftrightarrow> B = C ) )" 
       by (rule MMI_syl6bi)
     from S28 have S29: "( x \<in> \<complex> \<and> ( A \<ca> x ) = \<zero> ) \<longrightarrow> 
       ( ( ( x \<ca> A ) \<ca> B ) = ( ( x \<ca> A ) \<ca> C ) \<longleftrightarrow> B = C )" 
       by (rule MMI_imp)
     from S14 S29 have S30: "( x \<in> \<complex> \<and> ( A \<ca> x ) = \<zero> ) \<longrightarrow> 
       ( ( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> B = C )" by (rule MMI_sylibd)
     from S30 have "x \<in> \<complex> \<longrightarrow> ( ( A \<ca> x ) = \<zero> \<longrightarrow> 
       ( ( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> B = C ) )" by (rule MMI_ex)
   } then have S31: "\<forall> x. (x \<in> \<complex> \<longrightarrow> ( ( A \<ca> x ) = \<zero> \<longrightarrow> 
       ( ( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> B = C ) ))" by auto;
   from S31 have S32: "( \<exists> x \<in> \<complex> . ( A \<ca> x ) = \<zero> ) \<longrightarrow> 
     ( ( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> B = C )" by (rule MMI_r19_23aiv);
   from S2 S32 have S33: "( A \<ca> B ) = ( A \<ca> C ) \<longrightarrow> B = C" 
     by (rule MMI_ax_mp)
   have S34: "B = C \<longrightarrow> ( A \<ca> B ) = ( A \<ca> C )" by (rule MMI_opreq2)
   from S33 S34 show "( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> B = C" 
     by (rule MMI_impbi)
qed;

lemma (in MMIsar0) MMI_addcan2: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<ca> C ) = ( B \<ca> C ) \<longleftrightarrow> A = B"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A3 have S2: "C \<in> \<complex>".
   from S1 S2 have S3: "( A \<ca> C ) = ( C \<ca> A )" by (rule MMI_addcom)
   from A2 have S4: "B \<in> \<complex>".
   from A3 have S5: "C \<in> \<complex>".
   from S4 S5 have S6: "( B \<ca> C ) = ( C \<ca> B )" by (rule MMI_addcom)
   from S3 S6 have S7: "( A \<ca> C ) = ( B \<ca> C ) \<longleftrightarrow> 
     ( C \<ca> A ) = ( C \<ca> B )" by (rule MMI_eqeq12i)
   from A3 have S8: "C \<in> \<complex>".
   from A1 have S9: "A \<in> \<complex>".
   from A2 have S10: "B \<in> \<complex>".
   from S8 S9 S10 have S11: "( C \<ca> A ) = ( C \<ca> B ) \<longleftrightarrow> A = B" 
     by (rule MMI_addcan)
   from S7 S11 show "( A \<ca> C ) = ( B \<ca> C ) \<longleftrightarrow> A = B" by (rule MMI_bitr)
qed

lemma (in MMIsar0) MMI_addcant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
  ( ( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> B = C )"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<ca> B ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B )" by (rule MMI_opreq1)
   have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( A \<ca> C ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C )" by (rule MMI_opreq1)
   from S1 S2 have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) )" 
     by (rule MMI_eqeq12d)
   from S3 have S4: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( ( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> B = C ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) 
     \<longleftrightarrow> B = C ) )" by (rule MMI_bibi1d)
   have S5: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_opreq2)
   from S5 have S6: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) 
     \<longleftrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) )" by (rule MMI_eqeq1d)
   have S7: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( B = C \<longleftrightarrow> 
     if ( B \<in> \<complex> , B , \<zero> ) = C )" by (rule MMI_eqeq1)
   from S6 S7 have S8: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) \<longleftrightarrow> B = C ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) \<longleftrightarrow> if ( B \<in> \<complex> , B , \<zero> ) = C ) )" 
     by (rule MMI_bibi12d)
   have S9: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) )" 
     by (rule MMI_opreq2)
   from S9 have S10: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) )" 
     by (rule MMI_eqeq2d)
   have S11: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> ( if ( B \<in> \<complex> , B , \<zero> ) = C \<longleftrightarrow> 
     if ( B \<in> \<complex> , B , \<zero> ) = if ( C \<in> \<complex> , C , \<zero> ) )" by (rule MMI_eqeq2)
   from S10 S11 have S12: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> C ) \<longleftrightarrow> if ( B \<in> \<complex> , B , \<zero> ) = C ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) \<longleftrightarrow> 
     if ( B \<in> \<complex> , B , \<zero> ) = if ( C \<in> \<complex> , C , \<zero> ) ) )" by (rule MMI_bibi12d)
   have S13: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S13 have S14: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S15: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S15 have S16: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S17: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S17 have S18: "if ( C \<in> \<complex> , C , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S14 S16 S18 have S19: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) \<longleftrightarrow> 
     if ( B \<in> \<complex> , B , \<zero> ) = if ( C \<in> \<complex> , C , \<zero> )" by (rule MMI_addcan)
   from S4 S8 S12 S19 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) = ( A \<ca> C ) \<longleftrightarrow> B = C )" by (rule MMI_dedth3h)
qed

lemma (in MMIsar0) MMI_addcan2t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> C ) = ( B \<ca> C ) \<longleftrightarrow> 
  A = B )"
proof -
   have S1: "( C \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( C \<ca> A ) = ( A \<ca> C )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( C \<ca> A ) = 
     ( A \<ca> C )" by (rule MMI_3adant3)
   have S3: "( C \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( C \<ca> B ) = ( B \<ca> C )" 
     by (rule MMI_axaddcom)
   from S3 have S4: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( C \<ca> B ) = 
     ( B \<ca> C )" by (rule MMI_3adant2)
   from S2 S4 have S5: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( C \<ca> A ) = ( C \<ca> B ) \<longleftrightarrow> ( A \<ca> C ) = ( B \<ca> C ) )" 
     by (rule MMI_eqeq12d)
   have S6: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( C \<ca> A ) = 
     ( C \<ca> B ) \<longleftrightarrow> A = B )" by (rule MMI_addcant)
   from S5 S6 have S7: "( C \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> C ) = 
     ( B \<ca> C ) \<longleftrightarrow> A = B )" by (rule MMI_bitr3d)
   from S7 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> C ) = 
     ( B \<ca> C ) \<longleftrightarrow> A = B )" by (rule MMI_3coml)
qed;

(************************ 20-30********************************)

lemma (in MMIsar0) MMI_add12t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<ca> C ) ) = 
  ( B \<ca> ( A \<ca> C ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) = ( B \<ca> A )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
     ( ( B \<ca> A ) \<ca> C )" by (rule MMI_opreq1d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( B \<ca> A ) \<ca> C )" 
     by (rule MMI_3adant3)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
     ( A \<ca> ( B \<ca> C ) )" by (rule MMI_axaddass)
   have S5: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( B \<ca> A ) \<ca> C ) = 
     ( B \<ca> ( A \<ca> C ) )" by (rule MMI_axaddass)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<ca> A ) \<ca> C ) = ( B \<ca> ( A \<ca> C ) )" by (rule MMI_3com12)
   from S3 S4 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( B \<ca> C ) ) = ( B \<ca> ( A \<ca> C ) )" 
     by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_add23t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
  ( ( A \<ca> C ) \<ca> B )"
proof -
   have S1: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<ca> C ) = ( C \<ca> B )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<ca> C ) ) = 
     ( A \<ca> ( C \<ca> B ) )" by (rule MMI_opreq2d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( B \<ca> C ) ) = ( A \<ca> ( C \<ca> B ) )" 
     by (rule MMI_3adant1)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
     ( A \<ca> ( B \<ca> C ) )" by (rule MMI_axaddass)
   have S5: "( A \<in> \<complex> \<and> C \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> C ) \<ca> B ) = 
     ( A \<ca> ( C \<ca> B ) )" by (rule MMI_axaddass)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> C ) \<ca> B ) = ( A \<ca> ( C \<ca> B ) )" by (rule MMI_3com23)
   from S3 S4 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )" 
     by (rule MMI_3eqtr4d)
qed

lemma (in MMIsar0) MMI_add4t: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
  ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )" by (rule MMI_add23t)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D )" by (rule MMI_opreq1d)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D )" by (rule MMI_3expa)
   from S3 have S4: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D )" by (rule MMI_adantrr)
   have S5: "( ( A \<ca> B ) \<in> \<complex> \<and> C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) )" by (rule MMI_axaddass)
   from S5 have S6: "( ( A \<ca> B ) \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) )" by (rule MMI_3expb)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S6 S7 have S8: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<ca> D ) = 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) )" by (rule MMI_sylan)
   have S9: "( ( A \<ca> C ) \<in> \<complex> \<and> B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_axaddass)
   from S9 have S10: "( ( A \<ca> C ) \<in> \<complex> \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_3expb)
   have S11: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> C ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S10 S11 have S12: "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_sylan)
   from S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<ca> D ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_an4s)
   from S4 S8 S13 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_add42t: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
  ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )"
proof -
   have S1: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_add4t)
   have S2: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<ca> D ) = 
     ( D \<ca> B )" by (rule MMI_axaddcom)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<ca> D ) = ( D \<ca> B )" by (rule MMI_ad2ant2l)
   from S3 have S4: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )" by (rule MMI_opreq2d)
   from S1 S4 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )" by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_add12: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<ca> ( B \<ca> C ) ) = ( B \<ca> ( A \<ca> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<ca> C ) ) = 
     ( B \<ca> ( A \<ca> C ) )" by (rule MMI_add12t)
   from S1 S2 S3 S4 show "( A \<ca> ( B \<ca> C ) ) = 
     ( B \<ca> ( A \<ca> C ) )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_add23: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )" by (rule MMI_add23t)
   from S1 S2 S3 S4 show "( ( A \<ca> B ) \<ca> C ) = 
     ( ( A \<ca> C ) \<ca> B )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_add4: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
  ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_add4t)
   from S3 S6 S7 show "( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_add42: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
  ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   from A4 have S4: "D \<in> \<complex>".
   from S1 S2 S3 S4 have S5: "( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( B \<ca> D ) )" by (rule MMI_add4)
   from A2 have S6: "B \<in> \<complex>".
   from A4 have S7: "D \<in> \<complex>".
   from S6 S7 have S8: "( B \<ca> D ) = ( D \<ca> B )" by (rule MMI_addcom)
   from S8 have S9: "( ( A \<ca> C ) \<ca> ( B \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )" by (rule MMI_opreq2i)
   from S5 S9 show "( ( A \<ca> B ) \<ca> ( C \<ca> D ) ) = 
     ( ( A \<ca> C ) \<ca> ( D \<ca> B ) )" by (rule MMI_eqtr)
qed

lemma (in MMIsar0) MMI_addid2t: 
   shows "A \<in> \<complex> \<longrightarrow> ( \<zero> \<ca> A ) = A"
proof -
   have S1: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   have S2: "( \<zero> \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( \<zero> \<ca> A ) = ( A \<ca> \<zero> )" 
     by (rule MMI_axaddcom)
   from S1 S2 have S3: "A \<in> \<complex> \<longrightarrow> ( \<zero> \<ca> A ) = ( A \<ca> \<zero> )" 
     by (rule MMI_mpan)
   have S4: "A \<in> \<complex> \<longrightarrow> ( A \<ca> \<zero> ) = A" by (rule MMI_ax0id)
   from S3 S4 show "A \<in> \<complex> \<longrightarrow> ( \<zero> \<ca> A ) = A" by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_peano2cn: 
   shows "A \<in> \<complex> \<longrightarrow> ( A \<ca> \<one> ) \<in> \<complex>"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S2: "( A \<in> \<complex> \<and> \<one> \<in> \<complex> ) \<longrightarrow> ( A \<ca> \<one> ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S1 S2 show "A \<in> \<complex> \<longrightarrow> ( A \<ca> \<one> ) \<in> \<complex>" by (rule MMI_mpan2)
qed;

(*** 31-34 ********************************************************)

lemma (in MMIsar0) MMI_peano2re: 
   shows "A \<in> \<real> \<longrightarrow> ( A \<ca> \<one> ) \<in> \<real>"
proof -
   have S1: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   have S2: "( A \<in> \<real> \<and> \<one> \<in> \<real> ) \<longrightarrow> ( A \<ca> \<one> ) \<in> \<real>" by (rule MMI_axaddrcl)
   from S1 S2 show "A \<in> \<real> \<longrightarrow> ( A \<ca> \<one> ) \<in> \<real>" by (rule MMI_mpan2)
qed

lemma (in MMIsar0) MMI_negeu: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "\<exists>! x . x \<in> \<complex> \<and> ( A \<ca> x ) = B"
proof -
   { fix x y
     have S1: "x = y \<longrightarrow> ( A \<ca> x ) = ( A \<ca> y )" by (rule MMI_opreq2)
     from S1 have "x = y \<longrightarrow> ( ( A \<ca> x ) = B \<longleftrightarrow> ( A \<ca> y ) = B )" 
       by (rule MMI_eqeq1d)
   } then have S2: "\<forall>x y. x = y \<longrightarrow> ( ( A \<ca> x ) = B \<longleftrightarrow> 
       ( A \<ca> y ) = B )" by simp;
   from S2 have S3: "( \<exists>! x . x \<in> \<complex> \<and> ( A \<ca> x ) = B ) \<longleftrightarrow> 
     ( ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B ) \<and> 
     ( \<forall> x \<in> \<complex> . \<forall> y \<in> \<complex> . ( ( ( A \<ca> x ) = B \<and> ( A \<ca> y ) = B ) \<longrightarrow> 
     x = y ) ) )" by (rule MMI_reu4);
   from A1 have S4: "A \<in> \<complex>".
   from S4 have S5: "\<exists> y \<in> \<complex> . ( A \<ca> y ) = \<zero>" by (rule MMI_negex)
   from A2 have S6: "B \<in> \<complex>".
   { fix y
     have S7: "( y \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( y \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
     from S6 S7 have S8: "y \<in> \<complex> \<longrightarrow> ( y \<ca> B ) \<in> \<complex>" by (rule MMI_mpan2)
     have S9: "( y \<ca> B ) \<in> \<complex> \<longleftrightarrow> ( \<exists> x \<in> \<complex> . x = ( y \<ca> B ) )" 
       by (rule MMI_risset)
     from S8 S9 have S10: "y \<in> \<complex> \<longrightarrow> ( \<exists> x \<in> \<complex> . x = ( y \<ca> B ) )" 
       by (rule MMI_sylib)
     { fix x
       have S11: "x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = 
	 ( A \<ca> ( y \<ca> B ) )" by (rule MMI_opreq2)
       from A1 have S12: "A \<in> \<complex>".
       from A2 have S13: "B \<in> \<complex>".
       have S14: "( A \<in> \<complex> \<and> y \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
	 ( ( A \<ca> y ) \<ca> B ) = ( A \<ca> ( y \<ca> B ) )" 
	 by (rule MMI_axaddass)
       from S12 S13 S14 have S15: "y \<in> \<complex> \<longrightarrow> ( ( A \<ca> y ) \<ca> B ) = 
	 ( A \<ca> ( y \<ca> B ) )" by (rule MMI_mp3an13)
       from S15 have S16: "y \<in> \<complex> \<longrightarrow> ( A \<ca> ( y \<ca> B ) ) = 
	 ( ( A \<ca> y ) \<ca> B )" by (rule MMI_eqcomd)
       from S11 S16 have S17: "( y \<in> \<complex> \<and> x = ( y \<ca> B ) ) 
	 \<longrightarrow> ( A \<ca> x ) = ( ( A \<ca> y ) \<ca> B )" by (rule MMI_sylan9eqr)
       have S18: "( A \<ca> y ) = \<zero> \<longrightarrow> 
	 ( ( A \<ca> y ) \<ca> B ) = ( \<zero> \<ca> B )" by (rule MMI_opreq1)
       from A2 have S19: "B \<in> \<complex>".
       from S19 have S20: "( \<zero> \<ca> B ) = B" by (rule MMI_addid2)
       from S18 S20 have S21: "( A \<ca> y ) = \<zero> \<longrightarrow> 
	 ( ( A \<ca> y ) \<ca> B ) = B" by (rule MMI_syl6eq)
       from S17 S21 have S22: "( ( A \<ca> y ) = \<zero> \<and> ( y \<in> \<complex> \<and> x = 
	 ( y \<ca> B ) ) ) \<longrightarrow> ( A \<ca> x ) = B" by (rule MMI_sylan9eqr)
       from S22 have S23: "( A \<ca> y ) = \<zero> \<longrightarrow> 
	 ( y \<in> \<complex> \<longrightarrow> ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) )" 
	 by (rule MMI_exp32)
       from S23 have S24: "( y \<in> \<complex> \<and> ( A \<ca> y ) = \<zero> ) \<longrightarrow> 
	 ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B )" by (rule MMI_impcom)
       from S24 have "( y \<in> \<complex> \<and> ( A \<ca> y ) = \<zero> ) \<longrightarrow> 
	 ( x \<in> \<complex> \<longrightarrow> ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) )" 
	 by (rule MMI_a1d)
     } then have S25: "\<forall> x. ( y \<in> \<complex> \<and> ( A \<ca> y ) = \<zero> ) \<longrightarrow> 
	 ( x \<in> \<complex> \<longrightarrow> ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) )" by auto;
     from S25 have S26: "( y \<in> \<complex> \<and> ( A \<ca> y ) = \<zero> ) \<longrightarrow> 
       ( \<forall> x \<in> \<complex> . ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) )" 
       by (rule MMI_r19_21aiv);
     from S26 have S27: "y \<in> \<complex> \<longrightarrow> ( ( A \<ca> y ) = \<zero> \<longrightarrow> 
       ( \<forall> x \<in> \<complex> . ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) ) )" 
       by (rule MMI_ex)
     have S28: "( \<forall> x \<in> \<complex> . ( x = ( y \<ca> B ) \<longrightarrow> ( A \<ca> x ) = B ) ) 
       \<longrightarrow> ( ( \<exists> x \<in> \<complex> . x = ( y \<ca> B ) ) \<longrightarrow> 
       ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B ) )" by (rule MMI_r19_22);
     from S27 S28 have S29: "y \<in> \<complex> \<longrightarrow> ( ( A \<ca> y ) = \<zero> \<longrightarrow> 
       ( ( \<exists> x \<in> \<complex> . x = ( y \<ca> B ) ) \<longrightarrow> 
       ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B ) ) )" by (rule MMI_syl6)
     from S10 S29 have "y \<in> \<complex> \<longrightarrow> ( ( A \<ca> y ) = \<zero> \<longrightarrow> 
       ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B ) )" by (rule MMI_mpid);
   } then have S30: "\<forall> y. y \<in> \<complex> \<longrightarrow> ( ( A \<ca> y ) = \<zero> \<longrightarrow> 
       ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B ) )" by simp;
   from S30 have S31: "( \<exists> y \<in> \<complex> . ( A \<ca> y ) = \<zero> ) \<longrightarrow> 
     ( \<exists> x \<in> \<complex> . ( A \<ca> x ) = B )" by (rule MMI_r19_23aiv)
   from S5 S31 have S32: "\<exists> x \<in> \<complex> . ( A \<ca> x ) = B" by (rule MMI_ax_mp)
   from A1 have S33: "A \<in> \<complex>".
   { fix x y
     have S34: "( A \<in> \<complex> \<and> x \<in> \<complex> \<and> y \<in> \<complex> ) \<longrightarrow> 
       ( ( A \<ca> x ) = ( A \<ca> y ) \<longleftrightarrow> x = y )" by (rule MMI_addcant)
     have S35: "( ( A \<ca> x ) = B \<and> ( A \<ca> y ) = B ) \<longrightarrow> 
       ( A \<ca> x ) = ( A \<ca> y )" by (rule MMI_eqtr3t)
     from S34 S35 have S36: "( A \<in> \<complex> \<and> x \<in> \<complex> \<and> y \<in> \<complex> ) \<longrightarrow> 
       ( ( ( A \<ca> x ) = B \<and> ( A \<ca> y ) = B ) \<longrightarrow> x = y )" 
       by (rule MMI_syl5bi)
     from S33 S36 have "( x \<in> \<complex> \<and> y \<in> \<complex> ) \<longrightarrow> 
       ( ( ( A \<ca> x ) = B \<and> ( A \<ca> y ) = B ) \<longrightarrow> x = y )" 
       by (rule MMI_mp3an1)
   } then have S37: "\<forall>x y . ( x \<in> \<complex> \<and> y \<in> \<complex> ) \<longrightarrow> 
       ( ( ( A \<ca> x ) = B \<and> ( A \<ca> y ) = B ) \<longrightarrow> x = y )" by auto;
   from S37 have S38: "\<forall> x \<in> \<complex> . \<forall> y \<in> \<complex> . ( ( ( A \<ca> x ) = B \<and> 
     ( A \<ca> y ) = B ) \<longrightarrow> x = y )" by (rule MMI_rgen2)
   from S3 S32 S38 show "\<exists>! x . x \<in> \<complex> \<and> ( A \<ca> x ) = B" 
     by (rule MMI_mpbir2an)
qed;

(** this is proven by definition rather than importing the Metamath proof **)

lemma (in MMIsar0) MMI_subval: assumes "A \<in> \<complex>"  "B \<in> \<complex>"
  shows "A \<cs> B =  \<Union> { x \<in> \<complex> . B \<ca> x = A }"
  using sub_def by simp;

(** this is a definition in Metamath *)

lemma (in MMIsar0) MMI_df_neg: shows "(\<cn> A) = \<zero> \<cs> A"
  using cneg_def by simp;

(************** 35-37 ****************************************)
 
lemma (in MMIsar0) MMI_negeq: 
   shows "A = B \<longrightarrow> \<cn> A = \<cn> B"
proof -
   have S1: "A = B \<longrightarrow> ( \<zero> \<cs> A ) = ( \<zero> \<cs> B )" by (rule MMI_opreq2)
   have S2: "\<cn> A = ( \<zero> \<cs> A )" by (rule MMI_df_neg)
   have S3: "\<cn> B = ( \<zero> \<cs> B )" by (rule MMI_df_neg)
   from S1 S2 S3 show "A = B \<longrightarrow> \<cn> A = \<cn> B" by (rule MMI_3eqtr4g)
qed;

lemma (in MMIsar0) MMI_negeqi: assumes A1: "A = B"   
   shows "\<cn> A = \<cn> B"
proof -
   from A1 have S1: "A = B".
   have S2: "A = B \<longrightarrow> \<cn> A = \<cn> B" by (rule MMI_negeq)
   from S1 S2 show "\<cn> A = \<cn> B" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_negeqd: assumes A1: "\<phi> \<longrightarrow> A = B"   
   shows "\<phi> \<longrightarrow> \<cn> A = \<cn> B"
proof -
   from A1 have S1: "\<phi> \<longrightarrow> A = B".
   have S2: "A = B \<longrightarrow> \<cn> A = \<cn> B" by (rule MMI_negeq)
   from S1 S2 show "\<phi> \<longrightarrow> \<cn> A = \<cn> B" by (rule MMI_syl)
qed;

(**********************auto************************************)

lemma (in MMIsar0) MMI_hbneg: assumes A1: "y \<in> A \<longrightarrow> ( \<forall> x . y \<in> A )"   
   shows "y \<in> (\<cn> A) \<longrightarrow> ( \<forall> x . (y \<in> (\<cn> A) ) )"
  using prems by auto;

lemma (in MMIsar0) MMI_minusex: 
   shows "(\<cn> A) isASet" by auto;

(********38-43************************************************)

lemma (in MMIsar0) MMI_subcl: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<cs> B ) \<in> \<complex>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "( A \<cs> B ) = \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A }" 
     by (rule MMI_subval)
   from A2 have S4: "B \<in> \<complex>".
   from A1 have S5: "A \<in> \<complex>".
   from S4 S5 have S6: "\<exists>! x . x \<in> \<complex> \<and> ( B \<ca> x ) = A" by (rule MMI_negeu)
   have S7: "( \<exists>! x . x \<in> \<complex> \<and> ( B \<ca> x ) = A ) \<longrightarrow> 
     \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } \<in> \<complex>" by (rule MMI_reucl)
   from S6 S7 have S8: "\<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } \<in> \<complex>" 
     by (rule MMI_ax_mp)
   from S3 S8 show "( A \<cs> B ) \<in> \<complex>" by simp;
qed;

lemma (in MMIsar0) MMI_subclt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> B ) \<in> \<complex>"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B )" by (rule MMI_opreq1)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( ( A \<cs> B ) \<in> \<complex> \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) \<in> \<complex> )" by (rule MMI_eleq1d)
   have S3: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_opreq2)
   from S3 have S4: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) \<in> \<complex> \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) \<in> \<complex> )" 
     by (rule MMI_eleq1d)
   have S5: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S5 have S6: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S7: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S7 have S8: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S6 S8 have S9: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) \<in> \<complex>" 
     by (rule MMI_subcl)
   from S2 S4 S9 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> B ) \<in> \<complex>" 
     by (rule MMI_dedth2h)
qed;

lemma (in MMIsar0) MMI_negclt: 
   shows "A \<in> \<complex> \<longrightarrow> ( \<cn> A ) \<in> \<complex>"
proof -
   have S1: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   have S2: "( \<zero> \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( \<zero> \<cs> A ) \<in> \<complex>" by (rule MMI_subclt)
   from S1 S2 have S3: "A \<in> \<complex> \<longrightarrow> ( \<zero> \<cs> A ) \<in> \<complex>" by (rule MMI_mpan)
   have S4: "( \<cn> A ) = ( \<zero> \<cs> A )" by (rule MMI_df_neg)
   from S3 S4 show "A \<in> \<complex> \<longrightarrow> ( \<cn> A ) \<in> \<complex>" by (rule MMI_syl5eqel)
qed

lemma (in MMIsar0) MMI_negcl: assumes A1: "A \<in> \<complex>"   
   shows "( \<cn> A ) \<in> \<complex>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   have S2: "A \<in> \<complex> \<longrightarrow> ( \<cn> A ) \<in> \<complex>" by (rule MMI_negclt)
   from S1 S2 show "( \<cn> A ) \<in> \<complex>" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_subadd: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A"
proof -
   from A3 have S1: "C \<in> \<complex>".
   { fix x
     have S2: "x = C \<longrightarrow> ( ( A \<cs> B ) = x \<longleftrightarrow> ( A \<cs> B ) = C )" 
       by (rule MMI_eqeq2)
     have S3: "x = C \<longrightarrow> ( B \<ca> x ) = ( B \<ca> C )" by (rule MMI_opreq2)
     from S3 have S4: "x = C \<longrightarrow> ( ( B \<ca> x ) = A \<longleftrightarrow> ( B \<ca> C ) = A )" 
       by (rule MMI_eqeq1d)
     from S2 S4 have "x = C \<longrightarrow> ( ( ( A \<cs> B ) = x \<longleftrightarrow> 
       ( B \<ca> x ) = A ) \<longleftrightarrow> ( ( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A ) )" 
       by (rule MMI_bibi12d)
   } then have S5: "\<forall>x. x = C \<longrightarrow> ( ( ( A \<cs> B ) = x \<longleftrightarrow> 
       ( B \<ca> x ) = A ) \<longleftrightarrow> ( ( A \<cs> B ) = C \<longleftrightarrow> 
       ( B \<ca> C ) = A ) )" by simp;
   from A2 have S6: "B \<in> \<complex>".
   from A1 have S7: "A \<in> \<complex>".
   from S6 S7 have S8: "\<exists>! x . x \<in> \<complex> \<and> ( B \<ca> x ) = A" by (rule MMI_negeu)
   { fix x 
     have S9: "( x \<in> \<complex> \<and> ( \<exists>! x . x \<in> \<complex> \<and> ( B \<ca> x ) = A ) \<longrightarrow> 
       ( ( B \<ca> x ) = A ) \<longleftrightarrow> \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } = x )" 
       by (rule MMI_reuuni1)
     from S8 S9 have "x \<in> \<complex> \<longrightarrow> ( ( B \<ca> x ) = A \<longleftrightarrow> 
       \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } = x )" by (rule MMI_mpan2)
   } then have S10: "\<forall> x. x \<in> \<complex> \<longrightarrow> ( ( B \<ca> x ) = A \<longleftrightarrow> 
       \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } = x )" by blast;
   from A1 have S11: "A \<in> \<complex>".
   from A2 have S12: "B \<in> \<complex>".
   from S11 S12 have S13: "( A \<cs> B ) = \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A }" 
     by (rule MMI_subval)
   from S13 have S14: "\<forall>x. ( A \<cs> B ) = x \<longleftrightarrow> 
     \<Union> { x \<in> \<complex> . ( B \<ca> x ) = A } = x" by simp;  (* (rule MMI_eqeq1i)*)
   from S10 S14 have S15: "\<forall>x. x \<in> \<complex> \<longrightarrow> ( ( A \<cs> B ) = x \<longleftrightarrow> 
     ( B \<ca> x ) = A )" by (rule MMI_syl6rbbr);
   from S5 S15 have S16: "C \<in> \<complex> \<longrightarrow> ( ( A \<cs> B ) = C \<longleftrightarrow> 
     ( B \<ca> C ) = A )" by (rule MMI_vtoclga)
   from S1 S16 show "( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A" 
     by (rule MMI_ax_mp)
qed;

(*******************44-53*********************************************)


lemma (in MMIsar0) MMI_subsub23: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cs> B ) = C \<longleftrightarrow> ( A \<cs> C ) = B"
proof -
   from A2 have S1: "B \<in> \<complex>".
   from A3 have S2: "C \<in> \<complex>".
   from S1 S2 have S3: "( B \<ca> C ) = ( C \<ca> B )" by (rule MMI_addcom)
   from S3 have S4: "( B \<ca> C ) = A \<longleftrightarrow> ( C \<ca> B ) = A" 
     by (rule MMI_eqeq1i)
   from A1 have S5: "A \<in> \<complex>".
   from A2 have S6: "B \<in> \<complex>".
   from A3 have S7: "C \<in> \<complex>".
   from S5 S6 S7 have S8: "( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A" 
     by (rule MMI_subadd)
   from A1 have S9: "A \<in> \<complex>".
   from A3 have S10: "C \<in> \<complex>".
   from A2 have S11: "B \<in> \<complex>".
   from S9 S10 S11 have S12: "( A \<cs> C ) = B \<longleftrightarrow> ( C \<ca> B ) = A" 
     by (rule MMI_subadd)
   from S4 S8 S12 show "( A \<cs> B ) = C \<longleftrightarrow> ( A \<cs> C ) = B" 
     by (rule MMI_3bitr4)
qed

lemma (in MMIsar0) MMI_subaddt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) = C \<longleftrightarrow> 
  ( B \<ca> C ) = A )"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B )" by (rule MMI_opreq1)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( ( A \<cs> B ) = C \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = C )" by (rule MMI_eqeq1d)
   have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( ( B \<ca> C ) = A \<longleftrightarrow> 
     ( B \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) )" by (rule MMI_eqeq2)
   from S2 S3 have S4: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = 
     if ( A \<in> \<complex> , A , \<zero> ) ) )" by (rule MMI_bibi12d)
   have S5: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_opreq2)
   from S5 have S6: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = C \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = C )" 
     by (rule MMI_eqeq1d)
   have S7: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( B \<ca> C ) = 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C )" by (rule MMI_opreq1)
   from S7 have S8: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( B \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) )" 
     by (rule MMI_eqeq1d)
   from S6 S8 have S9: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = C \<longleftrightarrow> 
     ( B \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = C \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) ) )" 
     by (rule MMI_bibi12d)
   have S10: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = C \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     if ( C \<in> \<complex> , C , \<zero> ) )" by (rule MMI_eqeq2)
   have S11: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C ) = 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) )" by (rule MMI_opreq2)
   from S11 have S12: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) = 
     if ( A \<in> \<complex> , A , \<zero> ) )" by (rule MMI_eqeq1d)
   from S10 S12 have S13: "C = if ( C \<in> \<complex> , C , \<zero> ) \<longrightarrow> 
     ( ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = C \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> C ) = if ( A \<in> \<complex> , A , \<zero> ) ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     if ( C \<in> \<complex> , C , \<zero> ) \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) = 
     if ( A \<in> \<complex> , A , \<zero> ) ) )" by (rule MMI_bibi12d)
   have S14: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S14 have S15: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S16: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S16 have S17: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S18: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S18 have S19: "if ( C \<in> \<complex> , C , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S15 S17 S19 have S20: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = 
     if ( C \<in> \<complex> , C , \<zero> ) \<longleftrightarrow> 
     ( if ( B \<in> \<complex> , B , \<zero> ) \<ca> if ( C \<in> \<complex> , C , \<zero> ) ) = 
     if ( A \<in> \<complex> , A , \<zero> )" by (rule MMI_subadd)
   from S4 S9 S13 S20 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> B ) = C \<longleftrightarrow> ( B \<ca> C ) = A )" by (rule MMI_dedth3h)
qed

lemma (in MMIsar0) MMI_pncan3t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<cs> A ) ) = B"
proof -
   have S1: "( B \<cs> A ) = ( B \<cs> A )" by (rule MMI_eqid)
   have S2: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> ( B \<cs> A ) \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<cs> A ) = ( B \<cs> A ) \<longleftrightarrow> ( A \<ca> ( B \<cs> A ) ) = B )" 
     by (rule MMI_subaddt)
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_pm3_27)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> A \<in> \<complex>" by (rule MMI_pm3_26)
   have S5: "( B \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( B \<cs> A ) \<in> \<complex>" by (rule MMI_subclt)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( B \<cs> A ) \<in> \<complex>" 
     by (rule MMI_ancoms)
   from S2 S3 S4 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( B \<cs> A ) = 
     ( B \<cs> A ) \<longleftrightarrow> ( A \<ca> ( B \<cs> A ) ) = B )" by (rule MMI_syl3anc)
   from S1 S7 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<cs> A ) ) = B" 
     by (rule MMI_mpbii)
qed

lemma (in MMIsar0) MMI_pncan3: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<ca> ( B \<cs> A ) ) = B"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<cs> A ) ) = B" 
     by (rule MMI_pncan3t)
   from S1 S2 S3 show "( A \<ca> ( B \<cs> A ) ) = B" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_negidt: 
   shows "A \<in> \<complex> \<longrightarrow> ( A \<ca> ( \<cn> A ) ) = \<zero>"
proof -
   have S1: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   have S2: "( A \<in> \<complex> \<and> \<zero> \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<zero> \<cs> A ) ) = \<zero>" 
     by (rule MMI_pncan3t)
   from S1 S2 have S3: "A \<in> \<complex> \<longrightarrow> ( A \<ca> ( \<zero> \<cs> A ) ) = \<zero>" 
     by (rule MMI_mpan2)
   have S4: "( \<cn> A ) = ( \<zero> \<cs> A )" by (rule MMI_df_neg)
   from S4 have S5: "( A \<ca> ( \<cn> A ) ) = ( A \<ca> ( \<zero> \<cs> A ) )" 
     by (rule MMI_opreq2i)
   from S3 S5 show "A \<in> \<complex> \<longrightarrow> ( A \<ca> ( \<cn> A ) ) = \<zero>" by (rule MMI_syl5eq)
qed

lemma (in MMIsar0) MMI_negid: assumes A1: "A \<in> \<complex>"   
   shows "( A \<ca> ( \<cn> A ) ) = \<zero>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   have S2: "A \<in> \<complex> \<longrightarrow> ( A \<ca> ( \<cn> A ) ) = \<zero>" by (rule MMI_negidt)
   from S1 S2 show "( A \<ca> ( \<cn> A ) ) = \<zero>" by (rule MMI_ax_mp)
qed

lemma (in MMIsar0) MMI_negsub: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )"
proof -
   from A2 have S1: "B \<in> \<complex>".
   from A1 have S2: "A \<in> \<complex>".
   from A2 have S3: "B \<in> \<complex>".
   from S3 have S4: "( \<cn> B ) \<in> \<complex>" by (rule MMI_negcl)
   from S2 S4 have S5: "( A \<ca> ( \<cn> B ) ) \<in> \<complex>" by (rule MMI_addcl)
   from S1 S5 have S6: "( B \<ca> ( A \<ca> ( \<cn> B ) ) ) = 
     ( ( A \<ca> ( \<cn> B ) ) \<ca> B )" by (rule MMI_addcom)
   from A1 have S7: "A \<in> \<complex>".
   from S4 have S8: "( \<cn> B ) \<in> \<complex>" .
   from A2 have S9: "B \<in> \<complex>".
   from S7 S8 S9 have S10: "( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = 
     ( A \<ca> ( ( \<cn> B ) \<ca> B ) )" by (rule MMI_addass)
   from S4 have S11: "( \<cn> B ) \<in> \<complex>" .
   from A2 have S12: "B \<in> \<complex>".
   from S11 S12 have S13: "( ( \<cn> B ) \<ca> B ) = ( B \<ca> ( \<cn> B ) )" 
     by (rule MMI_addcom)
   from A2 have S14: "B \<in> \<complex>".
   from S14 have S15: "( B \<ca> ( \<cn> B ) ) = \<zero>" by (rule MMI_negid)
   from S13 S15 have S16: "( ( \<cn> B ) \<ca> B ) = \<zero>" by (rule MMI_eqtr)
   from S16 have S17: "( A \<ca> ( ( \<cn> B ) \<ca> B ) ) = ( A \<ca> \<zero> )" 
     by (rule MMI_opreq2i)
   from A1 have S18: "A \<in> \<complex>".
   from S18 have S19: "( A \<ca> \<zero> ) = A" by (rule MMI_addid1)
   from S10 S17 S19 have S20: "( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = A" 
     by (rule MMI_3eqtr)
   from S6 S20 have S21: "( B \<ca> ( A \<ca> ( \<cn> B ) ) ) = A" 
     by (rule MMI_eqtr)
   from A1 have S22: "A \<in> \<complex>".
   from A2 have S23: "B \<in> \<complex>".
   from S5 have S24: "( A \<ca> ( \<cn> B ) ) \<in> \<complex>" .
   from S22 S23 S24 have S25: "( A \<cs> B ) = ( A \<ca> ( \<cn> B ) ) \<longleftrightarrow> 
     ( B \<ca> ( A \<ca> ( \<cn> B ) ) ) = A" by (rule MMI_subadd)
   from S21 S25 have S26: "( A \<cs> B ) = ( A \<ca> ( \<cn> B ) )" 
     by (rule MMI_mpbir)
   from S26 show "( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" by (rule MMI_eqcomi)
qed

lemma (in MMIsar0) MMI_negsubt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> B ) )" by (rule MMI_opreq1)
   have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B )" by (rule MMI_opreq1)
   from S1 S2 have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) = ( A \<cs> B ) \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> B ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) )" by (rule MMI_eqeq12d)
   have S4: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( \<cn> B ) = ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_negeq)
   from S4 have S5: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> B ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) )" 
     by (rule MMI_opreq2d)
   have S6: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) )" 
     by (rule MMI_opreq2)
   from S5 S6 have S7: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> B ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) )" 
     by (rule MMI_eqeq12d)
   have S8: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S8 have S9: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S10: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S10 have S11: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S9 S11 have S12: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<ca> ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) )" 
     by (rule MMI_negsub)
   from S3 S7 S12 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = 
     ( A \<cs> B )" by (rule MMI_dedth2h)
qed

lemma (in MMIsar0) MMI_addsubasst: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
  ( A \<ca> ( B \<cs> C ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> ( \<cn> C ) \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( \<cn> C ) ) = 
     ( A \<ca> ( B \<ca> ( \<cn> C ) ) )" by (rule MMI_axaddass)
   have S2: "C \<in> \<complex> \<longrightarrow> ( \<cn> C ) \<in> \<complex>" by (rule MMI_negclt)
   from S1 S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( \<cn> C ) ) = 
     ( A \<ca> ( B \<ca> ( \<cn> C ) ) )" by (rule MMI_syl3an3)
   have S4: "( ( A \<ca> B ) \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( \<cn> C ) ) = ( ( A \<ca> B ) \<cs> C )" 
     by (rule MMI_negsubt)
   have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S4 S5 have S6: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( \<cn> C ) ) = ( ( A \<ca> B ) \<cs> C )" 
     by (rule MMI_sylan)
   from S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> ( \<cn> C ) ) = ( ( A \<ca> B ) \<cs> C )" 
     by (rule MMI_3impa)
   have S8: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<ca> ( \<cn> C ) ) = ( B \<cs> C )" 
     by (rule MMI_negsubt)
   from S8 have S9: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( B \<ca> ( \<cn> C ) ) = ( B \<cs> C )" by (rule MMI_3adant1)
   from S9 have S10: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( B \<ca> ( \<cn> C ) ) ) = ( A \<ca> ( B \<cs> C ) )" 
     by (rule MMI_opreq2d)
   from S3 S7 S10 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> C ) = ( A \<ca> ( B \<cs> C ) )" 
     by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_addsubt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
  ( ( A \<cs> C ) \<ca> B )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) = ( B \<ca> A )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
     ( ( B \<ca> A ) \<cs> C )" by (rule MMI_opreq1d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> C ) = ( ( B \<ca> A ) \<cs> C )" 
     by (rule MMI_3adant3)
   have S4: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( B \<ca> A ) \<cs> C ) = 
     ( B \<ca> ( A \<cs> C ) )" by (rule MMI_addsubasst)
   from S4 have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<ca> A ) \<cs> C ) = ( B \<ca> ( A \<cs> C ) )" by (rule MMI_3com12)
   have S6: "( B \<in> \<complex> \<and> ( A \<cs> C ) \<in> \<complex> ) \<longrightarrow> ( B \<ca> ( A \<cs> C ) ) = 
     ( ( A \<cs> C ) \<ca> B )" by (rule MMI_axaddcom)
   from S6 have S7: "B \<in> \<complex> \<longrightarrow> ( ( A \<cs> C ) \<in> \<complex> \<longrightarrow> 
     ( B \<ca> ( A \<cs> C ) ) = ( ( A \<cs> C ) \<ca> B ) )" by (rule MMI_ex)
   have S8: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cs> C ) \<in> \<complex>" by (rule MMI_subclt)
   from S7 S8 have S9: "B \<in> \<complex> \<longrightarrow> ( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( B \<ca> ( A \<cs> C ) ) = ( ( A \<cs> C ) \<ca> B ) )" by (rule MMI_syl5)
   from S9 have S10: "B \<in> \<complex> \<longrightarrow> ( A \<in> \<complex> \<longrightarrow> ( C \<in> \<complex> \<longrightarrow> 
     ( B \<ca> ( A \<cs> C ) ) = ( ( A \<cs> C ) \<ca> B ) ) )" 
     by (rule MMI_exp3a)
   from S10 have S11: "A \<in> \<complex> \<longrightarrow> ( B \<in> \<complex> \<longrightarrow> ( C \<in> \<complex> \<longrightarrow> 
     ( B \<ca> ( A \<cs> C ) ) = ( ( A \<cs> C ) \<ca> B ) ) )" 
     by (rule MMI_com12)
   from S11 have S12: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( B \<ca> ( A \<cs> C ) ) = ( ( A \<cs> C ) \<ca> B )" by (rule MMI_3imp)
   from S3 S5 S12 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> C ) = ( ( A \<cs> C ) \<ca> B )" by (rule MMI_3eqtrd)
qed;

(******** 54-63**************************************)

lemma (in MMIsar0) MMI_addsub12t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<cs> C ) ) = 
  ( B \<ca> ( A \<cs> C ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) = ( B \<ca> A )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
     ( ( B \<ca> A ) \<cs> C )" by (rule MMI_opreq1d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> C ) = ( ( B \<ca> A ) \<cs> C )" 
     by (rule MMI_3adant3)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
     ( A \<ca> ( B \<cs> C ) )" by (rule MMI_addsubasst)
   have S5: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( B \<ca> A ) \<cs> C ) = 
     ( B \<ca> ( A \<cs> C ) )" by (rule MMI_addsubasst)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<ca> A ) \<cs> C ) = ( B \<ca> ( A \<cs> C ) )" by (rule MMI_3com12)
   from S3 S4 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( B \<cs> C ) ) = ( B \<ca> ( A \<cs> C ) )" 
     by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_addsubass: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<cs> C ) = ( A \<ca> ( B \<cs> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
     ( A \<ca> ( B \<cs> C ) )" by (rule MMI_addsubasst)
   from S1 S2 S3 S4 show "( ( A \<ca> B ) \<cs> C ) = 
     ( A \<ca> ( B \<cs> C ) )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_addsub: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<cs> C ) = ( ( A \<cs> C ) \<ca> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> C ) = 
     ( ( A \<cs> C ) \<ca> B )" by (rule MMI_addsubt)
   from S1 S2 S3 S4 show "( ( A \<ca> B ) \<cs> C ) = 
     ( ( A \<cs> C ) \<ca> B )" by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_2addsubt: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
  ( ( ( A \<ca> B ) \<ca> C ) \<cs> D ) = ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<ca> C ) = 
     ( ( A \<ca> C ) \<ca> B )" by (rule MMI_add23t)
   from S1 have S2: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )" by (rule MMI_3expa)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<ca> C ) = ( ( A \<ca> C ) \<ca> B )" 
     by (rule MMI_adantrr)
   from S3 have S4: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<ca> B ) \<cs> D )" by (rule MMI_opreq1d)
   have S5: "( ( A \<ca> C ) \<in> \<complex> \<and> B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )" by (rule MMI_addsubt)
   from S5 have S6: "( ( A \<ca> C ) \<in> \<complex> \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )" by (rule MMI_3expb)
   have S7: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> C ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S6 S7 have S8: "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )" by (rule MMI_sylan)
   from S8 have S9: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> C ) \<ca> B ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )" by (rule MMI_an4s)
   from S4 S9 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<ca> C ) \<cs> D ) = 
     ( ( ( A \<ca> C ) \<cs> D ) \<ca> B )" by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_negneg: assumes A1: "A \<in> \<complex>"   
   shows "( \<cn> ( \<cn> A ) ) = A"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from S1 have S2: "( \<cn> A ) \<in> \<complex>" by (rule MMI_negcl)
   from S2 have S3: "( ( \<cn> A ) \<ca> ( \<cn> ( \<cn> A ) ) ) = \<zero>" 
     by (rule MMI_negid)
   from S3 have S4: "( A \<ca> ( ( \<cn> A ) \<ca> ( \<cn> ( \<cn> A ) ) ) ) = 
     ( A \<ca> \<zero> )" by (rule MMI_opreq2i)
   from A1 have S5: "A \<in> \<complex>".
   from S5 have S6: "( A \<ca> ( \<cn> A ) ) = \<zero>" by (rule MMI_negid)
   from S6 have S7: "( ( A \<ca> ( \<cn> A ) ) \<ca> ( \<cn> ( \<cn> A ) ) ) = 
     ( \<zero> \<ca> ( \<cn> ( \<cn> A ) ) )" by (rule MMI_opreq1i)
   from A1 have S8: "A \<in> \<complex>".
   from S2 have S9: "( \<cn> A ) \<in> \<complex>" .
   from S2 have S10: "( \<cn> A ) \<in> \<complex>" .
   from S10 have S11: "( \<cn> ( \<cn> A ) ) \<in> \<complex>" by (rule MMI_negcl)
   from S8 S9 S11 have S12: 
     "( ( A \<ca> ( \<cn> A ) ) \<ca> ( \<cn> ( \<cn> A ) ) ) = 
     ( A \<ca> ( ( \<cn> A ) \<ca> ( \<cn> ( \<cn> A ) ) ) )" 
     by (rule MMI_addass)
   from S11 have S13: "( \<cn> ( \<cn> A ) ) \<in> \<complex>" .
   from S13 have S14: "( \<zero> \<ca> ( \<cn> ( \<cn> A ) ) ) = 
     ( \<cn> ( \<cn> A ) )" by (rule MMI_addid2)
   from S7 S12 S14 have S15: 
     "( A \<ca> ( ( \<cn> A ) \<ca> ( \<cn> ( \<cn> A ) ) ) ) = 
     ( \<cn> ( \<cn> A ) )" by (rule MMI_3eqtr3)
   from A1 have S16: "A \<in> \<complex>".
   from S16 have S17: "( A \<ca> \<zero> ) = A" by (rule MMI_addid1)
   from S4 S15 S17 show "( \<cn> ( \<cn> A ) ) = A" by (rule MMI_3eqtr3)
qed

lemma (in MMIsar0) MMI_subid: assumes A1: "A \<in> \<complex>"   
   shows "( A \<cs> A ) = \<zero>"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A1 have S2: "A \<in> \<complex>".
   from S1 S2 have S3: "( A \<ca> ( \<cn> A ) ) = ( A \<cs> A )" 
     by (rule MMI_negsub)
   from A1 have S4: "A \<in> \<complex>".
   from S4 have S5: "( A \<ca> ( \<cn> A ) ) = \<zero>" by (rule MMI_negid)
   from S3 S5 show "( A \<cs> A ) = \<zero>" by (rule MMI_eqtr3)
qed

lemma (in MMIsar0) MMI_subid1: assumes A1: "A \<in> \<complex>"   
   shows "( A \<cs> \<zero> ) = A"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from S1 have S2: "( \<zero> \<ca> A ) = A" by (rule MMI_addid2)
   from A1 have S3: "A \<in> \<complex>".
   have S4: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from A1 have S5: "A \<in> \<complex>".
   from S3 S4 S5 have S6: "( A \<cs> \<zero> ) = A \<longleftrightarrow> ( \<zero> \<ca> A ) = A" 
     by (rule MMI_subadd)
   from S2 S6 show "( A \<cs> \<zero> ) = A" by (rule MMI_mpbir)
qed

lemma (in MMIsar0) MMI_negnegt: 
   shows "A \<in> \<complex> \<longrightarrow> ( \<cn> ( \<cn> A ) ) = A"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( \<cn> A ) = 
     ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) )" by (rule MMI_negeq)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( \<cn> ( \<cn> A ) ) = 
     ( \<cn> ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) )" by (rule MMI_negeqd)
   have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> A = if ( A \<in> \<complex> , A , \<zero> )" 
     by (rule MMI_id)
   from S2 S3 have S4: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( \<cn> ( \<cn> A ) ) = A \<longleftrightarrow> 
     ( \<cn> ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) ) = if ( A \<in> \<complex> , A , \<zero> ) )" 
     by (rule MMI_eqeq12d)
   have S5: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S5 have S6: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S6 have S7: "( \<cn> ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) ) = 
     if ( A \<in> \<complex> , A , \<zero> )" by (rule MMI_negneg)
   from S4 S7 show "A \<in> \<complex> \<longrightarrow> ( \<cn> ( \<cn> A ) ) = A" by (rule MMI_dedth)
qed

lemma (in MMIsar0) MMI_subnegt: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> ( \<cn> B ) ) = ( A \<ca> B )"
proof -
   have S1: "( A \<in> \<complex> \<and> ( \<cn> B ) \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> ( \<cn> B ) ) ) = ( A \<cs> ( \<cn> B ) )" 
     by (rule MMI_negsubt)
   have S2: "B \<in> \<complex> \<longrightarrow> ( \<cn> B ) \<in> \<complex>" by (rule MMI_negclt)
   from S1 S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> ( \<cn> B ) ) ) = ( A \<cs> ( \<cn> B ) )" 
     by (rule MMI_sylan2)
   have S4: "B \<in> \<complex> \<longrightarrow> ( \<cn> ( \<cn> B ) ) = B" by (rule MMI_negnegt)
   from S4 have S5: "B \<in> \<complex> \<longrightarrow> ( A \<ca> ( \<cn> ( \<cn> B ) ) ) = 
     ( A \<ca> B )" by (rule MMI_opreq2d)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> ( \<cn> B ) ) ) = ( A \<ca> B )" by (rule MMI_adantl)
   from S3 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> ( \<cn> B ) ) = 
     ( A \<ca> B )" by (rule MMI_eqtr3d)
qed

lemma (in MMIsar0) MMI_subidt: 
   shows "A \<in> \<complex> \<longrightarrow> ( A \<cs> A ) = \<zero>"
proof -
   have S1: "( A = if ( A \<in> \<complex> , A , \<zero> ) \<and> A = if ( A \<in> \<complex> , A , \<zero> ) ) \<longrightarrow> 
     ( A \<cs> A ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( A \<in> \<complex> , A , \<zero> ) )" 
     by (rule MMI_opreq12)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( A \<cs> A ) = ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( A \<in> \<complex> , A , \<zero> ) )" 
     by (rule MMI_anidms)
   from S2 have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( A \<cs> A ) = \<zero> \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( A \<in> \<complex> , A , \<zero> ) ) = \<zero> )" 
     by (rule MMI_eqeq1d)
   have S4: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S4 have S5: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S5 have S6: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( A \<in> \<complex> , A , \<zero> ) ) = \<zero>" 
     by (rule MMI_subid)
   from S3 S6 show "A \<in> \<complex> \<longrightarrow> ( A \<cs> A ) = \<zero>" by (rule MMI_dedth)
qed;

(************** 64-73 *************************************)
lemma (in MMIsar0) MMI_subid1t: 
   shows "A \<in> \<complex> \<longrightarrow> ( A \<cs> \<zero> ) = A"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<cs> \<zero> ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> \<zero> )" by (rule MMI_opreq1)
   have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     A = if ( A \<in> \<complex> , A , \<zero> )" by (rule MMI_id)
   from S1 S2 have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( A \<cs> \<zero> ) = A \<longleftrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> \<zero> ) = 
     if ( A \<in> \<complex> , A , \<zero> ) )" by (rule MMI_eqeq12d)
   have S4: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S4 have S5: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S5 have S6: "( if ( A \<in> \<complex> , A , \<zero> ) \<cs> \<zero> ) = 
     if ( A \<in> \<complex> , A , \<zero> )" by (rule MMI_subid1)
   from S3 S6 show "A \<in> \<complex> \<longrightarrow> ( A \<cs> \<zero> ) = A" by (rule MMI_dedth)
qed

lemma (in MMIsar0) MMI_pncant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> B ) = A"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> B ) = 
     ( A \<ca> ( B \<cs> B ) )" by (rule MMI_addsubasst)
   from S1 have S2: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> B ) = ( A \<ca> ( B \<cs> B ) )" by (rule MMI_3expb)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> B ) = 
     ( A \<ca> ( B \<cs> B ) )" by (rule MMI_anabsan2)
   have S4: "B \<in> \<complex> \<longrightarrow> ( B \<cs> B ) = \<zero>" by (rule MMI_subidt)
   from S4 have S5: "B \<in> \<complex> \<longrightarrow> ( A \<ca> ( B \<cs> B ) ) = ( A \<ca> \<zero> )" 
     by (rule MMI_opreq2d)
   have S6: "A \<in> \<complex> \<longrightarrow> ( A \<ca> \<zero> ) = A" by (rule MMI_ax0id)
   from S5 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( B \<cs> B ) ) = A" 
     by (rule MMI_sylan9eqr)
   from S3 S7 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> B ) = A" 
     by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_pncan2t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> A ) = B"
proof -
   have S1: "( B \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( B \<ca> A ) = ( A \<ca> B )" 
     by (rule MMI_axaddcom)
   from S1 have S2: "( B \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( ( B \<ca> A ) \<cs> A ) = 
     ( ( A \<ca> B ) \<cs> A )" by (rule MMI_opreq1d)
   have S3: "( B \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( ( B \<ca> A ) \<cs> A ) = B" 
     by (rule MMI_pncant)
   from S2 S3 have S4: "( B \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> A ) = B" by (rule MMI_eqtr3d)
   from S4 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> A ) = B" 
     by (rule MMI_ancoms)
qed

lemma (in MMIsar0) MMI_npcant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) \<ca> B ) = A"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> B ) = ( ( A \<cs> B ) \<ca> B )" 
     by (rule MMI_addsubt)
   from S1 have S2: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> B ) = ( ( A \<cs> B ) \<ca> B )" by (rule MMI_3expb)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cs> B ) = ( ( A \<cs> B ) \<ca> B )" 
     by (rule MMI_anabsan2)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<ca> B ) \<cs> B ) = A" 
     by (rule MMI_pncant)
   from S3 S4 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) \<ca> B ) = A" 
     by (rule MMI_eqtr3d)
qed

lemma (in MMIsar0) MMI_npncant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
  ( ( A \<cs> B ) \<ca> ( B \<cs> C ) ) = ( A \<cs> C )"
proof -
   have S1: "( ( A \<cs> B ) \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<cs> C ) = 
     ( ( A \<cs> B ) \<ca> ( B \<cs> C ) )" by (rule MMI_addsubasst)
   have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> B ) \<in> \<complex>" by (rule MMI_subclt)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<cs> B ) \<in> \<complex>" by (rule MMI_3adant3)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_3simp2)
   have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> C \<in> \<complex>" by (rule MMI_3simp3)
   from S1 S3 S4 S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<cs> C ) = 
     ( ( A \<cs> B ) \<ca> ( B \<cs> C ) )" by (rule MMI_syl3anc)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) \<ca> B ) = A" 
     by (rule MMI_npcant)
   from S7 have S8: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<cs> C ) = ( A \<cs> C )" 
     by (rule MMI_opreq1d)
   from S8 have S9: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<cs> C ) = ( A \<cs> C )" 
     by (rule MMI_3adant3)
   from S6 S9 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> B ) \<ca> ( B \<cs> C ) ) = ( A \<cs> C )" 
     by (rule MMI_eqtr3d)
qed

lemma (in MMIsar0) MMI_nppcant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
  ( ( ( A \<cs> B ) \<ca> C ) \<ca> B ) = ( A \<ca> C )"
proof -
   have S1: "( ( A \<cs> B ) \<in> \<complex> \<and> C \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> C ) \<ca> B ) = 
     ( ( ( A \<cs> B ) \<ca> B ) \<ca> C )" by (rule MMI_add23t)
   have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> B ) \<in> \<complex>" by (rule MMI_subclt)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cs> B ) \<in> \<complex>" 
     by (rule MMI_3adant3)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> C \<in> \<complex>" by (rule MMI_3simp3)
   have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_3simp2)
   from S1 S3 S4 S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> C ) \<ca> B ) = 
     ( ( ( A \<cs> B ) \<ca> B ) \<ca> C )" by (rule MMI_syl3anc)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) \<ca> B ) = A" 
     by (rule MMI_npcant)
   from S7 have S8: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<ca> C ) = ( A \<ca> C )" 
     by (rule MMI_opreq1d)
   from S8 have S9: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> B ) \<ca> C ) = ( A \<ca> C )" 
     by (rule MMI_3adant3)
   from S6 S9 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) \<ca> C ) \<ca> B ) = ( A \<ca> C )" by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_subneg: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<cs> ( \<cn> B ) ) = ( A \<ca> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cs> ( \<cn> B ) ) = ( A \<ca> B )" 
     by (rule MMI_subnegt)
   from S1 S2 S3 show "( A \<cs> ( \<cn> B ) ) = ( A \<ca> B )" 
     by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_subeq0: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" 
     by (rule MMI_negsub)
   from S3 have S4: "( A \<ca> ( \<cn> B ) ) = \<zero> \<longleftrightarrow> ( A \<cs> B ) = \<zero>" 
     by (rule MMI_eqeq1i)
   have S5: "( A \<ca> ( \<cn> B ) ) = \<zero> \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = ( \<zero> \<ca> B )" by (rule MMI_opreq1)
   from S4 S5 have S6: "( A \<cs> B ) = \<zero> \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = ( \<zero> \<ca> B )" by (rule MMI_sylbir)
   from A1 have S7: "A \<in> \<complex>".
   from A2 have S8: "B \<in> \<complex>".
   from S8 have S9: "( \<cn> B ) \<in> \<complex>" by (rule MMI_negcl)
   from A2 have S10: "B \<in> \<complex>".
   from S7 S9 S10 have S11: "( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = 
     ( ( A \<ca> B ) \<ca> ( \<cn> B ) )" by (rule MMI_add23)
   from A1 have S12: "A \<in> \<complex>".
   from A2 have S13: "B \<in> \<complex>".
   from S9 have S14: "( \<cn> B ) \<in> \<complex>" .
   from S12 S13 S14 have S15: "( ( A \<ca> B ) \<ca> ( \<cn> B ) ) = 
     ( A \<ca> ( B \<ca> ( \<cn> B ) ) )" by (rule MMI_addass)
   from A2 have S16: "B \<in> \<complex>".
   from S16 have S17: "( B \<ca> ( \<cn> B ) ) = \<zero>" by (rule MMI_negid)
   from S17 have S18: "( A \<ca> ( B \<ca> ( \<cn> B ) ) ) = ( A \<ca> \<zero> )" 
     by (rule MMI_opreq2i)
   from A1 have S19: "A \<in> \<complex>".
   from S19 have S20: "( A \<ca> \<zero> ) = A" by (rule MMI_addid1)
   from S18 S20 have S21: "( A \<ca> ( B \<ca> ( \<cn> B ) ) ) = A" 
     by (rule MMI_eqtr)
   from S11 S15 S21 have S22: "( ( A \<ca> ( \<cn> B ) ) \<ca> B ) = A" 
     by (rule MMI_3eqtr)
   from A2 have S23: "B \<in> \<complex>".
   from S23 have S24: "( \<zero> \<ca> B ) = B" by (rule MMI_addid2)
   from S6 S22 S24 have S25: "( A \<cs> B ) = \<zero> \<longrightarrow> A = B" 
     by (rule MMI_3eqtr3g)
   have S26: "A = B \<longrightarrow> ( A \<cs> B ) = ( B \<cs> B )" by (rule MMI_opreq1)
   from A2 have S27: "B \<in> \<complex>".
   from S27 have S28: "( B \<cs> B ) = \<zero>" by (rule MMI_subid)
   from S26 S28 have S29: "A = B \<longrightarrow> ( A \<cs> B ) = \<zero>" by (rule MMI_syl6eq)
   from S25 S29 show "( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B" by (rule MMI_impbi)
qed

lemma (in MMIsar0) MMI_neg11: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( \<cn> A ) = ( \<cn> B ) \<longleftrightarrow> A = B"
proof -
   have S1: "( \<cn> A ) = ( \<zero> \<cs> A )" by (rule MMI_df_neg)
   have S2: "( \<cn> B ) = ( \<zero> \<cs> B )" by (rule MMI_df_neg)
   from S1 S2 have S3: "( \<cn> A ) = ( \<cn> B ) \<longleftrightarrow> ( \<zero> \<cs> A ) = 
     ( \<zero> \<cs> B )" by (rule MMI_eqeq12i)
   have S4: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from A1 have S5: "A \<in> \<complex>".
   have S6: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from A2 have S7: "B \<in> \<complex>".
   from S6 S7 have S8: "( \<zero> \<cs> B ) \<in> \<complex>" by (rule MMI_subcl)
   from S4 S5 S8 have S9: "( \<zero> \<cs> A ) = ( \<zero> \<cs> B ) \<longleftrightarrow> 
     ( A \<ca> ( \<zero> \<cs> B ) ) = \<zero>" by (rule MMI_subadd)
   from S2 have S10: "( \<cn> B ) = ( \<zero> \<cs> B )" .
   from S10 have S11: "( A \<ca> ( \<cn> B ) ) = ( A \<ca> ( \<zero> \<cs> B ) )" 
     by (rule MMI_opreq2i)
   from A1 have S12: "A \<in> \<complex>".
   from A2 have S13: "B \<in> \<complex>".
   from S12 S13 have S14: "( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" 
     by (rule MMI_negsub)
   from S11 S14 have S15: "( A \<ca> ( \<zero> \<cs> B ) ) = ( A \<cs> B )" 
     by (rule MMI_eqtr3)
   from S15 have S16: "( A \<ca> ( \<zero> \<cs> B ) ) = \<zero> \<longleftrightarrow> ( A \<cs> B ) = \<zero>" 
     by (rule MMI_eqeq1i)
   from A1 have S17: "A \<in> \<complex>".
   from A2 have S18: "B \<in> \<complex>".
   from S17 S18 have S19: "( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B" by (rule MMI_subeq0)
   from S16 S19 have S20: "( A \<ca> ( \<zero> \<cs> B ) ) = \<zero> \<longleftrightarrow> A = B" 
     by (rule MMI_bitr)
   from S3 S9 S20 show "( \<cn> A ) = ( \<cn> B ) \<longleftrightarrow> A = B" by (rule MMI_3bitr)
qed;

(*********** 75-84****************************************)

lemma (in MMIsar0) MMI_negcon1: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( \<cn> A ) = B \<longleftrightarrow> ( \<cn> B ) = A"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from S1 have S2: "( \<cn> ( \<cn> A ) ) = A" by (rule MMI_negneg)
   from S2 have S3: "( \<cn> ( \<cn> A ) ) = ( \<cn> B ) \<longleftrightarrow> A = ( \<cn> B )" 
     by (rule MMI_eqeq1i)
   from A1 have S4: "A \<in> \<complex>".
   from S4 have S5: "( \<cn> A ) \<in> \<complex>" by (rule MMI_negcl)
   from A2 have S6: "B \<in> \<complex>".
   from S5 S6 have S7: "( \<cn> ( \<cn> A ) ) = 
     ( \<cn> B ) \<longleftrightarrow> ( \<cn> A ) = B" by (rule MMI_neg11)
   have S8: "A = ( \<cn> B ) \<longleftrightarrow> ( \<cn> B ) = A" by (rule MMI_eqcom)
   from S3 S7 S8 show "( \<cn> A ) = B \<longleftrightarrow> ( \<cn> B ) = A" by (rule MMI_3bitr3)
qed

lemma (in MMIsar0) MMI_negcon2: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "A = ( \<cn> B ) \<longleftrightarrow> B = ( \<cn> A )"
proof -
   from A2 have S1: "B \<in> \<complex>".
   from A1 have S2: "A \<in> \<complex>".
   from S1 S2 have S3: "( \<cn> B ) = A \<longleftrightarrow> ( \<cn> A ) = B" 
     by (rule MMI_negcon1)
   have S4: "A = ( \<cn> B ) \<longleftrightarrow> ( \<cn> B ) = A" by (rule MMI_eqcom)
   have S5: "B = ( \<cn> A ) \<longleftrightarrow> ( \<cn> A ) = B" by (rule MMI_eqcom)
   from S3 S4 S5 show "A = ( \<cn> B ) \<longleftrightarrow> B = ( \<cn> A )" by (rule MMI_3bitr4)
qed

lemma (in MMIsar0) MMI_neg11t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = ( \<cn> B ) \<longleftrightarrow> A = B )"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( \<cn> A ) = 
     ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) )" by (rule MMI_negeq)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( ( \<cn> A ) = 
     ( \<cn> B ) \<longleftrightarrow> ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = ( \<cn> B ) )" 
     by (rule MMI_eqeq1d)
   have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A = B \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B )" by (rule MMI_eqeq1)
   from S2 S3 have S4: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( ( \<cn> A ) = ( \<cn> B ) \<longleftrightarrow> A = B ) \<longleftrightarrow> 
     ( ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = ( \<cn> B ) \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B ) )" by (rule MMI_bibi12d)
   have S5: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( \<cn> B ) = 
     ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_negeq)
   from S5 have S6: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = ( \<cn> B ) \<longleftrightarrow> 
     ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) )" 
     by (rule MMI_eqeq2d)
   have S7: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) = B \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_eqeq2)
   from S6 S7 have S8: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = ( \<cn> B ) \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B ) \<longleftrightarrow> ( ( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = 
     ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) \<longleftrightarrow> if ( A \<in> \<complex> , A , \<zero> ) = 
     if ( B \<in> \<complex> , B , \<zero> ) ) )" by (rule MMI_bibi12d)
   have S9: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S9 have S10: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S11: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S11 have S12: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S10 S12 have S13: "( \<cn> if ( A \<in> \<complex> , A , \<zero> ) ) = 
     ( \<cn> if ( B \<in> \<complex> , B , \<zero> ) ) \<longleftrightarrow> if ( A \<in> \<complex> , A , \<zero> ) = 
     if ( B \<in> \<complex> , B , \<zero> )" by (rule MMI_neg11)
   from S4 S8 S13 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = 
     ( \<cn> B ) \<longleftrightarrow> A = B )" by (rule MMI_dedth2h)
qed

lemma (in MMIsar0) MMI_negcon1t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = B \<longleftrightarrow> ( \<cn> B ) = A )"
proof -
   have S1: "( ( \<cn> A ) \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> ( \<cn> A ) ) = 
     ( \<cn> B ) \<longleftrightarrow> ( \<cn> A ) = B )" by (rule MMI_neg11t)
   have S2: "A \<in> \<complex> \<longrightarrow> ( \<cn> A ) \<in> \<complex>" by (rule MMI_negclt)
   from S1 S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> ( \<cn> A ) ) = 
     ( \<cn> B ) \<longleftrightarrow> ( \<cn> A ) = B )" by (rule MMI_sylan)
   have S4: "A \<in> \<complex> \<longrightarrow> ( \<cn> ( \<cn> A ) ) = A" by (rule MMI_negnegt)
   from S4 have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( \<cn> ( \<cn> A ) ) = A" 
     by (rule MMI_adantr)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> ( \<cn> A ) ) = 
     ( \<cn> B ) \<longleftrightarrow> A = ( \<cn> B ) )" by (rule MMI_eqeq1d)
   from S3 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = B \<longleftrightarrow> A = 
     ( \<cn> B ) )" by (rule MMI_bitr3d)
   have S8: "A = ( \<cn> B ) \<longleftrightarrow> ( \<cn> B ) = A" by (rule MMI_eqcom)
   from S7 S8 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = B \<longleftrightarrow> 
     ( \<cn> B ) = A )" by (rule MMI_syl6bb)
qed

lemma (in MMIsar0) MMI_negcon2t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A = ( \<cn> B ) \<longleftrightarrow> B = ( \<cn> A ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<cn> A ) = B \<longleftrightarrow> ( \<cn> B ) = A )" 
     by (rule MMI_negcon1t)
   have S2: "A = ( \<cn> B ) \<longleftrightarrow> ( \<cn> B ) = A" by (rule MMI_eqcom)
   from S1 S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A = ( \<cn> B ) \<longleftrightarrow> 
     ( \<cn> A ) = B )" by (rule MMI_syl6rbbrA);
   have S4: "( \<cn> A ) = B \<longleftrightarrow> B = ( \<cn> A )" by (rule MMI_eqcom)
   from S3 S4 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A = ( \<cn> B ) \<longleftrightarrow> B = 
     ( \<cn> A ) )" by (rule MMI_syl6bb)
qed

lemma (in MMIsar0) MMI_subcant: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) = 
  ( A \<cs> C ) \<longleftrightarrow> B = C )"
proof -
   have S1: "( A \<in> \<complex> \<and> ( \<cn> B ) \<in> \<complex> \<and> ( \<cn> C ) \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) = ( A \<ca> ( \<cn> C ) ) \<longleftrightarrow> 
     ( \<cn> B ) = ( \<cn> C ) )" by (rule MMI_addcant)
   have S2: "C \<in> \<complex> \<longrightarrow> ( \<cn> C ) \<in> \<complex>" by (rule MMI_negclt)
   from S1 S2 have S3: "( A \<in> \<complex> \<and> ( \<cn> B ) \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) = ( A \<ca> ( \<cn> C ) ) \<longleftrightarrow> 
     ( \<cn> B ) = ( \<cn> C ) )" by (rule MMI_syl3an3)
   have S4: "B \<in> \<complex> \<longrightarrow> ( \<cn> B ) \<in> \<complex>" by (rule MMI_negclt)
   from S3 S4 have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) = ( A \<ca> ( \<cn> C ) ) \<longleftrightarrow> 
     ( \<cn> B ) = ( \<cn> C ) )" by (rule MMI_syl3an2)
   have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" 
     by (rule MMI_negsubt)
   from S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" by (rule MMI_3adant3)
   have S8: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> C ) ) = ( A \<cs> C )" 
     by (rule MMI_negsubt)
   from S8 have S9: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> C ) ) = ( A \<cs> C )" by (rule MMI_3adant2)
   from S7 S9 have S10: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> B ) ) = ( A \<ca> ( \<cn> C ) ) \<longleftrightarrow> 
     ( A \<cs> B ) = ( A \<cs> C ) )" by (rule MMI_eqeq12d)
   have S11: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( \<cn> B ) = ( \<cn> C ) \<longleftrightarrow> B = C )" 
     by (rule MMI_neg11t)
   from S11 have S12: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( \<cn> B ) = ( \<cn> C ) \<longleftrightarrow> B = C )" by (rule MMI_3adant1)
   from S5 S10 S12 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> B ) = ( A \<cs> C ) \<longleftrightarrow> B = C )" by (rule MMI_3bitr3d)
qed

lemma (in MMIsar0) MMI_subcan2t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
  ( ( A \<cs> C ) = ( B \<cs> C ) \<longleftrightarrow> A = B )"
proof -
   have S1: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> C ) ) = ( A \<cs> C )" 
     by (rule MMI_negsubt)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<ca> ( \<cn> C ) ) = ( A \<cs> C )" by (rule MMI_3adant2)
   have S3: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<ca> ( \<cn> C ) ) = ( B \<cs> C )" 
     by (rule MMI_negsubt)
   from S3 have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( B \<ca> ( \<cn> C ) ) = ( B \<cs> C )" by (rule MMI_3adant1)
   from S2 S4 have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> C ) ) = ( B \<ca> ( \<cn> C ) ) \<longleftrightarrow> ( A \<cs> C ) = 
     ( B \<cs> C ) )" by (rule MMI_eqeq12d)
   have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> ( \<cn> C ) \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> C ) ) = ( B \<ca> ( \<cn> C ) ) \<longleftrightarrow> A = B )" 
     by (rule MMI_addcan2t)
   have S7: "C \<in> \<complex> \<longrightarrow> ( \<cn> C ) \<in> \<complex>" by (rule MMI_negclt)
   from S6 S7 have S8: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> ( \<cn> C ) ) = ( B \<ca> ( \<cn> C ) ) \<longleftrightarrow> A = B )" 
     by (rule MMI_syl3an3)
   from S5 S8 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> C ) = ( B \<cs> C ) \<longleftrightarrow> A = B )" by (rule MMI_bitr3d)
qed

lemma (in MMIsar0) MMI_subcan: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cs> B ) = ( A \<cs> C ) \<longleftrightarrow> B = C"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) = ( A \<cs> C ) \<longleftrightarrow> B = C )" by (rule MMI_subcant)
   from S1 S2 S3 S4 show "( A \<cs> B ) = ( A \<cs> C ) \<longleftrightarrow> B = C" 
     by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_subcan2: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cs> C ) = ( B \<cs> C ) \<longleftrightarrow> A = B"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> C ) = ( B \<cs> C ) \<longleftrightarrow> A = B )" by (rule MMI_subcan2t)
   from S1 S2 S3 S4 show "( A \<cs> C ) = ( B \<cs> C ) \<longleftrightarrow> A = B" 
     by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_subeq0t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B )"
proof -
   have S1: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B )" by (rule MMI_opreq1)
   from S1 have S2: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( ( A \<cs> B ) = \<zero> \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = \<zero> )" by (rule MMI_eqeq1d)
   have S3: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> ( A = B \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B )" by (rule MMI_eqeq1)
   from S2 S3 have S4: "A = if ( A \<in> \<complex> , A , \<zero> ) \<longrightarrow> 
     ( ( ( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = \<zero> \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B ) )" by (rule MMI_bibi12d)
   have S5: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) )" 
     by (rule MMI_opreq2)
   from S5 have S6: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = \<zero> \<longleftrightarrow> 
     ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = \<zero> )" 
     by (rule MMI_eqeq1d)
   have S7: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> ( if ( A \<in> \<complex> , A , \<zero> ) = B \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = if ( B \<in> \<complex> , B , \<zero> ) )" by (rule MMI_eqeq2)
   from S6 S7 have S8: "B = if ( B \<in> \<complex> , B , \<zero> ) \<longrightarrow> 
     ( ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> B ) = \<zero> \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = B ) \<longleftrightarrow> 
     ( ( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = \<zero> \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = if ( B \<in> \<complex> , B , \<zero> ) ) )" 
     by (rule MMI_bibi12d)
   have S9: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S9 have S10: "if ( A \<in> \<complex> , A , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   have S11: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S11 have S12: "if ( B \<in> \<complex> , B , \<zero> ) \<in> \<complex>" by (rule MMI_elimel)
   from S10 S12 have S13: 
     "( if ( A \<in> \<complex> , A , \<zero> ) \<cs> if ( B \<in> \<complex> , B , \<zero> ) ) = \<zero> \<longleftrightarrow> 
     if ( A \<in> \<complex> , A , \<zero> ) = if ( B \<in> \<complex> , B , \<zero> )" 
     by (rule MMI_subeq0)
   from S4 S8 S13 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cs> B ) = \<zero> \<longleftrightarrow> A = B )" by (rule MMI_dedth2h)
qed;

(*******************85-90*******************************)

lemma (in MMIsar0) MMI_neg0: 
   shows "( \<cn> \<zero> ) = \<zero>"
proof -
   have S1: "( \<cn> \<zero> ) = ( \<zero> \<cs> \<zero> )" by (rule MMI_df_neg)
   have S2: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
   from S2 have S3: "( \<zero> \<cs> \<zero> ) = \<zero>" by (rule MMI_subid)
   from S1 S3 show "( \<cn> \<zero> ) = \<zero>" by (rule MMI_eqtr)
qed

lemma (in MMIsar0) MMI_renegcl: assumes A1: "A \<in> \<real>"   
   shows "( \<cn> A ) \<in> \<real>"
proof -
   from A1 have S1: "A \<in> \<real>".
   have S2: "A \<in> \<real> \<longrightarrow> ( \<exists> x \<in> \<real> . ( A \<ca> x ) = \<zero> )" by (rule MMI_axrnegex)
   from S1 S2 have S3: "\<exists> x \<in> \<real> . ( A \<ca> x ) = \<zero>" by (rule MMI_ax_mp)
   have S4: "( \<exists> x \<in> \<real> . ( A \<ca> x ) = \<zero> ) \<longleftrightarrow> 
     ( \<exists> x . ( x \<in> \<real> \<and> ( A \<ca> x ) = \<zero> ) )" by (rule MMI_df_rex);
   from S3 S4 have S5: "\<exists> x . ( x \<in> \<real> \<and> ( A \<ca> x ) = \<zero> )" 
     by (rule MMI_mpbi)
   { fix x
     have S6: "x \<in> \<real> \<longrightarrow> x \<in> \<complex>" by (rule MMI_recnt)
     have S7: "\<zero> \<in> \<complex>" by (rule MMI_0cn)
     from A1 have S8: "A \<in> \<real>".
     from S8 have S9: "A \<in> \<complex>" by (rule MMI_recn)
     have S10: "( \<zero> \<in> \<complex> \<and> A \<in> \<complex> \<and> x \<in> \<complex> ) \<longrightarrow> ( ( \<zero> \<cs> A ) = x \<longleftrightarrow> 
       ( A \<ca> x ) = \<zero> )" by (rule MMI_subaddt)
     from S7 S9 S10 have S11: "x \<in> \<complex> \<longrightarrow> ( ( \<zero> \<cs> A ) = x \<longleftrightarrow> 
       ( A \<ca> x ) = \<zero> )" by (rule MMI_mp3an12)
     from S6 S11 have S12: "x \<in> \<real> \<longrightarrow> ( ( \<zero> \<cs> A ) = x \<longleftrightarrow> 
       ( A \<ca> x ) = \<zero> )" by (rule MMI_syl)
     have S13: "( \<cn> A ) = ( \<zero> \<cs> A )" by (rule MMI_df_neg)
     from S13 have S14: "( \<cn> A ) = x \<longleftrightarrow> ( \<zero> \<cs> A ) = x" 
       by (rule MMI_eqeq1i)
     from S12 S14 have S15: "x \<in> \<real> \<longrightarrow> ( ( \<cn> A ) = x \<longleftrightarrow> 
       ( A \<ca> x ) = \<zero> )" by (rule MMI_syl5bb)
     have S16: "x \<in> \<real> \<longrightarrow> ( ( \<cn> A ) = x \<longrightarrow> ( \<cn> A ) \<in> \<real> )" 
       by (rule MMI_eleq1a)
     from S15 S16 have S17: "x \<in> \<real> \<longrightarrow> ( ( A \<ca> x ) = \<zero> \<longrightarrow> 
       ( \<cn> A ) \<in> \<real> )" by (rule MMI_sylbird)
     from S17 have "( x \<in> \<real> \<and> ( A \<ca> x ) = \<zero> ) \<longrightarrow> ( \<cn> A ) \<in> \<real>" 
       by (rule MMI_imp)
     } then have S18: 
	 "\<forall>x . ( x \<in> \<real> \<and> ( A \<ca> x ) = \<zero> ) \<longrightarrow> ( \<cn> A ) \<in> \<real>" 
       by auto;
   from S18 have S19: "( \<exists> x . ( x \<in> \<real> \<and> ( A \<ca> x ) = \<zero> ) ) \<longrightarrow> 
     ( \<cn> A ) \<in> \<real>" by (rule MMI_19_23aiv);
   from S5 S19 show "( \<cn> A ) \<in> \<real>" by (rule MMI_ax_mp)
qed;

lemma (in MMIsar0) MMI_renegclt: 
   shows "A \<in> \<real> \<longrightarrow> ( \<cn> A ) \<in> \<real>"
proof -
   have S1: "A = if ( A \<in> \<real> , A , \<one> ) \<longrightarrow> ( \<cn> A ) = 
     ( \<cn> if ( A \<in> \<real> , A , \<one> ) )" by (rule MMI_negeq)
   from S1 have S2: "A = if ( A \<in> \<real> , A , \<one> ) \<longrightarrow> ( ( \<cn> A ) \<in> \<real> \<longleftrightarrow> 
     ( \<cn> if ( A \<in> \<real> , A , \<one> ) ) \<in> \<real> )" by (rule MMI_eleq1d)
   have S3: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from S3 have S4: "if ( A \<in> \<real> , A , \<one> ) \<in> \<real>" by (rule MMI_elimel)
   from S4 have S5: "( \<cn> if ( A \<in> \<real> , A , \<one> ) ) \<in> \<real>" by (rule MMI_renegcl)
   from S2 S5 show "A \<in> \<real> \<longrightarrow> ( \<cn> A ) \<in> \<real>" by (rule MMI_dedth)
qed

lemma (in MMIsar0) MMI_resubclt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<cs> B ) \<in> \<real>"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = ( A \<cs> B )" 
     by (rule MMI_negsubt)
   have S2: "A \<in> \<real> \<longrightarrow> A \<in> \<complex>" by (rule MMI_recnt)
   have S3: "B \<in> \<real> \<longrightarrow> B \<in> \<complex>" by (rule MMI_recnt)
   from S1 S2 S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) = 
     ( A \<cs> B )" by (rule MMI_syl2an)
   have S5: "( A \<in> \<real> \<and> ( \<cn> B ) \<in> \<real> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) \<in> \<real>" 
     by (rule MMI_axaddrcl)
   have S6: "B \<in> \<real> \<longrightarrow> ( \<cn> B ) \<in> \<real>" by (rule MMI_renegclt)
   from S5 S6 have S7: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ca> ( \<cn> B ) ) \<in> \<real>" 
     by (rule MMI_sylan2)
   from S4 S7 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<cs> B ) \<in> \<real>" 
     by (rule MMI_eqeltrrd)
qed

lemma (in MMIsar0) MMI_resubcl: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "( A \<cs> B ) \<in> \<real>"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<cs> B ) \<in> \<real>" by (rule MMI_resubclt)
   from S1 S2 S3 show "( A \<cs> B ) \<in> \<real>" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_0re: 
   shows "\<zero> \<in> \<real>"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S1 have S2: "( \<one> \<cs> \<one> ) = \<zero>" by (rule MMI_subid)
   have S3: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   have S4: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from S3 S4 have S5: "( \<one> \<cs> \<one> ) \<in> \<real>" by (rule MMI_resubcl)
   from S2 S5 show "\<zero> \<in> \<real>" by (rule MMI_eqeltrr)
qed

(************** 91-95 ****************************************)

lemma (in MMIsar0) MMI_mulid2t: 
   shows "A \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> A ) = A"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S2: "( \<one> \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( \<one> \<cdot> A ) = ( A \<cdot> \<one> )" 
     by (rule MMI_axmulcom)
   from S1 S2 have S3: "A \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> A ) = ( A \<cdot> \<one> )" by (rule MMI_mpan)
   have S4: "A \<in> \<complex> \<longrightarrow> ( A \<cdot> \<one> ) = A" by (rule MMI_ax1id)
   from S3 S4 show "A \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> A ) = A" by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_mul12t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> ( B \<cdot> C ) ) = 
  ( B \<cdot> ( A \<cdot> C ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cdot> B ) = ( B \<cdot> A )" 
     by (rule MMI_axmulcom)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> C ) = ( ( B \<cdot> A ) \<cdot> C )" by (rule MMI_opreq1d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> C ) = ( ( B \<cdot> A ) \<cdot> C )" by (rule MMI_3adant3)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> C ) = ( A \<cdot> ( B \<cdot> C ) )" by (rule MMI_axmulass)
   have S5: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<cdot> A ) \<cdot> C ) = ( B \<cdot> ( A \<cdot> C ) )" by (rule MMI_axmulass)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( B \<cdot> A ) \<cdot> C ) = ( B \<cdot> ( A \<cdot> C ) )" by (rule MMI_3com12)
   from S3 S4 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( A \<cdot> ( B \<cdot> C ) ) = ( B \<cdot> ( A \<cdot> C ) )" by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_mul23t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cdot> B ) \<cdot> C ) = 
  ( ( A \<cdot> C ) \<cdot> B )"
proof -
   have S1: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) = ( C \<cdot> B )" 
     by (rule MMI_axmulcom)
   from S1 have S2: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> ( B \<cdot> C ) ) = 
     ( A \<cdot> ( C \<cdot> B ) )" by (rule MMI_opreq2d)
   from S2 have S3: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> ( B \<cdot> C ) ) = 
     ( A \<cdot> ( C \<cdot> B ) )" by (rule MMI_3adant1)
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cdot> B ) \<cdot> C ) = 
     ( A \<cdot> ( B \<cdot> C ) )" by (rule MMI_axmulass)
   have S5: "( A \<in> \<complex> \<and> C \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( A \<cdot> C ) \<cdot> B ) = 
     ( A \<cdot> ( C \<cdot> B ) )" by (rule MMI_axmulass)
   from S5 have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<cdot> B ) = ( A \<cdot> ( C \<cdot> B ) )" by (rule MMI_3com23)
   from S3 S4 S6 show "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<cdot> B )" by (rule MMI_3eqtr4d)
qed

lemma (in MMIsar0) MMI_mul4t: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
  ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<cdot> B )" by (rule MMI_mul23t)
   from S1 have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D )" 
     by (rule MMI_opreq1d)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D )" 
     by (rule MMI_3expa)
   from S3 have S4: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D )" 
     by (rule MMI_adantrr)
   have S5: "( ( A \<cdot> B ) \<in> \<complex> \<and> C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) )" 
     by (rule MMI_axmulass)
   from S5 have S6: "( ( A \<cdot> B ) \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) )" by (rule MMI_3expb)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<cdot> B ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S6 S7 have S8: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> B ) \<cdot> C ) \<cdot> D ) = ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) )" by (rule MMI_sylan)
   have S9: "( ( A \<cdot> C ) \<in> \<complex> \<and> B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_axmulass)
   from S9 have S10: "( ( A \<cdot> C ) \<in> \<complex> \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_3expb)
   have S11: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S10 S11 have S12: "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_sylan)
   from S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<cdot> B ) \<cdot> D ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_an4s)
   from S4 S8 S13 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_muladdt: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
  ( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
  ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )"
proof -
   have S1: "( ( A \<ca> B ) \<in> \<complex> \<and> C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
     ( ( ( A \<ca> B ) \<cdot> C ) \<ca> ( ( A \<ca> B ) \<cdot> D ) )" 
     by (rule MMI_axdistr)
   have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( A \<ca> B ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<ca> B ) \<in> \<complex>" by (rule MMI_adantr)
   have S4: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> C \<in> \<complex>" by (rule MMI_pm3_26)
   from S4 have S5: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> C \<in> \<complex>" 
     by (rule MMI_adantl)
   have S6: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> D \<in> \<complex>" by (rule MMI_pm3_27)
   from S6 have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> D \<in> \<complex>" 
     by (rule MMI_adantl)
   from S1 S3 S5 S7 have S8: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow>
     ( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
     ( ( ( A \<ca> B ) \<cdot> C ) \<ca> ( ( A \<ca> B ) \<cdot> D ) )" 
     by (rule MMI_syl3anc)
   have S9: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_adddirt)
   from S9 have S10: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> C \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_3expa)
   from S10 have S11: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_adantrr)
   have S12: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> D ) = ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) )" 
     by (rule MMI_adddirt)
   from S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> D ) = ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) )" 
     by (rule MMI_3expa)
   from S13 have S14: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> D ) = ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) )" 
     by (rule MMI_adantrl)
   from S11 S14 have S15: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<ca> B ) \<cdot> C ) \<ca> ( ( A \<ca> B ) \<cdot> D ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) )" 
     by (rule MMI_opreq12d)
   have S16: 
     "( ( A \<cdot> C ) \<in> \<complex> \<and> ( B \<cdot> C ) \<in> \<complex> \<and> 
     ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_add23t)
   have S17: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S17 have S18: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<cdot> C ) \<in> \<complex>" by (rule MMI_ad2ant2r)
   have S19: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S19 have S20: "( B \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantrr)
   from S20 have S21: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantll)
   have S22: "( ( A \<cdot> D ) \<in> \<complex> \<and> ( B \<cdot> D ) \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) \<in> \<complex>" by (rule MMI_axaddcl)
   have S23: "( A \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   have S24: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S22 S23 S24 have S25: 
     "( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) \<in> \<complex>" by (rule MMI_syl2an)
   from S25 have S26: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> D \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) \<in> \<complex>" by (rule MMI_anandirs)
   from S26 have S27: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) \<in> \<complex>" by (rule MMI_adantrl)
   from S16 S18 S21 S27 have S28: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) \<ca> ( B \<cdot> C ) )" 
     by (rule MMI_syl3anc)
   have S29: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<cdot> D ) = ( D \<cdot> B )" 
     by (rule MMI_axmulcom)
   from S29 have S30: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> D ) = ( D \<cdot> B )" by (rule MMI_ad2ant2l)
   from S30 have S31: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( B \<cdot> D ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( D \<cdot> B ) )" 
     by (rule MMI_opreq2d)
   have S32: "( ( A \<cdot> C ) \<in> \<complex> \<and> ( A \<cdot> D ) \<in> \<complex> \<and> ( B \<cdot> D ) \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( B \<cdot> D ) ) = 
     ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) )" 
     by (rule MMI_axaddass)
   from S18 have S33: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> ( A \<cdot> C ) \<in> \<complex>" .
   from S23 have S34: "( A \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( A \<cdot> D ) \<in> \<complex>" .
   from S34 have S35: "( A \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantrl)
   from S35 have S36: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantlr)
   from S24 have S37: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<cdot> D ) \<in> \<complex>" .
   from S37 have S38: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   from S32 S33 S36 S38 have S39: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( B \<cdot> D ) ) = 
     ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) )" by (rule MMI_syl3anc)
   have S40: "( ( A \<cdot> C ) \<in> \<complex> \<and> ( A \<cdot> D ) \<in> \<complex> \<and> ( D \<cdot> B ) \<in> \<complex> ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( D \<cdot> B ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) )" by (rule MMI_add23t)
   from S18 have S41: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> ( A \<cdot> C ) \<in> \<complex>" .
   from S36 have S42: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<cdot> D ) \<in> \<complex>" .
   have S43: "( D \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( D \<cdot> B ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S43 have S44: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<cdot> B ) \<in> \<complex>" 
     by (rule MMI_ancoms)
   from S44 have S45: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( D \<cdot> B ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   from S40 S41 S42 S45 have S46: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( A \<cdot> D ) ) \<ca> ( D \<cdot> B ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) )" by (rule MMI_syl3anc)
   from S31 S39 S46 have S47: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) )" by (rule MMI_3eqtr3d)
   have S48: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) = ( C \<cdot> B )" 
     by (rule MMI_axmulcom)
   from S48 have S49: "( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> C \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> C ) = ( C \<cdot> B )" by (rule MMI_adantl)
   from S49 have S50: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( B \<cdot> C ) = ( C \<cdot> B )" by (rule MMI_an42s)
   from S47 S50 have S51: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) \<ca> ( B \<cdot> C ) ) = 
     ( ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) ) \<ca> ( C \<cdot> B ) )" 
     by (rule MMI_opreq12d)
   have S52: 
     "( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<in> \<complex> \<and> ( A \<cdot> D ) \<in> \<complex> \<and> 
     ( C \<cdot> B ) \<in> \<complex> ) \<longrightarrow> 
     ( ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) ) \<ca> ( C \<cdot> B ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_axaddass)
   have S53: "( ( A \<cdot> C ) \<in> \<complex> \<and> ( D \<cdot> B ) \<in> \<complex> ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S17 have S54: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( A \<cdot> C ) \<in> \<complex>" .
   from S44 have S55: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<cdot> B ) \<in> \<complex>" .
   from S53 S54 S55 have S56: 
     "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<in> \<complex>" by (rule MMI_syl2an)
   from S56 have S57: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<in> \<complex>" by (rule MMI_an4s)
   from S36 have S58: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( A \<cdot> D ) \<in> \<complex>" .
   have S59: "( C \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( C \<cdot> B ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S59 have S60: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( C \<cdot> B ) \<in> \<complex>" 
     by (rule MMI_ancoms)
   from S60 have S61: "( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> C \<in> \<complex> ) ) \<longrightarrow> 
     ( C \<cdot> B ) \<in> \<complex>" by (rule MMI_adantl)
   from S61 have S62: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( C \<cdot> B ) \<in> \<complex>" by (rule MMI_an42s)
   from S52 S57 S58 S62 have S63: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( A \<cdot> D ) ) \<ca> ( C \<cdot> B ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_syl3anc)
   from S28 S51 S63 have S64: 
     "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( ( A \<cdot> C ) \<ca> ( B \<cdot> C ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( B \<cdot> D ) ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_3eqtrd)
   from S8 S15 S64 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_3eqtrd)
qed;

(********* 96-100****************************************************)

lemma (in MMIsar0) MMI_muladd11t: 
   shows "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> ( \<one> \<ca> B ) ) = 
  ( ( \<one> \<ca> A ) \<ca> ( B \<ca> ( A \<cdot> B ) ) )"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S2: "( ( \<one> \<ca> A ) \<in> \<complex> \<and> \<one> \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( \<one> \<ca> A ) \<cdot> ( \<one> \<ca> B ) ) = 
     ( ( ( \<one> \<ca> A ) \<cdot> \<one> ) \<ca> ( ( \<one> \<ca> A ) \<cdot> B ) )" 
     by (rule MMI_axdistr)
   from S1 S2 have S3: "( ( \<one> \<ca> A ) \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( \<one> \<ca> A ) \<cdot> ( \<one> \<ca> B ) ) = 
     ( ( ( \<one> \<ca> A ) \<cdot> \<one> ) \<ca> ( ( \<one> \<ca> A ) \<cdot> B ) )" 
     by (rule MMI_mp3an2)
   have S4: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S5: "( \<one> \<in> \<complex> \<and> A \<in> \<complex> ) \<longrightarrow> ( \<one> \<ca> A ) \<in> \<complex>" by (rule MMI_axaddcl)
   from S4 S5 have S6: "A \<in> \<complex> \<longrightarrow> ( \<one> \<ca> A ) \<in> \<complex>" by (rule MMI_mpan)
   from S3 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( \<one> \<ca> A ) \<cdot> ( \<one> \<ca> B ) ) = 
     ( ( ( \<one> \<ca> A ) \<cdot> \<one> ) \<ca> ( ( \<one> \<ca> A ) \<cdot> B ) )" by (rule MMI_sylan)
   from S6 have S8: "A \<in> \<complex> \<longrightarrow> ( \<one> \<ca> A ) \<in> \<complex>" .
   have S9: "( \<one> \<ca> A ) \<in> \<complex> \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> \<one> ) = ( \<one> \<ca> A )" 
     by (rule MMI_ax1id)
   from S8 S9 have S10: "A \<in> \<complex> \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> \<one> ) = ( \<one> \<ca> A )" 
     by (rule MMI_syl)
   from S10 have S11: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( \<one> \<ca> A ) \<cdot> \<one> ) = ( \<one> \<ca> A )" by (rule MMI_adantr)
   have S12: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S13: "( \<one> \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> B ) = 
     ( ( \<one> \<cdot> B ) \<ca> ( A \<cdot> B ) )" by (rule MMI_adddirt)
   from S12 S13 have S14: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> B ) = ( ( \<one> \<cdot> B ) \<ca> ( A \<cdot> B ) )" by (rule MMI_mp3an1)
   have S15: "B \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> B ) = B" by (rule MMI_mulid2t)
   from S15 have S16: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( \<one> \<cdot> B ) = B" 
     by (rule MMI_adantl)
   from S16 have S17: 
     "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<one> \<cdot> B ) \<ca> ( A \<cdot> B ) ) = 
     ( B \<ca> ( A \<cdot> B ) )" by (rule MMI_opreq1d)
   from S14 S17 have S18: 
     "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( ( \<one> \<ca> A ) \<cdot> B ) = 
     ( B \<ca> ( A \<cdot> B ) )" by (rule MMI_eqtrd)
   from S11 S18 have S19: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( ( \<one> \<ca> A ) \<cdot> \<one> ) \<ca> ( ( \<one> \<ca> A ) \<cdot> B ) ) = 
     ( ( \<one> \<ca> A ) \<ca> ( B \<ca> ( A \<cdot> B ) ) )" by (rule MMI_opreq12d)
   from S7 S19 show "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
     ( ( \<one> \<ca> A ) \<cdot> ( \<one> \<ca> B ) ) = 
     ( ( \<one> \<ca> A ) \<ca> ( B \<ca> ( A \<cdot> B ) ) )" 
     by (rule MMI_eqtrd)
qed

lemma (in MMIsar0) MMI_mul12: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( A \<cdot> ( B \<cdot> C ) ) = ( B \<cdot> ( A \<cdot> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "( A \<cdot> B ) = ( B \<cdot> A )" by (rule MMI_mulcom)
   from S3 have S4: "( ( A \<cdot> B ) \<cdot> C ) = ( ( B \<cdot> A ) \<cdot> C )" 
     by (rule MMI_opreq1i)
   from A1 have S5: "A \<in> \<complex>".
   from A2 have S6: "B \<in> \<complex>".
   from A3 have S7: "C \<in> \<complex>".
   from S5 S6 S7 have S8: "( ( A \<cdot> B ) \<cdot> C ) = ( A \<cdot> ( B \<cdot> C ) )" 
     by (rule MMI_mulass)
   from A2 have S9: "B \<in> \<complex>".
   from A1 have S10: "A \<in> \<complex>".
   from A3 have S11: "C \<in> \<complex>".
   from S9 S10 S11 have S12: "( ( B \<cdot> A ) \<cdot> C ) = ( B \<cdot> ( A \<cdot> C ) )" 
     by (rule MMI_mulass)
   from S4 S8 S12 show "( A \<cdot> ( B \<cdot> C ) ) = ( B \<cdot> ( A \<cdot> C ) )" 
     by (rule MMI_3eqtr3)
qed

lemma (in MMIsar0) MMI_mul23: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( ( A \<cdot> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<cdot> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   have S4: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( ( A \<cdot> B ) \<cdot> C ) = 
     ( ( A \<cdot> C ) \<cdot> B )" by (rule MMI_mul23t)
   from S1 S2 S3 S4 show "( ( A \<cdot> B ) \<cdot> C ) = ( ( A \<cdot> C ) \<cdot> B )" 
     by (rule MMI_mp3an)
qed

lemma (in MMIsar0) MMI_mul4: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>"   
   shows "( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_mul4t)
   from S3 S6 S7 show "( ( A \<cdot> B ) \<cdot> ( C \<cdot> D ) ) = ( ( A \<cdot> C ) \<cdot> ( B \<cdot> D ) )" 
     by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_muladd: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>"   
   shows "( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
  ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
     ( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) =
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_muladdt)
   from S3 S6 S7 show 
     "( ( A \<ca> B ) \<cdot> ( C \<ca> D ) ) = 
     ( ( ( A \<cdot> C ) \<ca> ( D \<cdot> B ) ) \<ca> ( ( A \<cdot> D ) \<ca> ( C \<cdot> B ) ) )" 
     by (rule MMI_mp2an)
qed;

end