(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Int\_ZF\_1.thy}*}

theory Int_ZF_1 imports Int_ZF Ring_ZF 

begin;

text{*This theory file considers the set of integers as an ordered ring.*}

section{*Integers as a ring*}

text{*In this section we show that integers form a commutative ring. *}


text{*The next lemma provides the condition to show that addition is 
  distributive with respect to multiplication.*}

lemma (in int0) Int_ZF_1_1_L1: assumes A1: "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>" 
  shows "a\<cdot>(b\<ra>c) = a\<cdot>b \<ra> a\<cdot>c" "(b\<ra>c)\<cdot>a = b\<cdot>a \<ra> c\<cdot>a"
  using prems Int_ZF_1_L2 zadd_zmult_distrib zadd_zmult_distrib2
  by auto;

text{*Integers form a commutative ring, hence we can use theorems proven 
  in @{text "ring0"} context (locale).*}

lemma (in int0) Int_ZF_1_1_L2: shows
  "IsAring(\<int>,IntegerAddition,IntegerMultiplication)"
  "IntegerMultiplication {is commutative on} \<int>"
  "ring0(\<int>,IntegerAddition,IntegerMultiplication)"
proof -
  have "\<forall>a\<in>\<int>.\<forall>b\<in>\<int>.\<forall>c\<in>\<int>. 
    a\<cdot>(b\<ra>c) = a\<cdot>b \<ra> a\<cdot>c \<and> (b\<ra>c)\<cdot>a = b\<cdot>a \<ra> c\<cdot>a"
    using Int_ZF_1_1_L1 by simp;
  then have "IsDistributive(\<int>,IntegerAddition,IntegerMultiplication)"
    using IsDistributive_def by simp;
  then show "IsAring(\<int>,IntegerAddition,IntegerMultiplication)"
    "ring0(\<int>,IntegerAddition,IntegerMultiplication)"
    using Int_ZF_1_T1 Int_ZF_1_T2 IsAring_def ring0_def 
    by auto;
  have "\<forall>a\<in>\<int>.\<forall>b\<in>\<int>. a\<cdot>b = b\<cdot>a" using Int_ZF_1_L4 by simp;
  then show "IntegerMultiplication {is commutative on} \<int>"
    using IsCommutative_def by simp;
qed;

text{*Zero and one are integers.*}

lemma (in int0) Int_ZF_1_1_L3: shows "\<zero>\<in>\<int>" "\<one>\<in>\<int>"
  using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L2 by auto;

text{*Negative of zero is zero.*}

lemma (in int0) Int_ZF_1_1_L3A: shows "(\<rm>\<zero>) = \<zero>"
  using Int_ZF_1_T2 group0.group0_2_L7A by simp;

text{*Properties with one integer.*}

lemma (in int0) Int_ZF_1_1_L4: assumes A1: "a \<in> \<int>"
  shows "a\<ra>\<zero> = a" "\<zero>\<ra>a = a" "a\<cdot>\<one> = a" "\<one>\<cdot>a = a"
  "\<zero>\<cdot>a = \<zero>" "a\<cdot>\<zero> = \<zero>" "(\<rm>a) \<in> \<int>" "a\<rs>a = \<zero>" "a\<rs>\<zero> = a"
proof -;
  from A1 show 
    "a\<ra>\<zero> = a" "\<zero>\<ra>a = a" "a\<cdot>\<one> = a" 
    "\<one>\<cdot>a = a" "a\<rs>a = \<zero>" "a\<rs>\<zero> = a" "(\<rm>a) \<in> \<int>"
    using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L3 by auto;
  from A1 show "\<zero>\<cdot>a = \<zero>" "a\<cdot>\<zero> = \<zero>"
    using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L6 by auto;
qed;

text{*Properties that require two integers.*}

lemma (in int0) Int_ZF_1_1_L5: assumes A1: "a\<in>\<int>" "b\<in>\<int>"
  shows 
  "a\<ra>b \<in> \<int>" 
  "a\<rs>b \<in> \<int>" 
  "a\<cdot>b \<in> \<int>"
  "a\<ra>b = b\<ra>a" 
  "a\<cdot>b = b\<cdot>a" 
  "(\<rm>b)\<rs>a = (\<rm>a)\<rs>b" 
  "(\<rm>(a\<ra>b)) = (\<rm>a)\<rs>b"  
  "(\<rm>(a\<rs>b)) = ((\<rm>a)\<ra>b)"
  "(\<rm>a)\<cdot>b = \<rm>(a\<cdot>b)" 
  "a\<cdot>(\<rm>b) = \<rm>(a\<cdot>b)"
  "(\<rm>a)\<cdot>(\<rm>b) = a\<cdot>b"
  using prems Int_ZF_1_1_L2 ring0.Ring_ZF_1_L4 ring0.Ring_ZF_1_L9
    ring0.Ring_ZF_1_L7 ring0.Ring_ZF_1_L7A Int_ZF_1_L4 by auto;

text{*$2$ and $3$ are integer.*}

lemma (in int0) Int_ZF_1_1_L5A: shows "\<two> \<in> \<int>" "\<three> \<in> \<int>"
    using Int_ZF_1_1_L3 Int_ZF_1_1_L5 by auto;

text{*Properties that require three integers.*}

lemma (in int0) Int_ZF_1_1_L6: assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>"
  shows 
  "a\<rs>(b\<ra>c) = a\<rs>b\<rs>c"
  "a\<rs>(b\<rs>c) = a\<rs>b\<ra>c"
  "a\<cdot>(b\<rs>c) = a\<cdot>b \<rs> a\<cdot>c"
  "(b\<rs>c)\<cdot>a = b\<cdot>a \<rs> c\<cdot>a"
  using prems Int_ZF_1_1_L2 ring0.Ring_ZF_1_L10 ring0.Ring_ZF_1_L8 
  by auto;

text{*Associativity of addition and multiplication.*}

lemma (in int0) Int_ZF_1_1_L7: assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>"
  shows 
  "a\<ra>b\<ra>c = a\<ra>(b\<ra>c)"
  "a\<cdot>b\<cdot>c = a\<cdot>(b\<cdot>c)"
  using prems Int_ZF_1_1_L2 ring0.Ring_ZF_1_L11 by auto;
  
section{*Rearrangement lemmas*}

text{*In this section we collect lemmas about identities related to 
  rearranging the terms in expresssions*}

text{*A formula with a positive integer.*}

lemma (in int0) Int_ZF_1_2_L1: assumes "\<zero>\<lsq>a"
  shows "abs(a)\<ra>\<one> = abs(a\<ra>\<one>)"
  using prems Int_ZF_2_L16 Int_ZF_2_L12A by simp;

text{*A formula with two integers, one positive.*}

lemma (in int0) Int_ZF_1_2_L2: assumes A1: "a\<in>\<int>" and A2: "\<zero>\<lsq>b"
  shows "a\<ra>(abs(b)\<ra>\<one>)\<cdot>a = (abs(b\<ra>\<one>)\<ra>\<one>)\<cdot>a"
proof -
  from A2 have T1: "abs(b\<ra>\<one>) \<in> \<int>"
    using Int_ZF_2_L12A Int_ZF_2_L1A Int_ZF_2_L14 by blast;
  with A1 A2 show ?thesis 
    using Int_ZF_1_2_L1 Int_ZF_1_1_L2 ring0.Ring_ZF_2_L1 
    by simp;
qed;

text{*A couple of formulae about canceling opposite integers.*}

lemma (in int0) Int_ZF_1_2_L3: assumes A1: "a\<in>\<int>" "b\<in>\<int>"
  shows "a\<ra>b\<rs>a = b" "a\<ra>b\<rs>b = a" "a\<rs>b\<ra>b = a" 
  using prems Int_ZF_1_T2 group0.group0_4_L6A group0.group0_2_L16 
  by auto;

text{*Subtracting one decreases integers. This may be moved to a theory
  about ordered rings one day.*}

lemma (in int0) Int_ZF_1_2_L3A: assumes A1: "a\<lsq>b"
  shows "a\<rs>\<one> \<lsq> b"
proof -
  from A1 have "b\<ra>\<one>\<rs>\<one> = b"
    using Int_ZF_2_L1A Int_ZF_1_1_L3 Int_ZF_1_2_L3 by simp;
  moreover from A1 have "a\<rs>\<one> \<lsq> b\<ra>\<one>\<rs>\<one>"
    using Int_ZF_2_L12A Int_ZF_1_1_L3 Int_ZF_1_1_L4 Int_ZF_2_L8
    by simp;
  ultimately show "a\<rs>\<one> \<lsq> b" by simp;
qed;

text{*A formula with a negative integer.*}

lemma (in int0) Int_ZF_1_2_L4: assumes "a\<lsq>\<zero>"
  shows "abs(a)\<ra>\<one> = abs(a\<rs>\<one>)"
  using prems Int_ZF_1_1_L3 Int_ZF_1_2_L3A Int_ZF_2_T1 
      group3.OrderedGroup_ZF_3_L3A Int_ZF_2_L1A 
      Int_ZF_1_1_L3 Int_ZF_1_1_L5 by simp;

text{*A formula with two integers, one negative.*}

lemma (in int0) Int_ZF_1_2_L5: assumes A1: "a\<in>\<int>" and A2: "b\<lsq>\<zero>"
  shows "a\<ra>(abs(b)\<ra>\<one>)\<cdot>a = (abs(b\<rs>\<one>)\<ra>\<one>)\<cdot>a"
proof -
  from A2 have "abs(b\<rs>\<one>) \<in> \<int>"
    using Int_ZF_1_1_L3 Int_ZF_1_2_L3A Int_ZF_2_L1A Int_ZF_2_L14 
    by blast;
  with A1 A2 show ?thesis 
    using Int_ZF_1_2_L4 Int_ZF_1_1_L2 ring0.Ring_ZF_2_L1
    by simp;
qed;
  
text{*A rearrangement with four integers.*}

lemma (in int0) Int_ZF_1_2_L6: 
  assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>" "d\<in>\<int>"
  shows "a\<rs>(b\<rs>\<one>)\<cdot>c = (d\<rs>b\<cdot>c)\<rs>(d\<rs>a\<rs>c)"
proof -;
  from A1 have T1: 
    "(d\<rs>b\<cdot>c) \<in> \<int>" "d\<rs>a \<in> \<int>" "(\<rm>(b\<cdot>c)) \<in> \<int>"
    using Int_ZF_1_1_L5 Int_ZF_1_1_L4 by auto;   
  with A1 have 
    "(d\<rs>b\<cdot>c)\<rs>(d\<rs>a\<rs>c) = (\<rm>(b\<cdot>c))\<ra>a\<ra>c"
    using Int_ZF_1_1_L6 Int_ZF_1_2_L3 by simp;
  also from A1 T1 have "(\<rm>(b\<cdot>c))\<ra>a\<ra>c = a\<rs>(b\<rs>\<one>)\<cdot>c" 
    using Int_ZF_1_1_L3 Int_ZF_1_1_L6 Int_ZF_1_1_L4 Int_ZF_1_1_L5
    by simp;
  finally show ?thesis by simp
qed;

text{*Four other rearrangements with two integers.*}

(*lemma (in int0) Int_ZF_1_2_L7: 
  assumes "a\<in>\<int>" "b\<in>\<int>"
  shows 
  "a\<cdot>b = (a\<rs>\<one>)\<cdot>b\<ra>b"
  using prems Int_ZF_1_1_L5 Int_ZF_1_1_L3 Int_ZF_1_1_L6 Int_ZF_1_1_L4
    Int_ZF_1_T2 group0.group0_2_L16 by simp;*)
lemma (in int0) Int_ZF_1_2_L7: 
  assumes "a\<in>\<int>" "b\<in>\<int>"
  shows 
  "a\<cdot>b = (a\<rs>\<one>)\<cdot>b\<ra>b"
  "a\<cdot>(b\<ra>\<one>) = a\<cdot>b\<ra>a"
  "(b\<ra>\<one>)\<cdot>a = b\<cdot>a\<ra>a"
  "(b\<ra>\<one>)\<cdot>a = a\<ra>b\<cdot>a"
  using prems Int_ZF_1_1_L1 Int_ZF_1_1_L5 Int_ZF_1_1_L3 Int_ZF_1_1_L6 
    Int_ZF_1_1_L4 Int_ZF_1_T2 group0.group0_2_L16 by auto;
  
text{*Another rearrangement with two integers.*}

lemma (in int0) Int_ZF_1_2_L8: 
  assumes A1: "a\<in>\<int>" "b\<in>\<int>"
  shows "a\<ra>\<one>\<ra>(b\<ra>\<one>) = b\<ra>a\<ra>\<two>"
  using prems Int_ZF_1_1_L3 Int_ZF_1_T2 group0.group0_4_L8
  by simp;

text{*Another rearrangement with three integers.*}

lemma (in int0) Int_ZF_1_2_L9: 
  assumes "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>"
  shows 
  "(a\<rs>b)\<ra>(b\<rs>c) = a\<rs>c"
  "(a\<rs>b)\<rs>(a\<rs>c) = c\<rs>b"
  using prems Int_ZF_1_T2 
    group0.group0_4_L4B group0.group0_4_L4D by auto;

text{*Another rearrangement with three integers.*}

lemma (in int0) Int_ZF_1_2_L10: 
  assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>"
  shows "(a\<ra>\<one>)\<cdot>b \<ra> (c\<ra>\<one>)\<cdot>b = (c\<ra>a\<ra>\<two>)\<cdot>b"
proof -
  from A1 have "a\<ra>\<one> \<in> \<int>" "c\<ra>\<one> \<in> \<int>" 
    using Int_ZF_1_1_L3 Int_ZF_1_1_L5 by auto; 
  with A1 have 
    "(a\<ra>\<one>)\<cdot>b \<ra> (c\<ra>\<one>)\<cdot>b = (a\<ra>\<one>\<ra>(c\<ra>\<one>))\<cdot>b"
    using Int_ZF_1_1_L1 by simp;
  also from A1 have "\<dots> = (c\<ra>a\<ra>\<two>)\<cdot>b"
    using Int_ZF_1_2_L8 by simp;
  finally show ?thesis by simp;
qed;

text{*A technical rearrangement involing inequalities with absolute value.*}

lemma (in int0) Int_ZF_1_2_L10A: 
  assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>" "e\<in>\<int>"
  and A2: "abs(a\<cdot>b\<rs>c) \<lsq> d" "abs(b\<cdot>a\<rs>e) \<lsq> f"
  shows "abs(c\<rs>e) \<lsq>  f\<ra>d"
proof -  
  from A1 A2 have T1:
    "d\<in>\<int>"  "f\<in>\<int>"  "a\<cdot>b \<in> \<int>"  "a\<cdot>b\<rs>c \<in> \<int>"  "b\<cdot>a\<rs>e \<in> \<int>"
    using Int_ZF_2_L1A Int_ZF_1_1_L5 by auto;
  with A2 have
    "abs((b\<cdot>a\<rs>e)\<rs>(a\<cdot>b\<rs>c)) \<lsq> f \<ra>d"
    using Int_ZF_2_L21 by simp;
  with A1 T1 show "abs(c\<rs>e) \<lsq> f\<ra>d" 
    using Int_ZF_1_1_L5 Int_ZF_1_2_L9 by simp;
qed;

text{*Some arithmetics.*}

lemma (in int0) Int_ZF_1_2_L11: assumes A1: "a\<in>\<int>"
  shows "a\<ra>\<one>\<ra>\<two> = a\<ra>\<three>"
  using prems Int_ZF_1_1_L3 Int_ZF_1_1_L5A Int_ZF_1_T2 group0.group0_4_L4C
  by simp;

text{*A simple rearrangement with three integers.*}

lemma (in int0) Int_ZF_1_2_L12: 
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>"
  shows "(b\<rs>c)\<cdot>a = a\<cdot>b \<rs> a\<cdot>c"
  using prems Int_ZF_1_1_L6 Int_ZF_1_1_L5 by simp;

text{*A big rearrangement with five integers.*}

lemma (in int0) Int_ZF_1_2_L13: 
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>" "d\<in>\<int>"  "x\<in>\<int>"
  shows "(x\<ra>(a\<cdot>x\<ra>b)\<ra>c)\<cdot>d = d\<cdot>(a\<ra>\<one>)\<cdot>x \<ra> (b\<cdot>d\<ra>c\<cdot>d)"
proof -
  from A1 have T1: 
    "a\<cdot>x \<in> \<int>"   "(a\<ra>\<one>)\<cdot>x \<in> \<int>"  
    "(a\<ra>\<one>)\<cdot>x \<ra> b \<in> \<int>" 
    using Int_ZF_1_1_L5 Int_ZF_1_1_L3 by auto
  with A1 have "(x\<ra>(a\<cdot>x\<ra>b)\<ra>c)\<cdot>d = ((a\<ra>\<one>)\<cdot>x \<ra> b)\<cdot>d \<ra> c\<cdot>d"
    using Int_ZF_1_1_L7 Int_ZF_1_2_L7 Int_ZF_1_1_L1
    by simp;
  also from A1 T1 have "\<dots> = (a\<ra>\<one>)\<cdot>x\<cdot>d \<ra> b \<cdot> d \<ra> c\<cdot>d"
    using Int_ZF_1_1_L1 by simp;
  finally have "(x\<ra>(a\<cdot>x\<ra>b)\<ra>c)\<cdot>d = (a\<ra>\<one>)\<cdot>x\<cdot>d \<ra> b\<cdot>d \<ra> c\<cdot>d"
    by simp;
  moreover from A1 T1 have "(a\<ra>\<one>)\<cdot>x\<cdot>d = d\<cdot>(a\<ra>\<one>)\<cdot>x"
    using Int_ZF_1_1_L3 Int_ZF_1_1_L5 Int_ZF_1_1_L7 by simp;
  ultimately have "(x\<ra>(a\<cdot>x\<ra>b)\<ra>c)\<cdot>d = d\<cdot>(a\<ra>\<one>)\<cdot>x \<ra> b\<cdot>d \<ra> c\<cdot>d"
    by simp;
  moreover from A1 T1 have 
    "d\<cdot>(a\<ra>\<one>)\<cdot>x \<in> \<int>"  "b\<cdot>d \<in> \<int>"  "c\<cdot>d \<in> \<int>"
    using Int_ZF_1_1_L3 Int_ZF_1_1_L5 by auto;
  ultimately show ?thesis using Int_ZF_1_1_L7 by simp;
qed;

text{*Rerrangement about adding linear functions.*}

lemma (in int0) Int_ZF_1_2_L14:
  assumes "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>" "d\<in>\<int>"  "x\<in>\<int>"
  shows "(a\<cdot>x \<ra> b) \<ra> (c\<cdot>x \<ra> d) = (a\<ra>c)\<cdot>x \<ra> (b\<ra>d)"
  using prems Int_ZF_1_1_L2 ring0.Ring_ZF_2_L3 by simp;

section{*Integers as an ordered ring*}

text{*We already know from @{text "Int_ZF"} that integers with addition 
  form a linearly ordered group. To show that integers form 
  an ordered ring we need the fact that the set of nonnegative integers
  is closed with respect to multiplication. Since we don't have the theory
  of oredered rings we temporarily put some facts about integers as an ordered
  ring in this section.*}

text{* We start with the property that a product of 
  nonnegative integers is nonnegative. The proof is by induction and the next
  lemma is the induction step.*}

lemma (in int0) Int_ZF_1_3_L1: assumes A1: "\<zero>\<lsq>a" "\<zero>\<lsq>b"
  and A3: "\<zero> \<lsq> a\<cdot>b"
  shows "\<zero> \<lsq> a\<cdot>(b\<ra>\<one>)"
proof -
  from A1 A3 have "\<zero>\<ra>\<zero> \<lsq> a\<cdot>b\<ra>a"
    using Int_ZF_2_L15A by simp;
  with A1 show "\<zero> \<lsq> a\<cdot>(b\<ra>\<one>)"
    using Int_ZF_1_1_L3 Int_ZF_1_1_L4 Int_ZF_2_L1A Int_ZF_1_2_L7 
    by simp;
qed;

text{* Product of nonnegative integers is nonnegative.*}
  
lemma (in int0) Int_ZF_1_3_L2: assumes A1: "\<zero>\<lsq>a" "\<zero>\<lsq>b" 
  shows "\<zero>\<lsq>a\<cdot>b"
proof -
  from A1 have "\<zero>\<lsq>b" by simp
  moreover from A1 have "\<zero> \<lsq> a\<cdot>\<zero>" using
    Int_ZF_2_L1A Int_ZF_1_1_L4 Int_ZF_1_1_L3 Int_ZF_2_L2 refl_def
    by simp;
  moreover from A1 have 
    "\<forall>m. \<zero>\<lsq>m \<and> \<zero>\<lsq>a\<cdot>m \<longrightarrow> \<zero> \<lsq> a\<cdot>(m\<ra>\<one>)"
    using Int_ZF_1_3_L1 by simp;
  ultimately show "\<zero>\<lsq>a\<cdot>b" by (rule Induction_on_int);
qed;

text{*Product of integers that are greater that one is greater than one. 
  The proof is by induction and 
  the next step is the induction step.*}

lemma (in int0) Int_ZF_1_3_L3_indstep:  
  assumes A1: "\<one>\<lsq>a" "\<one>\<lsq>b"
  and A2: "\<one> \<lsq> a\<cdot>b"
  shows "\<one> \<lsq> a\<cdot>(b\<ra>\<one>)"
proof -
   from A1 A2 have "\<one>\<lsq>\<two>" and "\<two> \<lsq> a\<cdot>(b\<ra>\<one>)"
    using Int_ZF_2_L1A Int_ZF_2_L15A Int_ZF_2_L16C Int_ZF_1_2_L7 
    by auto;
  then show "\<one> \<lsq> a\<cdot>(b\<ra>\<one>)" by (rule Int_order_transitive);
qed;

text{*Product of integers that are greater that one is greater than one. *}

lemma (in int0) Int_ZF_1_3_L3: 
  assumes A1: "\<one>\<lsq>a" "\<one>\<lsq>b"
  shows "\<one> \<lsq> a\<cdot>b"
proof -
  from A1 have "\<one>\<lsq>b"  "\<one>\<lsq>a\<cdot>\<one>"
    using Int_ZF_2_L1A Int_ZF_1_1_L4 by auto;
  moreover from A1 have 
    "\<forall>m. \<one>\<lsq>m \<and> \<one> \<lsq> a\<cdot>m \<longrightarrow> \<one> \<lsq> a\<cdot>(m\<ra>\<one>)"
    using Int_ZF_1_3_L3_indstep by simp;
  ultimately show "\<one> \<lsq> a\<cdot>b" by (rule Induction_on_int);
qed;


text{*The absolute value is a homomorphism from interegers with 
  multiplication to
  nonnegative integers with multiplication ($|m\cdot n| = |m|\cdot |n|$). 
  This fact belongs to ordered rings and will be moved there
  one day. First we show that it is true for nonnegative integers.*}

lemma (in int0) Int_ZF_1_3_L3A: 
  assumes "\<zero>\<lsq>a" "\<zero>\<lsq>b"
  shows "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
  using prems Int_ZF_1_3_L2 Int_ZF_2_L16 by simp;

text{*$|a\cdot (-b)| = |(-a)\cdot b| = |(-a)\cdot (-b)| = |a\cdot b|$.*}

lemma (in int0) Int_ZF_1_3_L4: assumes "a\<in>\<int>" "b\<in>\<int>"
  shows 
  "abs((\<rm>a)\<cdot>b) = abs(a\<cdot>b)"
  "abs(a\<cdot>(\<rm>b)) = abs(a\<cdot>b)"
  "abs((\<rm>a)\<cdot>(\<rm>b)) = abs(a\<cdot>b)"
  using prems Int_ZF_1_1_L5 Int_ZF_2_L17 by auto;

text{*$|a\cdot b| = |a|\cdot |b|$, general case.*}

lemma (in int0) Int_ZF_1_3_L5:
  assumes A1: "a\<in>\<int>" "b\<in>\<int>"
  shows "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
proof (cases "\<zero>\<lsq>a")
  assume A2: "\<zero>\<lsq>a" show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
  proof (cases "\<zero>\<lsq>b")
    assume "\<zero>\<lsq>b"
    with A2 show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
      using Int_ZF_1_3_L3A by simp;
  next assume "\<not>(\<zero>\<lsq>b)" 
    with A1 A2 have "abs(a\<cdot>(\<rm>b)) = abs(a)\<cdot>abs(\<rm>b)"
       using Int_ZF_2_L19A Int_ZF_1_3_L3A by simp;
    with A1 show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
      using Int_ZF_1_3_L4 Int_ZF_2_L17 by simp;
  qed;
next assume "\<not>(\<zero>\<lsq>a)"
  with A1 have A3: "\<zero> \<lsq> (\<rm>a)"
    using Int_ZF_2_L19A by simp; 
  show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
  proof (cases "\<zero>\<lsq>b")
    assume "\<zero>\<lsq>b" 
    with A3 have "abs((\<rm>a)\<cdot>b) = abs(\<rm>a)\<cdot>abs(b)"
      using Int_ZF_1_3_L3A by simp;
    with A1 show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
      using Int_ZF_1_3_L4 Int_ZF_2_L17 by simp;
  next assume "\<not>(\<zero>\<lsq>b)"
    with A1 A3 have "abs((\<rm>a)\<cdot>(\<rm>b)) = abs(\<rm>a)\<cdot>abs(\<rm>b)"
      using Int_ZF_2_L19A Int_ZF_1_3_L3A by simp;
    with A1 show "abs(a\<cdot>b) = abs(a)\<cdot>abs(b)"
      using Int_ZF_1_3_L4 Int_ZF_2_L17 by simp;
  qed;
qed;

text{*The next lemma shows what happens when one integers is not
  greater or equal than another.*}

lemma (in int0) Int_ZF_1_3_L6: 
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>" 
  shows "\<not>(b\<lsq>a) \<longleftrightarrow> a\<ra>\<one> \<lsq> b"
proof;
  assume A3: "\<not>(b\<lsq>a)"
  with A1 have  "a\<lsq>b" by (rule Int_ZF_2_L19);
  then have "a = b   \<or>  a\<ra>\<one> \<lsq> b"
    using Int_ZF_4_L1B by simp; 
  moreover from A1 A3 have "a\<noteq>b" by (rule Int_ZF_2_L19);
  ultimately show "a\<ra>\<one> \<lsq> b" by simp;
next assume A4: "a\<ra>\<one> \<lsq> b"
  { assume "b\<lsq>a" 
    with A4 have "a\<ra>\<one> \<lsq> a" by (rule Int_order_transitive);
    moreover from A1 have "a \<lsq> a\<ra>\<one>"
      using Int_ZF_2_L12B by simp;
    ultimately have "a\<ra>\<one> = a"
      by (rule Int_ZF_2_L3); 
    with A1 have False using Int_ZF_1_L14 by simp; 
  } then show "\<not>(b\<lsq>a)" by auto
qed;

text{*An integer is not less or equal zero iff it is greater or equal one.*}

lemma (in int0) Int_ZF_1_3_L7: assumes "a\<in>\<int>" 
  shows "\<not>(a\<lsq>\<zero>) \<longleftrightarrow> \<one> \<lsq> a"
  using prems Int_ZF_1_1_L3 Int_ZF_1_3_L6 Int_ZF_1_1_L4
  by simp;

text{*product of positive integers is positive. This is one the defining 
  property of ordered rings.*}

lemma (in int0) Int_ZF_1_3_L8: 
  assumes "a\<in>\<int>"  "b\<in>\<int>" 
  and "\<not>(a\<lsq>\<zero>)"  "\<not>(b\<lsq>\<zero>)"
  shows "\<not>((a\<cdot>b) \<lsq> \<zero>)"
  using prems Int_ZF_1_3_L7 Int_ZF_1_3_L3 Int_ZF_1_1_L5 Int_ZF_1_3_L7
  by simp;

text{*If $a\cdot b$ is nonnegative and $b$ is positive, then $a$ is 
  nonnegative. This is a property of ordered rings. Proof by contradiction.*}

lemma (in int0) Int_ZF_1_3_L9:
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>"
  and A2:  "\<not>(b\<lsq>\<zero>)" and A3: "a\<cdot>b \<lsq> \<zero>" 
  shows "a\<lsq>\<zero>"
proof -
  { assume "\<not>(a\<lsq>\<zero>)"
    with A1 A2 have "\<not>((a\<cdot>b) \<lsq> \<zero>)" using Int_ZF_1_3_L8
      by simp;
  } with A3 show "a\<lsq>\<zero>" by auto;
qed;

text{*One integer is less or equal another iff the difference is nonpositive.*}

lemma (in int0) Int_ZF_1_3_L10:
  assumes "a\<in>\<int>"  "b\<in>\<int>"
  shows "a\<lsq>b \<longleftrightarrow> a\<rs>b \<lsq> \<zero>"
  using prems Int_ZF_2_T1 group3.OrderedGroup_ZF_1_L9
  by simp;

text{*We can simplify out a positive element on both sides of an 
  inequality. This is aproperty of ordered rings.*}

lemma (in int0) Int_ineq_simpl_positive: 
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>" 
  and A2: "a\<cdot>c \<lsq> b\<cdot>c" and A4: "\<not>(c\<lsq>\<zero>)"
  shows "a \<lsq> b"
proof -
  from A1 A4 have "a\<rs>b \<in>  \<int>"  "c\<in>\<int>"  "\<not>(c\<lsq>\<zero>)"
    using Int_ZF_1_1_L5 by auto;
  moreover from A1 A2 have "(a\<rs>b)\<cdot>c \<lsq> \<zero>"
    using Int_ZF_1_1_L5 Int_ZF_1_3_L10 Int_ZF_1_1_L6
    by simp;
  ultimately have "a\<rs>b \<lsq> \<zero>" by (rule Int_ZF_1_3_L9);
  with A1 show "a \<lsq> b" using Int_ZF_1_3_L10 by simp;
qed;

text{*A technical lemma about conclusion from an inequality between
  absolute values. This is a property of ordered rings.*}

lemma (in int0) Int_ZF_1_3_L11:
  assumes A1: "a\<in>\<int>"  "b\<in>\<int>"
  and A2: "\<not>(abs(a) \<lsq> abs(b))"
  shows "\<not>(abs(a) \<lsq> \<zero>)"
proof -
  { assume "abs(a) \<lsq> \<zero>"
    moreover from A1 have "\<zero> \<lsq> abs(a)" using Int_ZF_2_L22
      by simp;
    ultimately have "abs(a) = \<zero>" by (rule Int_ZF_2_L3);
    with A1 A2 have False using Int_ZF_2_L22 by simp;
  } then show  "\<not>(abs(a) \<lsq> \<zero>)" by auto;
qed;

text{*Negative times positive is negative. This a property of ordered rings.*}

lemma (in int0) Int_ZF_1_3_L12:
  assumes A1: "a\<lsq>\<zero>"  and A2: "\<zero>\<lsq>b"
  shows "a\<cdot>b \<lsq> \<zero>"
proof -;
  from A1 A2 have T1: "a\<in>\<int>"  "b\<in>\<int>"  "a\<cdot>b \<in> \<int>"
    using Int_ZF_2_L1A Int_ZF_1_1_L5 by auto;
  from A1 A2 have "\<zero>\<lsq>(\<rm>a)\<cdot>b" 
    using Int_ZF_2_L10A Int_ZF_1_3_L2 by simp;
  with T1 show "a\<cdot>b \<lsq> \<zero>"
    using Int_ZF_1_1_L5 Int_ZF_2_L10B by simp;
qed;

text{*We can multiply an inequality by a nonnegative number. 
  This a property of ordered rings.*}

lemma (in int0) Int_ZF_1_3_L13:
  assumes A1: "a\<lsq>b" and A2: "\<zero>\<lsq>c"
  shows "a\<cdot>c \<lsq> b\<cdot>c"
proof -
  from A1 A2 have T1:  
    "a\<in>\<int>"  "b\<in>\<int>"  "c\<in>\<int>"  "a\<cdot>c \<in> \<int>"  "b\<cdot>c \<in> \<int>" 
    using Int_ZF_2_L1A Int_ZF_1_1_L5 by auto
  with A1 A2 have "(a\<rs>b)\<cdot>c \<lsq> \<zero>"
    using Int_ZF_1_3_L10 Int_ZF_1_3_L12 by simp;
  with T1 show "a\<cdot>c \<lsq> b\<cdot>c"
    using Int_ZF_1_1_L6 Int_ZF_1_3_L10 by simp;
qed;

text{*A rearrangement with four integers and absolute value.*}

lemma (in int0) Int_ZF_1_3_L14:
  assumes  A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>" "d\<in>\<int>" 
  shows "abs(a\<cdot>b)\<ra>(abs(a)\<ra>c)\<cdot>d = (d\<ra>abs(b))\<cdot>abs(a)\<ra>c\<cdot>d"
proof -;
  from A1 have T1: 
    "abs(a) \<in> \<int>"  "abs(b) \<in> \<int>" 
    "abs(a)\<cdot>abs(b) \<in> \<int>" 
    "abs(a)\<cdot>d \<in> \<int>" 
    "c\<cdot>d \<in> \<int>"
    "abs(b)\<ra>d \<in> \<int>" 
    using Int_ZF_2_L14 Int_ZF_1_1_L5 by auto;
  with A1 have "abs(a\<cdot>b)\<ra>(abs(a)\<ra>c)\<cdot>d = abs(a)\<cdot>(abs(b)\<ra>d)\<ra>c\<cdot>d"
    using Int_ZF_1_3_L5 Int_ZF_1_1_L1 Int_ZF_1_1_L7 by simp;
  with A1 T1 show ?thesis using Int_ZF_1_1_L5 by simp;
qed;

section{*Miscelaneous*}

text{*In this section we put some technical lemmas needed in different other 
  places that are hard to classify.*}

text{*Suppose we have an integer expression (a meta-function)$F$ such that 
  $F(p)|p|$ is bounded by a linear function of $|p|$, that is for some integers
  $A,B$ we have $F(p)|p|\leq A|p|+B.$ We show that $F$ is then bounded. 
  The proof is easy, we just divide both sides by $|p|$ 
  and take the limit (just kidding). *}

lemma (in int0) Int_ZF_1_4_L1:
  assumes A1: "\<forall>q\<in>\<int>. F(q) \<in> \<int>"
  and A2:  "\<forall>q\<in>\<int>. F(q)\<cdot>abs(q) \<lsq> A\<cdot>abs(q) \<ra> B"
  and A3: "A\<in>\<int>"  "B\<in>\<int>"
  shows "\<exists>L. \<forall>p\<in>\<int>. F(p) \<lsq> L"
proof -
  let ?I = "(\<rm>abs(B))..abs(B)"
  def DefK: K == "{F(q). q \<in> ?I}"
  let ?M = "Maximum(IntegerOrder,K)"
  let ?L = "GreaterOf(IntegerOrder,?M,A\<ra>\<one>)"
  from A3 A1 DefK have C1:
    "IsBounded(?I,IntegerOrder)"   
    "?I \<noteq> 0"
    "\<forall>q\<in>\<int>. F(q) \<in> \<int>"
    "K = {F(q). q \<in> ?I}"
    using Order_ZF_3_L9 Int_ZF_2_L24 by auto;
  then have "?M \<in> \<int>" by (rule Int_ZF_4_L7);
  with A3 have T1: "?M \<lsq> ?L"  "A\<ra>\<one> \<lsq> ?L"
    using Int_ZF_1_1_L3 Int_ZF_1_1_L5 Int_ZF_2_L25
    by auto;
  from C1 have T2: "\<forall>q\<in>?I. F(q) \<lsq> ?M"
    by (rule Int_ZF_4_L7);
  { fix p assume A4: "p\<in>\<int>" have "F(p) \<lsq> ?L" 
    proof (cases "abs(p) \<lsq> abs(B)")
      assume "abs(p) \<lsq> abs(B)"
      with A4 T1 T2 have "F(p) \<lsq> ?M"  "?M \<lsq> ?L"
	using Int_ZF_2_L26 by auto;
      then show "F(p) \<lsq> ?L" by (rule Int_order_transitive);
    next assume A5: "\<not>(abs(p) \<lsq> abs(B))"
      from A3 A2 A4 have 
	"A\<cdot>abs(p) \<in> \<int>"  "F(p)\<cdot>abs(p) \<lsq> A\<cdot>abs(p) \<ra> B"
	using Int_ZF_2_L14 Int_ZF_1_1_L5 by auto;
      moreover from A3 A4 A5 have "B \<lsq> abs(p)"
	using Int_ZF_2_L22A by simp;
      ultimately have
	"F(p)\<cdot>abs(p) \<lsq> A\<cdot>abs(p) \<ra> abs(p)"
	using Int_ZF_2_L15B by blast;
      with A3 A4 have "F(p)\<cdot>abs(p) \<lsq> (A\<ra>\<one>)\<cdot>abs(p)"
	using Int_ZF_2_L14 Int_ZF_1_2_L7 by simp;
      moreover from A3 A1 A4 A5 have 
	"F(p) \<in> \<int>"  "A\<ra>\<one> \<in> \<int>"  "abs(p) \<in> \<int>"
	 "\<not>(abs(p) \<lsq> \<zero>)"
	using Int_ZF_1_1_L3 Int_ZF_1_1_L5 Int_ZF_2_L14 Int_ZF_1_3_L11
	by auto;
      ultimately have "F(p) \<lsq> A\<ra>\<one>"
	using Int_ineq_simpl_positive by simp;
      moreover from T1 have  "A\<ra>\<one> \<lsq> ?L" by simp;
      ultimately show "F(p) \<lsq> ?L" by (rule Int_order_transitive);
    qed
 } then have "\<forall>p\<in>\<int>. F(p) \<lsq> ?L" by simp
 thus ?thesis by auto;
qed;
end