(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar (ZF logic).

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Group\_ZF\_2.thy}*}

theory Group_ZF_2 = Group_ZF + func_ZF + EquivClass1:;

text{*This theory continues Group\_ZF.thy and considers lifting the group 
  structure to function spaces and projecting the group structure to 
  quotient spaces, in particular the quotient qroup.*}

section{*Lifting groups to function spaces*}

text{*If we have a monoid (group) $G$ than we get a monoid (group) 
  structure on a space of functions valued in 
  in $G$ by defining $(f\cdot g)(x) := f(x)\cdot g(x)$. 
  We call this process "lifting the monoid (group) to function space.
  This section formalizes this "lifting".*}

text{*The lifted operation is an operation on the function space.*}

lemma (in monoid0) Group_ZF_2_1_L0A:
  assumes A1:"F = f {lifted to function space over} X"
  shows "F : (X\<rightarrow>G)\<times>(X\<rightarrow>G)\<rightarrow>(X\<rightarrow>G)"
proof -
  from monoidAsssum have "f : G\<times>G\<rightarrow>G"
    using IsAmonoid_def IsAssociative_def by simp;
  with A1 show ?thesis
    using func_ZF_1_L3 group0_1_L3B by auto;
qed;


text{*The result of the lifted operation is in the function space.*}

lemma (in monoid0) Group_ZF_2_1_L0: 
  assumes A1:"F = f {lifted to function space over} X"
  and A2:"s:X\<rightarrow>G" "r:X\<rightarrow>G"
  shows "F`<s,r> : X\<rightarrow>G"
proof -
  from A1 have "F : (X\<rightarrow>G)\<times>(X\<rightarrow>G)\<rightarrow>(X\<rightarrow>G)"
    using Group_ZF_2_1_L0A
    by simp;
  with A2 show ?thesis using apply_funtype
    by simp;
qed;
    
text{*The lifted monoid operation has a neutral element, namely
  the constant function with the neutral element as the value. *}

lemma (in monoid0) Group_ZF_2_1_L1: 
  assumes A1: "F = f {lifted to function space over} X"
  and A2:"E = ConstantFunction(X,TheNeutralElement(G,f))"
  shows "E : X\<rightarrow>G \<and> (\<forall>s\<in>X\<rightarrow>G. F`<E,s> = s \<and> F`<s,E> = s)"
proof
  from A2 show T1:"E : X\<rightarrow>G"
    using group0_1_L3 func1_3_L1 by simp;
  show "\<forall>s\<in>X\<rightarrow>G. F`<E,s> = s \<and> F`<s,E> = s"
  proof;
    fix s assume A3:"s:X\<rightarrow>G"
    from monoidAsssum have T2:"f : G\<times>G\<rightarrow>G"
      using IsAmonoid_def IsAssociative_def by simp;
    from A3 A1 T1 have 
      "F`<E,s> : X\<rightarrow>G" "F`<s,E> : X\<rightarrow>G" "s : X\<rightarrow>G"
      using Group_ZF_2_1_L0 by auto;
    moreover from T2 A1 T1 A2 A3 have
      "\<forall>x\<in>X. (F`<E,s>)`(x) = s`(x)"
      "\<forall>x\<in>X. (F`<s,E>)`(x) = s`(x)"
      using func_ZF_1_L4 group0_1_L3B func1_3_L2 
	apply_type group0_1_L3 by auto;
    ultimately show 
      "F`<E,s> = s \<and> F`<s,E> = s"
      using fun_extension_iff by auto;
  qed;
qed;

text{*Monoids can be lifted to a function space.*}

lemma (in monoid0) Group_ZF_2_1_T1: 
  assumes A1:"F = f {lifted to function space over} X"
  shows "IsAmonoid(X\<rightarrow>G,F)"
proof -;
  from monoidAsssum A1 have 
    "F {is associative on} (X\<rightarrow>G)"
    using IsAmonoid_def func_ZF_2_L4 group0_1_L3B
    by auto;
  moreover from A1 have 
    "\<exists> E \<in> X\<rightarrow>G. \<forall>s \<in> X\<rightarrow>G. F`<E,s> = s \<and> F`<s,E> = s"
    using Group_ZF_2_1_L1 by blast;
  ultimately show ?thesis using IsAmonoid_def
    by simp
qed;

text{*The constant function with the neutral element as the value is the
  neutral element of the lifted monoid.*}

lemma Group_ZF_2_1_L2:
  assumes A1:"IsAmonoid(G,f)"
  and A2:"F = f {lifted to function space over} X"
  and A3:"E = ConstantFunction(X,TheNeutralElement(G,f))"
  shows "E = TheNeutralElement(X\<rightarrow>G,F)"
proof - 
  from A1 A2 have 
     T1:"monoid0(G,f)" and T2:"monoid0(X\<rightarrow>G,F)"
    using monoid0_def monoid0.Group_ZF_2_1_T1
    by auto;
  from T1 A2 A3 have 
    "E : X\<rightarrow>G \<and> (\<forall>s\<in>X\<rightarrow>G. F`<E,s> = s \<and> F`<s,E> = s)"
    using monoid0.Group_ZF_2_1_L1 by simp;
  with T2 show ?thesis
    using monoid0.group0_1_L4 by auto;
qed;

text{*The lifted operation acts on the functions in a natural way defined
  by the group operation.*}

lemma (in group0) Group_ZF_2_1_L3:
  assumes A1:"F = f {lifted to function space over} X"
  and A2:"s:X\<rightarrow>G" "r:X\<rightarrow>G"
  and A3:"x\<in>X"
  shows "(F`<s,r>)`(x) = s`(x)\<cdot>r`(x)"
proof -;
  from groupAsssum A1 A2 A3 show ?thesis
     using IsAgroup_def IsAmonoid_def IsAssociative_def
      group0_2_L1 monoid0.group0_1_L3B func_ZF_1_L4
     by auto;
qed;
    
text{*In the group0 context we can apply theorems proven in monoid0 context
  to the lifted monoid.*}

lemma (in group0) Group_ZF_2_1_L4:
  assumes A1:"F = f {lifted to function space over} X"
  shows "monoid0(X\<rightarrow>G,F)"
proof -;
  from A1 show ?thesis
    using group0_2_L1 monoid0.Group_ZF_2_1_T1 monoid0_def
    by simp;
qed;

text{*The compostion of a function $f:X\rightarrow G$ with the group inverse
  is a right inverse for the lifted group. Recall that in the group0 context
  $e$ is the neutral element of the group.*}

lemma (in group0) Group_ZF_2_1_L5: 
  assumes A1:"F = f {lifted to function space over} X"
  and A2:"s : X\<rightarrow>G"
  and A3:"i = GroupInv(G,f) O s"
  shows "i: X\<rightarrow>G" "F`<s,i> = TheNeutralElement(X\<rightarrow>G,F)"
proof -;
  let ?E = "ConstantFunction(X,e)"
  have "?E : X\<rightarrow>G" 
    using group0_2_L2 func1_3_L1 by simp;
  moreover from groupAsssum A2 A3 A1 have
    "F`<s,i> :  X\<rightarrow>G" using group0_2_T2 comp_fun 
      Group_ZF_2_1_L4 monoid0.group0_1_L1
    by simp;
  moreover from groupAsssum A2 A3 A1 have 
    "\<forall>x\<in>X. (F`<s,i>)`(x) = ?E`(x)"
    using group0_2_T2 comp_fun Group_ZF_2_1_L3 
      comp_fun_apply apply_funtype group0_2_L6 func1_3_L2
    by simp;
  moreover from groupAsssum A1 have
    "?E = TheNeutralElement(X\<rightarrow>G,F)"
    using IsAgroup_def Group_ZF_2_1_L2 by simp;
  ultimately show "F`<s,i> = TheNeutralElement(X\<rightarrow>G,F)"
    using fun_extension_iff IsAgroup_def Group_ZF_2_1_L2
    by simp
  from groupAsssum A2 A3 show "i: X\<rightarrow>G" 
    using group0_2_T2 comp_fun by simp
qed;

text{*Groups can be lifted to the function space.*}

theorem (in group0) Group_ZF_2_1_T2:
  assumes A1:"F = f {lifted to function space over} X"
  shows "IsAgroup(X\<rightarrow>G,F)"
proof -;
  from A1 have "IsAmonoid(X\<rightarrow>G,F)"
    using group0_2_L1 monoid0.Group_ZF_2_1_T1
    by simp;
  moreover have 
    "\<forall>s\<in>X\<rightarrow>G. \<exists>i\<in>X\<rightarrow>G. F`<s,i> = TheNeutralElement(X\<rightarrow>G,F)"
  proof;
    fix s assume A2: "s : X\<rightarrow>G"
    let ?i = "GroupInv(G,f) O s"
    from groupAsssum A2 have "?i:X\<rightarrow>G"
      using group0_2_T2 comp_fun by simp;
    moreover from A1 A2 have 
      "F`<s,?i> = TheNeutralElement(X\<rightarrow>G,F)"
      using Group_ZF_2_1_L5 by fast;
   ultimately show "\<exists>i\<in>X\<rightarrow>G. F`<s,i> = TheNeutralElement(X\<rightarrow>G,F)" 
      by auto;
  qed;
  ultimately show ?thesis using IsAgroup_def
    by simp;
qed;

text{*What is the group inverse for the lifted group?*}

lemma (in group0) Group_ZF_2_1_L6: 
  assumes A1: "F = f {lifted to function space over} X"
  shows "\<forall>s\<in>(X\<rightarrow>G). GroupInv(X\<rightarrow>G,F)`(s) = GroupInv(G,f) O s"
proof -;
  from A1 have  "group0(X\<rightarrow>G,F)"
    using group0_def Group_ZF_2_1_T2 
    by simp;
  moreover from A1 have "\<forall>s\<in>X\<rightarrow>G. GroupInv(G,f) O s : X\<rightarrow>G \<and> 
    F`<s,GroupInv(G,f) O s> = TheNeutralElement(X\<rightarrow>G,F)"
    using Group_ZF_2_1_L5 by simp;
  ultimately have 
    "\<forall>s\<in>(X\<rightarrow>G).  GroupInv(G,f) O s = GroupInv(X\<rightarrow>G,F)`(s)"
    by (rule group0.group0_2_L9A);
  thus ?thesis by simp;
qed;

text{*What is the group inverse in a subgroup of the lifted group?*}

lemma (in group0) Group_ZF_2_1_L6A:
  assumes A1: "F = f {lifted to function space over} X"
  and A2: "IsAsubgroup(H,F)"
  and A3: "g = restrict(F,H\<times>H)"
  and A4: "s\<in>H"
  shows "GroupInv(H,g)`(s) = GroupInv(G,f) O s"
proof -;
  from A1 have T1: "group0(X\<rightarrow>G,F)"
    using group0_def Group_ZF_2_1_T2 
    by simp;
  with A2 A3 A4 have "GroupInv(H,g)`(s) = GroupInv(X\<rightarrow>G,F)`(s)"
    using group0.group0_3_T1 restrict by simp;
  moreover from T1 A1 A2 A4 have
    "GroupInv(X\<rightarrow>G,F)`(s) = GroupInv(G,f) O s"
    using group0.group0_3_L2 Group_ZF_2_1_L6 by blast;
  ultimately show ?thesis by simp;
qed;

(*lemma Group_ZF_2_1_L6: assumes A1:"IsAgroup(G,f)"
  and A2:"F = f {lifted to function space over} X"
  and A3:"s : X\<rightarrow>G"
  shows "GroupInv(X\<rightarrow>G,F)`(s) = GroupInv(G,f) O s"
proof -;
  from A1 have T1:"group0(G,f)"
    using group0_def by simp;
  from A1 A2 have "group0(X\<rightarrow>G,F)"
    using group0_def group0.Group_ZF_2_1_T2 
    by simp;
  moreover from A1 A3 have
    "s : X\<rightarrow>G"
    "GroupInv(G,f) O s : X\<rightarrow>G"
    using group0_2_T2 comp_fun
    by auto;
  moreover from T1 A2 A3 have
    "F`<s,GroupInv(G,f) O s> = TheNeutralElement(X\<rightarrow>G,F)"
    using group0.Group_ZF_2_1_L5 by simp;
  ultimately show ?thesis using group0.group0_2_L9
    by simp;
qed;*)

text{*If a group is abelian, then its lift to a function space is also 
  abelian.*}

lemma (in group0) Group_ZF_2_1_L7: 
  assumes A1:"F = f {lifted to function space over} X"
  and A2:"f {is commutative on} G"
  shows "F {is commutative on} (X\<rightarrow>G)"
proof-
  from A1 A2  have
    "F {is commutative on} (X\<rightarrow>range(f))"
    using group0_2_L3A func_ZF_2_L2
    by simp;
  moreover from groupAsssum have "range(f) = G"
    using group0_2_L1 monoid0.group0_1_L3B
    by simp;
  ultimately show ?thesis by simp;
qed;
    
section{*Equivalence relations on groups*}

text{*The goal of this section is to establish that (under some conditions) 
  given an equivalence
  relation on a group or (monoid )we can project the group (monoid)
  structure on the quotient and obtain another group.*}

text{*The neutral element class is neutral in the projection.*}

lemma (in monoid0) Group_ZF_2_2_L1: 
  assumes A1:"equiv(G,r)" and A2:"Congruent2(r,f)"
  and A3: "F = ProjFun2(G,r,f)" 
  and A4:"e = TheNeutralElement(G,f)"
  shows "r``{e} \<in> G//r \<and> 
  (\<forall>c \<in> G//r. F`<r``{e},c> = c \<and>  F`<c,r``{e}> = c)"
proof;
  from A4 show T1:"r``{e} \<in> G//r"
    using group0_1_L3 quotientI
    by simp;
  show 
    "\<forall>c \<in> G//r. F`<r``{e},c> = c \<and>  F`<c,r``{e}> = c"
  proof;
    fix c assume A5:"c \<in> G//r"
    then obtain g where D1:"g\<in>G" "c = r``{g}"
      using quotient_def by auto
    with A1 A2 A3 A4 D1 show 
      "F`<r``{e},c> = c \<and>  F`<c,r``{e}> = c"
      using group0_1_L3 EquivClass_1_L10 group0_1_L3
      by simp;
  qed;
qed;

text{*The projected structure is a monoid.*}

theorem (in monoid0) Group_ZF_2_2_T1:
  assumes A1:"equiv(G,r)" and A2:"Congruent2(r,f)"
  and A3: "F = ProjFun2(G,r,f)"
  shows "IsAmonoid(G//r,F)"
proof -
  let ?E = "r``{TheNeutralElement(G,f)}"
  from A1 A2 A3 have 
    "?E \<in> G//r \<and> (\<forall>c\<in>G//r. F`<?E,c> = c \<and> F`<c,?E> = c)"
    using Group_ZF_2_2_L1 by simp;
  hence
    "\<exists>E\<in>G//r. \<forall> c\<in>G//r. F`<E,c> = c \<and> F`<c,E> = c"
    by auto;
  with monoidAsssum A1 A2 A3 show ?thesis
    using IsAmonoid_def EquivClass_2_T2
    by simp;
qed;

text{*The class of the neutral element is the neutral element of the
  projected monoid.*}

lemma Group_ZF_2_2_L1:
  assumes A1:"IsAmonoid(G,f)"
  and A2:"equiv(G,r)" and A3:"Congruent2(r,f)"
  and A4: "F = ProjFun2(G,r,f)"
  and A5: "e = TheNeutralElement(G,f)"
  shows " r``{e} = TheNeutralElement(G//r,F)"
proof -;
  from A1 A2 A3 A4 have 
    T1:"monoid0(G,f)" and T2:"monoid0(G//r,F)"
    using monoid0_def monoid0.Group_ZF_2_2_T1 by auto;
  from T1 A2 A3 A4 A5 have "r``{e} \<in> G//r \<and> 
    (\<forall>c \<in> G//r. F`<r``{e},c> = c \<and>  F`<c,r``{e}> = c)"
    using monoid0.Group_ZF_2_2_L1 by simp;
  with T2 show ?thesis using monoid0.group0_1_L4
    by auto;
qed;

text{*The projected operation can be defined in terms of the group operation
  on representants in a natural way.*}

lemma (in group0) Group_ZF_2_2_L2:
  assumes A1:"equiv(G,r)" and A2:"Congruent2(r,f)"
  and A3:"F = ProjFun2(G,r,f)"
  and A4:"a\<in>G" "b\<in>G"
  shows "F`<r``{a},r``{b}> = r``{a\<cdot>b}"
proof -;
  from A1 A2 A3 A4 show ?thesis
    using EquivClass_1_L10 by simp;
qed;

text{*The class of the inverse is the right inverse of the class.*}

lemma (in group0) Group_ZF__2_2_L2:
  assumes A1:"equiv(G,r)" and A2:"Congruent2(r,f)"
  and A3:"F = ProjFun2(G,r,f)"
  and A4:"a\<in>G"
  shows "F`<r``{a},r``{a\<inverse>}> = TheNeutralElement(G//r,F)"
proof -;
  from A1 A2 A3 A4 have
    "F`<r``{a},r``{a\<inverse>}> = r``{e}"
    using group0_2_L5 Group_ZF_2_2_L2 group0_2_L6 
    by simp;
  with groupAsssum A1 A2 A3 show ?thesis
    using IsAgroup_def Group_ZF_2_2_L1 by simp;
qed;

text{*The group structure can be projected to the quotient space.*}

theorem (in group0) Group_ZF_3_T2:
  assumes A1:"equiv(G,r)" and A2:"Congruent2(r,f)"
  shows "IsAgroup(G//r,ProjFun2(G,r,f))"
proof -;
  let ?F = "ProjFun2(G,r,f)"
  let ?E = "TheNeutralElement(G//r,?F)"
  from groupAsssum A1 A2 have "IsAmonoid(G//r,?F)"
    using IsAgroup_def monoid0_def monoid0.Group_ZF_2_2_T1
    by simp;
  moreover have
    "\<forall>c\<in>G//r. \<exists>b\<in>G//r. ?F`<c,b> = ?E"
  proof;
    fix c assume A3:"c \<in> G//r"
    then obtain g where D1:"g\<in>G" "c = r``{g}"
      using quotient_def by auto;
    let ?b = "r``{g\<inverse>}"
    from D1 have "?b \<in> G//r"
      using group0_2_L5 quotientI
      by simp;
    moreover from A1 A2 D1 have 
      "?F`<c,?b> = ?E"
      using Group_ZF__2_2_L2 by simp;
    ultimately show "\<exists>b\<in>G//r. ?F`<c,b> = ?E"
      by auto;
  qed;
  ultimately show ?thesis
    using IsAgroup_def by simp;
qed;

section{*Normal subgroups and quotient groups*}

text{*A normal subgrup $N$ of a group $G$ is such that $aba^{-1}$ belongs to 
  $N$ if $a\in G, b\in N$. Having a group and a normal subgroup $N$ 
  we can create another group
  consisting of eqivalence classes of the relation 
  $a\sim b \equiv a\cdot b^{-1} \in N$.  We will refer to this relation
  as the quotient group relation.*}

constdefs
  IsAnormalSubgroup :: "[i,i,i]\<Rightarrow>o"
  "IsAnormalSubgroup(G,f,N) == IsAsubgroup(N,f) \<and> 
  (\<forall>n\<in>N.\<forall>g\<in>G. f`< f`< g,n >,GroupInv(G,f)`(g) > \<in> N)"

  QuotientGroupRel :: "[i,i,i]\<Rightarrow>i"
  "QuotientGroupRel(G,f,H) == 
  {<a,b> \<in> G\<times>G. f`<a, GroupInv(G,f)`(b)> \<in> H}"

  QuotientGroupOp :: "[i,i,i]\<Rightarrow>i"
  "QuotientGroupOp(G,f,H) == ProjFun2(G,QuotientGroupRel(G,f,H ),f)";

text{*Definition of a normal subgroup in a more readable notation.*}

lemma (in group0) Group_ZF_2_4_L0: 
  assumes A1:"IsAnormalSubgroup(G,f,H)"
  and A2:"g\<in>G" "n\<in>H"
  shows "g\<cdot>n\<cdot>g\<inverse> \<in> H"
proof -; 
  from A1 A2 show ?thesis using IsAnormalSubgroup_def
    by simp;
qed;


text{*The quotient group relation is reflexive.*}

lemma (in group0) Group_ZF_2_4_L1: 
  assumes A1:"IsAsubgroup(H,f)"
  shows "refl(G,QuotientGroupRel(G,f,H))"
proof -;
  from A1 show ?thesis
    using group0_2_L6 group0_3_L5 
    QuotientGroupRel_def refl_def
    by simp;
qed;

text{*The quotient group relation is symmetric.*}

lemma (in group0) Group_ZF_2_4_L2:
  assumes A1:"IsAsubgroup(H,f)"
  shows "sym(QuotientGroupRel(G,f,H))"
proof -;
  have "\<forall>a b. <a,b> \<in> QuotientGroupRel(G,f,H) \<longrightarrow>
    <b,a> \<in> QuotientGroupRel(G,f,H)"
  proof (rule double_forall_implies);
    fix a b assume A2:"<a,b> \<in> QuotientGroupRel(G,f,H)"
    with A1 have "(a\<cdot>b\<inverse>)\<inverse> \<in> H" 
      using QuotientGroupRel_def group0_3_T3A
      by simp;
    moreover from A2 have "(a\<cdot>b\<inverse>)\<inverse> =  b\<cdot>a\<inverse>"
      using QuotientGroupRel_def group0_2_L12
      by simp;
    ultimately have "b\<cdot>a\<inverse> \<in> H" by simp;
    with A2 show "<b,a> \<in> QuotientGroupRel(G,f,H)"
      using QuotientGroupRel_def by simp;
  qed
  then show ?thesis using symI by simp;
qed;

text{*The quotient group relation is transistive.*}

lemma (in group0) Group_ZF_2_4_L3A:
  assumes A1:"IsAsubgroup(H,f)"
  and A2:"<a,b> \<in> QuotientGroupRel(G,f,H)"
  and A3:"<b,c> \<in> QuotientGroupRel(G,f,H)"
  shows "<a,c> \<in> QuotientGroupRel(G,f,H)"
proof -;
  let ?r = "QuotientGroupRel(G,f,H)"
  from A2 A3 have T1:"a\<in>G" "b\<in>G" "c\<in>G"
    using QuotientGroupRel_def by auto
  from A1 A2 A3 have "(a\<cdot>b\<inverse>)\<cdot>(b\<cdot>c\<inverse>) \<in> H"
    using  QuotientGroupRel_def group0_3_L6
    by simp;
  moreover from T1 have 
    "a\<cdot>c\<inverse> = (a\<cdot>b\<inverse>)\<cdot>(b\<cdot>c\<inverse>)"
    using group0_2_L14A by blast;
  ultimately have "a\<cdot>c\<inverse> \<in> H" 
    by simp;
  with T1 show ?thesis using QuotientGroupRel_def
    by simp;
qed;

text{*The quotient group relation is an equivalence relation. Note
  we do not need the subgroup to be normal for this to be true.*}

lemma (in group0) Group_ZF_2_4_L3: assumes A1:"IsAsubgroup(H,f)"
  shows "equiv(G,QuotientGroupRel(G,f,H))"
proof -;
  let ?r = "QuotientGroupRel(G,f,H)"
  from A1 have 
     "\<forall>a b c. (\<langle>a, b\<rangle> \<in> ?r  \<and>  \<langle>b, c\<rangle> \<in> ?r \<longrightarrow> \<langle>a, c\<rangle> \<in> ?r)"
    using Group_ZF_2_4_L3A by blast;
  then have "trans(?r)"
    using Fol1_L2 by blast;
  with A1 show ?thesis 
    using Group_ZF_2_4_L1 Group_ZF_2_4_L2 
      QuotientGroupRel_def equiv_def
    by auto;
qed;

text{*The next lemma states the essential condition for congruency of 
  the group operation with respect to the quotient group relation.*}

lemma (in group0) Group_ZF_2_4_L4: 
  assumes A1:"IsAnormalSubgroup(G,f,H)"
  and A2:"<a1,a2> \<in> QuotientGroupRel(G,f,H)"
  and A3:"<b1,b2> \<in> QuotientGroupRel(G,f,H)"
  shows "<a1\<cdot>b1, a2\<cdot>b2> \<in> QuotientGroupRel(G,f,H)"
proof -;
  from A2 A3 have T1:
    "a1\<in>G" "a2\<in>G" "b1\<in>G" "b2\<in>G"
    "a1\<cdot>b1 \<in> G" "a2\<cdot>b2 \<in> G"
    "b1\<cdot>b2\<inverse> \<in> H" "a1\<cdot>a2\<inverse> \<in> H"
    using QuotientGroupRel_def group0_2_L1 monoid0.group0_1_L1
    by auto;
  with A1 show ?thesis using
    IsAnormalSubgroup_def group0_3_L6 group0_2_L15
    QuotientGroupRel_def by simp;
qed;

text{*If the subgroup is normal, the group operation is congruent 
  with respect to the quotient group relation.*}

lemma Group_ZF_2_4_L5A:
  assumes A1: "IsAgroup(G,f)"
  and A2: "IsAnormalSubgroup(G,f,H)" 
  shows "Congruent2(QuotientGroupRel(G,f,H),f)"
proof - 
  from A1 A2 show ?thesis using
    group0_def group0.Group_ZF_2_4_L4 Congruent2_def
    by simp;
qed;

text{*The quotient group is indeed a group.*}

theorem Group_ZF_2_4_T1:
  assumes A1:"IsAgroup(G,f)"
  and A2:"IsAnormalSubgroup(G,f,H)"
  shows   
  "IsAgroup(G//QuotientGroupRel(G,f,H),QuotientGroupOp(G,f,H))"
proof -;
  from A1 A2 show ?thesis using
    group0_def group0.Group_ZF_2_4_L3 IsAnormalSubgroup_def
    Group_ZF_2_4_L5A group0.Group_ZF_3_T2 QuotientGroupOp_def
    by simp;
qed;


text{*Essential condition to show that every subgroup of an abelian group 
  is normal.*}

lemma (in group0) Group_ZF_2_4_L5:
  assumes A1:"f {is commutative on} G" 
  and A2:"IsAsubgroup(H,f)"
  and A3:"g\<in>G" "h\<in>H" 
  shows "g\<cdot>h\<cdot>g\<inverse> \<in> H"
proof -;
  from A2 A3 have T1:"h\<in>G" "g\<inverse> \<in> G" 
    using group0_3_L2 group0_2_L5 by auto;
  with A3 A1 have "g\<cdot>h\<cdot>g\<inverse> = g\<inverse>\<cdot>g\<cdot>h"
    using group0_4_L4A by simp;
  with A3 T1 show ?thesis using
    group0_2_L6 group0_2_L2
    by simp;
qed;

text{*Every subgroup of an abelian group is normal. Moreover, the quotient
  group is also abelian.*}

lemma Group_ZF_2_4_L6:
  assumes A1: "IsAgroup(G,f)"
  and A2:"f {is commutative on} G" 
  and A3:"IsAsubgroup(H,f)"
  shows "IsAnormalSubgroup(G,f,H)"
  "QuotientGroupOp(G,f,H) {is commutative on} (G//QuotientGroupRel(G,f,H))"
proof -;
  from A1 A2 A3 show T1: "IsAnormalSubgroup(G,f,H)" using
    group0_def IsAnormalSubgroup_def group0.Group_ZF_2_4_L5 
    by simp;
  let ?r = "QuotientGroupRel(G,f,H)"
  from A1 A3 T1 have "equiv(G,?r)" "Congruent2(?r,f)"
    using group0_def group0.Group_ZF_2_4_L3 Group_ZF_2_4_L5A
    by auto;
  with A2 show 
    "QuotientGroupOp(G,f,H) {is commutative on} (G//QuotientGroupRel(G,f,H))"
    using EquivClass_2_T1 QuotientGroupOp_def
    by simp;
qed;

section{*Function spaces as monoids*}

text{*On every space of functions $\{f : X\rightarrow X\}$ 
  we can define a natural 
  monoid structure with composition as the operation. This section explores 
  this fact.*}

text{*The next lemma states that composition has a neutral element, 
  namely the identity function on $X$ 
  (the one that maps $x\in X$ into itself).*}

(*lemma Group_ZF_2_5_L1A: 
  assumes A1: "F = Composition(X)" "I = IdentityFunction(X)"
  shows "I\<in>(X\<rightarrow>X) \<and> (\<forall>f\<in>(X\<rightarrow>X). F`<I,f> = f \<and> F`<f,I> = f)"
proof-
  from A1 show ?thesis using func1_8_L1 func_ZF_5_L3
    by simp;
qed;*)
  
lemma Group_ZF_2_5_L1: assumes A1: "F = Composition(X)"
  shows "\<exists>I\<in>(X\<rightarrow>X). \<forall>f\<in>(X\<rightarrow>X). F`<I,f> = f \<and> F`<f,I> = f"
proof-;
  let ?I = "id(X)"
  from A1 have 
    "?I \<in> X\<rightarrow>X \<and> (\<forall>f\<in>(X\<rightarrow>X). F`<?I,f> = f \<and> F`<f,?I> = f)" 
    using id_type func_ZF_6_L1A by simp;
  thus ?thesis by auto;
qed;

text{*The space of functions that map a set $X$ into 
  itsef is a monoid with composition as operation and the identity function
  as the neutral element.*}

lemma Group_ZF_2_5_L2: "IsAmonoid(X\<rightarrow>X,Composition(X))"
  "id(X) = TheNeutralElement(X\<rightarrow>X,Composition(X))"
proof -;
  let ?I = "id(X)"
  let ?F = "Composition(X)"
  show "IsAmonoid(X\<rightarrow>X,Composition(X))" 
    using func_ZF_5_L5 Group_ZF_2_5_L1 IsAmonoid_def
    by auto;  
  then have "monoid0(X\<rightarrow>X,?F)"
    using monoid0_def by simp;
  moreover have
    "?I \<in> X\<rightarrow>X \<and> (\<forall>f\<in>(X\<rightarrow>X). ?F`<?I,f> = f \<and> ?F`<f,?I> = f)"
    using id_type func_ZF_6_L1A by simp;
  ultimately show "?I = TheNeutralElement(X\<rightarrow>X,?F)"
    using monoid0.group0_1_L4 by auto;
qed;

text{*This concludes Group\_ZF\_2.thy.*}

end;