(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Group\_ZF\_1.thy}*}

theory Group_ZF_1 = Group_ZF + Finite1 + Int:

section{*Integers as a group.*}

text{*In this section we prove that integers defined in Int.thy form a group
  under addition.
  *}

constdefs
  IntegerAddition :: "i"
  "IntegerAddition == { <x,c> \<in> (int\<times>int)\<times>int. fst(x) $+ snd(x) = c}";

text{*IntegerAddition is a function on int$\times$int.*}

lemma group1_1_L1: shows "IntegerAddition \<in> int\<times>int \<rightarrow> int"
proof -;
  have
    "{<x,c> \<in> (int\<times>int)\<times>int. fst(x) $+ snd(x) = c} \<in> int\<times>int\<rightarrow>int" 
    using func1_1_L11A by simp;
  then show ?thesis using IntegerAddition_def by simp;
qed;

text{*IntegerAddition adds integers.*}

lemma group1_1_L2: assumes A1:"a \<in> int" "b \<in> int"
  shows "IntegerAddition`(<a,b>) = a $+ b"
proof -;
  let ?x = "<a,b>"
  let ?c = "a $+ b"
  from A1 have "fst(?x) $+ snd(?x) = ?c" by simp;
  with A1 have 
    "<?x,?c> \<in> {<x,c> \<in> (int\<times>int)\<times>int. fst(x) $+ snd(x) = c}"
    by simp;
  then show "IntegerAddition`(?x) = ?c"
    using IntegerAddition_def group1_1_L1 apply_iff by simp;
qed;
 

text{*Integer addition is associative.*}

lemma group1_1_L3: 
  assumes A1:"x \<in> int" "y\<in>int" "z\<in>int"
  shows "IntegerAddition`(<IntegerAddition`(<x,y>),z>) = 
  IntegerAddition`( < x,IntegerAddition`(<y,z>)> )"
proof -;
  from A1 show ?thesis using 
     group1_1_L2 zadd_assoc by simp;
qed;

text{*Integer addition is commutative.*}

lemma group1_1_L4:
  assumes A1:"x \<in> int" "y\<in>int"
  shows "IntegerAddition` <x,y> = IntegerAddition` <y,x>"
proof -;
  from A1 show ?thesis using 
     group1_1_L2 zadd_commute by simp;
qed;

text{*Zero is neutral for addition.*}

lemma group1_1_L5: assumes A1:"x \<in> int"
  shows "(IntegerAddition` (< ($# 0), x >) = x) &
   (IntegerAddition` (< x ,($# 0) >) = x)";
proof -;
  from A1 show ?thesis using 
    group1_1_L2 zadd_int0 group1_1_L4 by simp;
qed;

text{*Zero is neutral for addition - different form..*}

lemma group1_1_L6: 
  shows "($# 0) \<in> int & 
  (\<forall>x \<in> int.(IntegerAddition` (< ($# 0), x >) = x) &
  (IntegerAddition` (< x ,($# 0) >) = x))"
proof -;
  show ?thesis using group1_1_L5 by simp;
qed;

text{*Integers with addition form a monoid.*}
 
theorem  group1_1_T1: shows "IsAmonoid(int,IntegerAddition)"
proof -
  have 
    "\<exists>e \<in> int. (\<forall>x \<in> int.(IntegerAddition` (< e, x >) = x) &
   (IntegerAddition` (< x ,e >) = x))" 
    using  group1_1_L6 exI by fast;
  then show ?thesis using 
    IsAmonoid_def IsAssociative_def group1_1_L1 group1_1_L3 
    by simp;
qed;

text{*We can use theorems proven in the monoid0 context.*}

lemma group1_1_L7: shows "monoid0(int,IntegerAddition)"
proof -; 
  show ?thesis using group1_1_T1 monoid0_def by simp;
qed;

text{*Zero is the neutral element of the integers with addition.*}

lemma group1_1_L8: "($# 0) = TheNeutralElement(int,IntegerAddition)"
proof -;
  have "monoid0(int,IntegerAddition)" using group1_1_L7 
    by simp;
  moreover  have 
    "($# 0) \<in> int & 
    (\<forall>x \<in> int.(IntegerAddition` (< ($# 0), x >) = x) &
    (IntegerAddition` (< x ,($# 0) >) = x))"
    using group1_1_L5 by simp;
  ultimately show ?thesis by (rule monoid0.group0_1_L4)
qed;

text{*Each integer has an inverse (in the addition sense).*}

lemma group1_1_L9: assumes A1:"g \<in> int"
  shows 
  "\<exists> b \<in> int. IntegerAddition`<g,b> = 
  TheNeutralElement(int,IntegerAddition)"
proof -;
  from A1 have "IntegerAddition`<g,$-g> = 
    TheNeutralElement(int,IntegerAddition)"
    using group1_1_L2 group1_1_L8 by simp;
  thus ?thesis by auto;
qed;

text{*Integers with addition form an abelian group.*}
 
theorem  group1_1_T1: 
  shows "IsAgroup(int,IntegerAddition)"
  "IntegerAddition {is commutative on} int"
proof -;
  show "IsAgroup(int,IntegerAddition)"
    using group1_1_T1 group1_1_L9 IsAgroup_def
    by simp;
  show "IntegerAddition {is commutative on} int"
    using group1_1_L4 IsCommutative_def by simp;
qed;
end






 
