(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{IntDiv\_ZF.thy}*}

theory IntDiv_ZF imports Int_ZF IntDiv

begin

text{*This theory translates some results form the Isabelle's 
  @{text "IntDiv.thy"} theory to the notation used by IsarMathLib.*}

section{*Quotient and reminder*}

text{*For any integers $m,n$ , $n>0$ there are unique integers $q,p$
  such that $0\leq p < n$ and $m = n\cdot q + p$. Number $p$ in this 
  decompsition is usually called $m$ mod $n$. Standard Isabelle denotes numbers
  $q,p$ as @{text "m zdiv n"} and @{text "m zmod n"}, resp., 
  and we will use the same notation. *}

text{*The next lemma is sometimes called the "quotient-reminder theorem".*}

lemma (in int0) IntDiv_ZF_1_L1: assumes A1: "m\<in>\<int>"  "n\<in>\<int>"
  shows "m = n\<cdot>(m zdiv n) \<ra> (m zmod n)"
  using prems Int_ZF_1_L2 raw_zmod_zdiv_equality
  by simp;

text{*If $n>0$ then @{text "m zmod n"} is between $0$ and $n-1$.*}

lemma (in int0) IntDiv_ZF_1_L2: 
  assumes A1: "m\<in>\<int>" and A2: "\<zero>\<lsq>n"  "n\<noteq>\<zero>"
  shows 
  "\<zero> \<lsq> m zmod n"  
  "m zmod n \<lsq> n"  "m zmod n \<noteq> n" 
  "m zmod n \<lsq> n\<rs>\<one>"
proof -
  from A2 have T: "n \<in> \<int>"
    using Int_ZF_2_L1A by simp;
  from A2 have "#0 $< n" using Int_ZF_2_L9 Int_ZF_1_L8 
    by auto;
  with T show 
    "\<zero> \<lsq> m zmod n"  
    "m zmod n \<lsq> n"  
    "m zmod n \<noteq> n" 
    using pos_mod Int_ZF_1_L8 Int_ZF_1_L8A zmod_type 
      Int_ZF_2_L1 Int_ZF_2_L9AA 
    by auto;
  then show "m zmod n \<lsq> n\<rs>\<one>"
    using Int_ZF_4_L1B by auto;
qed;
  
  
 
  
  

  
 
  
