/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MultipleSearchPattern;

public class TypeReferencePattern
extends MultipleSearchPattern {
    private char[] qualification;
    private char[] simpleName;
    private char[] decodedSimpleName;
    private static char[][] TAGS = new char[][]{IIndexConstants.TYPE_REF, IIndexConstants.SUPER_REF, IIndexConstants.REF, IIndexConstants.CONSTRUCTOR_REF};
    private static char[][] REF_TAGS = new char[][]{IIndexConstants.REF};
    private char[][] segments;
    private int currentSegment;
    private char[] decodedSegment;

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        this.qualification = isCaseSensitive ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase(simpleName);
        if (simpleName == null) {
            this.segments = this.qualification == null ? IIndexConstants.ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification);
        }
        this.needsResolve = true;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int tagLength = this.currentTag.length;
        int nameLength = CharOperation.indexOf('/', word, tagLength);
        if (nameLength < 0) {
            nameLength = size;
        }
        if (this.simpleName == null) {
            this.decodedSegment = CharOperation.subarray(word, tagLength, nameLength);
        } else {
            this.decodedSimpleName = CharOperation.subarray(word, tagLength, nameLength);
        }
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        if (this.currentTag == IIndexConstants.REF) {
            this.foundAmbiguousIndexMatches = true;
        }
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file;
            int reference = references[i];
            if (reference != -1 && (file = input.getIndexedFile(reference)) != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptTypeReference(path, this.decodedSimpleName);
            }
            ++i;
        }
    }

    protected char[][] getPossibleTags() {
        if (this.simpleName == null) {
            return REF_TAGS;
        }
        return TAGS;
    }

    protected boolean hasNextQuery() {
        if (this.simpleName == null) {
            if (this.segments.length > 2) {
                return --this.currentSegment >= 2;
            }
            return --this.currentSegment >= 0;
        }
        return false;
    }

    public char[] indexEntryPrefix() {
        if (this.simpleName == null) {
            return AbstractIndexer.bestReferencePrefix(IIndexConstants.REF, this.segments[this.currentSegment], this.matchMode, this.isCaseSensitive);
        }
        return AbstractIndexer.bestReferencePrefix(this.currentTag, this.simpleName, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 15;
    }

    protected boolean matchIndexEntry() {
        block14: {
            block13: {
                if (this.simpleName != null) break block13;
                switch (this.matchMode) {
                    case 0: {
                        if (!CharOperation.equals(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) {
                            return false;
                        }
                        break block14;
                    }
                    case 1: {
                        if (!CharOperation.prefixEquals(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) {
                            return false;
                        }
                        break block14;
                    }
                    case 2: {
                        if (!CharOperation.match(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) {
                            return false;
                        } else {
                            break;
                        }
                    }
                }
                break block14;
            }
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected void matchReportReference(AstNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (reference instanceof QualifiedNameReference) {
            this.matchReportReference((QualifiedNameReference)reference, element, accuracy, locator);
        } else if (reference instanceof QualifiedTypeReference) {
            this.matchReportReference((QualifiedTypeReference)reference, element, accuracy, locator);
        } else if (reference instanceof ArrayTypeReference) {
            this.matchReportReference((ArrayTypeReference)reference, element, accuracy, locator);
        } else {
            super.matchReportReference(reference, element, accuracy, locator);
        }
    }

    protected void matchReportReference(QualifiedNameReference qNameRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        Object tokens = null;
        Binding binding = qNameRef.binding;
        TypeBinding typeBinding = null;
        char[][] nameTokens = qNameRef.tokens;
        int lastIndex = nameTokens.length - 1;
        switch (qNameRef.bits & 7) {
            case 1: {
                typeBinding = qNameRef.actualReceiverType;
                int otherBindingsCount = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
                lastIndex -= otherBindingsCount + 1;
                break;
            }
            case 4: {
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding pbBinding = (ProblemBinding)binding;
                typeBinding = pbBinding.searchType;
                char[] partialQualifiedName = pbBinding.name;
                lastIndex = CharOperation.occurencesOf('.', partialQualifiedName) - 1;
            }
        }
        while (typeBinding != null && lastIndex >= 0) {
            int level;
            if (this.matchesName(this.simpleName, nameTokens[lastIndex--]) && (level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding)) != 0) {
                tokens = new char[lastIndex + 2][];
                System.arraycopy(nameTokens, 0, tokens, 0, lastIndex + 2);
                break;
            }
            typeBinding = typeBinding instanceof ReferenceBinding ? ((ReferenceBinding)typeBinding).enclosingType() : null;
        }
        if (tokens == null) {
            tokens = binding == null || binding instanceof ProblemBinding ? (Object)new char[][]{this.simpleName} : qNameRef.tokens;
            if (!this.isCaseSensitive) {
                int length = ((char[][])tokens).length;
                char[][] lowerCaseTokens = new char[length][];
                int i = 0;
                while (i < length) {
                    char[] token = tokens[i];
                    lowerCaseTokens[i] = CharOperation.toLowerCase(token);
                    ++i;
                }
                tokens = lowerCaseTokens;
            }
        }
        locator.reportAccurateReference(qNameRef.sourceStart, qNameRef.sourceEnd, (char[][])tokens, element, accuracy);
    }

    protected void matchReportReference(QualifiedTypeReference qTypeRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        Object tokens = null;
        TypeBinding typeBinding = qTypeRef.resolvedType;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        char[][] typeTokens = qTypeRef.tokens;
        int lastIndex = typeTokens.length - 1;
        while (typeBinding != null && lastIndex >= 0) {
            int level;
            if (this.matchesName(this.simpleName, typeTokens[lastIndex--]) && (level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding)) != 0) {
                tokens = new char[lastIndex + 2][];
                System.arraycopy(typeTokens, 0, tokens, 0, lastIndex + 2);
                break;
            }
            typeBinding = typeBinding instanceof ReferenceBinding ? ((ReferenceBinding)typeBinding).enclosingType() : null;
        }
        if (tokens == null) {
            tokens = typeBinding == null || typeBinding instanceof ProblemReferenceBinding ? (Object)new char[][]{this.simpleName} : qTypeRef.tokens;
            if (!this.isCaseSensitive) {
                int length = ((char[][])tokens).length;
                char[][] lowerCaseTokens = new char[length][];
                int i = 0;
                while (i < length) {
                    char[] token = tokens[i];
                    lowerCaseTokens[i] = CharOperation.toLowerCase(token);
                    ++i;
                }
                tokens = lowerCaseTokens;
            }
        }
        locator.reportAccurateReference(qTypeRef.sourceStart, qTypeRef.sourceEnd, (char[][])tokens, element, accuracy);
    }

    protected void resetQuery() {
        if (this.simpleName == null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("TypeReferencePattern: pkg<");
        if (this.qualification != null) {
            buffer.append(this.qualification);
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (node instanceof TypeReference) {
            return this.matchLevel((TypeReference)node, resolve);
        }
        if (node instanceof NameReference) {
            return this.matchLevel((NameReference)node, resolve);
        }
        if (node instanceof ImportReference) {
            return this.matchLevel((ImportReference)node, resolve);
        }
        return 0;
    }

    private int matchLevel(ImportReference importRef, boolean resolve) {
        char[][] tokens = importRef.tokens;
        int importLength = tokens.length;
        if (this.qualification != null) {
            char[] pattern = this.simpleName == null ? this.qualification : CharOperation.concat(this.qualification, this.simpleName, '.');
            char[] qualifiedTypeName = CharOperation.concatWith(importRef.tokens, '.');
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (!CharOperation.prefixEquals(pattern, qualifiedTypeName, this.isCaseSensitive)) break;
                    return 1;
                }
                case 2: {
                    if (!CharOperation.match(pattern, qualifiedTypeName, this.isCaseSensitive)) break;
                    return 1;
                }
            }
            return 0;
        }
        if (this.simpleName == null) {
            return this.needsResolve ? 1 : 2;
        }
        int i = 0;
        while (i < importLength) {
            if (this.matchesName(this.simpleName, tokens[i])) {
                return this.needsResolve ? 1 : 2;
            }
            ++i;
        }
        return 0;
    }

    private int matchLevel(NameReference nameRef, boolean resolve) {
        if (!resolve) {
            if (this.simpleName == null) {
                return this.needsResolve ? 1 : 2;
            }
            if (nameRef instanceof SingleNameReference) {
                if (this.matchesName(this.simpleName, ((SingleNameReference)nameRef).token)) {
                    return 1;
                }
                return 0;
            }
            char[][] tokens = ((QualifiedNameReference)nameRef).tokens;
            int i = 0;
            int max = tokens.length;
            while (i < max) {
                if (this.matchesName(this.simpleName, tokens[i])) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        Binding binding = nameRef.binding;
        if (nameRef instanceof SingleNameReference) {
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).original;
            }
            if (binding instanceof VariableBinding) {
                return 0;
            }
            if (!(binding instanceof TypeBinding)) {
                return 3;
            }
            return this.matchLevelForType(this.simpleName, this.qualification, (TypeBinding)binding);
        }
        TypeBinding typeBinding = null;
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        char[][] tokens = qNameRef.tokens;
        int lastIndex = tokens.length - 1;
        switch (qNameRef.bits & 7) {
            case 1: {
                int otherBindingsCount;
                typeBinding = nameRef.actualReceiverType;
                int n = otherBindingsCount = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
                if ((lastIndex -= otherBindingsCount + 1) >= 0) break;
                return 0;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (binding instanceof ProblemReferenceBinding) {
                    binding = ((ProblemReferenceBinding)binding).original;
                }
                if (!(binding instanceof TypeBinding)) {
                    return 3;
                }
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                Object partialQualifiedName;
                Binding pbBinding;
                if (binding instanceof ProblemBinding) {
                    pbBinding = (ProblemBinding)binding;
                    typeBinding = pbBinding.searchType;
                    partialQualifiedName = pbBinding.name;
                    lastIndex = CharOperation.occurencesOf('.', partialQualifiedName) - 1;
                    if (typeBinding != null && lastIndex >= 0) break;
                    return 3;
                }
                if (!(binding instanceof ProblemReferenceBinding)) break;
                pbBinding = (ProblemReferenceBinding)binding;
                binding = ((ProblemReferenceBinding)pbBinding).original;
                if (!(binding instanceof TypeBinding)) {
                    return 3;
                }
                typeBinding = (TypeBinding)binding;
                partialQualifiedName = ((ReferenceBinding)pbBinding).compoundName;
                int n = lastIndex = partialQualifiedName == null ? -1 : ((char[])partialQualifiedName).length - 1;
                if (typeBinding != null && lastIndex >= 0) break;
                return 3;
            }
        }
        while (typeBinding != null && lastIndex >= 0) {
            int level;
            if (this.matchesName(this.simpleName, tokens[lastIndex--]) && (level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding)) != 0) {
                return level;
            }
            typeBinding = typeBinding instanceof ReferenceBinding ? ((ReferenceBinding)typeBinding).enclosingType() : null;
        }
        return 0;
    }

    protected void matchReportReference(ArrayTypeReference arrayRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        Object object;
        if (this.simpleName == null) {
            object = CharOperation.NO_CHAR_CHAR;
        } else {
            char[][] cArrayArray = new char[1][];
            object = cArrayArray;
            cArrayArray[0] = this.simpleName;
        }
        char[][] tokens = object;
        locator.reportAccurateReference(arrayRef.sourceStart, arrayRef.sourceEnd, tokens, element, accuracy);
    }

    private int matchLevel(TypeReference typeRef, boolean resolve) {
        if (!resolve) {
            if (this.simpleName == null) {
                return this.needsResolve ? 1 : 2;
            }
            if (typeRef instanceof SingleTypeReference) {
                if (this.matchesName(this.simpleName, ((SingleTypeReference)typeRef).token)) {
                    return this.needsResolve ? 1 : 2;
                }
                return 0;
            }
            char[][] tokens = ((QualifiedTypeReference)typeRef).tokens;
            int i = 0;
            int max = tokens.length;
            while (i < max) {
                if (this.matchesName(this.simpleName, tokens[i])) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        TypeBinding typeBinding = typeRef.resolvedType;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            Binding binding = ((ProblemReferenceBinding)typeBinding).original;
            if (binding instanceof TypeBinding) {
                typeBinding = (TypeBinding)binding;
            } else if (binding == null) {
                typeBinding = null;
            }
        }
        if (typeBinding == null) {
            return 3;
        }
        if (typeRef instanceof SingleTypeReference) {
            return this.matchLevelForType(this.simpleName, this.qualification, typeBinding);
        }
        QualifiedTypeReference qTypeRef = (QualifiedTypeReference)typeRef;
        char[][] tokens = qTypeRef.tokens;
        int lastIndex = tokens.length - 1;
        while (typeBinding != null && lastIndex >= 0) {
            int level;
            if (this.matchesName(this.simpleName, tokens[lastIndex--]) && (level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding)) != 0) {
                return level;
            }
            typeBinding = typeBinding instanceof ReferenceBinding ? ((ReferenceBinding)typeBinding).enclosingType() : null;
        }
        return 0;
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        ReferenceBinding typeBinding = null;
        Object tokens = null;
        if (binding instanceof ReferenceBinding) {
            typeBinding = (ReferenceBinding)binding;
        }
        char[][] typeTokens = importRef.tokens;
        int lastIndex = typeTokens.length - 1;
        while (typeBinding != null && lastIndex >= 0) {
            int level;
            if (this.matchesName(this.simpleName, typeTokens[lastIndex--]) && (level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding)) != 0) {
                tokens = new char[lastIndex + 2][];
                System.arraycopy(typeTokens, 0, tokens, 0, lastIndex + 2);
                break;
            }
            typeBinding = typeBinding instanceof ReferenceBinding ? typeBinding.enclosingType() : null;
        }
        if (tokens == null) {
            tokens = typeBinding == null || typeBinding instanceof ProblemReferenceBinding ? (Object)new char[][]{this.simpleName} : importRef.tokens;
            if (!this.isCaseSensitive) {
                int length = ((char[][])tokens).length;
                char[][] lowerCaseTokens = new char[length][];
                int i = 0;
                while (i < length) {
                    char[] token = tokens[i];
                    lowerCaseTokens[i] = CharOperation.toLowerCase(token);
                    ++i;
                }
                tokens = lowerCaseTokens;
            }
        }
        locator.reportAccurateReference(importRef.sourceStart, importRef.sourceEnd, (char[][])tokens, element, accuracy);
    }

    /*
     * Unable to fully structure code
     */
    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        typeBinding = (TypeBinding)binding;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (!(typeBinding instanceof ProblemReferenceBinding)) ** GOTO lbl14
        return 3;
lbl-1000:
        // 1 sources

        {
            level = this.matchLevelForType(this.simpleName, this.qualification, typeBinding);
            if (level != 0) {
                return level;
            }
            typeBinding = typeBinding instanceof ReferenceBinding != false ? ((ReferenceBinding)typeBinding).enclosingType() : null;
lbl14:
            // 2 sources

            ** while (typeBinding != null)
        }
lbl15:
        // 1 sources

        return 0;
    }
}

