/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.TypeVector;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    static final byte VERSION = 0;
    static final byte SEPARATOR1 = 10;
    static final byte SEPARATOR2 = 44;
    static final byte SEPARATOR3 = 62;
    static final byte SEPARATOR4 = 13;
    static final byte COMPUTE_SUBTYPES = 1;
    static final byte CLASS = 0;
    static final byte INTERFACE = 1;
    static final byte COMPUTED_FOR = 2;
    static final byte ROOT = 4;
    static final byte[] NO_FLAGS = new byte[0];
    static final int SIZE = 10;
    protected IJavaProject project;
    protected IType type;
    protected Map classToSuperclass;
    protected Map typeToSuperInterfaces;
    protected Map typeToSubtypes;
    protected Map typeFlags;
    protected TypeVector rootClasses = new TypeVector();
    protected ArrayList interfaces = new ArrayList(10);
    public ArrayList missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected IProgressMonitor progressMonitor = null;
    protected ArrayList changeListeners = null;
    protected Map files = null;
    protected Region packageRegion = null;
    protected Region rootRegion = null;
    protected Region projectRegion = null;
    protected boolean isActivated = false;
    protected boolean exists = true;
    protected boolean computeSubtypes;
    IJavaSearchScope scope;

    public TypeHierarchy() throws JavaModelException {
    }

    public TypeHierarchy(IType type, IJavaProject project, boolean computeSubtypes) throws JavaModelException {
        this(type, SearchEngine.createJavaSearchScope(new IJavaElement[]{project}), computeSubtypes);
        this.project = project;
    }

    public TypeHierarchy(IType type, IJavaSearchScope scope, boolean computeSubtypes) throws JavaModelException {
        this.type = type;
        this.computeSubtypes = computeSubtypes;
        this.scope = scope;
    }

    protected void activate() {
        this.files = new HashMap(5);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.rootRegion = new Region();
        IType[] types = this.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            Openable o = (Openable)((JavaElement)((Object)type)).getOpenableParent();
            if (o != null) {
                this.files.put(o, o);
            }
            IPackageFragment pkg = type.getPackageFragment();
            this.packageRegion.add(pkg);
            this.rootRegion.add(pkg.getParent());
            IJavaProject project = type.getJavaProject();
            if (project != null) {
                this.projectRegion.add(project);
            }
            this.checkCanceled();
            ++i;
        }
        JavaCore.addElementChangedListener(this);
        this.isActivated = true;
    }

    private void addAllCheckingDuplicates(ArrayList list, IType[] collection) {
        int i = 0;
        while (i < collection.length) {
            IType element = collection[i];
            if (!list.contains(element)) {
                list.add(element);
            }
            ++i;
        }
    }

    protected void addInterface(IType type) {
        this.interfaces.add(type);
    }

    protected void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    protected void addSubtype(IType type, IType subtype) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            subtypes = new TypeVector();
            this.typeToSubtypes.put(type, subtypes);
        }
        if (!subtypes.contains(subtype)) {
            subtypes.add(subtype);
        }
    }

    public void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
            if (this.exists) {
                this.activate();
            }
        }
        if (this.changeListeners.indexOf(listener) == -1) {
            this.changeListeners.add(listener);
        }
    }

    private static Integer bytesToFlags(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return new Integer(new String(bytes));
        }
        return null;
    }

    public void cacheFlags(IType type, int flags) {
        this.typeFlags.put(type, new Integer(flags));
    }

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            this.classToSuperclass.put(type, superclass);
            this.addSubtype(superclass, type);
        }
    }

    protected void cacheSuperInterfaces(IType type, IType[] superinterfaces) {
        this.typeToSuperInterfaces.put(type, superinterfaces);
        int i = 0;
        while (i < superinterfaces.length) {
            IType superinterface = superinterfaces[i];
            if (superinterface != null) {
                this.addSubtype(superinterface, type);
            }
            ++i;
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws JavaModelException, CoreException {
        if (this.type != null) {
            IndexBasedHierarchyBuilder builder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)builder).build(this.computeSubtypes);
        }
    }

    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        if (this.rootClasses.contains(type)) {
            return true;
        }
        return this.interfaces.contains(type);
    }

    protected void deactivate() {
        JavaModelManager.getJavaModelManager().removeElementChangedListener(this);
        this.files = null;
        this.packageRegion = null;
        this.rootRegion = null;
        this.projectRegion = null;
        this.changeListeners = null;
        this.isActivated = false;
    }

    protected void destroy() {
        this.exists = false;
        this.classToSuperclass = new HashMap(1);
        this.files = new HashMap(5);
        this.interfaces = new ArrayList(0);
        this.packageRegion = new Region();
        this.projectRegion = new Region();
        this.rootClasses = new TypeVector();
        this.rootRegion = new Region();
        this.typeToSubtypes = new HashMap(1);
        this.typeFlags = new HashMap(1);
        this.typeToSuperInterfaces = new HashMap(1);
        this.missingTypes = new ArrayList(4);
        JavaModelManager.getJavaModelManager().removeElementChangedListener(this);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.exists && this.isActivated()) {
            if (this.exists()) {
                if (this.isAffected(event.getDelta())) {
                    this.fireChange();
                }
            } else {
                this.destroy();
                this.fireChange();
            }
        }
    }

    public boolean exists() {
        if (this.exists) {
            boolean bl = this.exists = (this.type == null || this.type != null && this.type.exists()) && this.javaProject().exists();
            if (!this.exists) {
                this.destroy();
            }
        }
        return this.exists;
    }

    protected void fireChange() {
        if (this.changeListeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.type != null) {
                System.out.println("    for hierarchy focused on " + ((JavaElement)((Object)this.type)).toStringWithAncestors());
            }
        }
        ArrayList listeners = (ArrayList)this.changeListeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)listeners.get(i);
            if (this.changeListeners != null && this.changeListeners.indexOf(listener) >= 0) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Type hierarchy change notification");
                    }

                    public void run() throws Exception {
                        listener.typeHierarchyChanged(TypeHierarchy.this);
                    }
                });
            }
            ++i;
        }
    }

    private static byte[] flagsToBytes(Integer flags) {
        if (flags != null) {
            return flags.toString().getBytes();
        }
        return NO_FLAGS;
    }

    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add((IType)iter.next());
        }
        return classes.elements();
    }

    public IType[] getAllInterfaces() {
        IType[] collection = new IType[this.interfaces.size()];
        this.interfaces.toArray(collection);
        return collection;
    }

    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypesForType(type);
    }

    private IType[] getAllSubtypesForType(IType type) {
        ArrayList subTypes = new ArrayList();
        this.getAllSubtypesForType0(type, subTypes);
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private void getAllSubtypesForType0(IType type, ArrayList subs) {
        IType[] subTypes = this.getSubtypesForType(type);
        if (subTypes.length != 0) {
            int i = 0;
            while (i < subTypes.length) {
                IType subType = subTypes[i];
                subs.add(subType);
                this.getAllSubtypesForType0(subType, subs);
                ++i;
            }
        }
    }

    public IType[] getAllSuperclasses(IType type) {
        IType superclass = this.getSuperclass(type);
        TypeVector supers = new TypeVector();
        while (superclass != null) {
            supers.add(superclass);
            superclass = this.getSuperclass(superclass);
        }
        return supers.elements();
    }

    public IType[] getAllSuperInterfaces(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperInterfaces.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSuperInterfaces0(type, supers);
        IType[] superinterfaces = new IType[supers.size()];
        supers.toArray(superinterfaces);
        return superinterfaces;
    }

    private void getAllSuperInterfaces0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = (IType[])this.typeToSuperInterfaces.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperInterfaces0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.get(type)) != null) {
            this.getAllSuperInterfaces0(superclass, supers);
        }
    }

    public IType[] getAllSupertypes(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperInterfaces.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSupertypes0(type, supers);
        IType[] supertypes = new IType[supers.size()];
        supers.toArray(supertypes);
        return supertypes;
    }

    private void getAllSupertypes0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = (IType[])this.typeToSuperInterfaces.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperInterfaces0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.get(type)) != null) {
            supers.add(superclass);
            this.getAllSupertypes0(superclass, supers);
        }
    }

    public IType[] getAllTypes() {
        IType[] classes = this.getAllClasses();
        int classesLength = classes.length;
        IType[] interfaces = this.getAllInterfaces();
        int interfacesLength = interfaces.length;
        IType[] all = new IType[classesLength + interfacesLength];
        System.arraycopy(classes, 0, all, 0, classesLength);
        System.arraycopy(interfaces, 0, all, classesLength, interfacesLength);
        return all;
    }

    public int getCachedFlags(IType type) {
        Integer flagObject = (Integer)this.typeFlags.get(type);
        if (flagObject != null) {
            return flagObject;
        }
        return -1;
    }

    public IType[] getExtendingInterfaces(IType type) {
        try {
            if (!this.isInterface(type)) {
                return new IType[0];
            }
        }
        catch (JavaModelException javaModelException) {
            return new IType[0];
        }
        return this.getExtendingInterfaces0(type);
    }

    private IType[] getExtendingInterfaces0(IType interfce) {
        Iterator iter = this.typeToSuperInterfaces.keySet().iterator();
        ArrayList<IType> xers = new ArrayList<IType>();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            try {
                if (!this.isInterface(type)) {
                }
            }
            catch (JavaModelException javaModelException) {}
            continue;
            IType[] interfaces = (IType[])this.typeToSuperInterfaces.get(type);
            if (interfaces == null) continue;
            int i = 0;
            while (i < interfaces.length) {
                IType iFace = interfaces[i];
                if (iFace.equals(interfce)) {
                    xers.add(type);
                }
                ++i;
            }
        }
        IType[] extenders = new IType[xers.size()];
        xers.toArray(extenders);
        return extenders;
    }

    public IType[] getImplementingClasses(IType type) {
        try {
            if (!this.isInterface(type)) {
                return NO_TYPE;
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_TYPE;
        }
        return this.getImplementingClasses0(type);
    }

    private IType[] getImplementingClasses0(IType interfce) {
        Iterator iter = this.typeToSuperInterfaces.keySet().iterator();
        ArrayList<IType> iMenters = new ArrayList<IType>();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            try {
                if (this.isInterface(type)) {
                }
            }
            catch (JavaModelException javaModelException) {}
            continue;
            IType[] interfaces = (IType[])this.typeToSuperInterfaces.get(type);
            int i = 0;
            while (i < interfaces.length) {
                IType iFace = interfaces[i];
                if (iFace.equals(interfce)) {
                    iMenters.add(type);
                }
                ++i;
            }
        }
        IType[] implementers = new IType[iMenters.size()];
        iMenters.toArray(implementers);
        return implementers;
    }

    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    public IType[] getRootInterfaces() {
        IType[] allInterfaces = this.getAllInterfaces();
        IType[] roots = new IType[allInterfaces.length];
        int rootNumber = 0;
        int i = 0;
        while (i < allInterfaces.length) {
            IType[] superInterfaces = this.getSuperInterfaces(allInterfaces[i]);
            if (superInterfaces == null || superInterfaces.length == 0) {
                roots[rootNumber++] = allInterfaces[i];
            }
            ++i;
        }
        IType[] result = new IType[rootNumber];
        if (result.length > 0) {
            System.arraycopy(roots, 0, result, 0, rootNumber);
        }
        return result;
    }

    public IType[] getSubclasses(IType type) {
        try {
            if (this.isInterface(type)) {
                return NO_TYPE;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IType[0];
        }
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType[] getSubtypes(IType type) {
        return this.getSubtypesForType(type);
    }

    private IType[] getSubtypesForType(IType type) {
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType getSuperclass(IType type) {
        try {
            if (this.isInterface(type)) {
                return null;
            }
            return (IType)this.classToSuperclass.get(type);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType[] getSuperInterfaces(IType type) {
        IType[] interfaces = (IType[])this.typeToSuperInterfaces.get(type);
        if (interfaces == null) {
            return NO_TYPE;
        }
        return interfaces;
    }

    public IType[] getSupertypes(IType type) {
        IType superclass = this.getSuperclass(type);
        if (superclass == null) {
            return this.getSuperInterfaces(type);
        }
        TypeVector superTypes = new TypeVector(this.getSuperInterfaces(type));
        superTypes.add(superclass);
        return superTypes.elements();
    }

    public IType getType() {
        return this.type;
    }

    protected IType[] growAndAddToArray(IType[] array, IType[] additions) {
        if (array == null || array.length == 0) {
            return additions;
        }
        IType[] old = array;
        array = new IType[old.length + additions.length];
        System.arraycopy(old, 0, array, 0, old.length);
        System.arraycopy(additions, 0, array, old.length, additions.length);
        return array;
    }

    protected IType[] growAndAddToArray(IType[] array, IType addition) {
        if (array == null || array.length == 0) {
            return new IType[]{addition};
        }
        IType[] old = array;
        array = new IType[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    private boolean hasSubtypeNamed(String simpleName) {
        if (this.type.getElementName().equals(simpleName)) {
            return true;
        }
        IType[] types = this.getAllSubtypes(this.type);
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeNamed(String simpleName) {
        IType[] types = this.getAllTypes();
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean includesTypeOrSupertype(IType type) {
        try {
            String[] superinterfaceNames;
            if (this.hasTypeNamed(type.getElementName())) {
                return true;
            }
            String superclassName = type.getSuperclassName();
            if (superclassName != null) {
                String simpleName;
                int lastSeparator = superclassName.lastIndexOf(46);
                String string = simpleName = lastSeparator > -1 ? superclassName.substring(lastSeparator) : superclassName;
                if (this.hasTypeNamed(simpleName)) {
                    return true;
                }
            }
            if ((superinterfaceNames = type.getSuperInterfaceNames()) != null) {
                int i = 0;
                int length = superinterfaceNames.length;
                while (i < length) {
                    String simpleName;
                    String superinterfaceName = superinterfaceNames[i];
                    int lastSeparator = superinterfaceName.lastIndexOf(46);
                    String string = simpleName = lastSeparator > -1 ? superinterfaceName.substring(lastSeparator) : superinterfaceName;
                    if (this.hasTypeNamed(simpleName)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected void initialize(int size) {
        if (size < 10) {
            size = 10;
        }
        int smallSize = size / 2;
        this.classToSuperclass = new HashMap(size);
        this.interfaces = new ArrayList(smallSize);
        this.missingTypes = new ArrayList(smallSize);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap(smallSize);
        this.typeToSuperInterfaces = new HashMap(smallSize);
        this.typeFlags = new HashMap(smallSize);
    }

    protected boolean isActivated() {
        return this.isActivated;
    }

    public boolean isAffected(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                return this.isAffectedByJavaModel(delta, element);
            }
            case 2: {
                return this.isAffectedByJavaProject(delta, element);
            }
            case 3: {
                return this.isAffectedByPackageFragmentRoot(delta, element);
            }
            case 4: {
                return this.isAffectedByPackageFragment(delta, element);
            }
            case 5: 
            case 6: {
                return this.isAffectedByOpenable(delta, element);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IJavaElementDelta delta) {
        if ((delta.getFlags() & 8) > 0) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAffected(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isAffectedByJavaModel(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                return element.equals(this.javaProject().getJavaModel());
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByJavaProject(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: {
                try {
                    IClasspathEntry[] classpath = ((JavaProject)this.javaProject()).getExpandedClasspath(true);
                    int i = 0;
                    while (i < classpath.length) {
                        if (classpath[i].getEntryKind() == 2 && classpath[i].getPath().equals((Object)element.getPath())) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            case 2: {
                IJavaElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    IJavaProject project = pkgs[i].getJavaProject();
                    if (project != null && project.equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragment(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: {
                return this.packageRegionContainsSamePackageFragment(element);
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedByPackageFragmentRoot(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: 
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 && this.projectRegion != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    IPath rootPath = root.getPath();
                    IJavaElement[] elements = this.projectRegion.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IJavaProject project = (IJavaProject)elements[i];
                        try {
                            IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                            int j = 0;
                            while (j < classpath.length) {
                                IClasspathEntry entry = classpath[j];
                                if (entry.getPath().equals((Object)rootPath)) {
                                    return true;
                                }
                                ++j;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        ++i;
                    }
                }
                if ((flags & 0x80) <= 0 && (flags & 1) <= 0) break;
                IJavaElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(delta);
    }

    protected boolean isAffectedByOpenable(IJavaElementDelta delta, IJavaElement element) {
        if (element instanceof CompilationUnit && ((CompilationUnit)element).isWorkingCopy()) {
            return false;
        }
        int kind = delta.getKind();
        switch (kind) {
            case 2: {
                return this.files.get(element) != null;
            }
            case 1: {
                IType[] types = null;
                try {
                    IType[] iTypeArray;
                    if (element instanceof CompilationUnit) {
                        iTypeArray = ((CompilationUnit)element).getAllTypes();
                    } else {
                        IType[] iTypeArray2 = new IType[1];
                        iTypeArray = iTypeArray2;
                        iTypeArray2[0] = ((ClassFile)element).getType();
                    }
                    types = iTypeArray;
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    return false;
                }
                int i = 0;
                int length = types.length;
                while (i < length) {
                    IType type = types[i];
                    if (this.typeHasSupertype(type) || this.subtypesIncludeSupertypeOf(type) || this.missingTypes.contains(type.getElementName())) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                boolean hasImportChange = false;
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaElementDelta child = children[i];
                    IJavaElement childElement = child.getElement();
                    if (childElement instanceof IType) {
                        if (this.isAffectedByType(child, (IType)childElement, hasImportChange)) {
                            return true;
                        }
                    } else if (childElement instanceof ImportContainer && !hasImportChange) {
                        hasImportChange = true;
                        IType[] types = null;
                        try {
                            IType[] iTypeArray;
                            if (element instanceof CompilationUnit) {
                                iTypeArray = ((CompilationUnit)element).getAllTypes();
                            } else {
                                IType[] iTypeArray3 = new IType[1];
                                iTypeArray = iTypeArray3;
                                iTypeArray3[0] = ((ClassFile)element).getType();
                            }
                            types = iTypeArray;
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                            return false;
                        }
                        int j = 0;
                        int typesLength = types.length;
                        while (j < typesLength) {
                            if (this.includesTypeOrSupertype(types[j])) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    protected boolean isAffectedByType(IJavaElementDelta delta, IType type, boolean hasImportChange) {
        switch (delta.getKind()) {
            case 1: {
                if (!this.typeHasSupertype(type) && !this.subtypesIncludeSupertypeOf(type) && !this.missingTypes.contains(type.getElementName())) break;
                return true;
            }
            case 4: {
                boolean hasSupertypeChange;
                boolean hasVisibilityChange = (delta.getFlags() & 2) > 0;
                boolean bl = hasSupertypeChange = (delta.getFlags() & 0x800) > 0;
                if ((!hasVisibilityChange || !this.typeHasSupertype(type)) && (!hasImportChange && !hasSupertypeChange || !this.includesTypeOrSupertype(type))) break;
                return true;
            }
            case 2: {
                if (!this.contains(type)) break;
                return true;
            }
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IJavaElementDelta child = children[i];
            IJavaElement childElement = child.getElement();
            if (childElement instanceof IType && this.isAffectedByType(child, (IType)childElement, hasImportChange)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInterface(IType type) throws JavaModelException {
        int flags = this.getCachedFlags(type);
        if (flags == -1) {
            return type.isInterface();
        }
        return Flags.isInterface(flags);
    }

    public IJavaProject javaProject() {
        return this.type.getJavaProject();
    }

    protected static byte[] readUntil(InputStream input, byte separator) throws JavaModelException, IOException {
        return TypeHierarchy.readUntil(input, separator, 0);
    }

    protected static byte[] readUntil(InputStream input, byte separator, int offset) throws IOException, JavaModelException {
        byte b;
        int length = 0;
        byte[] bytes = new byte[10];
        while ((b = (byte)input.read()) != separator && b != -1) {
            if (bytes.length == length) {
                byte[] byArray = bytes;
                bytes = new byte[length * 2];
                System.arraycopy(byArray, 0, bytes, 0, length);
            }
            bytes[length++] = b;
        }
        if (b == -1) {
            throw new JavaModelException(new JavaModelStatus(4));
        }
        byte[] byArray = bytes;
        bytes = new byte[length + offset];
        System.arraycopy(byArray, 0, bytes, offset, length);
        return bytes;
    }

    public static ITypeHierarchy load(IType type, InputStream input) throws JavaModelException {
        try {
            byte[] missing;
            byte b;
            byte[] bytes;
            TypeHierarchy typeHierarchy = new TypeHierarchy();
            typeHierarchy.initialize(1);
            IType[] types = new IType[10];
            int typeCount = 0;
            byte version = (byte)input.read();
            if (version != 0) {
                throw new JavaModelException(new JavaModelStatus(4));
            }
            byte generalInfo = (byte)input.read();
            if ((generalInfo & 1) != 0) {
                typeHierarchy.computeSubtypes = true;
            }
            if ((bytes = TypeHierarchy.readUntil(input, (byte)10)).length > 0) {
                typeHierarchy.project = (IJavaProject)JavaCore.create(new String(bytes));
                typeHierarchy.scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{typeHierarchy.project});
            } else {
                typeHierarchy.project = null;
                typeHierarchy.scope = SearchEngine.createWorkspaceScope();
            }
            bytes = TypeHierarchy.readUntil(input, (byte)10);
            int j = 0;
            int length = bytes.length;
            int i = 0;
            while (i < length) {
                b = bytes[i];
                if (b == 44) {
                    missing = new byte[i - j];
                    System.arraycopy(bytes, j, missing, 0, i - j);
                    typeHierarchy.missingTypes.add(new String(missing));
                    j = i + 1;
                }
                ++i;
            }
            missing = new byte[length - j];
            System.arraycopy(bytes, j, missing, 0, length - j);
            typeHierarchy.missingTypes.add(new String(missing));
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte info;
                bytes = TypeHierarchy.readUntil(input, (byte)13, 1);
                bytes[0] = b;
                IType element = (IType)JavaCore.create(new String(bytes));
                if (types.length == typeCount) {
                    IType[] iTypeArray = types;
                    types = new IType[typeCount * 2];
                    System.arraycopy(iTypeArray, 0, types, 0, typeCount);
                }
                types[typeCount++] = element;
                bytes = TypeHierarchy.readUntil(input, (byte)13);
                Integer flags = TypeHierarchy.bytesToFlags(bytes);
                if (flags != null) {
                    typeHierarchy.cacheFlags(element, flags);
                }
                if (((info = (byte)input.read()) & 1) != 0) {
                    typeHierarchy.addInterface(element);
                }
                if ((info & 2) != 0) {
                    if (!element.equals(type)) {
                        throw new JavaModelException(new JavaModelStatus(4));
                    }
                    typeHierarchy.type = element;
                }
                if ((info & 4) == 0) continue;
                typeHierarchy.addRootClass(element);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = new Integer(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                int superClass = new Integer(new String(bytes));
                typeHierarchy.cacheSuperclass(types[subClass], types[superClass]);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte[] b2;
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = new Integer(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                IType[] superInterfaces = new IType[bytes.length / 2 + 1];
                int interfaceCount = 0;
                int j2 = 0;
                int i2 = 0;
                while (i2 < bytes.length) {
                    if (bytes[i2] == 44) {
                        b2 = new byte[i2 - j2];
                        System.arraycopy(bytes, j2, b2, 0, i2 - j2);
                        j2 = i2 + 1;
                        superInterfaces[interfaceCount++] = types[new Integer(new String(b2))];
                    }
                    ++i2;
                }
                b2 = new byte[bytes.length - j2];
                System.arraycopy(bytes, j2, b2, 0, bytes.length - j2);
                superInterfaces[interfaceCount++] = types[new Integer(new String(b2))];
                IType[] iTypeArray = superInterfaces;
                superInterfaces = new IType[interfaceCount];
                System.arraycopy(iTypeArray, 0, superInterfaces, 0, interfaceCount);
                typeHierarchy.cacheSuperInterfaces(types[subClass], superInterfaces);
            }
            if (b == -1) {
                throw new JavaModelException(new JavaModelStatus(4));
            }
            return typeHierarchy;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected boolean packageRegionContainsSamePackageFragment(IJavaElement element) {
        IJavaElement[] pkgs = this.packageRegion.getElements();
        int i = 0;
        while (i < pkgs.length) {
            if (pkgs[i].getElementName().equals(element.getElementName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void refresh(IProgressMonitor monitor) throws JavaModelException {
        try {
            try {
                boolean reactivate = this.isActivated();
                ArrayList listeners = this.changeListeners;
                if (reactivate) {
                    this.deactivate();
                }
                this.progressMonitor = monitor;
                if (monitor != null) {
                    if (this.type != null) {
                        monitor.beginTask(Util.bind("hierarchy.creatingOnType", this.type.getFullyQualifiedName()), 100);
                    } else {
                        monitor.beginTask(Util.bind("hierarchy.creating"), 100);
                    }
                }
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.computeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.type != null) {
                        System.out.println("  on type " + ((JavaElement)((Object)this.type)).toStringWithAncestors());
                    }
                }
                this.compute();
                if (reactivate) {
                    this.activate();
                    this.changeListeners = listeners;
                }
                if (DEBUG) {
                    if (this.computeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (JavaModelException e) {
                this.progressMonitor = null;
                throw e;
            }
            catch (CoreException e) {
                this.progressMonitor = null;
                throw new JavaModelException(e);
            }
            catch (OperationCanceledException oce) {
                this.refreshCancelled(oce);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
            throw throwable;
        }
        Object var6_10 = null;
        if (monitor != null) {
            monitor.done();
        }
        this.progressMonitor = null;
    }

    protected void refreshCancelled(OperationCanceledException oce) throws JavaModelException {
        this.destroy();
        this.progressMonitor = null;
        throw oce;
    }

    public void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        if (this.changeListeners == null) {
            return;
        }
        ((AbstractCollection)this.changeListeners).remove(listener);
        if (this.changeListeners.isEmpty()) {
            this.deactivate();
        }
    }

    public void store(OutputStream output, IProgressMonitor monitor) throws JavaModelException {
        try {
            IJavaElement key;
            Integer index;
            Object t;
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
            Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
            int count = 0;
            if (this.type != null) {
                Integer index2 = new Integer(count++);
                hashtable.put(this.type, index2);
                hashtable2.put(index2, this.type);
            }
            Object[] types = this.classToSuperclass.keySet().toArray();
            int i = 0;
            while (i < types.length) {
                Object superClass;
                t = types[i];
                if (hashtable.get(t) == null) {
                    index = new Integer(count++);
                    hashtable.put(t, index);
                    hashtable2.put(index, t);
                }
                if ((superClass = this.classToSuperclass.get(t)) != null && hashtable.get(superClass) == null) {
                    Integer index3 = new Integer(count++);
                    hashtable.put(superClass, index3);
                    hashtable2.put(index3, superClass);
                }
                ++i;
            }
            types = this.typeToSuperInterfaces.keySet().toArray();
            i = 0;
            while (i < types.length) {
                Object[] sp;
                t = types[i];
                if (hashtable.get(t) == null) {
                    index = new Integer(count++);
                    hashtable.put(t, index);
                    hashtable2.put(index, t);
                }
                if ((sp = (Object[])this.typeToSuperInterfaces.get(t)) != null) {
                    int j = 0;
                    while (j < sp.length) {
                        Object superInterface = sp[j];
                        if (sp[j] != null && hashtable.get(superInterface) == null) {
                            Integer index4 = new Integer(count++);
                            hashtable.put(superInterface, index4);
                            hashtable2.put(index4, superInterface);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            output.write(0);
            int generalInfo = 0;
            if (this.computeSubtypes) {
                generalInfo = (byte)(generalInfo | 1);
            }
            output.write(generalInfo);
            if (this.project != null) {
                output.write(this.project.getHandleIdentifier().getBytes());
            }
            output.write(10);
            int i2 = 0;
            while (i2 < this.missingTypes.size()) {
                if (i2 != 0) {
                    output.write(44);
                }
                output.write(((String)this.missingTypes.get(i2)).getBytes());
                ++i2;
            }
            output.write(10);
            i2 = 0;
            while (i2 < count) {
                IType t2 = (IType)hashtable2.get(new Integer(i2));
                output.write(t2.getHandleIdentifier().getBytes());
                output.write(13);
                output.write(TypeHierarchy.flagsToBytes((Integer)this.typeFlags.get(t2)));
                output.write(13);
                int info = 0;
                if (this.type != null && this.type.equals(t2)) {
                    info = (byte)(info | 2);
                }
                if (this.interfaces.contains(t2)) {
                    info = (byte)(info | 1);
                }
                if (this.rootClasses.contains(t2)) {
                    info = (byte)(info | 4);
                }
                output.write(info);
                ++i2;
            }
            output.write(10);
            types = this.classToSuperclass.keySet().toArray();
            i2 = 0;
            while (i2 < types.length) {
                key = (IJavaElement)types[i2];
                IJavaElement value = (IJavaElement)this.classToSuperclass.get(key);
                output.write(((Integer)hashtable.get(key)).toString().getBytes());
                output.write(62);
                output.write(((Integer)hashtable.get(value)).toString().getBytes());
                output.write(10);
                ++i2;
            }
            output.write(10);
            types = this.typeToSuperInterfaces.keySet().toArray();
            i2 = 0;
            while (i2 < types.length) {
                key = (IJavaElement)types[i2];
                IJavaElement[] values = (IJavaElement[])this.typeToSuperInterfaces.get(key);
                if (values.length > 0) {
                    output.write(((Integer)hashtable.get(key)).toString().getBytes());
                    output.write(62);
                    int j = 0;
                    while (j < values.length) {
                        IJavaElement value = values[j];
                        if (j != 0) {
                            output.write(44);
                        }
                        output.write(((Integer)hashtable.get(value)).toString().getBytes());
                        ++j;
                    }
                    output.write(10);
                }
                ++i2;
            }
            output.write(10);
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    private boolean subtypesIncludeSupertypeOf(IType type) {
        String simpleSuper;
        String superclassName = null;
        try {
            superclassName = type.getSuperclassName();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
        if (superclassName == null) {
            superclassName = "Object";
        }
        int dot = -1;
        dot = superclassName.lastIndexOf(46);
        String string = simpleSuper = dot > -1 ? superclassName.substring(dot + 1) : superclassName;
        if (this.hasSubtypeNamed(simpleSuper)) {
            return true;
        }
        String[] interfaceNames = null;
        try {
            interfaceNames = type.getSuperInterfaceNames();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
        int i = 0;
        int length = interfaceNames.length;
        while (i < length) {
            String simpleInterface;
            dot = -1;
            String interfaceName = interfaceNames[i];
            dot = interfaceName.lastIndexOf(46);
            String string2 = simpleInterface = dot > -1 ? interfaceName.substring(dot) : interfaceName;
            if (this.hasSubtypeNamed(simpleInterface)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Focus: ");
        buffer.append(this.type == null ? "<NONE>" : this.type.getFullyQualifiedName());
        buffer.append("\n");
        if (this.exists()) {
            int i;
            IType[] roots;
            if (this.type != null) {
                buffer.append("Super types:\n");
                this.toString(buffer, this.type, 1, true);
                buffer.append("Sub types:\n");
                this.toString(buffer, this.type, 1, false);
            } else {
                buffer.append("Sub types of root classes:\n");
                roots = this.getRootClasses();
                i = 0;
                while (i < roots.length) {
                    this.toString(buffer, roots[i], 1, false);
                    ++i;
                }
            }
            if (this.rootClasses.size > 1) {
                buffer.append("Root classes:\n");
                roots = this.getRootClasses();
                i = 0;
                int length = roots.length;
                while (i < length) {
                    IType type = roots[i];
                    this.toString(buffer, type, 1, false);
                    ++i;
                }
            } else if (this.rootClasses.size == 0) {
                buffer.append("No root classes");
            }
        } else {
            buffer.append("(Hierarchy became stale)");
        }
        return buffer.toString();
    }

    private void toString(StringBuffer buffer, IType type, int indent, boolean ascendant) {
        int i = 0;
        while (i < indent) {
            buffer.append("  ");
            ++i;
        }
        JavaElement element = (JavaElement)((Object)type);
        buffer.append(element.toStringWithAncestors());
        buffer.append('\n');
        IType[] types = ascendant ? this.getSupertypes(type) : this.getSubtypes(type);
        int i2 = 0;
        while (i2 < types.length) {
            this.toString(buffer, types[i2], indent + 1, ascendant);
            ++i2;
        }
    }

    private boolean typeHasSupertype(IType type) {
        String simpleName = type.getElementName();
        Iterator iter = this.classToSuperclass.values().iterator();
        while (iter.hasNext()) {
            IType superType = (IType)iter.next();
            if (!superType.getElementName().equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    protected void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }
}

