/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class ReconcileWorkingCopyOperation
extends JavaModelOperation {
    boolean forceProblemDetection;

    public ReconcileWorkingCopyOperation(IJavaElement workingCopy, boolean forceProblemDetection) {
        super(new IJavaElement[]{workingCopy});
        this.forceProblemDetection = forceProblemDetection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block11: {
            block10: {
                if (this.fMonitor != null) {
                    if (this.fMonitor.isCanceled()) {
                        return;
                    }
                    this.fMonitor.beginTask(Util.bind("element.reconciling"), 10);
                }
                WorkingCopy workingCopy = this.getWorkingCopy();
                boolean wasConsistent = workingCopy.isConsistent();
                JavaElementDeltaBuilder deltaBuilder = null;
                try {
                    if (!wasConsistent) {
                        deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
                        workingCopy.makeConsistent(this.fMonitor);
                        deltaBuilder.buildDeltas();
                    }
                    if (this.fMonitor != null) {
                        this.fMonitor.worked(2);
                    }
                    if (this.forceProblemDetection && wasConsistent) {
                        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                            Object var5_4 = null;
                            if (this.fMonitor == null) return;
                            break block10;
                        }
                        IProblemRequestor problemRequestor = workingCopy.problemRequestor;
                        if (problemRequestor != null && problemRequestor.isActive()) {
                            problemRequestor.beginReporting();
                            CompilationUnitProblemFinder.process(workingCopy, problemRequestor, this.fMonitor);
                            problemRequestor.endReporting();
                        }
                    }
                    if (deltaBuilder != null && deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                        this.addReconcileDelta(workingCopy, deltaBuilder.delta);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.fMonitor == null) throw throwable;
                    this.fMonitor.done();
                    throw throwable;
                }
            }
            this.fMonitor.done();
            return;
        }
        Object var5_6 = null;
        if (this.fMonitor == null) return;
        this.fMonitor.done();
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy.useCount == 0) {
            return new JavaModelStatus(969, workingCopy);
        }
        return status;
    }
}

