/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CopyElementsOperation;
import org.eclipse.jdt.internal.core.CopyResourceElementsOperation;
import org.eclipse.jdt.internal.core.DeleteElementsOperation;
import org.eclipse.jdt.internal.core.DeleteResourceElementsOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.MoveElementsOperation;
import org.eclipse.jdt.internal.core.MoveResourceElementsOperation;
import org.eclipse.jdt.internal.core.MultiOperation;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.RenameElementsOperation;
import org.eclipse.jdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.jdt.internal.core.Util;

public class JavaModel
extends Openable
implements IJavaModel {
    public static HashSet existingExternalFiles = new HashSet();

    protected JavaModel() throws Error {
        super(1, null, "");
    }

    public boolean contains(IResource resource) {
        IJavaProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            JavaProject project = (JavaProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void copy(IJavaElement[] elements, IJavaElement[] containers, IJavaElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new CopyElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    protected OpenableElementInfo createElementInfo() {
        return new JavaModelInfo();
    }

    public void delete(IJavaElement[] elements, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            JavaElement.runOperation(new DeleteResourceElementsOperation(elements, force), monitor);
        } else {
            JavaElement.runOperation(new DeleteElementsOperation(elements, force), monitor);
        }
    }

    public IJavaProject findJavaProject(IProject project) {
        try {
            IJavaProject[] projects = this.getOldJavaProjectsList();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return javaProject;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        JavaModelManager.getJavaModelManager().putInfo(this, info);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject project = projects[i];
            if (JavaProject.hasJavaNature(project)) {
                info.addChild(this.getJavaProject((IResource)project));
            }
            ++i;
        }
        return true;
    }

    protected IJavaElement getHandleFromMementoForBinaryMembers(String memento, IPackageFragmentRoot root, int rootEnd, int end) throws JavaModelException {
        IPackageFragment frag = null;
        frag = rootEnd == end - 1 ? root.getPackageFragment("") : root.getPackageFragment(memento.substring(rootEnd + 1, end));
        int oldEnd = end;
        if ((end = memento.indexOf(91, oldEnd)) == -1) {
            return frag.getClassFile(memento.substring(oldEnd + 1));
        }
        IClassFile cf = frag.getClassFile(memento.substring(oldEnd + 1, end));
        oldEnd = end;
        oldEnd = end = memento.indexOf(91, oldEnd);
        if ((end = memento.indexOf(94, end)) != -1) {
            IType type = cf.getType();
            return type.getField(memento.substring(end + 1));
        }
        end = memento.indexOf(126, oldEnd);
        if (end != -1) {
            String methodName;
            oldEnd = end;
            IType type = cf.getType();
            end = memento.lastIndexOf(126);
            String[] parameterTypes = null;
            if (end == oldEnd) {
                methodName = memento.substring(end + 1);
                parameterTypes = new String[]{};
            } else {
                String parameters = memento.substring(oldEnd + 1);
                StringTokenizer tokenizer = new StringTokenizer(parameters, new String(new char[]{'~'}));
                parameterTypes = new String[tokenizer.countTokens() - 1];
                methodName = tokenizer.nextToken();
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    parameterTypes[i] = tokenizer.nextToken();
                    ++i;
                }
            }
            return type.getMethod(methodName, parameterTypes);
        }
        return cf.getType();
    }

    protected IPackageFragmentRoot getHandleFromMementoForRoot(String memento, JavaProject project, int projectEnd, int rootEnd) {
        String rootName = null;
        rootName = rootEnd == projectEnd - 1 ? "" : memento.substring(projectEnd + 1, rootEnd);
        return project.getPackageFragmentRoot((IPath)new Path(rootName));
    }

    protected IJavaElement getHandleFromMementoForSourceMembers(String memento, IPackageFragmentRoot root, int rootEnd, int end) throws JavaModelException {
        IPackageFragment frag = null;
        frag = rootEnd == end - 1 ? root.getPackageFragment("") : root.getPackageFragment(memento.substring(rootEnd + 1, end));
        int oldEnd = end;
        if ((end = memento.indexOf(37, end)) != -1) {
            ICompilationUnit cu = frag.getCompilationUnit(memento.substring(oldEnd + 1, end));
            return cu.getPackageDeclaration(memento.substring(end + 1));
        }
        end = memento.indexOf(35, oldEnd);
        if (end != -1) {
            ICompilationUnit cu = frag.getCompilationUnit(memento.substring(oldEnd + 1, end));
            return cu.getImport(memento.substring(end + 1));
        }
        int typeStart = memento.indexOf(91, oldEnd);
        if (typeStart == -1) {
            return frag.getCompilationUnit(memento.substring(oldEnd + 1));
        }
        ICompilationUnit cu = frag.getCompilationUnit(memento.substring(oldEnd + 1, typeStart));
        end = memento.indexOf(94, oldEnd);
        if (end != -1) {
            IType type = this.getHandleFromMementoForSourceType(memento, cu, typeStart, end);
            return type.getField(memento.substring(end + 1));
        }
        end = memento.indexOf(126, oldEnd);
        if (end != -1) {
            String methodName;
            IType type = this.getHandleFromMementoForSourceType(memento, cu, typeStart, end);
            oldEnd = end;
            end = memento.lastIndexOf(126);
            String[] parameterTypes = null;
            if (end == oldEnd) {
                methodName = memento.substring(end + 1);
                parameterTypes = new String[]{};
            } else {
                String parameters = memento.substring(oldEnd + 1);
                StringTokenizer mTokenizer = new StringTokenizer(parameters, new String(new char[]{'~'}));
                parameterTypes = new String[mTokenizer.countTokens() - 1];
                methodName = mTokenizer.nextToken();
                int i = 0;
                while (mTokenizer.hasMoreTokens()) {
                    parameterTypes[i] = mTokenizer.nextToken();
                    ++i;
                }
            }
            return type.getMethod(methodName, parameterTypes);
        }
        end = memento.indexOf(124, oldEnd);
        if (end != -1) {
            IType type = this.getHandleFromMementoForSourceType(memento, cu, typeStart, end);
            return type.getInitializer(Integer.parseInt(memento.substring(end + 1)));
        }
        return this.getHandleFromMementoForSourceType(memento, cu, typeStart, memento.length());
    }

    protected IType getHandleFromMementoForSourceType(String memento, ICompilationUnit cu, int typeStart, int typeEnd) throws JavaModelException {
        int end = memento.lastIndexOf(91);
        IType type = null;
        if (end == typeStart) {
            String typeName = memento.substring(typeStart + 1, typeEnd);
            type = cu.getType(typeName);
        } else {
            String typeNames = memento.substring(typeStart + 1, typeEnd);
            StringTokenizer tokenizer = new StringTokenizer(typeNames, new String(new char[]{'['}));
            type = cu.getType(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                type = type.getType(tokenizer.nextToken());
            }
        }
        return type;
    }

    public String getHandleMemento() {
        return this.getElementName();
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    public IJavaProject getJavaProject(String name) {
        return new JavaProject(ResourcesPlugin.getWorkspace().getRoot().getProject(name), this);
    }

    public IJavaProject getJavaProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new JavaProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new JavaProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new JavaProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(Util.bind("element.invalidResourceForProject"));
    }

    public IJavaProject[] getJavaProjects() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(2);
        IJavaProject[] array = new IJavaProject[list.size()];
        list.toArray(array);
        return array;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JavaModelInfo)this.getElementInfo()).getNonJavaResources();
    }

    public IJavaProject[] getOldJavaProjectsList() throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        return manager.javaProjectsCache == null ? this.getJavaProjects() : manager.javaProjectsCache;
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void move(IJavaElement[] elements, IJavaElement[] containers, IJavaElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new MoveElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    public void refreshExternalArchives(IJavaElement[] elementsScope, IProgressMonitor monitor) throws JavaModelException {
        if (elementsScope == null) {
            elementsScope = new IJavaElement[]{this};
        }
        JavaModelManager.getJavaModelManager().deltaProcessor.checkExternalArchiveChanges(elementsScope, monitor);
    }

    public void rename(IJavaElement[] elements, IJavaElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        MultiOperation op = elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7 ? new RenameResourceElementsOperation(elements, destinations, renamings, force) : new RenameElementsOperation(elements, destinations, renamings, force);
        JavaElement.runOperation(op, monitor);
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return this;
    }

    protected void runOperation(MultiOperation op, IJavaElement[] elements, IJavaElement[] siblings, String[] renamings, IProgressMonitor monitor) throws JavaModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        JavaElement.runOperation(op, monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("Java Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModel.getTarget(...)] Checking existence of " + path.toString());
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }
}

