/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected ICompilationUnit fUnit;
    protected CompilationUnitElementInfo fUnitInfo;
    protected JavaElementInfo fImportContainerInfo = null;
    protected Map fNewElements;
    protected Stack fInfoStack;
    protected Stack fHandleStack;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected int fRefCount = 0;
    protected static int fgReferenceAllocation = 50;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static String[] fgEmptyStringArray = new String[0];
    protected static byte[] fgEmptyByte = new byte[0];
    protected static char[][] fgEmptyCharChar = new char[0][];
    protected static char[] fgEmptyChar = new char[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) throws JavaModelException {
        this.fUnit = unit;
        this.fUnitInfo = unitInfo;
        this.fNewElements = newElements;
        this.fSourceFileName = unit.getElementName().toCharArray();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue(false);
        }
        ICompilationUnit parentCU = (ICompilationUnit)((Object)parentHandle);
        IImportContainer importContainer = parentCU.getImportContainer();
        if (this.fImportContainerInfo == null) {
            this.fImportContainerInfo = new JavaElementInfo();
            this.fImportContainerInfo.setIsStructureKnown(true);
            parentInfo.addChild(importContainer);
            this.fNewElements.put(importContainer, this.fImportContainerInfo);
        }
        String importName = onDemand ? String.valueOf(new String(name)) + ".*" : new String(name);
        ImportDeclaration handle = new ImportDeclaration(importContainer, importName);
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        this.fImportContainerInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        PackageDeclaration handle = null;
        this.fPackageName = name;
        if (parentHandle.getElementType() == 5) {
            handle = new PackageDeclaration((ICompilationUnit)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    public void acceptProblem(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature(typeNames[i], false);
            ++i;
        }
        return typeSigs;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, superclass, superinterfaces);
    }

    public void enterCompilationUnit() {
        this.fInfoStack = new Stack();
        this.fHandleStack = new Stack();
        this.fInfoStack.push(this.fUnitInfo);
        this.fHandleStack.push(this.fUnit);
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, null, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, true);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new SourceField((IType)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setTypeName(type);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        IInitializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = ((IType)((Object)parentHandle)).getInitializer(1);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        InitializerElementInfo info = new InitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, null, superinterfaces);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, false);
    }

    protected void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, boolean isConstructor) {
        char[] cArray;
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        SourceMethod handle = null;
        if (parameterTypes == null) {
            parameterTypes = fgEmptyCharChar;
        }
        if (parameterNames == null) {
            parameterNames = fgEmptyCharChar;
        }
        if (exceptionTypes == null) {
            exceptionTypes = fgEmptyCharChar;
        }
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(parameterTypes);
        if (parentHandle.getElementType() == 7) {
            handle = new SourceMethod((IType)((Object)parentHandle), new String(name), parameterTypeSigs);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setConstructor(isConstructor);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setArgumentTypeNames(parameterTypes);
        if (returnType == null) {
            char[] cArray2 = new char[4];
            cArray2[0] = 118;
            cArray2[1] = 111;
            cArray2[2] = 105;
            cArray = cArray2;
            cArray2[3] = 100;
        } else {
            cArray = returnType;
        }
        info.setReturnType(cArray);
        info.setExceptionTypeNames(exceptionTypes);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    protected void enterType(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        char[] enclosingTypeName = null;
        char[] qualifiedName = null;
        JavaElementInfo parentInfo = (JavaElementInfo)this.fInfoStack.peek();
        JavaElement parentHandle = (JavaElement)this.fHandleStack.peek();
        IType handle = null;
        String nameString = new String(name);
        if (parentHandle.getElementType() == 5) {
            handle = ((ICompilationUnit)((Object)parentHandle)).getType(nameString);
            qualifiedName = this.fPackageName == null ? nameString.toCharArray() : (String.valueOf(new String(this.fPackageName)) + "." + nameString).toCharArray();
        } else if (parentHandle.getElementType() == 7) {
            handle = ((IType)((Object)parentHandle)).getType(nameString);
            enclosingTypeName = ((SourceTypeElementInfo)parentInfo).getName();
            qualifiedName = (String.valueOf(new String(((SourceTypeElementInfo)parentInfo).getQualifiedName())) + "." + nameString).toCharArray();
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSuperclassName(superclass);
        info.setSuperInterfaceNames(superinterfaces);
        info.setEnclosingTypeName(enclosingTypeName);
        info.setSourceFileName(this.fSourceFileName);
        info.setPackageName(this.fPackageName);
        info.setQualifiedName(qualifiedName);
        Iterator iter = this.fNewElements.keySet().iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof IImportDeclaration)) continue;
            info.addImport(((IImportDeclaration)object).getElementName().toCharArray());
        }
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    public void exitClass(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.fUnitInfo.setSourceLength(declarationEnd + 1);
        this.fUnitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int length;
        Object typeInfo;
        int flags;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        if (initializationStart != -1 && (Flags.isStatic(flags = info.flags) && Flags.isFinal(flags) || (typeInfo = this.fInfoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)typeInfo).flags)) && (length = declarationEnd - initializationStart) > 0) {
            char[] initializer = new char[length];
            System.arraycopy(this.parser.scanner.source, initializationStart, initializer, 0, length);
            info.initializationSource = initializer;
        }
        this.fHandleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitInterface(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.fHandleStack.pop();
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(IJavaElement handle) {
        while (this.fNewElements.containsKey(handle)) {
            JavaElement h = (JavaElement)handle;
            h.setOccurrenceCount(h.getOccurrenceCount() + 1);
        }
    }
}

