/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference type, int operator) {
        this.expression = expression;
        this.type = type;
        this.bits |= operator << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public final boolean areTypesCastCompatible(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType == expressionType) {
            return true;
        }
        if (BaseTypes.NullBinding == expressionType) {
            return true;
        }
        if (expressionType.isArrayType()) {
            if (castType.isArrayType()) {
                TypeBinding expressionEltTb = ((ArrayBinding)expressionType).elementsType(scope);
                if (expressionEltTb.isBaseType()) {
                    return ((ArrayBinding)castType).elementsType(scope) == expressionEltTb;
                }
                return this.areTypesCastCompatible(scope, ((ArrayBinding)castType).elementsType(scope), expressionEltTb);
            }
            if (castType.isClass()) {
                return scope.isJavaLangObject(castType);
            }
            if (castType.isInterface()) {
                return scope.isJavaLangCloneable(castType) || scope.isJavaIoSerializable(castType);
            }
            return false;
        }
        if (expressionType.isBaseType()) {
            return false;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType()) {
                return scope.isJavaLangObject(expressionType);
            }
            if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return true;
                }
                return castType.isCompatibleWith(expressionType);
            }
            if (castType.isInterface()) {
                if (((ReferenceBinding)expressionType).isFinal()) {
                    return expressionType.isCompatibleWith(castType);
                }
                return true;
            }
            return false;
        }
        if (expressionType.isInterface()) {
            if (castType.isArrayType()) {
                return scope.isJavaLangCloneable(expressionType) || scope.isJavaIoSerializable(expressionType);
            }
            if (castType.isClass()) {
                if (scope.isJavaLangObject(castType)) {
                    return true;
                }
                if (((ReferenceBinding)castType).isFinal()) {
                    return castType.isCompatibleWith(expressionType);
                }
                return true;
            }
            if (castType.isInterface()) {
                if (Scope.compareTypes(castType, expressionType) == 0) {
                    MethodBinding[] castTbMethods = ((ReferenceBinding)castType).methods();
                    int castTbMethodsLength = castTbMethods.length;
                    MethodBinding[] expressionTbMethods = ((ReferenceBinding)expressionType).methods();
                    int expressionTbMethodsLength = expressionTbMethods.length;
                    int i = 0;
                    while (i < castTbMethodsLength) {
                        int j = 0;
                        while (j < expressionTbMethodsLength) {
                            if (castTbMethods[i].selector == expressionTbMethods[j].selector && castTbMethods[i].returnType != expressionTbMethods[j].returnType && castTbMethods[i].areParametersEqual(expressionTbMethods[j])) {
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        codeStream.instance_of(this.type.resolvedType);
        if (!valueRequired) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = AstNode.NotAConstant;
        TypeBinding expressionType = this.expression.resolveType(scope);
        TypeBinding checkType = this.type.resolveType(scope);
        if (expressionType == null || checkType == null) {
            return null;
        }
        if (!this.areTypesCastCompatible(scope, checkType, expressionType)) {
            scope.problemReporter().notCompatibleTypesError(this, expressionType, checkType);
            return null;
        }
        this.resolvedType = BaseTypes.BooleanBinding;
        return BaseTypes.BooleanBinding;
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.expression.toStringExpression()) + " instanceof " + this.type.toString(0);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

