/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ClusterSessionBase;
import org.apache.catalina.cluster.ReplicationWrapper;

public class MulticastSender
extends ClusterSessionBase
implements ClusterSender {
    private static String senderId = null;
    private String senderName = "MulticastSender";
    private MulticastSocket multicastSocket = null;
    private InetAddress multicastAddress = null;
    private int multicastPort;

    MulticastSender(String senderId, MulticastSocket multicastSocket, InetAddress multicastAddress, int multicastPort) {
        this.multicastAddress = multicastAddress;
        this.multicastPort = multicastPort;
        this.multicastSocket = multicastSocket;
        MulticastSender.senderId = senderId;
    }

    public String getName() {
        return this.senderName;
    }

    public void send(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            oos.writeObject(o);
            oos.flush();
            byte[] obs = bos.toByteArray();
            this.send(obs);
        }
        catch (IOException e) {
            this.log(this.sm.getString("multicastSender.sendException", e.toString()));
        }
    }

    public void send(byte[] b) {
        ReplicationWrapper out = new ReplicationWrapper(b, senderId);
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            oos.writeObject(out);
            oos.flush();
            byte[] obs = bos.toByteArray();
            int size = obs.length;
            DatagramPacket p = new DatagramPacket(obs, size, this.multicastAddress, this.multicastPort);
            this.send(p);
        }
        catch (IOException e) {
            this.log(this.sm.getString("multicastSender.sendException", e.toString()));
        }
    }

    private synchronized void send(DatagramPacket p) {
        try {
            this.multicastSocket.send(p);
        }
        catch (IOException e) {
            this.log(this.sm.getString("multicastSender.sendException", e.toString()));
        }
    }
}

