/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.StringUtils;
import org.apache.excalibur.source.SourceParameters;

public class NetUtils {
    private static BitSet safeCharacters;
    private static final char[] hexadecimal;

    public static String decodePath(String path) {
        StringBuffer translatedPath = new StringBuffer(path.length());
        byte[] encodedchars = new byte[path.length() / 3];
        int i = 0;
        int length = path.length();
        int encodedcharsLength = 0;
        while (i < length) {
            if (path.charAt(i) == '%') {
                while (i < length && path.charAt(i) == '%') {
                    if (i + 2 < length) {
                        try {
                            byte x;
                            encodedchars[encodedcharsLength] = x = (byte)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("NetUtils.decodePath: illegal hex characters in pattern %" + path.substring(i + 1, i + 3));
                        }
                        ++encodedcharsLength;
                        i += 3;
                        continue;
                    }
                    throw new IllegalArgumentException("NetUtils.decodePath: % character should be followed by 2 hexadecimal characters.");
                }
                try {
                    String translatedPart = new String(encodedchars, 0, encodedcharsLength, "UTF-8");
                    translatedPath.append(translatedPart);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Problem in decodePath: UTF-8 encoding not supported.");
                }
                encodedcharsLength = 0;
                continue;
            }
            translatedPath.append(path.charAt(i));
            ++i;
        }
        return translatedPath.toString();
    }

    public static String encodePath(String path) {
        int maxBytesPerChar = 10;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    public static String getPath(String uri) {
        int i = uri.lastIndexOf(47);
        if (i > -1) {
            return uri.substring(0, i);
        }
        i = uri.indexOf(58);
        return i > -1 ? uri.substring(i + 1, uri.length()) : "";
    }

    public static String getExtension(String uri) {
        int dot = uri.lastIndexOf(46);
        if (dot > -1) {
            int slash = (uri = uri.substring(dot)).lastIndexOf(47);
            if (slash > -1) {
                return null;
            }
            int sharp = uri.lastIndexOf(35);
            if (sharp > -1) {
                return uri.substring(0, sharp);
            }
            int mark = uri.lastIndexOf(63);
            if (mark > -1) {
                return uri.substring(0, mark);
            }
            return uri;
        }
        return null;
    }

    public static String absolutize(String path, String resource) {
        if (path == null || path.length() == 0) {
            return resource;
        }
        if (resource == null || resource.length() == 0) {
            return path;
        }
        if (resource.charAt(0) == '/') {
            return resource;
        }
        int length = path.length() - 1;
        boolean slash = path.charAt(length) == '/';
        StringBuffer b = new StringBuffer();
        b.append(path);
        if (!slash) {
            b.append('/');
        }
        b.append(resource);
        return b.toString();
    }

    public static String relativize(String path, String absoluteResource) {
        if (path == null || "".equals(path)) {
            return absoluteResource;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if (absoluteResource.startsWith(path)) {
            return absoluteResource.substring(path.length());
        }
        int index = StringUtils.matchStrings(path, absoluteResource);
        if (index > 0 && path.charAt(index - 1) != '/') {
            index = path.substring(0, index).lastIndexOf(47);
            ++index;
        }
        String pathDiff = path.substring(index);
        String resource = absoluteResource.substring(index);
        int levels = StringUtils.count(pathDiff, '/');
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < levels; ++i) {
            b.append("../");
        }
        b.append(resource);
        return b.toString();
    }

    public static String normalize(String uri) {
        String[] dirty = StringUtils.split(uri, "/");
        int length = dirty.length;
        String[] clean = new String[length];
        while (true) {
            boolean path = false;
            boolean finished = true;
            int j = 0;
            for (int i = 0; i < length && dirty[i] != null; ++i) {
                if (".".equals(dirty[i])) continue;
                if ("..".equals(dirty[i])) {
                    clean[j++] = dirty[i];
                    if (!path) continue;
                    finished = false;
                    continue;
                }
                if (i + 1 < length && "..".equals(dirty[i + 1])) {
                    ++i;
                    continue;
                }
                clean[j++] = dirty[i];
                path = true;
            }
            if (finished) break;
            dirty = clean;
            clean = new String[length];
        }
        StringBuffer b = new StringBuffer(uri.length());
        for (int i = 0; i < length && clean[i] != null; ++i) {
            b.append(clean[i]);
            if (i + 1 >= length || clean[i + 1] == null) continue;
            b.append("/");
        }
        return b.toString();
    }

    public static String deparameterize(String uri, Map parameters) {
        String p;
        int k;
        int i = uri.lastIndexOf(63);
        if (i == -1) {
            return uri;
        }
        String[] params = StringUtils.split(uri.substring(i + 1), "&");
        for (int j = 0; j < params.length && (k = (p = params[j]).indexOf(61)) != -1; ++j) {
            String name = p.substring(0, k);
            String value = p.substring(k + 1);
            parameters.put(name, value);
        }
        return uri.substring(0, i);
    }

    public static String parameterize(String uri, Map parameters) {
        if (parameters.size() == 0) {
            return uri;
        }
        StringBuffer buffer = new StringBuffer(uri);
        buffer.append('?');
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!i.hasNext()) continue;
            buffer.append('&');
        }
        return buffer.toString();
    }

    public static SourceParameters createParameters(Request request) {
        SourceParameters pars = new SourceParameters();
        if (null != request) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String current = (String)names.nextElement();
                String[] values = request.getParameterValues(current);
                if (null == values) continue;
                for (int i = 0; i < values.length; ++i) {
                    pars.setParameter(current, values[i]);
                }
            }
        }
        return pars;
    }

    public static String removeAuthorisation(String uri) {
        if (uri.indexOf("@") != -1 && (uri.startsWith("ftp://") || uri.startsWith("http://"))) {
            return uri.substring(0, uri.indexOf(":") + 2) + uri.substring(uri.indexOf("@") + 1);
        }
        return uri;
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(43);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
        safeCharacters.set(47);
        safeCharacters.set(58);
        safeCharacters.set(64);
        safeCharacters.set(38);
        safeCharacters.set(61);
    }
}

