/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;

class SerialObjectOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private byte[] m_buffer;
    private LinkedList m_buffers;
    private int m_index;
    private int m_size;
    private int m_blockSize;
    private boolean m_closed;

    public SerialObjectOutputStream() {
        this(8192);
    }

    public SerialObjectOutputStream(int n) {
        this.m_blockSize = n;
        this.m_buffer = new byte[this.m_blockSize];
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.m_buffers != null) {
            Iterator iterator = this.m_buffers.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                outputStream.write(byArray, 0, this.m_blockSize);
            }
        }
        outputStream.write(this.m_buffer, 0, this.m_index);
    }

    public void writeTo(RandomAccessFile randomAccessFile) throws IOException {
        if (this.m_buffers != null) {
            Iterator iterator = this.m_buffers.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                randomAccessFile.write(byArray, 0, this.m_blockSize);
            }
        }
        randomAccessFile.write(this.m_buffer, 0, this.m_index);
    }

    public int getSize() {
        return this.m_size + this.m_index;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.getSize()];
        int n = 0;
        if (this.m_buffers != null) {
            Iterator iterator = this.m_buffers.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                System.arraycopy(byArray2, 0, byArray, n, this.m_blockSize);
                n += this.m_blockSize;
            }
        }
        System.arraycopy(this.m_buffer, 0, byArray, n, this.m_index);
        return byArray;
    }

    public void write(int n) throws IOException {
        if (this.m_closed) {
            throw new IOException("Stream m_closed");
        }
        if (this.m_index == this.m_blockSize) {
            if (this.m_buffers == null) {
                this.m_buffers = new LinkedList();
            }
            this.m_buffers.addLast(this.m_buffer);
            this.m_buffer = new byte[this.m_blockSize];
            this.m_size += this.m_index;
            this.m_index = 0;
        }
        this.m_buffer[this.m_index++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > byArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_closed) {
            throw new IOException("Stream m_closed");
        }
        if (this.m_index + n2 > this.m_blockSize) {
            int n3 = 0;
            while (n3 < n2) {
                this.write(byArray[n + n3]);
                ++n3;
            }
        } else {
            System.arraycopy(byArray, n, this.m_buffer, this.m_index, n2);
            this.m_index += n2;
        }
    }

    public void close() {
        this.m_closed = true;
    }
}

