/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReadDOMSessionTransformer
extends AbstractTransformer {
    public static final String ATTRIBUTE_NAME = "attribute-name";
    public static final String TRIGGER_ELEMENT = "trigger-element";
    public static final String POSITION = "position";
    Session session;
    String attributeName;
    String trigger;
    String position;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        this.session = request.getSession(false);
        if (this.session != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Session is available. ID=" + this.session.getId());
            }
            this.attributeName = parameters.getParameter(ATTRIBUTE_NAME, null);
            if (this.attributeName == null) {
                this.attributeName = parameters.getParameter("dom-name", null);
            }
            this.trigger = parameters.getParameter(TRIGGER_ELEMENT, null);
            this.position = parameters.getParameter(POSITION, "in");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("attribute-name=" + this.attributeName + ", " + TRIGGER_ELEMENT + "=" + this.trigger + ", " + POSITION + "=" + this.position);
            }
        } else {
            this.getLogger().warn("No session object: Nothing to do.");
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (name.equalsIgnoreCase(this.trigger)) {
            this.getLogger().debug("Trigger encountered");
            if ("before".equalsIgnoreCase(this.position)) {
                this.stream();
                this.contentHandler.startElement(uri, name, raw, attributes);
            } else if ("in".equalsIgnoreCase(this.position)) {
                this.contentHandler.startElement(uri, name, raw, attributes);
                this.stream();
            } else if ("after".equalsIgnoreCase(this.position)) {
                this.contentHandler.startElement(uri, name, raw, attributes);
            }
        } else {
            this.contentHandler.startElement(uri, name, raw, attributes);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        this.contentHandler.endElement(uri, name, raw);
        if (name.equalsIgnoreCase(this.trigger) && "after".equalsIgnoreCase(this.position)) {
            this.stream();
        }
    }

    private void stream() throws SAXException {
        if (this.attributeName != null) {
            Object node = this.session.getAttribute(this.attributeName);
            if (node != null) {
                this.getLogger().debug("Start streaming");
                XMLUtils.valueOf((ContentHandler)new IncludeXMLConsumer(this.xmlConsumer), node);
            } else {
                this.getLogger().error("No attribute " + this.attributeName + " in session");
            }
        } else {
            this.getLogger().error("No attribute-name parameter specified");
        }
    }
}

