/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class SuperTypeReferencePattern
extends SearchPattern {
    public char[] superQualification;
    public char[] superSimpleName;
    protected char[] decodedSuperQualification;
    protected char[] decodedSuperSimpleName;
    protected char decodedSuperClassOrInterface;
    protected char[] decodedQualification;
    protected char[] decodedSimpleName;
    protected char[] decodedEnclosingTypeName;
    protected char decodedClassOrInterface;
    protected int decodedModifiers;
    public HashMap entryResults;
    private static final IEntryResult[] NO_ENTRY_RESULT = new IEntryResult[0];

    public SuperTypeReferencePattern(char[] superQualification, char[] superSimpleName, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        this.superQualification = isCaseSensitive ? superQualification : CharOperation.toLowerCase(superQualification);
        this.superSimpleName = isCaseSensitive ? superSimpleName : CharOperation.toLowerCase(superSimpleName);
        this.needsResolve = superQualification != null;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int slash = IIndexConstants.SUPER_REF.length - 1;
        int n = slash + 1;
        slash = CharOperation.indexOf('/', word, slash + 1);
        this.decodedSuperSimpleName = CharOperation.subarray(word, n, slash);
        int oldSlash = slash;
        this.decodedSuperQualification = (char[])((slash = CharOperation.indexOf('/', word, slash + 1)) == oldSlash + 1 ? null : CharOperation.subarray(word, oldSlash + 1, slash));
        this.decodedSuperClassOrInterface = word[slash + 1];
        int n2 = (slash += 2) + 1;
        slash = CharOperation.indexOf('/', word, slash + 1);
        this.decodedSimpleName = CharOperation.subarray(word, n2, slash);
        oldSlash = slash;
        this.decodedEnclosingTypeName = (char[])((slash = CharOperation.indexOf('/', word, slash + 1)) == oldSlash + 1 ? null : (slash == oldSlash + 2 && word[oldSlash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO : CharOperation.subarray(word, oldSlash + 1, slash)));
        oldSlash = slash;
        slash = CharOperation.indexOf('/', word, slash + 1);
        this.decodedQualification = (char[])(slash == oldSlash + 1 ? null : CharOperation.subarray(word, oldSlash + 1, slash));
        this.decodedClassOrInterface = word[slash + 1];
        this.decodedModifiers = word[slash + 2];
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptSuperTypeReference(path, this.decodedQualification, this.decodedSimpleName, this.decodedEnclosingTypeName, this.decodedClassOrInterface, this.decodedSuperQualification, this.decodedSuperSimpleName, this.decodedSuperClassOrInterface, this.decodedModifiers);
            }
            ++i;
        }
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IJavaSearchScope scope) throws IOException {
        if (this.entryResults == null) {
            super.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
            return;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IEntryResult[] entries = (IEntryResult[])this.entryResults.get(input);
        if (entries == null) {
            entries = input.queryEntriesPrefixedBy(IIndexConstants.SUPER_REF);
            if (entries == null) {
                entries = NO_ENTRY_RESULT;
            }
            this.entryResults.put(input, entries);
        }
        if (entries == NO_ENTRY_RESULT) {
            return;
        }
        int slash = IIndexConstants.SUPER_REF.length;
        char[] simpleName = this.superSimpleName;
        int length = simpleName == null ? 0 : simpleName.length;
        int i = 0;
        int max = entries.length;
        while (i < max) {
            IEntryResult entry = entries[i];
            if (simpleName != null) {
                char[] word = entry.getWord();
                if (slash + length < word.length && word[length + slash] == '/') {
                    int j = 0;
                    while (j < length) {
                        char value = word[j + slash];
                        if (value == simpleName[j]) {
                            ++j;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.decodeIndexEntry(entry);
                this.feedIndexRequestor(requestor, detailLevel, entry.getFileReferences(), input, scope);
            }
            ++i;
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestReferencePrefix(IIndexConstants.SUPER_REF, this.superSimpleName, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 2;
    }

    protected boolean matchIndexEntry() {
        if (this.superSimpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.superSimpleName, this.decodedSuperSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.superSimpleName, this.decodedSuperSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.superSimpleName, this.decodedSuperSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SuperTypeReferencePattern: <");
        if (this.superSimpleName != null) {
            buffer.append(this.superSimpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        char[][] superInterfaces;
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] vmName = type.getSuperclassName();
        if (vmName != null) {
            char[] superclassName = (char[])vmName.clone();
            CharOperation.replace(vmName, '/', '.');
            if (this.matchesType(this.superSimpleName, this.superQualification, superclassName)) {
                return true;
            }
        }
        if ((superInterfaces = type.getInterfaceNames()) != null) {
            int i = 0;
            int max = superInterfaces.length;
            while (i < max) {
                char[] superInterfaceName = (char[])superInterfaces[i].clone();
                CharOperation.replace(superInterfaceName, '/', '.');
                if (this.matchesType(this.superSimpleName, this.superQualification, superInterfaceName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (!(node instanceof TypeReference)) {
            return 0;
        }
        TypeReference typeRef = (TypeReference)node;
        if (resolve) {
            TypeBinding binding = typeRef.resolvedType;
            if (binding == null) {
                return 3;
            }
            return this.matchLevelForType(this.superSimpleName, this.superQualification, binding);
        }
        if (this.superSimpleName == null) {
            return this.needsResolve ? 1 : 2;
        }
        char[] typeRefSimpleName = null;
        if (typeRef instanceof SingleTypeReference) {
            typeRefSimpleName = ((SingleTypeReference)typeRef).token;
        } else {
            char[][] tokens = ((QualifiedTypeReference)typeRef).tokens;
            typeRefSimpleName = tokens[tokens.length - 1];
        }
        if (this.matchesName(this.superSimpleName, typeRefSimpleName)) {
            return this.needsResolve ? 1 : 2;
        }
        return 0;
    }

    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof ReferenceBinding)) {
            return 0;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        int level = this.matchLevelForType(this.superSimpleName, this.superQualification, type.superclass());
        switch (level) {
            case 0: {
                break;
            }
            case 2: {
                return 2;
            }
        }
        ReferenceBinding[] superInterfaces = type.superInterfaces();
        int i = 0;
        int max = superInterfaces.length;
        while (i < max) {
            int newLevel = this.matchLevelForType(this.superSimpleName, this.superQualification, superInterfaces[i]);
            switch (newLevel) {
                case 0: {
                    break;
                }
                case 2: {
                    return 2;
                }
                default: {
                    level = newLevel;
                }
            }
            ++i;
        }
        return level;
    }
}

