/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;

public class PackageReferencePattern
extends AndPattern {
    private static char[][] TAGS = new char[][]{IIndexConstants.REF};
    private char[] pkgName;
    private char[][] segments;
    private int currentSegment;
    private char[] decodedSegment;

    public PackageReferencePattern(char[] pkgName, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        Object object;
        if (!isCaseSensitive) {
            pkgName = CharOperation.toLowerCase(pkgName);
        }
        this.pkgName = pkgName;
        char[][] splittedName = CharOperation.splitOn('.', pkgName);
        if (splittedName == CharOperation.NO_CHAR_CHAR) {
            char[][] cArrayArray = new char[1][];
            object = cArrayArray;
            cArrayArray[0] = pkgName;
        } else {
            object = splittedName;
        }
        this.segments = object;
        this.needsResolve = pkgName != null;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int tagLength = IIndexConstants.REF.length;
        int nameLength = CharOperation.indexOf('/', word, tagLength);
        if (nameLength < 0) {
            nameLength = size;
        }
        this.decodedSegment = CharOperation.subarray(word, tagLength, nameLength);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file;
            int reference = references[i];
            if (reference != -1 && (file = input.getIndexedFile(reference)) != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptPackageReference(path, this.pkgName);
            }
            ++i;
        }
    }

    protected char[][] getPossibleTags() {
        return TAGS;
    }

    protected boolean hasNextQuery() {
        if (this.segments.length > 2) {
            return --this.currentSegment >= 2;
        }
        return --this.currentSegment >= 0;
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestReferencePrefix(IIndexConstants.REF, this.segments[this.currentSegment], this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 15;
    }

    private boolean matches(char[][] tokens) {
        char[] name = CharOperation.concatWith(tokens, '.');
        return this.matchesName(this.pkgName, name);
    }

    protected boolean matchIndexEntry() {
        switch (this.matchMode) {
            case 0: {
                if (CharOperation.equals(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) break;
                return false;
            }
            case 1: {
                if (CharOperation.prefixEquals(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) break;
                return false;
            }
            case 2: {
                if (CharOperation.match(this.segments[this.currentSegment], this.decodedSegment, this.isCaseSensitive)) break;
                return false;
            }
        }
        return true;
    }

    protected void matchReportReference(AstNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        char[][] tokens = null;
        if (reference instanceof ImportReference) {
            ImportReference importRef = (ImportReference)reference;
            if (importRef.onDemand) {
                tokens = importRef.tokens;
            } else {
                int length = importRef.tokens.length - 1;
                tokens = new char[length][];
                System.arraycopy(importRef.tokens, 0, tokens, 0, length);
            }
        } else if (reference instanceof QualifiedNameReference) {
            PackageBinding pkgBinding;
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            Binding binding = qNameRef.binding;
            TypeBinding typeBinding = null;
            switch (qNameRef.bits & 7) {
                case 1: {
                    typeBinding = qNameRef.actualReceiverType;
                    break;
                }
                case 4: {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                case 3: 
                case 7: {
                    if (!(binding instanceof ProblemBinding)) break;
                    ProblemBinding pbBinding = (ProblemBinding)binding;
                    typeBinding = pbBinding.searchType;
                }
            }
            if (typeBinding instanceof ReferenceBinding && (pkgBinding = ((ReferenceBinding)typeBinding).fPackage) != null) {
                tokens = pkgBinding.compoundName;
            }
            if (tokens == null) {
                tokens = qNameRef.tokens;
            }
        } else if (reference instanceof QualifiedTypeReference) {
            PackageBinding pkgBinding;
            QualifiedTypeReference qTypeRef = (QualifiedTypeReference)reference;
            TypeBinding typeBinding = qTypeRef.resolvedType;
            if (typeBinding instanceof ArrayBinding) {
                typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
            }
            if (typeBinding instanceof ReferenceBinding && (pkgBinding = ((ReferenceBinding)typeBinding).fPackage) != null) {
                tokens = pkgBinding.compoundName;
            }
            if (tokens == null) {
                tokens = qTypeRef.tokens;
            }
        }
        if (tokens == null) {
            tokens = CharOperation.NO_CHAR_CHAR;
        }
        locator.reportAccurateReference(reference.sourceStart, reference.sourceEnd, tokens, element, accuracy);
    }

    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            buffer.append(this.pkgName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (node instanceof QualifiedTypeReference) {
            return this.matchLevel((QualifiedTypeReference)node, resolve);
        }
        if (node instanceof ImportReference) {
            return this.matchLevel((ImportReference)node, resolve);
        }
        if (node instanceof QualifiedNameReference) {
            return this.matchLevel((QualifiedNameReference)node, resolve);
        }
        return 0;
    }

    private int matchLevel(ImportReference importRef, boolean resolve) {
        if (importRef.onDemand) {
            if (this.matches(importRef.tokens)) {
                return 2;
            }
            return 0;
        }
        char[] qualifiedTypeName = CharOperation.concatWith(importRef.tokens, '.');
        switch (this.matchMode) {
            case 0: 
            case 1: {
                if (!CharOperation.prefixEquals(this.pkgName, qualifiedTypeName, this.isCaseSensitive)) break;
                return 1;
            }
            case 2: {
                if (!CharOperation.match(this.pkgName, qualifiedTypeName, this.isCaseSensitive)) break;
                return 1;
            }
        }
        return 0;
    }

    private int matchLevel(QualifiedNameReference qNameRef, boolean resolve) {
        if (!resolve) {
            if (this.pkgName == null) {
                return this.needsResolve ? 1 : 2;
            }
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (CharOperation.prefixEquals(this.pkgName, CharOperation.concatWith(qNameRef.tokens, '.'), this.isCaseSensitive)) {
                        return this.needsResolve ? 1 : 2;
                    }
                    return 0;
                }
                case 2: {
                    char[] pattern;
                    char[] cArray = pattern = this.pkgName[this.pkgName.length - 1] == '*' ? this.pkgName : CharOperation.concat(this.pkgName, ".*".toCharArray());
                    if (CharOperation.match(pattern, CharOperation.concatWith(qNameRef.tokens, '.'), this.isCaseSensitive)) {
                        return this.needsResolve ? 1 : 2;
                    }
                    return 0;
                }
            }
            return 0;
        }
        Binding binding = qNameRef.binding;
        if (binding == null) {
            return 3;
        }
        TypeBinding typeBinding = null;
        char[][] tokens = qNameRef.tokens;
        int lastIndex = tokens.length - 1;
        switch (qNameRef.bits & 7) {
            case 1: {
                int otherBindingsCount;
                typeBinding = qNameRef.actualReceiverType;
                int n = otherBindingsCount = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
                if ((lastIndex -= otherBindingsCount + 1) >= 0) break;
                return 0;
            }
            case 2: {
                return 0;
            }
            case 4: {
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding pbBinding = (ProblemBinding)binding;
                typeBinding = pbBinding.searchType;
                char[] partialQualifiedName = pbBinding.name;
                lastIndex = CharOperation.occurencesOf('.', partialQualifiedName) - 1;
                if (typeBinding != null && lastIndex >= 0) break;
                return 3;
            }
        }
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding == null) {
            return 3;
        }
        if (typeBinding instanceof ReferenceBinding) {
            PackageBinding pkgBinding = ((ReferenceBinding)typeBinding).fPackage;
            if (pkgBinding == null) {
                return 3;
            }
            if (this.matches(pkgBinding.compoundName)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    private int matchLevel(QualifiedTypeReference typeRef, boolean resolve) {
        if (!resolve) {
            if (this.pkgName == null) {
                return this.needsResolve ? 1 : 2;
            }
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (CharOperation.prefixEquals(this.pkgName, CharOperation.concatWith(typeRef.tokens, '.'), this.isCaseSensitive)) {
                        return this.needsResolve ? 1 : 2;
                    }
                    return 0;
                }
                case 2: {
                    char[] pattern;
                    char[] cArray = pattern = this.pkgName[this.pkgName.length - 1] == '*' ? this.pkgName : CharOperation.concat(this.pkgName, ".*".toCharArray());
                    if (CharOperation.match(pattern, CharOperation.concatWith(typeRef.tokens, '.'), this.isCaseSensitive)) {
                        return this.needsResolve ? 1 : 2;
                    }
                    return 0;
                }
            }
            return 0;
        }
        return this.matchLevel(typeRef.resolvedType);
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (binding == null) {
            this.matchReportReference(importRef, element, accuracy, locator);
        } else if (binding instanceof ImportBinding) {
            locator.reportAccurateReference(importRef.sourceStart, importRef.sourceEnd, importRef.tokens, element, accuracy);
        } else if (binding instanceof ReferenceBinding) {
            PackageBinding pkgBinding = ((ReferenceBinding)binding).fPackage;
            if (pkgBinding != null) {
                locator.reportAccurateReference(importRef.sourceStart, importRef.sourceEnd, pkgBinding.compoundName, element, accuracy);
            } else {
                locator.reportAccurateReference(importRef.sourceStart, importRef.sourceEnd, importRef.tokens, element, accuracy);
            }
        }
    }

    public int matchLevel(Binding binding) {
        if (binding instanceof ImportBinding) {
            if (this.matches(((ImportBinding)binding).compoundName)) {
                return 2;
            }
            return 0;
        }
        if (binding instanceof TypeBinding) {
            TypeBinding typeBinding = (TypeBinding)binding;
            if (typeBinding == null || typeBinding instanceof ProblemReferenceBinding) {
                return 3;
            }
            if (typeBinding instanceof ArrayBinding) {
                typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
            }
            if (typeBinding == null) {
                return 3;
            }
            if (typeBinding instanceof ReferenceBinding) {
                PackageBinding pkgBinding = ((ReferenceBinding)typeBinding).fPackage;
                if (this.matches(pkgBinding.compoundName)) {
                    return 2;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }
}

