/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class CreateWorkingCopyOperation
extends JavaModelOperation {
    Map perFactoryWorkingCopies;
    IBufferFactory factory;
    IProblemRequestor problemRequestor;

    public CreateWorkingCopyOperation(ICompilationUnit originalElement, Map perFactoryWorkingCopies, IBufferFactory factory, IProblemRequestor problemRequestor) {
        super(new IJavaElement[]{originalElement});
        this.perFactoryWorkingCopies = perFactoryWorkingCopies;
        this.factory = factory;
        this.problemRequestor = problemRequestor;
    }

    protected void executeOperation() throws JavaModelException {
        ICompilationUnit cu = this.getCompilationUnit();
        WorkingCopy workingCopy = new WorkingCopy((IPackageFragment)cu.getParent(), cu.getElementName(), this.factory, this.problemRequestor);
        workingCopy.open(this.fMonitor);
        if (this.perFactoryWorkingCopies != null) {
            this.perFactoryWorkingCopies.put(cu, workingCopy);
            if (CompilationUnit.SHARED_WC_VERBOSE) {
                System.out.println("Creating shared working copy " + workingCopy.toStringWithAncestors());
            }
        }
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        delta.added(workingCopy);
        this.addDelta(delta);
        this.fResultElements = new IJavaElement[]{workingCopy};
    }

    protected ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

