/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;
    public static final Block None = new Block(0);

    public Block(int explicitDeclarations) {
        this.explicitDeclarations = explicitDeclarations;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean didAlreadyComplain = false;
        int i = 0;
        int max = this.statements.length;
        while (i < max) {
            Statement stat = this.statements[i];
            if (!flowInfo.complainIfUnreachable(stat, this.scope, didAlreadyComplain)) {
                flowInfo = stat.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                didAlreadyComplain = true;
            }
            ++i;
        }
        return flowInfo;
    }

    public static final Block EmptyWith(int sourceStart, int sourceEnd) {
        Block bk = new Block(0);
        bk.sourceStart = sourceStart;
        bk.sourceEnd = sourceEnd;
        return bk;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.statements != null) {
            int i = 0;
            int max = this.statements.length;
            while (i < max) {
                this.statements[i].generateCode(this.scope, codeStream);
                ++i;
            }
        }
        if (this.scope != currentScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public void resolve(BlockScope upperScope) {
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope, this.explicitDeclarations);
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public void resolveUsing(BlockScope givenScope) {
        this.scope = givenScope;
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        if (this.statements == null) {
            s = String.valueOf(s) + "{\n";
            s = String.valueOf(s) + AstNode.tabString(tab);
            s = String.valueOf(s) + "}";
            return s;
        }
        s = String.valueOf(s) + "{\n";
        s = String.valueOf(s) + this.toStringStatements(tab);
        s = String.valueOf(s) + AstNode.tabString(tab);
        s = String.valueOf(s) + "}";
        return s;
    }

    public String toStringStatements(int tab) {
        if (this.statements == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.statements.length) {
            buffer.append(this.statements[i].toString(tab + 1));
            if (this.statements[i] instanceof Block) {
                buffer.append("\n");
            } else {
                buffer.append(";\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.statements != null) {
            int statementLength = this.statements.length;
            int i = 0;
            while (i < statementLength) {
                this.statements[i].traverse(visitor, this.scope);
                ++i;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(label);
        }
    }
}

