/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;


public class StringTools
{
    public static final Logger log = Logger.getLogger(StringTools.class);

    public static final byte[] LF = new byte[] {(byte)10};
    public static final String LF_TOKEN = new String(LF);
    public static final String HTML_LF_TOKEN = "\\<br/\\>";

    public static boolean hasInfo(String s) {
	return s != null && ! s.equals("");
    }

//     public static String formatLeadingWhitespace(String s) {
// 	// probably should write something more intelligent, 
// 	// but for now this will have to do
// 	int nb = countLeadingWhitespace(s);
// 	StringBuffer ret = new StringBuffer();
// 	for (int i = 0; i < nb; i++)
// 	    ret.append("&nbsp;");
// 	return ret.toString();
//     }

//     public static int countLeadingWhitespace(String s) {
// 	if (s == null || s.length() == 0)
// 	    return 0;
// 	int i = 0;
// 	while (Character.isWhitespace(s.charAt(i))) 
// 	    i++;
// 	return i;
//     }

    /**
     * Print the stack trace of an exception into a string
     */
    public static String getStackTraceAsString(Throwable t)
    {
	ByteArrayOutputStream bytes = new ByteArrayOutputStream();
	PrintWriter writer = new PrintWriter(bytes, true);
	t.printStackTrace(writer);
	return bytes.toString();
    }

    /**
     * Convert a string array to an int array. 
     * @throws NumberFormatException if one of the strings is not an int
     */
    public static int[] toIntArray(String[] sa)
	throws NumberFormatException
    {
	if (sa == null) return null;
	int[] ret = new int[sa.length];
	for (int i = 0; i < sa.length; i++) {
	    String curr = sa[i];
	    if (curr != null) curr = curr.trim();
	    ret[i] = Integer.parseInt(curr);
	}
	return ret;
    }

    public static String toStandardString(Date d) {
	return DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, Locale.US).format(d);
    }

    public static String toDisplayableString(String s) {
	if (s != null)
		return s.replace((char)Character.LINE_SEPARATOR, ' ');
	else
		return null;
    }

    public static String toHtmlDisplayableString(String s) {
	if (s != null) {
	    // replace returns by html break-line
	    StringTokenizer st = new StringTokenizer(s, LF_TOKEN);
	    StringBuffer newString = new StringBuffer();
	    while (st.hasMoreTokens()) {
		newString.append(st.nextToken()).
		    append(HTML_LF_TOKEN);
	    }
	    
	    return newString.toString();
	}
	else
	    return null;
    }

    public static void writeToDisplayableReferencedString(StringBuffer base, String addStuff, String prefix) 
    {
	StringTokenizer st = new StringTokenizer(addStuff, LF_TOKEN);
	while (st.hasMoreTokens()) {
	    base.append(prefix).
		append(st.nextToken()).
		append(LF_TOKEN);
	}
 
	if (log.isDebugEnabled()) {
	    log.debug("writeToDisplayableReferencedString() called with prefix " + prefix);
	    log.debug("writeToDisplayableReferencedString() before replacement: " + addStuff);
	    log.debug("writeToDisplayableReferencedString() after replacement: " + base.toString());
	    log.debug("writeToDisplayableReferencedString() done");
	}
    }

    public static String sizeToString(long size) {
	if (size < 1024)
	    return Long.toString(size) + " b";
	else
	    return Long.toString(size / 1024) + " Kb";
    }

    /**
     * Get string as short format in us locale - this allows a common
     * format which can then be converted into desired locale by GUI
     * application such as Cocoon
     */
    public static String getCurrentDateAsString() {
	return toStandardString(new Date());
    }

    /** 
     * Determines if the parameter can be interpreted as an empty line:
     * for instance, if it contains just a newline
     */
    public static boolean isEmptyLine(String s) {
	if (s == null)
	    return true;
	else
	    return (s.trim().length() == 0);
    }

    /**
     * useful for debugging
     */
    public static String toString(Map map)
    {
	StringBuffer ret = new StringBuffer();
	ret.append("<" + Map.class + " ");
	Iterator it = map.keySet().iterator();
	while (it.hasNext()) {
	    Object key = it.next();
	    ret.append(key + "=" + map.get(key) + " ");
	}

	ret.append("/>");
	return ret.toString();
    }


}
