/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

/**
 * Base class for exceptions which are framework exceptions or application
 * exceptions, and may encapsulate a system exception (or other exception
 * coming from a lower layer)
 * 
 * @author jwk
 */
public class ExceptionWithChild extends Exception
{
    private Throwable child;

    public ExceptionWithChild(String s) {
	this(s, null);
    }

    public ExceptionWithChild(String s, Throwable child) {
	super(s);
	this.child = child;
    }

    public Throwable getChild() {
	return child;
    }

    public String toString() {
	return getClass().getName() + ": " + getMessage()
	    + " (child: "
	    + (child == null ? "null" : child.toString())
	    + ")";
    }

}
