/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.NoConnectionException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.model.user.UserPreferences;

class UserBehaviorAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(UserBehaviorAction.class);

    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("process() handling user behavior setup");

	String store = req.getParameter("store");
	if (store != null) {
	    String parInitialFolder = ServletTools.getString(req,"initialFolder");
	    boolean parReplyToAll = ServletTools.getBoolean(req,"replyToAll");
	    boolean parForwardAsAttachment = 
		ServletTools.getBoolean(req,"forwardAsAttachment");
	    int parNbMsgsPerScreen = 
		ServletTools.getInteger(req, "nbMsgsPerScreen", true, 0);

	    if (log.isDebugEnabled())
		log.debug("process() handling storing, parameters are "
			  + "(initialFolder," + parInitialFolder 
			  + "), (replyToAll," + parReplyToAll 
			  + "), (forwardAsAttachment," + parForwardAsAttachment
			  + "), (nbMsgsPerScreen," + parNbMsgsPerScreen
			  + ")");

	    UserPreferences up = wb.getUserPreferences();
	    if (up == null) {
		log.info("process() initial user preferences non-existent, creating");
		up = new UserPreferences();
	    }

	    up.setInitialFolder(getInitialFolder(wb, parInitialFolder));
	    up.setReplyToAll(parReplyToAll);
	    up.setForwardAsAttachment(parForwardAsAttachment);
	    up.setNbMsgsPerScreen(parNbMsgsPerScreen);

	    // done creating new UserPreferences
	    try {
		wb.setUserPreferences(up);
		// OK, so set marker
		ServletTools.setUpdate(req);
	    }
	    catch (NoConnectionException e) {
		// TO DO: handle this exception differently, somehow ??
		// either attempt to recreate connection, 
		// or do not fail action, instead set error for nicer
		// handling of user interface
		throw e;
	    }
	}
	else {
	    if (log.isDebugEnabled())
		log.debug("process() not called with a specific action - no further processing");
	}

	if (log.isDebugEnabled())
	    log.debug("process() completed succesfully");
    }

    private String getInitialFolder(MailWorkerBean wb, String s_initFolderNr) {
	    int initialFolderNr = -1;
	    if (s_initFolderNr != null)
		initialFolderNr = Integer.parseInt(s_initFolderNr);
	    // now determine a folder name to store
	    String initialFolder;
	    if (initialFolderNr >= 0)
		initialFolder = wb.getMailboxOverview().getMailFolderHeader(initialFolderNr).getName();
	    else
		initialFolder = null;

	    if (log.isDebugEnabled())
		log.debug("process() got parameter initialFolder: " + initialFolder);	    

	    return initialFolder;
    }
}
