/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;
import java.util.Map;
import javax.servlet.ServletRequest;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.ServletTools;

class FolderAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(FolderAction.class);
    private final static String PARAM_FOLDER_NR = "folderNr";
    private final static String PARAM_REFRESH = "refresh";
    private final static String PARAM_REFRESH_ALL = "refreshAll";
    

    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("process() called");

	// folder information is requested : load data
	int nr = ServletTools.getInteger(req,PARAM_FOLDER_NR,true);

	// see if refresh is to be forced
	boolean refresh = (req.getParameter(PARAM_REFRESH) != null);

	// see if refresh all is to be forced
	boolean refreshAll = (req.getParameter(PARAM_REFRESH_ALL) != null);

	if (log.isDebugEnabled())
	    log.debug("process() read parameters nr " + nr 
		      + ", refresh ? " + refresh 
		      + ", refreshAll ? " + refreshAll);

	if (refreshAll) {
	    wb.setMailboxOverview(true);
	    wb.setMailFolder(nr, false);
	}
	else
	    wb.setMailFolder(nr, refresh);

	if (log.isDebugEnabled())
	    log.debug("process() successful");
    }
}
