/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import java.util.Vector;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;

/**
 * Represents something the user has input into a form,
 * so basically name-value pairs
 */
public class UserInput
{
    private final Logger log = Logger.getLogger(UserInput.class);

    private Vector names;
    private Vector values;

    public UserInput() {
	names = new Vector();
	values = new Vector();
    }

    public UserInput(ServletRequest req, String[]params) {
	names = new Vector(params.length);
	values = new Vector(params.length);
	for (int i = 0; i < params.length; i++) {
	    names.add(i, params[i]);
	    values.add(i, (String)req.getParameter(params[i]));
	}
    }
    
    public String get(String name) {
	int index = names.indexOf(name);
	if (index >= 0)
	    return (String)values.get(index);
	else
	    return null;
    }

    public void add(String name, String value) {
	names.add(name);
	values.add(value);
    }
}
