/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import javax.security.auth.login.LoginException;
import javax.security.auth.login.FailedLoginException;

public interface ServerConnection
{
    /**
     * @throws IllegalArgumentException if you pass crap as parameters
     * @throws FailedLoginException if user login was not successful,
     * for example due to incorrect password
     * @throws LoginException if some unexpected error occurred while
     * attempting to connect. 
     * N.B. FailedLoginException is more specifid than LoginException
     * and must be caught first !
     */
    void connect(String host, String user, char[] password)
	throws IllegalArgumentException, FailedLoginException, LoginException;

    void disconnect();

    String getUser();

    String getHost();
}
