/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model.user;

import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

/**
 * Implementation note: this must be a bean, as it will be serialized as XML
 */
public class UserPreferences
{
    public final static String KEY = "UserPreferences";
    // user types used in this class (including superclasses of used types)
    public final static Class[] TYPES = {UserPreferences.class, InternetAddress.class, Address.class, CustomSeparator.class};

    private final static Logger log = Logger.getLogger(UserPreferences.class);

    private long key;
    private String signature;
    private String initialFolder;
    private boolean isReplyToAll;
    private boolean isForwardAsAttachment;
    private InternetAddress fromAddress;
    private CustomSeparator replySeparator;
    private CustomSeparator forwardSeparator;
    private int nbMsgsPerScreen;

    public UserPreferences() {
	key = System.currentTimeMillis();
	if (log.isDebugEnabled())
	    log.debug("UserPreferences() created" + this.toString());
    }

    public void setKey(long newKey) {
	key = newKey;
    }
    public long getKey() {
	return key;
    }

    public void setSignature(String signature) {
	if (log.isDebugEnabled())
	    log.debug("setSignature() called on key " + key + " with signature=" + signature);

	if (signature != null && ! signature.equals(""))
	    this.signature = signature;
	else
	    signature = null;
    }

    public String getSignature() {
	if (log.isDebugEnabled())
	    log.debug("getSignature() called on key " + key + ", returning signature " + signature);
	return signature;
    }

    public void setInitialFolder(String initialFolder) {
	this.initialFolder = initialFolder;
    }

    public String getInitialFolder() {
	return initialFolder;
    }

    public void setReplyToAll(boolean isReplyToAll) {
	this.isReplyToAll = isReplyToAll;
    }

    public boolean getReplyToAll() {
	return isReplyToAll;
    }

    public void setForwardAsAttachment(boolean isForwardAsAttachment) {
	this.isForwardAsAttachment = isForwardAsAttachment;
    }

    public boolean getForwardAsAttachment() {
	return isForwardAsAttachment;
    }

    public void setFromAddress(InternetAddress fromAddress) {
	this.fromAddress = fromAddress;
    }

    public InternetAddress getFromAddress() {
	return fromAddress;
    }

    public void setReplySeparator(CustomSeparator referenceSeparator) {
	this.replySeparator = referenceSeparator;
    }

    public CustomSeparator getReplySeparator() {
	return replySeparator;
    }

    public void setForwardSeparator(CustomSeparator referenceSeparator) {
	this.forwardSeparator = referenceSeparator;
    }

    public CustomSeparator getForwardSeparator() {
	return forwardSeparator;
    }

    public CustomSeparator getReferenceSeparator(boolean isReply) {
	if (isReply)
	    return replySeparator;
	else
	    return forwardSeparator;
    }

    public int getNbMsgsPerScreen() {
	return nbMsgsPerScreen;
    }

    public void setNbMsgsPerScreen(int par) {
	nbMsgsPerScreen = par;
    }

    /** for debugging */
    public String toString() {
	StringBuffer ret = new StringBuffer();
	ret.append("UserPreferences are {")
	    .append("key: " + key)
	    .append(", signature: " + signature)
	    .append(", initialFolder: " + initialFolder)
	    .append(", isReplyToAll: " + isReplyToAll)
	    .append(", fromAddress: " + fromAddress)
	    .append(", replySeparator: " + replySeparator)
	    .append(", forwardSeparator: " + forwardSeparator)
	    .append(", nbMsgsPerScreen: " + nbMsgsPerScreen)
	    .append("}");
	return ret.toString();
    }

    public static UserPreferences getTestObject() {
	UserPreferences ret = new UserPreferences();
	ret.setSignature("Prof.Dr. Evil\nKanntdafr Unternehmungen\n10, Doofe Strasse\nPlsqlamisch Republic Oraklistan");
	return ret;
    }
}
