/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.framework.StringTools;

/**
 * Representation of an attachment using a File.
 * Current implementation of Cocoon (2.0.2) uses files for multipart forms,
 * so we represent attachments as files in the current model. In the future,
 * it may be preferable to switch to something more generic.
 * Note that only the constructor is File specific, all other stuff is more
 * generic.
 */
public class FileAttachment
{
    private final Logger log = Logger.getLogger(FileAttachment.class);
    private File file;
    private long size;
    private String sizeAsString;
    private String name;
    private MimeBodyPart mimeBodyPart;

    public FileAttachment(File file) 
	throws ModelException
    {
	this.file = file;
	size = file.length();
	sizeAsString = StringTools.sizeToString(size);
	name = file.getName();
	if (log.isDebugEnabled())
	    log.debug("FileAttachment() created with name=" + name
		      + ", size=" + sizeAsString);

	try {
	    mimeBodyPart = new MimeBodyPart();
	    mimeBodyPart.setFileName(name);
	    mimeBodyPart.setDataHandler(new DataHandler(new FileDataSource(file)));
	}
	catch (MessagingException e) {
	    throw new ModelException("model initialized with crap", e);
	}
    }

    public void destroy() {
	if (log.isDebugEnabled())
	    log.debug("destroy() called");

	// actually try to physically remove file
	try {
	    if (! file.delete())
		log.warn("trying to delete temporary file " + name + " failed for unknown reason");
	}
	catch (Exception e) {
	    log.warn("trying to delete temporary file " + name + " failed with exception: " + e.toString());
	}
    }

    public String getName() {
	return name;
    }

    public long getSize() {
	return size;
    }

    public String getSizeAsString() {
	return sizeAsString;
    }

    public MimeBodyPart getMimeBodyPart() {
	return mimeBodyPart;
    }

//     public DataSource getDataSource() {
// 	if (log.isDebugEnabled())
// 	    log.debug("getDataSource() returning new data source on file with name " + file.getName() + ", size " + file.length());
// 	FileDataSource fds = new FileDataSource(file);

// 	return fds;
//     }
}
