/* 
 *   Copyright (C) 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import java.util.Comparator;

public class ContactComparator implements Comparator
{
    private boolean ascending;
    private int fieldIndex;

    public static final String[] ALLOWED_FIELDS
    = {"email","name","nickname"};

    public ContactComparator(String field, boolean ascending) 
	throws ModelException
    {
	fieldIndex = -1;
	for (int i = 0; i < ALLOWED_FIELDS.length; i++)
	    if (ALLOWED_FIELDS[i].equals(field)) {
		fieldIndex = i;
		break;
	    }
	if (fieldIndex < 0)
	    throw new ModelException("illegal usage of ContactComparator: field named " + field + " is not allowed for sorting criteria");
	
	this.ascending = ascending;
    }
    
    public int compare(Object o1, Object o2) {
	Contact c1 = (Contact)o1;
	Contact c2 = (Contact)o2;
	String s1 = null;
	String s2 = null;
	switch (fieldIndex) {
	    case 0:
		s1 = c1.getEmailAddress().getAddress();
		s2 = c2.getEmailAddress().getAddress();
		break;
	    case 1:
		s1 = c1.getEmailAddress().getPersonal();
		s2 = c2.getEmailAddress().getPersonal();
		break;
	    case 2:
		s1 = c1.getNickname();
		s2 = c2.getNickname();
		break;
	}
	if (ascending)
	    if (s1 != null)
		return s1.compareTo(s2);
	    else
		return (s2 == null ? 0 : 1);
	else
	    if (s2 != null)
		return s2.compareTo(s1);
	    else
		return (s1 == null ? 0 : 1);

    }
}
