/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.NoConnectionException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.model.user.CustomSeparator;
import net.jatec.ironmailer.model.user.UserPreferences;

class UserDataAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(UserDataAction.class);

    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("process() handling user setup");

	String store = req.getParameter("store");
	if (store != null) {
	    String parSignature = req.getParameter("signature");
	    String parReplySeparator = req.getParameter("replyseparator");
	    String parForwardSeparator = req.getParameter("forwardseparator");
	    if (log.isDebugEnabled())
		log.debug("process() handling storing, parameters are (signature," 
			  + parSignature 
			  + "), (replySeparator," + parReplySeparator
			  + "), (forwardSeparator," + parForwardSeparator
			  + ")");
	    
	    UserPreferences up = wb.getUserPreferences();
	    if (up == null) {
		log.info("process() initial user preferences non-existent, creating");
		up = new UserPreferences();
	    }
	    up.setSignature(parSignature);
	    if (parReplySeparator != null && ! parReplySeparator.equals(""))
		up.setReplySeparator(new CustomSeparator(parReplySeparator));
	    else
		up.setReplySeparator(null);
	    if (parForwardSeparator != null && ! parForwardSeparator.equals(""))
		up.setForwardSeparator(new CustomSeparator(parForwardSeparator));
	    else
		up.setForwardSeparator(null);

	    try {
		String fromAddress = ServletTools.getString(req,"fromAddressAddress");
		if (fromAddress != null &&
		    ! fromAddress.equals("")) {
		    log.debug("process() got parameter fromAddress " + fromAddress);
		    // trick to check just address part, because other constructor doesn't do it cleanly
		    new InternetAddress(fromAddress);
		    // OK, now get name
		    String fromName = ServletTools.getString(req,"fromAddressName");
		    up.setFromAddress(new InternetAddress(fromAddress, 
							  fromName));
		}
		else
		    up.setFromAddress(null);
	    }
	    catch (AddressException e) {
		throw new ControllerException("Address could not be created because it is invalid", e);
	    }
	    catch (UnsupportedEncodingException e) {
		throw new ControllerException("Address could not be created because of encoding problem", e);
	    }
	    // done creating new UserPreferences
	    try {
		wb.setUserPreferences(up);
		// OK, so set marker
		ServletTools.setUpdate(req);
	    }
	    catch (NoConnectionException e) {
		// TO DO: handle this exception differently, somehow ??
		// either attempt to recreate connection, 
		// or do not fail action, instead set error for nicer
		// handling of user interface
		throw e;
	    }
	}
	else {
	    log.debug("process() not called with a specific action - no further processing");
	}

	if (log.isDebugEnabled())
	    log.debug("process() completed succesfully");
    }
}
