/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.controller.NoSelectionException;
import net.jatec.ironmailer.framework.StringTools;
import net.jatec.ironmailer.framework.ServletTools;


class SetFlagAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(SetFlagAction.class);

    /**
     * @throws ControllerException if something is really screwed
     * @throws NoSelectionException if action can't be done because there is nothing selected
     */
    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	// Get relevant message parameters
	
	// Folder nr
	int folderNr = ServletTools.getInteger(req,"folderNr",true);
	log.debug("process() read folder nr " + folderNr);
	
	// Type of action : two categories, actual flag setting
	// or else moving of messages
	boolean firstCategory = false;
	String buttonIndex = null;

	// First, check if one of the flag buttons was pressed
	if (req.getParameter("flagmsgs1") != null) {
	    firstCategory = true;
	    buttonIndex = "1";
	}
	else 
	    if (req.getParameter("flagmsgs2") != null) {
		firstCategory = true;
		buttonIndex = "2";
	    }

	if (buttonIndex == null)
	    // should be second category, then
	    if (req.getParameter("copymovemsgs1") != null)
		buttonIndex = "1";
	    else
		if (req.getParameter("copymovemsgs2") != null)
		    buttonIndex = "2";
				 
	if (buttonIndex == null)
	    throw new ControllerException("setup error: no known submit name was specified", null);
	

	int[] msgIndices = ServletTools.getSelectedIndices(req, "checkedmessage");
	if (msgIndices == null)
	    throw new NoSelectionException("nothing selected for parameter " + "checkedmessage");

	if (firstCategory) {
	    // Handling flag category, read flag parameters
	    String flag = req.getParameter("flag" + buttonIndex);
	    if (flag == null) 
		throw new ControllerException("trying to set flag for a message, but no flag specified", null);
	    boolean value = 
		ServletTools.getBoolean(req,"value" + buttonIndex,true);
	    if (log.isDebugEnabled())
		log.debug("process() handling setting of flag " + flag 
			  + " to value " + value 
			  + " in folder " + folderNr);
	    wb.setMessagesFlag(folderNr, msgIndices, flag, value);
	}
	else {
	    // handling copy or moving of multiple messages
	    log.debug("act() handling copy/move");

	    // trying to track strange behaviour
	    if (log.isDebugEnabled())
		log.debug("act() copy/move got parameter destination with value: " + req.getParameter("destination"));


	    int destFolderNr = 
		ServletTools.getInteger(req, "destination" + buttonIndex, true);
	    boolean isCopy = ServletTools.getBoolean(req,"iscopy" + buttonIndex, true);

	    if (log.isDebugEnabled())
		log.debug("process() copy/move from folder " + folderNr 
			  + " to folder nr " + destFolderNr 
			  + " isCopy?" + isCopy);

	    wb.copyOrMoveMessages(folderNr, destFolderNr,
				  msgIndices, isCopy);
	}
    }

}
