/* 
 *   Copyright (C) 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Vector;
import javax.mail.search.SearchTerm;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SubjectTerm;
import javax.servlet.ServletRequest;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.controller.NoSelectionException;
import net.jatec.ironmailer.controller.UserInput;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.framework.StringTools;



public class SearchAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(SearchAction.class);
    public final static String PARAM_SUBJECT_CRITERIA = "subject";
    public final static String PARAM_BODY_CRITERIA = "body";
    public final static String PARAM_FROMADDRESS_CRITERIA = "fromaddress";
    public final static String PARAM_RECIPIENTADDRESS_CRITERIA = "recipientaddress";
    private final static String[] SEARCH_PARAMS
    = {PARAM_SUBJECT_CRITERIA,PARAM_BODY_CRITERIA,
       PARAM_FROMADDRESS_CRITERIA,PARAM_RECIPIENTADDRESS_CRITERIA,};

    public void process(ServletRequest req, MailWorkerBean wb, 
			Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	if (log.isDebugEnabled())
	    log.debug("process() called");
	wb.setSearchMessagesResults(null);

	if (ServletTools.getBoolean(req,"dosearch")) {
	    if (log.isDebugEnabled())
		log.debug("process() called to do search");

	    UserInput input = new UserInput(req, SEARCH_PARAMS);

	    SearchTerm searchTerm = getSearchTerm(input, true);
	    wb.searchMessages(searchTerm);

	    // remember user input
	    wb.setUserInput(input);
	}
// 	else
// 	    req.setAttribute("new", "true");
	    

	if (log.isDebugEnabled())
	    log.debug("process completed");
    }

    private SearchTerm getSearchTerm(UserInput input, boolean isOr)
	throws NoSelectionException
    {
	if (log.isDebugEnabled())
	    log.debug("getSearchTerm() called");
	String subjectCriteria = input.get(PARAM_SUBJECT_CRITERIA);
	String bodyCriteria = input.get(PARAM_BODY_CRITERIA);
	String fromaddressCriteria = input.get(PARAM_FROMADDRESS_CRITERIA);
	String recipientaddressCriteria = input.get(PARAM_RECIPIENTADDRESS_CRITERIA);
	int nbTerms = 0;
	boolean hasSubject = StringTools.hasInfo(subjectCriteria);
	if (hasSubject) nbTerms++;
	boolean hasBody = StringTools.hasInfo(bodyCriteria);
	if (hasBody) nbTerms++;
	boolean hasFromaddress = StringTools.hasInfo(fromaddressCriteria);
	if (hasFromaddress) nbTerms++;
	boolean hasRecipientaddress = StringTools.hasInfo(recipientaddressCriteria);
	if (hasRecipientaddress) nbTerms++;

	if (nbTerms == 0)
	    throw new NoSelectionException("no search terms were given.");

	SearchTerm retTerm = null;

	if (nbTerms == 1) {
	    if (hasSubject)
		retTerm = new SubjectTerm(subjectCriteria);
	    if (hasBody)
		retTerm = new BodyTerm(bodyCriteria);
	    if (hasFromaddress)
		retTerm = new FromStringTerm(fromaddressCriteria);
	    if (hasRecipientaddress)
		retTerm = MailTools.getRecipientAddressSearchTerm(recipientaddressCriteria);
	}
	else {
	    if (log.isDebugEnabled())
		log.debug("getSearchTerm() preparing search terms");

	    Vector terms = new Vector();
	    if (hasSubject)
		terms.add(new SubjectTerm(subjectCriteria));
	    if (hasBody)
		terms.add(new BodyTerm(bodyCriteria));
	    if (hasFromaddress)
		terms.add(new FromStringTerm(fromaddressCriteria));
	    if (hasRecipientaddress)
		terms.add(MailTools.getRecipientAddressSearchTerm(recipientaddressCriteria));
	    
	    if (log.isDebugEnabled()) {
		log.debug("getSearchTerm() preparing term array");
		Object[] tmp = terms.toArray();
		for (int t = 0; t < tmp.length; t++)
		    log.debug("getSearchTerm() term 1 is of type " + tmp[t].getClass().getName());
	    }
	    // toArray doesn't work - classcastexception !?
	    //SearchTerm[] sterms = (SearchTerm[])terms.toArray();
 	    SearchTerm[] sterms = new SearchTerm[nbTerms];
 	    for (int i = 0; i < nbTerms; i++)
 		sterms[i] = (SearchTerm)terms.get(i);
	
	    if (log.isDebugEnabled())
		log.debug("getSearchTerm() got terms, combining");

	    retTerm = 
		isOr ?
		(SearchTerm)new OrTerm(sterms) :
		(SearchTerm)new AndTerm(sterms)
		;
	}
	return retTerm;
    }

}
