/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;


/**
 * If the user cannot be represented in the model, because
 * she has a strange setup or something
 */
public class UserInstallationException extends ControllerException
{
    private String user;
    private String admin;

    public UserInstallationException(String problem, String user, String admin) {
	super(problem);
	this.user = user;
	this.admin = admin;
    }

    public String getUser() {
	return user;
    }

    public String getAdmin() {
	return admin;
    }
}
