/* 
 *   Copyright (C) 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import java.util.Iterator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.model.MailboxOverview;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.SearchMessagesResults;

/**
 * Good stuff to search for mails
 */
public class MailSearcher
{
    private final Logger log = Logger.getLogger(MailSearcher.class);
    private MailboxController mc;

    public MailSearcher(MailboxController mc) {
	this.mc = mc;
    }

    public SearchMessagesResults searchMessages(SearchTerm searchTerm) 
	throws ControllerException
    {
	if (searchTerm == null)
	    throw new IllegalArgumentException("at least one search term must be given");
	if (log.isDebugEnabled())
	    log.debug("searchMessages() called");

	SearchMessagesResults result = new SearchMessagesResults(searchTerm);
	int folderIndex = 0;

        for (Iterator i = mc.getMailboxOverview().getMailFolderHeaders().iterator(); i.hasNext();) {
	    MailFolderHeader el = (MailFolderHeader)i.next();
	    if (el.isSelectable()) {
		Folder f = el.getFolder();
		if (! f.isOpen())
		    mc.setMailFolder(folderIndex, true);
		try {
		    Message[] results = f.search(searchTerm);
		    if (results != null && results.length > 0) {
			int[] matches = new int[results.length];
			for (int k = 0; k < matches.length; k++)
			    matches[k] = results[k].getMessageNumber();
			result.add(folderIndex, el.getName(),matches);
		    }
		}
		catch (MessagingException e) {
		    throw new ControllerException("error searching on term " + searchTerm + " in folder " + f.getName(),e);
		}
		catch (IllegalStateException e) {
		    // backend has been known to throw this kind of stuff ;)
		    throw new ControllerException("error searching on term " + searchTerm + " in folder " + f.getName(),e);
		}
	    }
	    folderIndex++;
        }

	if (log.isDebugEnabled()) {
	    log.debug("searchMessages() returning " + result.toString());
	}
	return result;
    }
}

