/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.cocoonext;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;

import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.selection.Selector;
import org.apache.log4j.Logger;


/**
 * This selector tests if a parameter is present in the request.
 * This is different from Cocoon RequestAttributeSelector, which
 * requires a value to check against. But we do not have a value
 * (the value may be language dependant), we only want to check
 * if the parameter is present. This is useful in forms with multiple
 * submit buttons, to find out which button was pressed.
 *
 * @author JWK
 */
public class RequestParameterPresenceSelector extends AbstractLogEnabled
  implements Configurable, ThreadSafe, Selector 
{
    private final Logger log = Logger.getLogger(RequestParameterPresenceSelector.class);

    protected String defaultName;

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultName = config.getChild("parameter-name").getValue(null);
    }

    public boolean select(String expression, Map objectModel, Parameters parameters) {
        String name = parameters.getParameter("parameter-name", this.defaultName);

	log.debug("select() called for name " + name);

        if (name == null) {
            log.warn("select() No parameter name given -- failing.");
            return false;
        }

        String value = ObjectModelHelper.getRequest(objectModel).getParameter(name);
	log.debug("select() read value " + value);
	
	return value != null;
    }
}
