/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model.user;

import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.framework.MailTools;

/**
 * Implementation note: this must be a bean, as it will be serialized as XML
 * We need this class to know where the date is, because the date has a
 * special treatment: we need to be able to localize it
 */
public class CustomSeparator
{
    public final static String KEY = "CustomSeparator";
    // user types used in this class (including superclasses of used types)
    public final static Class[] TYPES = {CustomSeparator.class};

    public final static String DATE_VARIABLE = "ref.date";
    public final static String SENDER_VARIABLE = "ref.sender";

    private final static Logger log = Logger.getLogger(CustomSeparator.class);

    private String beforeDate;
    private String afterDate;
    private boolean dateExpected;
    private boolean senderExpected;
    private boolean senderInBefore;

    public CustomSeparator() {}

    public CustomSeparator(String userInput) {
	if (userInput != null && ! userInput.equals("")) {
	    // parse userInput for the date variable
	    int startDate = userInput.indexOf(DATE_VARIABLE);
	    dateExpected = startDate >= 0;
	    if (dateExpected) {
		beforeDate = userInput.substring(0,startDate);
		afterDate = userInput.substring(startDate + DATE_VARIABLE.length());
	    }
	    else {
		beforeDate = userInput;
		afterDate = "";
	    }

	    // parse userInput for the sender variable
	    int startSender = userInput.indexOf(SENDER_VARIABLE);
	    senderExpected = startSender >= 0;
	    if (senderExpected) {
		senderInBefore = (! dateExpected || startSender < startDate);
	    }
	}
    }

    public void setDateExpected(boolean dateExpected) {this.dateExpected = dateExpected;}

    public boolean getDateExpected() {return dateExpected;}

    public void setSenderExpected(boolean senderExpected) {this.senderExpected = senderExpected;}

    public boolean getSenderExpected() {return senderExpected;}

    public void setSenderInBefore(boolean senderInBefore) {this.senderInBefore = senderInBefore;}

    public boolean getSenderInBefore() {return senderInBefore;}

    public void setBeforeDate(String beforeDate) {this.beforeDate = beforeDate;}

    public String getBeforeDate() {return beforeDate;}

    public String getBeforeDate(InternetAddress[] senderValue) {
	if (senderExpected && senderInBefore) {
	    if (log.isDebugEnabled())
		log.debug("getBeforeDate() looking for " + SENDER_VARIABLE + " in text " + beforeDate + " and replaceing with " + MailTools.toString(senderValue) + ", thus returning " + beforeDate.replaceFirst(SENDER_VARIABLE,MailTools.toString(senderValue)));
	    return beforeDate.replaceFirst(SENDER_VARIABLE,
					   MailTools.toString(senderValue));
	}
	else
	    return beforeDate;
    }

    public void setAfterDate(String afterDate) {this.afterDate = afterDate;}

    public String getAfterDate() {return afterDate;}

    public String getAfterDate(InternetAddress[] senderValue) {
	if (senderExpected && ! senderInBefore)
	    return afterDate.replaceFirst(SENDER_VARIABLE,
					  MailTools.toString(senderValue));
	else
	    return afterDate;
    }

    public String toString() {
	StringBuffer ret = new StringBuffer();
	ret.append(beforeDate);
	if (dateExpected)
	    ret.append(DATE_VARIABLE);
	ret.append(afterDate);
	return ret.toString();
    }
}
