/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;

/**
 * Receptable for servlet utilities
 * @author jwk
 */
public class ServletTools
{
    public static final Logger log = Logger.getLogger(ServletTools.class);
    private static final String UPDATE_MARKER = "update.ok";

    public static int[] getSelectedIndices(ServletRequest req, String paramName)
    {
	// Read index of messages to handle
	String[] s_msgIndices = req.getParameterValues(paramName);
	if (s_msgIndices == null ||
	    s_msgIndices.length == 0) {
	    if (log.isDebugEnabled())
		log.debug("getSelectedIndices() no selection");
	    return null;
	}

	int[] msgIndices = StringTools.toIntArray(s_msgIndices);
	if (log.isDebugEnabled())
	    for (int i = 0; i < msgIndices.length; i++)
		log.debug("getSelectedIndices() selected index " + msgIndices[i]); 
	return msgIndices;
    }

    public static void setUpdate(ServletRequest req) {
	req.setAttribute(UPDATE_MARKER, "true");
    }

    public static boolean isUpdate(Request req) {
	return 
	    "true".equals((String)req.getAttribute(UPDATE_MARKER));
    }

    public static boolean getBoolean(ServletRequest req, String name) {
// 	String par = req.getParameter(name);
// 	if (par != null) par = par.trim();
// 	return Boolean.valueOf(par).booleanValue();
	return getBoolean(req, name, false);
    }

    public static boolean getBoolean(ServletRequest req, String name, boolean required) 
	throws IllegalArgumentException
    {
	String par = req.getParameter(name);
	if (par != null) par = par.trim();

	if (required)
	    if (par == null || par.equals(""))
		throw new IllegalArgumentException("parameter " + name + " does not have a value in request, but it is required");

	return Boolean.valueOf(par).booleanValue();
    }

    public static int getInteger(ServletRequest req, String name, boolean required) 
	throws IllegalArgumentException
    {
	String par = req.getParameter(name);
	if (par != null) par = par.trim();

	if (required)
	    if (par == null || par.equals(""))
		throw new IllegalArgumentException("parameter " + name + " does not have a value in request, but it is required");

	return Integer.parseInt(par);
    }

    public static String getString(ServletRequest req, String name)
	throws IllegalArgumentException
    {
	return getString(req, name, false);
    }

    public static String getString(ServletRequest req, String name, boolean required)
	throws IllegalArgumentException
    {
	String par = (String)req.getParameter(name);
	if (par != null) par = par.trim();

	if (required)
	    if (par == null || par.equals(""))
		throw new IllegalArgumentException("parameter " + name + " does not have a value in request, but it is required");

	return par;
    }
}
