/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.model.ComposeInfo;

/**
 * LeaveCompose may be called either because user wants to send the mail
 * that's being composed; or because the user is going somewhere else
 * so the composition info needs to be saved.
 */
class LeaveComposeAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(LeaveComposeAction.class);

    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel) 
	throws ControllerException
    {
	// store compose information
	log.debug("process() storing compose info");
	String to = ServletTools.getString(req, "to");
	String cc = ServletTools.getString(req, "cc");
	String replyTo = ServletTools.getString(req, "replyto");
	String bcc = ServletTools.getString(req, "bcc");
	String subject = ServletTools.getString(req, "subject");
	// TO DO : handle body not as string but as byte stream?
	String body = ServletTools.getString(req, "body");
	log.debug("process() got parameters to " + to
		  + ", cc " + cc
		  + ", replyTo " + replyTo
		  + ", bcc " + bcc
		  + ", subject " + subject
		  + ", body " + body);
	ComposeInfo ci = wb.getComposeInfo();
	ci.setTo(to);
	ci.setCc(cc);
	ci.setReplyTo(replyTo);
	ci.setBcc(bcc);
	ci.setSubject(subject);
	ci.setBody(body);

	// If this is the actual sending, then send
	String send = req.getParameter("send");
	if (send != null) {
	    log.debug("process() handling sending");
	    wb.send();
	}
	else {
	    log.debug("process() not called for sending - no further processing");
	}
    }
}
