/* 
 *   Copyright (C) 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.Message;
import javax.mail.search.SearchTerm;
import org.apache.log4j.Logger;

/**
 * Part of the client model.
 * Contains information about the result of a search
 */
public class SearchMessagesResults
{
    private final Logger log = Logger.getLogger(SearchMessagesResults.class);
    private Vector results;

    public SearchMessagesResults() {
	results = new Vector();
    }
    public void add(SearchTerm criteria, int folderIndex, String folderName, int[] matches) {
	results.add(new SearchMessagesResult(criteria,folderIndex,folderName,matches));
    }

    public Collection getResults() {
	return results;
    }

    public boolean isEmpty() {
	return results == null || results.size() == 0;
    }

    /** for debugging */
    public String toString() {
	StringBuffer ret = new StringBuffer();
	ret.append("SearchMessagesResults contains:\n");
        for (Iterator i = results.iterator(); i.hasNext();) {
	    SearchMessagesResult el = (SearchMessagesResult)i.next();
	    ret.append("\tentry ")
		.append(el.toString())
		.append("\n");
	}
	return ret.toString();
    }
}

